/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.TargetPanelAutomationHelper;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.n3.nanoxml.XMLElement;

public class TargetPanel
extends IzPanel
implements ActionListener {
    private String defaultDir;
    private JLabel infoLabel;
    private JTextField textField;
    private JButton browseButton;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();

    public TargetPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.setLayout(this.layout);
        this.loadDefaultDir();
        if (this.defaultDir != null) {
            installData.setInstallPath(this.defaultDir);
        }
        this.infoLabel = new JLabel(installerFrame.langpack.getString("TargetPanel.info"), installerFrame.icons.getImageIcon("home"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 0, 2, 1, 3.0, 0.0);
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.infoLabel, this.gbConstraints);
        this.add(this.infoLabel);
        this.textField = new JTextField(installData.getInstallPath(), 40);
        this.textField.addActionListener(this);
        installerFrame.buildConstraints(this.gbConstraints, 0, 1, 1, 1, 3.0, 0.0);
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 17;
        this.layout.addLayoutComponent(this.textField, this.gbConstraints);
        this.add(this.textField);
        this.browseButton = ButtonFactory.createButton(installerFrame.langpack.getString("TargetPanel.browse"), installerFrame.icons.getImageIcon("open"), installData.buttonsHColor);
        this.browseButton.addActionListener(this);
        installerFrame.buildConstraints(this.gbConstraints, 1, 1, 1, 1, 1.0, 0.0);
        this.gbConstraints.fill = 2;
        this.gbConstraints.anchor = 13;
        this.layout.addLayoutComponent(this.browseButton, this.gbConstraints);
        this.add(this.browseButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadDefaultDir() {
        block21: {
            block20: {
                var1_1 = null;
                try {
                    try {
                        var2_2 = System.getProperty("os.name");
                        var3_4 = null;
                        if (var2_2.regionMatches(true, 0, "windows", 0, 7)) {
                            var3_4 = this.parent.getResource("TargetPanel.dir.windows");
                        } else if (var2_2.regionMatches(true, 0, "mac os x", 0, 8)) {
                            var3_4 = this.parent.getResource("TargetPanel.dir.macosx");
                        } else if (var2_2.regionMatches(true, 0, "mac", 0, 3)) {
                            var3_4 = this.parent.getResource("TargetPanel.dir.mac");
                        } else {
                            var2_2.replace(' ', '_');
                            var2_2 = var2_2.toLowerCase();
                            var3_4 = this.parent.getResource("TargetPanel.dir.".concat(var2_2));
                            if (var3_4 == null) {
                                var3_4 = this.parent.getResource("TargetPanel.dir.unix");
                            }
                            if (var3_4 == null) {
                                var3_4 = this.parent.getResource("TargetPanel.dir");
                            }
                        }
                        if (var3_4 == null) {
                            var7_5 = null;
                            break block20;
                        }
                        var4_13 = new InputStreamReader(var3_4);
                        var1_1 = new BufferedReader(var4_13);
                        var5_14 = null;
                        while ((var5_14 = var1_1.readLine()) != null && (var5_14 = var5_14.trim()).equals("")) {
                        }
                        this.defaultDir = var5_14;
                        break block21;
                    }
                    catch (Exception var2_3) {
                        this.defaultDir = null;
                        var7_7 = null;
                        try {
                            if (var1_1 == null) return;
                            var1_1.close();
                            return;
                        }
                        catch (IOException var8_11) {
                            return;
                        }
                    }
                }
                catch (Throwable var6_15) {
                    var7_8 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 241->252)] { 
lbl48:
                    // 1 sources

                    if (var1_1 == null) throw var6_15;
                    var1_1.close();
                    throw var6_15;
lbl51:
                    // 1 sources

                    catch (IOException var8_12) {
                        // empty catch block
                    }
                    throw var6_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 241->252)] { 
lbl56:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl59:
            // 1 sources

            catch (IOException var8_9) {
                // empty catch block
            }
            return;
        }
        var7_6 = null;
        try {}
        catch (IOException var8_10) {}
        if (var1_1 == null) return;
        var1_1.close();
        return;
    }

    public boolean isValidated() {
        String string = this.textField.getText();
        boolean bl = true;
        if (string.length() == 0) {
            int n = JOptionPane.showConfirmDialog(this, this.parent.langpack.getString("TargetPanel.empty_target"), this.parent.langpack.getString("installer.warning"), 0);
            boolean bl2 = bl = n == 0;
        }
        if (!bl) {
            return bl;
        }
        File file = new File(string);
        string = file.toString();
        if (file.exists()) {
            int n = JOptionPane.showConfirmDialog(this, this.parent.langpack.getString("TargetPanel.warn"), this.parent.langpack.getString("installer.warning"), 0);
            bl = n == 0;
        } else {
            JOptionPane.showMessageDialog(this, this.parent.langpack.getString("TargetPanel.createdir") + "\n" + string);
        }
        this.idata.setInstallPath(string);
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.textField) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File(this.textField.getText()));
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            if (jFileChooser.showOpenDialog(this) == 0) {
                this.textField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void makeXMLData(XMLElement xMLElement) {
        new TargetPanelAutomationHelper().makeXMLData(this.idata, xMLElement);
    }
}

