/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.VariableSubstitutor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private BoxLayout layout;
    private JButton autoButton;
    private JPanel centerPanel;
    private VariableSubstitutor vs;

    public FinishPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.vs = new VariableSubstitutor(installData.getVariableValueMap());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.centerPanel = new JPanel();
        this.layout = new BoxLayout(this.centerPanel, 1);
        this.centerPanel.setLayout(this.layout);
        gridBagLayout.addLayoutComponent(this.centerPanel, gridBagConstraints);
        this.add(this.centerPanel);
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        if (this.idata.installSuccess) {
            this.centerPanel.add(new JLabel(this.parent.langpack.getString("FinishPanel.success"), this.parent.icons.getImageIcon("information"), 11));
            this.centerPanel.add(Box.createVerticalStrut(20));
            if (this.idata.info.getWriteUninstaller()) {
                String string = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
                this.centerPanel.add(new JLabel(this.parent.langpack.getString("FinishPanel.uninst.info"), this.parent.icons.getImageIcon("information"), 11));
                this.centerPanel.add(new JLabel(string, this.parent.icons.getImageIcon("empty"), 11));
            }
            this.centerPanel.add(Box.createVerticalStrut(20));
            this.autoButton = ButtonFactory.createButton(this.parent.langpack.getString("FinishPanel.auto"), this.parent.icons.getImageIcon("edit"), this.idata.buttonsHColor);
            this.autoButton.setToolTipText(this.parent.langpack.getString("FinishPanel.auto.tip"));
            this.autoButton.addActionListener(this);
            this.centerPanel.add(this.autoButton);
        } else {
            this.centerPanel.add(new JLabel(this.parent.langpack.getString("FinishPanel.fail"), this.parent.icons.getImageIcon("information"), 11));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(this.idata.getInstallPath()));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        try {
            if (jFileChooser.showSaveDialog(this) == 0) {
                File file = jFileChooser.getSelectedFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 5120);
                this.parent.writeXMLTree(this.idata.xmlData, bufferedOutputStream);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                this.autoButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, exception.toString(), this.parent.langpack.getString("installer.error"), 0);
        }
    }

    private String translatePath(String string) {
        string = this.vs.substitute(string, null);
        return string.replace('/', File.separatorChar);
    }
}

