unit GLE2000W;
{ Window Control Unit for GLE2000.
  Version 1.001  D. Ingram.  31st December 1999.}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin, GLE2000T;

type
  TWindowForm = class(TForm)
    Label1: TLabel;  {Origin}
    Label4: TLabel;  {Size}
    Label2: TLabel;  {x cm origin}
    Edit1: TEdit;    {NewXorg edit}
    SpinButton1: TSpinButton;
    Label3: TLabel;  {y cm origin}
    Edit2: TEdit;
    SpinButton2: TSpinButton;
    Label5: TLabel;   {x cm size}
    Edit3: TEdit;
    SpinButton3: TSpinButton;
    Panel1: TPanel;   {Lower line}
    Button1: TButton; {Accept}
    Button2: TButton; {Cancel}
    Label6: TLabel;    {y cm size}
    Edit4: TEdit;
    SpinButton4: TSpinButton;    { x zoom factor}
    Edit5: TEdit;
    SpinButton5: TSpinButton;
    Label9: TLabel;    {Zoom Factor}
    Panel2: TPanel;    {Zoom Button is represented by a panel}
    Button3: TButton;  {Resets Zoom  to 1.0}
    Button4: TButton;  {Sets to default values}
    Button5: TButton;  {Restores previous settings}
    procedure FormCreate(Sender: TObject);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure SpinButton2DownClick(Sender: TObject);
    procedure SpinButton2UpClick(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure SpinButton3UpClick(Sender: TObject);
    procedure SpinButton3DownClick(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure SpinButton4UpClick(Sender: TObject);
    procedure SpinButton4DownClick(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
    procedure SpinButton5UpClick(Sender: TObject);
    procedure SpinButton5DownClick(Sender: TObject);
    procedure Edit5Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WindowForm: TWindowForm;

implementation

{$R *.DFM}

uses GLE2000D, GLE2000E;

var  Ecode:integer;
     LastZoom, LastXorg, LastYorg, LastXsize, LastYsize:double;

procedure TWindowForm.FormCreate(Sender: TObject);
{ Stores initial settings as default values. }
begin
 WindowForm.Color:= Parchment;
end;

{ ***** Sets x value of window origin ******* }
procedure TWindowForm.SpinButton1DownClick(Sender: TObject);
Var s1:string;
begin
     NewXOrg:= NewXOrg-0.1;
     If NewXOrg<-300.0 then NewXOrg:= -300.0; {Limit of left edge}
     Str(NewXOrg:6:2,s1);
     Edit1.Text:= s1;
end;

procedure TWindowForm.SpinButton1UpClick(Sender: TObject);
Var s1:string;
begin
     NewXOrg:= NewXOrg+0.1;
     If NewXOrg>300.0 then NewXOrg:= 300.0; {Limit of right edge}
     Str(NewXOrg:6:2,s1);
     Edit1.Text:= s1;
end;

procedure TWindowForm.Edit1Change(Sender: TObject);
{Covers manual change of value. These can exceed limits set by spin buttons.}
begin
  Val(Edit1.Text,NewXOrg,Ecode);
  if Ecode<>0 then
  begin
   Messagedlg('W1: Error in setting window x origin. Value reset to zero.',
               mtError,[mbOK],0);
   NewXorg:= 0.0;
   Edit1.Text:= '0.0';
  end;
end;

{ ******* Sets y value of window origin ******** }

procedure TWindowForm.SpinButton2DownClick(Sender: TObject);
var s1:string;
begin
     NewYOrg:= NewYOrg-0.1;
     If NewYOrg<-300.0 then NewYOrg:= -300.0; {lower limit}
     Str(NewYOrg:6:2,s1);
     Edit2.Text:= s1;
end;

procedure TWindowForm.SpinButton2UpClick(Sender: TObject);
var s1:string;
begin
     NewYOrg:= NewYOrg+0.1;
     If NewYOrg>300.0 then NewYOrg:= 300.0; {Upper limit}
     Str(NewYOrg:6:2,s1);
     Edit2.Text:= s1;
end;

procedure TWindowForm.Edit2Change(Sender: TObject);
{Covers manual change of value. Can exceed spin button limits}
begin
  Val(Edit2.Text,NewYOrg,Ecode);
  if Ecode<>0 then
  begin
   Messagedlg('W2: Error in setting window y origin. Value reset to zero.',
               mtError,[mbOK],0);
   NewYorg:= 0.0;
   Edit2.Text:= '0.0';
  end;
end;

{ ******** Sets window width ********** }

procedure TWindowForm.SpinButton3UpClick(Sender: TObject);
var s1:string;
begin
     NewXSize:= NewXSize+0.1;
     If NewXSize>40.0 then NewXSize:= 40.0; {Upper Limit}
     Str(NewXSize:6:2,s1);
     Edit3.Text:= s1;
end;

procedure TWindowForm.SpinButton3DownClick(Sender: TObject);
var s1:string;
begin
     NewXSize:= NewXSize-0.1;
     If NewXSize<0.1 then NewXSize:= 0.1;  {Lower limit}
     Str(NewXSize:6:2,s1);
     Edit3.Text:= s1;
end;

procedure TWindowForm.Edit3Change(Sender: TObject);
{Covers manual changes}
begin
  Val(Edit3.Text,NewXSize,Ecode);
  if Ecode<>0 then
  begin
   Messagedlg('W3: Error in setting window width. Value reset to 10 cm.',
               mtError,[mbOK],0);
   NewXSize:= 10.0;
   Edit3.Text:= '10.0';
  end;
end;

{ ******** Sets window height ******** }

procedure TWindowForm.SpinButton4UpClick(Sender: TObject);
var s1:string;
begin
     NewYSize:= NewYSize+0.1;
     If NewYSize>40.0 then NewYSize:= 40.0;    {Upper limit}
     Str(NewYSize:6:2,s1);
     Edit4.Text:= s1;
end;

procedure TWindowForm.SpinButton4DownClick(Sender: TObject);
var s1:string;
begin
     NewYSize:= NewYSize-0.1;
     If NewYSize<0.1 then NewYSize:= 0.1; {Lower Limit}
     Str(NewYSize:6:2,s1);
     Edit4.Text:= s1;
end;

procedure TWindowForm.Edit4Change(Sender: TObject);
{Covers manual alterations}
begin
  Val(Edit4.Text,NewYSize,Ecode);
  if Ecode<>0 then
  begin
   Messagedlg('W4: Error in setting window height. Value reset to 10.0 cm.',
               mtError,[mbOK],0);
   NewYSize:= 10.0;
   Edit4.Text:= '10.0';
  end;
end;

{ ******** Sets zoom factor *********** }

procedure TWindowForm.SpinButton5UpClick(Sender: TObject);
var s1:string;
begin
     Zoomfactor:= Zoomfactor*1.189207115003;  {2^(1/4)}
     If Zoomfactor>8.0 then Zoomfactor:= 8.0; {Upper Limit}
     Str(Zoomfactor:10:5,s1);
     Edit5.Text:= s1;
end;

procedure TWindowForm.SpinButton5DownClick(Sender: TObject);
var s1:string;
begin
     Zoomfactor:= Zoomfactor*0.8408964152537; {1/(2^(1/4)}
     If Zoomfactor<0.125 then Zoomfactor:= 0.125;  {Lower Limit}
     Str(Zoomfactor:10:5,s1);
     Edit5.Text:= s1;
end;

procedure TWindowForm.Edit5Change(Sender: TObject);
{Covers manual setting}
begin
  Val(Edit5.Text,Zoomfactor,Ecode);
  if Ecode<>0 then
  begin
   Messagedlg('W5: Error in setting zoom factor. Value reset to 1.0.',
               mtError,[mbOK],0);
   Zoomfactor:= 1.0;
   Edit5.Text:= '1.0';
  end;
end;

{ ****** Reset zoom factor ******** }

procedure TWindowForm.Button3Click(Sender: TObject);
begin {Reset}
 Zoomfactor:= 1.0;
 Edit5.Text:= '   1.000';
end;

{ ****** Accept current settings ******** }

procedure TWindowForm.Button1Click(Sender: TObject);
begin
 UpdateSettings:= True;
 WindowForm.Close;
 DisplayForm.ReDrawBitBtn1Click(Sender);
end;

{ ******* Restore initial settings ******** }

procedure TWindowForm.Button4Click(Sender: TObject);
var s1:string;
begin
 UpdateSettings:= False;
 NewXOrg:= InitXOrg;
 LastXOrg:= InitXOrg;
 Str(NewXorg:6:2,s1);
 Edit1.Text:= s1;
 NewYOrg:= InitYOrg;
 LastYOrg:= InitYOrg;
 Str(InitYOrg:6:2,s1);
 Edit2.Text:= s1;
 NewXSize:= InitXSize;
 LastXSize:= InitXSize;
 Str(InitXsize:6:2,s1);
 Edit3.Text:= s1;
 NewYSize:= InitYSize;
 LastYSize:= InitYSize;
 Str(InitYSize:6:2,s1);
 Edit4.Text:= s1;
 Zoomfactor:= InitZoom;
 LastZoom:= InitZoom;
 Str(InitZoom:10:5,s1);
 Edit5.Text:= s1;
end;

{ ******* Restore previous settings and close window ******* }

procedure TWindowForm.Button2Click(Sender: TObject);
{The previous settings are restored and the window is closed}
var s1:string;
begin   {Cancel}
   UpdateSettings:= False;
   NewXOrg:= LastXOrg;
     Str(NewXorg:6:2,s1);
     Edit1.Text:= s1;
   NewYOrg:= LastYOrg;
     Str(NewYOrg:6:2,s1);
     Edit2.Text:= s1;
   NewXSize:= LastXSize;
     Str(NewXSize:6:2,s1);
     Edit3.Text:= s1;
   NewYSize:= LastYSize;
     Str(NewYsize:6:2,s1);
     Edit4.Text:= s1;
   Zoomfactor:= LastZoom;
     Str(Zoomfactor:10:5,s1);
     Edit5.Text:= s1;
   WindowForm.hide;
end;


{ ******** Restore Button ********}

procedure TWindowForm.Button5Click(Sender: TObject);
{ Entry settings are restored}
var s1:string;
begin
 UpdateSettings:= False;
 NewXOrg:= LastXOrg;
 Str(NewXorg:6:2,s1);
 Edit1.Text:= s1;
 NewYOrg:= LastYOrg;
 Str(NewYOrg:6:2,s1);
 Edit2.Text:= s1;
 NewXSize:= LastXSize;
 Str(NewXsize:6:2,s1);
 Edit3.Text:= s1;
 NewYSize:= LastYsize;
 Str(NewYSize:6:2,s1);
 Edit4.Text:= s1;
 Zoomfactor:= LastZoom;
{ LastZoom:= 1.0;  }
 Str(ZoomFactor:10:5,s1);
 Edit5.Text:= s1;
end;

{*** Operations on opening form ***}
procedure TWindowForm.FormActivate(Sender: TObject);
var s1:string;
begin
   LastZoom:= ZoomFactor;
   Str(ZoomFactor:10:5,s1);
   Edit5.Text:= s1;
   LastXOrg:= NewXOrg;
   Str(NewXOrg:6:2,s1);
   Edit1.Text:= s1;
   LastYOrg:= NewYOrg;
   Str(NewYOrg:6:2,s1);
   Edit2.Text:= s1;
   LastXSize:= NewXSize;
   Str(NewXSize:6:2,s1);
   Edit3.Text:= s1;
   LastYSize:= NewYsize;
   Str(NewYSize:6:2,s1);
   Edit4.Text:= s1;
end;

procedure TWindowForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  {Button5Click(Sender); }
end;

end.
