unit GLE2000F;
{ Fills Unit  Sets up fill colours and patterns
  D. Ingram Version 3.1 31st December 1999}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, ExtCtrls;

type
  TFillsForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Panel1: TPanel;
    Panel2: TPanel;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    Button7: TButton;
    Button8: TButton;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FillsForm: TFillsForm;
  Action,ln:integer;

implementation

uses GLE2000E, GLE2000D, GLE2000T;

{$R *.DFM}

var Bm,Col1,Col2,Colbk:integer;
    Style,Clr1,Clr2,Clrbk:Boolean;

procedure TFillsForm.FormShow(Sender: TObject);
begin
  Action:= 0;
  Bm:=BmStyle;
  Col1:= FCol1;
  Col2:= FCol2;
  Colbk:= FColbk;
  Style:= False;
  Clr1:=  False;
  Clr2:=  False;
  Clrbk:= False;
  Panel3.Caption:= '   Unchanged';
  Panel4.Caption:= 'Unchanged';
  Panel5.Caption:= 'Unchanged';
  Panel6.Caption:= 'Unchanged';
  Panel3.Color:= clwhite;
  Panel4.Color:= clwhite;
  Panel5.Color:= clwhite;
  Panel6.Color:= clwhite;
end;

procedure TFillsForm.Button1Click(Sender: TObject);

begin
 Panel3.Visible:= False;
 Panel4.Visible:= False;
 Panel2.Visible:= True;
 Action:=1;
 Bm:= spinEdit1.value;
end;

procedure TFillsForm.SpinEdit1Change(Sender: TObject);
begin
   Label1.Caption:= FillTitle[SpinEdit1.Value];
end;

procedure TFillsForm.Button5Click(Sender: TObject);

var s1,s2,s3,s4:string;

begin
       BmStyle:=Bm;
       FCol1:= Col1;
       Fcol2:= Col2;
       FColbk:= Colbk;
       FillsForm.Hide;

        try
         ln:= EditForm.GetLineIndex;
         Str(BmStyle:2,s1);s2:= '$'+IntToHex(Col1,8);
         s3:= '$'+IntToHex(Col2,8);s4:= '$'+IntToHex(Colbk,8);
         if (ln>0) and (ln<=EditForm.EditMemo.Lines.count) then
          EditForm.EditMemo.Lines.insert(EditForm.GetLineIndex,
          ' Set fillstyle  '+ s1 + ' FillColor ' + s2 + ' Fill2Color '
           + s3 + ' FillbColor ' + s4)
         else
          EditForm.EditMemo.Lines.add(' Set Fillstyle  '+s1+ ' FillColor '
          + s2 + ' Fill2Color ' + s3 + ' FillbColor ' + s4);
         with DisplayForm.Image1.Canvas do
         begin
          { Brush.Bitmap.Free;  May clear background }
          Brush.Style:= SetBrushStyle(BmStyle,BrushBitMap);
          If BrushBitMapset then
        {  BrushBitMapSet is a Global flag set in SetBrushBitMap }
          begin
            SetBrushBitMap(BmStyle,256,BrushBitMap,Mask1,Mask2,
                            Col1,Col2,Colbk);
            DisplayForm.Image1.Canvas.Brush.Bitmap:= BrushBitMap;
            FillsForm.Close;
          end;
         end;  {with DisplayForm}
        except
          Messagedlg('S50: Illegal fill style parameter',mtError,[mbAbort],0);
          Disaster:=True;
          exit;
        end; {except}
end;

procedure TFillsForm.Button2Click(Sender: TObject);
begin
   Action:= 2;
   if EditForm.ColorDialog1.execute then
   begin
     Col1:= EditForm.ColorDialog1.Color;
     Panel4.Caption:= '';
     Panel4.Color:=Col1
   end else begin
     Panel4.Caption:= 'Unchanged';
     Panel4.Color:= clwhite;
   end;
end;

procedure TFillsForm.Button3Click(Sender: TObject);
begin
  Action:= 3;
  if EditForm.ColorDialog1.execute then
  begin
     Col2:= EditForm.ColorDialog1.Color;
     Panel5.Caption:= '';
     Panel5.Color:=Col2
   end else begin
     Panel5.Caption:= 'Unchanged';
     Panel5.Color:= clwhite;
   end;
end;

procedure TFillsForm.Button4Click(Sender: TObject);
begin
  Action:= 4;
  if EditForm.ColorDialog1.execute then
  begin
     Colbk:= EditForm.ColorDialog1.Color;
     Panel6.Caption:= '';
     Panel6.Color:=Colbk
   end else begin
     Panel6.Caption:= 'Unchanged';
     Panel6.Color:= clwhite;
   end;
end;

procedure TFillsForm.Button6Click(Sender: TObject);
begin
  Action:= 0;
  Bm:=0;
  Style:= False;
  Clr1:=  False;
  Clr2:=  False;
  Clrbk:= False;
  Panel3.Caption:= '   Unchanged';
  Panel4.Caption:= 'Unchanged';
  Panel5.Caption:= 'Unchanged';
  Panel6.Caption:= 'Unchanged';
  Panel3.Color:= clwhite;
  Panel4.Color:= clwhite;
  Panel5.Color:= clwhite;
  Panel6.Color:= clwhite;
  FillsForm.Close;
end;

procedure TFillsForm.Button7Click(Sender: TObject);
begin
  Panel3.Caption:= Label1.Caption;
  Bm:= SpinEdit1.Value;
  Panel2.Visible:= False;
  Panel3.Visible:= True;
  Panel4.Visible:= True;
end;

procedure TFillsForm.Button8Click(Sender: TObject);
begin
  Panel3.Caption:= '   Unchanged';
  Bm:= 0;
  Panel2.Visible:= False;
  Panel3.Visible:= True;
  Panel4.Visible:= True;
  FillsForm.Hide;
end;

end.
