' Program for evaluating aerial patterns
' Currently set for array of 4 dipoles with reflectors
' See Reference Data for Radio Engineers on antenna arrays
' D. Ingram  18th March 2000
PRINT "Evaluation of aerial array radiation patterns"
INPUT "Enter Filename: "; n$
OPEN n$ FOR OUTPUT AS #1
PRINT #1, "! radiation Pattern"
pi = 4 * ATN(1)
rad = pi / 180' Conversion of degrees to radians
s = pi / 2
m = 4
FOR i = 0 TO 360 STEP 10
  r = i * rad
  s1 = SIN(m * s * SIN(r))
  s2 = SIN(s * SIN(r))
  IF i <> 0 THEN
     y1 = ABS(s1 / (m * s2))
  ELSE
     y1 = 1
  END IF
     y2 = ABS(COS(pi / 4 * (COS(r) - 1)))
  PRINT USING "  ####   ##.####^^^^   ##.####^^^^   ##.####^^^^ "; i; y1; y2; y1 * y2
  PRINT #1, USING "  ####   ##.####^^^^   ##.####^^^^    ##.####^^^^"; i; y1; y2; y1 * y2
NEXT i
CLOSE #1

