/** \file DS_Exceptions.h
    C++ Excpetions definitions

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_DS_EXCEPTIONS
#define H_DS_EXCEPTIONS

#include <DS_String.h>

// Standard exceptions for error handling.
// Correct programming removes the need for using 
// try - catch code
// Although, for debugging, this is very useful

/** Generic exception. */
class Exception
{
public:
  Exception(const String& Name) : m_Name(Name) {}
  Exception(const char* Name)   : m_Name(Name) {}

  virtual ~Exception() {}

  /** Returns the name of the exception, which can explain it. */
  const String& getName() const { return m_Name; }

protected:
  String m_Name;
};

/** Inconsistency in data structures exception. */
class ConsistencyException : public Exception
{
public:
  ConsistencyException(const char *Name) : Exception(Name) {}
  ConsistencyException() : Exception("Consistency") {}
};

/** Exception caused by trying to access array elements outside its range. */
class IndexOutOfBounds : public ConsistencyException 
{ 
public:
  IndexOutOfBounds(const int Ind, const int Size) :
	 ConsistencyException("Index Out Of Bounds"),
	 m_Ind(Ind),
	 m_Size(Size)
  {}
  int m_Ind,m_Size;
};

/** Exception thrown when trying to construct a copy of a container
    which is destructive.  The same elements cannot be shared. */
class DestructiveCopy : public ConsistencyException 
{ 
public:
  DestructiveCopy() : ConsistencyException("Destructive Copy") {}
};

class NotInitialized : public ConsistencyException
{
public:
   NotInitialized() : ConsistencyException("Not Initialized") {}
};


inline ostream& operator<< (ostream& os, const Exception& e)
{
  return (os << e.getName());
}

#endif // H_DS_EXCEPTIONS
