/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.FinishableOutputStream;
import org.freehep.util.io.RunLength;

public class RunLengthOutputStream
extends FilterOutputStream
implements RunLength,
FinishableOutputStream {
    private boolean end = false;
    private int[] buffer = new int[128];
    private int index = 0;
    private int last = -1;
    private int count = 1;

    public RunLengthOutputStream(OutputStream out) {
        super(out);
    }

    public void write(int a2) throws IOException {
        a2 &= 0xFF;
        if (this.last > 0) {
            if (a2 == this.last) {
                this.writeBuffer();
                ++this.count;
                if (this.count >= 128) {
                    this.writeCount();
                }
            } else if (this.count > 1) {
                this.writeCount();
            } else {
                this.buffer[this.index] = this.last;
                ++this.index;
                if (this.index >= 128) {
                    this.writeBuffer();
                }
            }
        }
        this.last = a2;
    }

    public void finish() throws IOException {
        if (!this.end) {
            this.end = true;
            this.writeCount();
            this.writeBuffer();
            super.write(128);
            this.flush();
            if (this.out instanceof FinishableOutputStream) {
                ((FinishableOutputStream)((Object)this.out)).finish();
            }
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    private void writeBuffer() throws IOException {
        if (this.index > 0) {
            super.write(this.index - 1);
            int i2 = 0;
            while (i2 < this.index) {
                super.write((byte)this.buffer[i2]);
                ++i2;
            }
        }
        this.index = 0;
    }

    private void writeCount() throws IOException {
        if (this.count > 1) {
            super.write(257 - this.count);
            super.write(this.last);
            this.last = -1;
        }
        this.count = 1;
    }
}

