/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.ClipActionRecord;
import org.freehep.graphicsio.swf.ClipEventFlags;
import org.freehep.graphicsio.swf.ColorXform;
import org.freehep.graphicsio.swf.ControlTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class PlaceObject2
extends ControlTag {
    private boolean move;
    private int depth;
    private int character = -1;
    private AffineTransform matrix = null;
    private ColorXform cxform = null;
    private int ratio = -1;
    private String name = null;
    private int clipDepth = -1;
    private ClipEventFlags allEventFlags = null;
    private Vector clipActionRecords = null;

    public PlaceObject2(int id, int depth, AffineTransform matrix) {
        this(false, depth, id, matrix, null, 0, null, 0);
    }

    public PlaceObject2(int id, int depth, AffineTransform matrix, int clipDepth) {
        this(false, depth, id, matrix, null, 0, null, clipDepth);
    }

    public PlaceObject2(boolean move, int depth, int id, AffineTransform matrix, ColorXform cxform, int ratio, String name, int clipDepth) {
        this();
        this.move = move;
        this.depth = depth;
        this.character = id;
        this.matrix = matrix;
        this.cxform = cxform;
        this.ratio = ratio;
        this.name = name;
        this.clipDepth = clipDepth;
    }

    public PlaceObject2() {
        super(26, 3);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        PlaceObject2 tag = new PlaceObject2();
        boolean hasClipActions = swf.readBitFlag();
        boolean hasClipDepth = swf.readBitFlag();
        boolean hasName = swf.readBitFlag();
        boolean hasRatio = swf.readBitFlag();
        boolean hasColorXform = swf.readBitFlag();
        boolean hasMatrix = swf.readBitFlag();
        boolean hasCharacter = swf.readBitFlag();
        this.move = swf.readBitFlag();
        tag.depth = swf.readUnsignedShort();
        if (hasCharacter) {
            tag.character = swf.readUnsignedShort();
        }
        if (hasMatrix) {
            tag.matrix = swf.readMatrix();
        }
        if (hasColorXform) {
            tag.cxform = new ColorXform(swf, true);
        }
        if (hasRatio) {
            tag.ratio = swf.readUnsignedShort();
        }
        if (hasName) {
            tag.name = swf.readString();
        }
        if (hasClipDepth) {
            tag.clipDepth = swf.readUnsignedShort();
        }
        if (hasClipActions) {
            swf.readUnsignedShort();
            tag.allEventFlags = new ClipEventFlags(swf);
            tag.clipActionRecords = new Vector();
            ClipActionRecord clipActionRecord = new ClipActionRecord(swf);
            while (clipActionRecord.isEndRecord()) {
                tag.clipActionRecords.add(clipActionRecord);
                clipActionRecord = new ClipActionRecord(swf);
            }
        }
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeBitFlag(this.allEventFlags != null);
        swf.writeBitFlag(this.clipDepth > 0);
        swf.writeBitFlag(this.name != null);
        swf.writeBitFlag(this.ratio >= 0);
        swf.writeBitFlag(this.cxform != null);
        swf.writeBitFlag(this.matrix != null);
        swf.writeBitFlag(this.character >= 0);
        swf.writeBitFlag(this.move);
        swf.writeUnsignedShort(this.depth);
        if (this.character >= 0) {
            swf.writeUnsignedShort(this.character);
        }
        if (this.matrix != null) {
            swf.writeMatrix(this.matrix);
        }
        if (this.cxform != null) {
            this.cxform.write(swf, true);
        }
        if (this.ratio >= 0) {
            swf.writeUnsignedShort(this.ratio);
        }
        if (this.name != null) {
            swf.writeString(this.name);
        }
        if (this.clipDepth > 0) {
            swf.writeUnsignedShort(this.clipDepth);
        }
        if (this.allEventFlags != null) {
            swf.writeUnsignedShort(0);
            this.allEventFlags.write(swf);
            int i2 = 0;
            while (i2 < this.clipActionRecords.size()) {
                ClipActionRecord clipActionRecord = (ClipActionRecord)this.clipActionRecords.get(i2);
                clipActionRecord.write(swf);
                ++i2;
            }
            swf.writeUnsignedInt(0L);
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer(super.toString() + "\n");
        if (this.move) {
            s2.append("  move\n");
        }
        s2.append("  depth: " + this.depth + "\n");
        if (this.character >= 0) {
            s2.append("  character: " + this.character + "\n");
        }
        if (this.matrix != null) {
            s2.append("  matrix: " + this.matrix + "\n");
        }
        if (this.cxform != null) {
            s2.append("  xform: " + this.cxform + "\n");
        }
        if (this.ratio >= 0) {
            s2.append("  ratio: " + this.ratio + "\n");
        }
        if (this.name != null) {
            s2.append("  name: " + this.name + "\n");
        }
        if (this.clipDepth > 0) {
            s2.append("  clipDepth: " + this.clipDepth + "\n");
        }
        if (this.allEventFlags != null) {
            s2.append("  allEventFlags: " + this.allEventFlags + "\n");
            int i2 = 0;
            while (i2 < this.clipActionRecords.size()) {
                s2.append("     " + this.clipActionRecords.get(i2) + "\n");
                ++i2;
            }
        }
        return s2.toString();
    }
}

