/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.emf.EMFHandleManager;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedOutputStream;

public class EMFOutputStream
extends TaggedOutputStream {
    private String application;
    private String name;
    private int recordCount = 0;
    private Rectangle imageBounds;
    private int version;
    private EMFHandleManager handles;
    private Dimension device;

    public EMFOutputStream(OutputStream os, Rectangle imageBounds, EMFHandleManager handles, String application, String name, Dimension device, int version) throws IOException {
        super(os, new EMFTagSet(version), null, true);
        this.version = version;
        this.imageBounds = imageBounds;
        this.handles = handles;
        this.application = application;
        this.name = name;
        this.device = device;
        this.pushBuffer();
    }

    public EMFOutputStream(OutputStream os, Rectangle imageBounds, EMFHandleManager handles, String application, String name, Dimension device) throws IOException {
        this(os, imageBounds, handles, application, name, device, 1);
    }

    public void close() throws IOException {
        int len = this.popBuffer();
        ++this.recordCount;
        EMFHeader header = new EMFHeader(this.imageBounds, this.getVersion(), 0, len, this.recordCount, this.handles.maxHandlesUsed(), this.application, this.name, this.device);
        this.writeHeader(header);
        this.append();
        super.close();
    }

    public void writeDWORD(int i2) throws IOException {
        this.writeUnsignedInt(i2);
    }

    public void writeDWORD(int[] w2) throws IOException {
        int i2 = 0;
        while (i2 < w2.length) {
            this.writeDWORD(w2[i2]);
            ++i2;
        }
    }

    public void writeWORD(int s2) throws IOException {
        this.writeUnsignedShort(s2);
    }

    public void writeFLOAT(float f2) throws IOException {
        this.writeFloat(f2);
    }

    public void writeCOLORREF(Color c2) throws IOException {
        this.writeByte(c2.getRed());
        this.writeByte(c2.getGreen());
        this.writeByte(c2.getBlue());
        this.writeByte(0);
    }

    public void writeCOLOR16(Color c2) throws IOException {
        this.writeShort(c2.getRed() << 8);
        this.writeShort(c2.getGreen() << 8);
        this.writeShort(c2.getBlue() << 8);
        this.writeShort(c2.getAlpha() << 8);
    }

    public void writeXFORM(AffineTransform t2) throws IOException {
        this.writeFLOAT((float)t2.getScaleX());
        this.writeFLOAT((float)t2.getShearY());
        this.writeFLOAT((float)t2.getShearX());
        this.writeFLOAT((float)t2.getScaleY());
        this.writeFLOAT((float)t2.getTranslateX());
        this.writeFLOAT((float)t2.getTranslateY());
    }

    public void writePOINTS(Point[] p2) throws IOException {
        this.writePOINTS(p2.length, p2);
    }

    public void writePOINTS(int n2, Point[] p2) throws IOException {
        int i2 = 0;
        while (i2 < n2) {
            this.writePOINTS(p2[i2]);
            ++i2;
        }
    }

    public void writePOINTS(Point p2) throws IOException {
        this.writeSHORT((short)p2.x);
        this.writeSHORT((short)p2.y);
    }

    public void writePOINTL(Point[] p2) throws IOException {
        this.writePOINTL(p2.length, p2);
    }

    public void writePOINTL(int n2, Point[] p2) throws IOException {
        int i2 = 0;
        while (i2 < n2) {
            this.writePOINTL(p2[i2]);
            ++i2;
        }
    }

    public void writePOINTL(Point p2) throws IOException {
        this.writeLONG(p2.x);
        this.writeLONG(p2.y);
    }

    public void writeRECTL(Rectangle r2) throws IOException {
        this.writeLONG(r2.x);
        this.writeLONG(r2.y);
        this.writeLONG(r2.x + r2.width);
        this.writeLONG(r2.y + r2.height);
    }

    public void writeSIZEL(Dimension d2) throws IOException {
        this.writeLONG(d2.width);
        this.writeLONG(d2.height);
    }

    public void writeUINT(int i2) throws IOException {
        this.writeUnsignedInt(i2);
    }

    public void writeULONG(int i2) throws IOException {
        this.writeUnsignedInt(i2);
    }

    public void writeLONG(int i2) throws IOException {
        this.writeInt(i2);
    }

    public void writeSHORT(short i2) throws IOException {
        this.writeShort(i2);
    }

    public void writeBYTE(byte[] b2) throws IOException {
        this.writeByte(b2);
    }

    public void writeBYTE(byte b2) throws IOException {
        this.writeByte(b2);
    }

    public void writeBYTE(int b2) throws IOException {
        this.writeByte(b2);
    }

    public void writeBYTE(boolean b2) throws IOException {
        this.writeBYTE(b2 ? 1 : 0);
    }

    public void writeWORD(boolean b2) throws IOException {
        this.writeWORD(b2 ? 1 : 0);
    }

    public void writeDWORD(boolean b2) throws IOException {
        this.writeDWORD(b2 ? 1 : 0);
    }

    public void writeWCHAR(String s2) throws IOException {
        this.writeByte(s2.getBytes("UTF-16LE"));
    }

    public void writeWCHAR(String s2, int size) throws IOException {
        this.writeWCHAR(s2);
        int i2 = size - s2.length();
        while (i2 > 0) {
            this.writeWORD(0);
            --i2;
        }
    }

    protected int getTagAlignment() {
        return 4;
    }

    protected void writeTagHeader(TagHeader header) throws IOException {
        int tagID = header.getTag();
        long length = header.getLength();
        this.writeUnsignedInt(tagID);
        this.writeUnsignedInt(length + 8L);
    }

    public void writeTag(Tag tag) throws IOException {
        ++this.recordCount;
        super.writeTag(tag);
    }

    protected void writeActionHeader(ActionHeader header) throws IOException {
    }

    public void writeHeader(EMFHeader header) throws IOException {
        header.write(this);
    }

    public int getVersion() {
        return this.version;
    }
}

