/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;

public class BarcodeInter25
extends Barcode {
    static byte[][] BARS = new byte[][]{{0, 0, 1, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 0, 0, 1}, {1, 1, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 1, 0, 0}, {0, 1, 1, 0, 0}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {0, 1, 0, 1, 0}};

    public BarcodeInter25() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static String keepNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 >= '0' && c2 <= '9') {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static char getChecksum(String string) {
        int n2 = 3;
        int n3 = 0;
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            int n5 = string.charAt(n4) - 48;
            n3 += n2 * n5;
            n2 ^= 2;
            --n4;
        }
        return (char)((10 - n3 % 10) % 10 + 48);
    }

    public static byte[] getBarsInter25(String string) {
        string = BarcodeInter25.keepNumbers(string);
        byte[] byArray = new byte[string.length() * 5 + 7];
        int n2 = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        int n3 = string.length() / 2;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = string.charAt(n4 * 2) - 48;
            int n6 = string.charAt(n4 * 2 + 1) - 48;
            byte[] byArray2 = BARS[n5];
            byte[] byArray3 = BARS[n6];
            int n7 = 0;
            while (n7 < 5) {
                byArray[n2++] = byArray2[n7];
                byArray[n2++] = byArray3[n7];
                ++n7;
            }
            ++n4;
        }
        byArray[n2++] = 1;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            f2 = this.font.getWidthPoint(string, this.size);
        }
        string = BarcodeInter25.keepNumbers(this.code);
        int n2 = string.length();
        if (this.generateChecksum) {
            ++n2;
        }
        float f4 = (float)n2 * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f2 = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            f2 = this.font.getWidthPoint(string, this.size);
        }
        String string2 = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            string2 = string2 + BarcodeInter25.getChecksum(string2);
        }
        int n2 = string2.length();
        float f3 = (float)n2 * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f7 = this.barHeight - this.baseline;
            } else {
                f7 = -this.font.getFontDescriptor(3, this.size);
                f6 = f7 + this.baseline;
            }
        }
        byte[] byArray = BarcodeInter25.getBarsInter25(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            float f8;
            float f9 = f8 = byArray[n3] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f4, f6, f8, this.barHeight);
            }
            bl = !bl;
            f4 += f8;
            ++n3;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f7);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }
}

