/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkupAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Rectangle
implements Element,
MarkupAttributes {
    public static final int UNDEFINED = -1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int NO_BORDER = 0;
    public static final int BOX = 15;
    protected float llx;
    protected float lly;
    protected float urx;
    protected float ury;
    protected int border = -1;
    protected float borderWidth = -1.0f;
    protected Color color = null;
    protected Color background = null;
    protected float grayFill = 0.0f;
    protected int rotation = 0;
    protected Properties markupAttributes;

    public Rectangle(float f2, float f3, float f4, float f5) {
        this.llx = f2;
        this.lly = f3;
        this.urx = f4;
        this.ury = f5;
    }

    public Rectangle(float f2, float f3) {
        this(0.0f, 0.0f, f2, f3);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.left(), rectangle.bottom(), rectangle.right(), rectangle.top());
        this.llx = rectangle.llx;
        this.lly = rectangle.lly;
        this.urx = rectangle.urx;
        this.ury = rectangle.ury;
        this.rotation = rectangle.rotation;
        this.border = rectangle.border;
        this.borderWidth = rectangle.borderWidth;
        this.color = rectangle.color;
        this.background = rectangle.background;
        this.grayFill = rectangle.grayFill;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 30;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public Rectangle rectangle(float f2, float f3) {
        Rectangle rectangle = new Rectangle(this);
        rectangle.setBorder(this.border);
        rectangle.setBorderWidth(this.borderWidth);
        rectangle.setBorderColor(this.color);
        rectangle.setBackgroundColor(this.background);
        rectangle.setGrayFill(this.grayFill);
        if (this.top() > f2) {
            rectangle.setTop(f2);
            rectangle.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < f3) {
            rectangle.setBottom(f3);
            rectangle.setBorder(this.border - (this.border & 2));
        }
        return rectangle;
    }

    public Rectangle rotate() {
        Rectangle rectangle = new Rectangle(this.lly, this.llx, this.ury, this.urx);
        rectangle.rotation = this.rotation + 90;
        rectangle.rotation %= 360;
        return rectangle;
    }

    public void setLeft(float f2) {
        this.llx = f2;
    }

    public void setRight(float f2) {
        this.urx = f2;
    }

    public void setTop(float f2) {
        this.ury = f2;
    }

    public void setBottom(float f2) {
        this.lly = f2;
    }

    public void setBorder(int n2) {
        this.border = n2;
    }

    public void setBorderWidth(float f2) {
        this.borderWidth = f2;
    }

    public void setBorderColor(Color color) {
        this.color = color;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
    }

    public void setGrayFill(float f2) {
        if (f2 >= 0.0f && (double)f2 <= 1.0) {
            this.grayFill = f2;
        }
    }

    public float left() {
        return this.llx;
    }

    public float right() {
        return this.urx;
    }

    public float top() {
        return this.ury;
    }

    public float bottom() {
        return this.lly;
    }

    public float left(float f2) {
        return this.llx + f2;
    }

    public float right(float f2) {
        return this.urx - f2;
    }

    public float top(float f2) {
        return this.ury - f2;
    }

    public float bottom(float f2) {
        return this.lly + f2;
    }

    public float width() {
        return this.urx - this.llx;
    }

    public float height() {
        return this.ury - this.lly;
    }

    public boolean hasBorders() {
        return this.border > 0 && this.borderWidth > 0.0f;
    }

    public boolean hasBorder(int n2) {
        return this.border != -1 && (this.border & n2) == n2;
    }

    public int border() {
        return this.border;
    }

    public float borderWidth() {
        return this.borderWidth;
    }

    public Color borderColor() {
        return this.color;
    }

    public Color backgroundColor() {
        return this.background;
    }

    public float grayFill() {
        return this.grayFill;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

