/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.io;

import java.util.Hashtable;
import org.freehep.xml.io.XMLIOFactory;
import org.freehep.xml.io.XMLIOProxy;
import org.freehep.xml.io.XMLIORegistry;

public class DefaultXMLIORegistry
implements XMLIORegistry {
    private Hashtable factoryHash = new Hashtable();
    private Hashtable proxyHash = new Hashtable();
    private Hashtable classIds = new Hashtable();
    private Hashtable idClasses = new Hashtable();

    public void register(Object obj) {
        int i2;
        Class[] classes;
        if (!(obj instanceof XMLIOFactory) && !(obj instanceof XMLIOProxy)) {
            throw new IllegalArgumentException("Cannot register object " + obj + "." + "Only XMLIOFactories and XMLIOProxies can be registered!");
        }
        if (obj instanceof XMLIOFactory) {
            XMLIOFactory xmlioFactory = (XMLIOFactory)obj;
            classes = xmlioFactory.XMLIOFactoryClasses();
            i2 = 0;
            while (i2 < classes.length) {
                if (this.factoryHash.containsKey(classes[i2])) {
                    throw new IllegalArgumentException("Identifier " + classes[i2] + " has already been registered!!");
                }
                this.factoryHash.put(classes[i2], xmlioFactory);
                String objClassString = classes[i2].toString();
                String classId = objClassString.substring(objClassString.lastIndexOf(".") + 1);
                classId = classId.replace('$', '-');
                if (this.classIds.containsValue(classId)) {
                    throw new RuntimeException("Already registered ClassId in the registry!!!");
                }
                this.classIds.put(classes[i2], classId);
                this.idClasses.put(classId, classes[i2]);
                ++i2;
            }
        }
        if (obj instanceof XMLIOProxy) {
            XMLIOProxy xmlioProxy = (XMLIOProxy)obj;
            classes = xmlioProxy.XMLIOProxyClasses();
            i2 = 0;
            while (i2 < classes.length) {
                if (this.proxyHash.containsKey(classes[i2])) {
                    throw new IllegalArgumentException("Class " + classes[i2] + " has already been registered!!");
                }
                this.proxyHash.put(classes[i2], xmlioProxy);
                ++i2;
            }
        }
    }

    public XMLIOFactory getXMLIOFactory(Class objClass) {
        return (XMLIOFactory)this.factoryHash.get(objClass);
    }

    public XMLIOProxy getXMLIOProxy(Class objClass) {
        return (XMLIOProxy)this.proxyHash.get(objClass);
    }

    public String getClassId(Class clName) {
        return (String)this.classIds.get(clName);
    }

    public Class getIdClass(String objName) {
        return (Class)this.idClasses.get(objName);
    }
}

