/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class DecompressableInputStream
extends InputStream {
    private boolean decompress;
    private InflaterInputStream iis;
    private InputStream in;

    public DecompressableInputStream(InputStream input) {
        this.in = input;
        this.decompress = false;
    }

    public int read() throws IOException {
        return this.decompress ? this.iis.read() : this.in.read();
    }

    public long skip(long n2) throws IOException {
        return this.decompress ? this.iis.skip(n2) : this.in.skip(n2);
    }

    public void startDecompressing() throws IOException {
        this.decompress = true;
        this.iis = new InflaterInputStream(this.in);
    }
}

