/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Observer;
import java.util.Set;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandTarget;
import org.freehep.util.commanddispatcher.MultiTarget;

public class CommandTargetManager {
    private Set groups = new HashSet();
    private Set sources = new HashSet();
    private boolean started = false;

    public synchronized void add(CommandGroup group) {
        if (this.groups.add(group) && this.started) {
            Iterator i2 = this.sources.iterator();
            while (i2.hasNext()) {
                CommandSource s2 = (CommandSource)i2.next();
                String command = s2.getCommand();
                CommandTarget target = group.acceptCommand(command);
                if (target == null) continue;
                CommandTarget existingTarget = s2.getTarget();
                if (existingTarget == null) {
                    if (!s2.setTarget(target) || !(s2 instanceof Observer)) continue;
                    group.addObserver((Observer)((Object)s2));
                    continue;
                }
                if (existingTarget instanceof MultiTarget) {
                    ((MultiTarget)existingTarget).add(target);
                    continue;
                }
                if (s2 instanceof Observer) {
                    existingTarget.getGroup().deleteObserver((Observer)((Object)s2));
                }
                MultiTarget multi = new MultiTarget(command);
                multi.add(existingTarget);
                multi.add(target);
                if (!s2.setTarget(multi) || !(s2 instanceof Observer)) continue;
                multi.getGroup().addObserver((Observer)((Object)s2));
            }
        }
        group.setManager(this);
    }

    public synchronized void add(CommandSource source) {
        if (this.sources.add(source) && this.started) {
            this.linkCommandSource(source);
        }
    }

    public void handleCommandError(Throwable x2) {
        System.err.println("Error during command invocation");
        x2.printStackTrace();
    }

    public synchronized void remove(CommandGroup group) {
        if (this.groups.remove(group) && this.started) {
            Iterator i2 = this.sources.iterator();
            while (i2.hasNext()) {
                CommandSource s2 = (CommandSource)i2.next();
                CommandTarget target = s2.getTarget();
                if (target == null) continue;
                if (target.getGroup() == group) {
                    s2.clearTarget();
                    if (!(s2 instanceof Observer)) continue;
                    group.deleteObserver((Observer)((Object)s2));
                    continue;
                }
                if (!(target instanceof MultiTarget)) continue;
                ((MultiTarget)target).removeGroup(group);
            }
        }
        group.setManager(null);
    }

    public synchronized void remove(CommandSource source) {
        CommandTarget t2;
        if (this.sources.remove(source) && this.started && (t2 = source.getTarget()) != null) {
            source.clearTarget();
            if (source instanceof Observer) {
                t2.getGroup().deleteObserver((Observer)((Object)source));
            }
        }
    }

    public synchronized void start() {
        this.started = true;
        Iterator i2 = this.sources.iterator();
        while (i2.hasNext()) {
            this.linkCommandSource((CommandSource)i2.next());
        }
    }

    private void linkCommandSource(CommandSource s2) {
        String command = s2.getCommand();
        CommandTarget theTarget = null;
        Iterator i2 = this.groups.iterator();
        while (i2.hasNext()) {
            CommandGroup g2 = (CommandGroup)i2.next();
            CommandTarget t2 = g2.acceptCommand(command);
            if (t2 == null) continue;
            if (theTarget == null) {
                theTarget = t2;
                continue;
            }
            if (theTarget instanceof MultiTarget) {
                ((MultiTarget)theTarget).add(t2);
                continue;
            }
            MultiTarget multi = new MultiTarget(command);
            multi.add(theTarget);
            multi.add(t2);
            theTarget = multi;
        }
        if (theTarget != null && s2.setTarget(theTarget) && s2 instanceof Observer) {
            theTarget.getGroup().addObserver((Observer)((Object)s2));
        }
    }
}

