/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.FillStyleArray;
import org.freehep.graphicsio.swf.LineStyleArray;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineMorphShape
extends DefinitionTag {
    private int character;
    private Rectangle2D startBounds;
    private Rectangle2D endBounds;
    protected FillStyleArray fillStyles;
    protected LineStyleArray lineStyles;
    protected SWFShape startEdges;
    protected SWFShape endEdges;

    public DefineMorphShape(int id, Rectangle2D startBounds, Rectangle2D endBounds, FillStyleArray fillStyles, LineStyleArray lineStyles, SWFShape startEdges, SWFShape endEdges) {
        this();
        this.character = id;
        this.startBounds = startBounds;
        this.endBounds = endBounds;
        this.fillStyles = fillStyles;
        this.lineStyles = lineStyles;
        this.startEdges = startEdges;
        this.endEdges = endEdges;
    }

    public DefineMorphShape() {
        super(46, 3);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineMorphShape tag = new DefineMorphShape();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        tag.startBounds = swf.readRect();
        tag.endBounds = swf.readRect();
        long offset = swf.readUnsignedInt();
        this.fillStyles = new FillStyleArray(swf, true, true);
        this.lineStyles = new LineStyleArray(swf, true, true);
        this.startEdges = new SWFShape(swf, this.fillStyles, this.lineStyles, true, true);
        this.endEdges = new SWFShape(swf, this.fillStyles, this.lineStyles, true, true);
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeRect(this.startBounds);
        swf.writeRect(this.endBounds);
        swf.pushBuffer();
        this.fillStyles.write(swf, true);
        this.lineStyles.write(swf, true);
        this.startEdges.write(swf, true);
        int offset = swf.popBuffer();
        swf.writeUnsignedInt(offset);
        swf.append();
        this.endEdges.write(swf, true);
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append(super.toString() + "\n");
        s2.append("  character:   " + this.character + "\n");
        s2.append("  startBounds: " + this.startBounds + "\n");
        s2.append("  endBounds:   " + this.endBounds + "\n");
        s2.append(this.fillStyles.toString());
        s2.append(this.lineStyles.toString());
        s2.append("  startEdges: " + this.startEdges + "\n");
        s2.append("  endEdges:   " + this.endEdges + "\n");
        return s2.toString();
    }
}

