/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class TextW
implements EMFConstants {
    private Point pos;
    private String string;
    private int options;
    private int[] widths;
    private Rectangle bounds;

    public TextW(Point pos, String string, int options, Rectangle bounds, int[] widths) {
        this.pos = pos;
        this.string = string;
        this.options = options;
        this.bounds = bounds;
        this.widths = widths;
    }

    TextW(EMFInputStream emf) throws IOException {
        this.pos = emf.readPOINTL();
        int sLen = emf.readDWORD();
        int sOffset = emf.readDWORD();
        this.options = emf.readDWORD();
        this.bounds = emf.readRECTL();
        int cOffset = emf.readDWORD();
        this.string = new String(emf.readBYTE(2 * sLen), "UTF-16LE");
        if (2 * sLen % 4 != 0) {
            int i2 = 0;
            while (i2 < 4 - 2 * sLen % 4) {
                emf.readBYTE();
                ++i2;
            }
        }
        this.widths = new int[sLen];
        int i3 = 0;
        while (i3 < sLen) {
            this.widths[i3] = emf.readDWORD();
            ++i3;
        }
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writePOINTL(this.pos);
        emf.writeDWORD(this.string.length());
        emf.writeDWORD(76);
        emf.writeDWORD(this.options);
        emf.writeRECTL(this.bounds);
        int pad = 2 * this.string.length() % 4;
        if (pad > 0) {
            pad = 4 - pad;
        }
        emf.writeDWORD(76 + 2 * this.string.length() + pad);
        emf.writeBYTE(this.string.getBytes("UTF-16LE"));
        int i2 = 0;
        while (i2 < pad) {
            emf.writeBYTE(0);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.string.length()) {
            emf.writeDWORD(this.widths[i3]);
            ++i3;
        }
    }

    public String toString() {
        StringBuffer widthsS = new StringBuffer();
        int i2 = 0;
        while (i2 < this.string.length()) {
            widthsS.append("," + this.widths[i2]);
            ++i2;
        }
        widthsS.append(']');
        widthsS.setCharAt(0, '[');
        return "  Text\n    pos: " + this.pos + "\n" + "    options: " + this.options + "\n" + "    bounds: " + this.bounds + "\n" + "    string: " + this.string + "\n" + "    widths: " + widthsS;
    }
}

