/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.Gradient;
import org.freehep.graphicsio.emf.GradientRectangle;
import org.freehep.graphicsio.emf.GradientTriangle;
import org.freehep.graphicsio.emf.TriVertex;

public class GradientFill
extends EMFTag
implements EMFConstants {
    private Rectangle bounds;
    private int mode;
    private TriVertex[] vertices;
    private Gradient[] gradients;

    GradientFill() {
        super(118, 1);
    }

    public GradientFill(Rectangle bounds, int mode, TriVertex[] vertices, Gradient[] gradients) {
        this();
        this.bounds = bounds;
        this.mode = mode;
        this.vertices = vertices;
        this.gradients = gradients;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle bounds = emf.readRECTL();
        TriVertex[] vertices = new TriVertex[emf.readDWORD()];
        Gradient[] gradients = new Gradient[emf.readDWORD()];
        int mode = emf.readULONG();
        int i2 = 0;
        while (i2 < vertices.length) {
            vertices[i2] = new TriVertex(emf);
            ++i2;
        }
        int i3 = 0;
        while (i3 < gradients.length) {
            gradients[i3] = mode == 2 ? new GradientTriangle(emf) : new GradientRectangle(emf);
            ++i3;
        }
        GradientFill tag = new GradientFill(bounds, mode, vertices, gradients);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.vertices.length);
        emf.writeDWORD(this.gradients.length);
        emf.writeULONG(this.mode);
        int i2 = 0;
        while (i2 < this.vertices.length) {
            this.vertices[i2].write(emf);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.gradients.length) {
            this.gradients[i3].write(emf);
            ++i3;
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append(super.toString() + "\n");
        s2.append("  bounds: " + this.bounds + "\n");
        s2.append("  mode: " + this.mode + "\n");
        int i2 = 0;
        while (i2 < this.vertices.length) {
            s2.append("  vertex[" + i2 + "]: " + this.vertices[i2] + "\n");
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.gradients.length) {
            s2.append("  gradient[" + i3 + "]: " + this.gradients[i3] + "\n");
            ++i3;
        }
        return s2.toString();
    }
}

