/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.IOException;
import org.freehep.graphicsio.PathConstructor;

public abstract class AbstractPathConstructor
implements PathConstructor {
    protected double currentX = 0.0;
    protected double currentY = 0.0;

    protected AbstractPathConstructor() {
    }

    public void flush() throws IOException {
        this.currentX = 0.0;
        this.currentY = 0.0;
    }

    public boolean addPath(Shape s2) throws IOException {
        return AbstractPathConstructor.addPath(this, s2);
    }

    public static boolean addPath(PathConstructor out, Shape s2) throws IOException {
        PathIterator path = s2.getPathIterator(null);
        double[] coords = new double[6];
        double currentX = 0.0;
        double currentY = 0.0;
        double pathStartX = 0.0;
        double pathStartY = 0.0;
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    out.move(coords[0], coords[1]);
                    pathStartX = currentX = coords[0];
                    pathStartY = currentY = coords[1];
                    break;
                }
                case 1: {
                    out.line(coords[0], coords[1]);
                    currentX = coords[0];
                    currentY = coords[1];
                    break;
                }
                case 2: {
                    out.quad(coords[0], coords[1], coords[2], coords[3]);
                    currentX = coords[2];
                    currentY = coords[3];
                    break;
                }
                case 3: {
                    out.cubic(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    currentX = coords[4];
                    currentY = coords[5];
                    break;
                }
                case 4: {
                    out.closePath();
                    currentX = pathStartX;
                    currentY = pathStartY;
                }
            }
            path.next();
        }
        out.flush();
        return path.getWindingRule() == 0;
    }

    public static boolean isEvenOdd(Shape s2) {
        return s2.getPathIterator(null).getWindingRule() == 0;
    }
}

