/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.PopupListener;
import org.freehep.application.PropertyUtilities;
import org.freehep.swing.layout.FlowScrollLayout;
import org.freehep.util.images.ImageHandler;

public class PrintPreview
extends JPanel {
    private Pageable m_pageable;
    private JPanel m_preview;
    private Properties m_props;
    private int m_scale = 10;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$javax$swing$JDialog;

    public PrintPreview() {
        Application app = Application.getApplication();
        if (app != null) {
            this.m_props = app.getUserProperties();
            this.m_scale = PropertyUtilities.getInteger(this.m_props, "printPreviewScale", 10);
        }
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        this.add((Component)this.createToolBar(), "North");
        JScrollPane ps = new JScrollPane();
        FlowScrollLayout layout = new FlowScrollLayout(ps);
        layout.setAlignment(0);
        this.m_preview = new JPanel(layout);
        this.m_preview.addMouseListener(new PopupListener(this.createPopupMenu()));
        ps.setViewportView(this.m_preview);
        this.add((Component)ps, "Center");
    }

    public void setPrintable(Printable target) throws PrinterException {
        this.setPrintable(target, PrinterJob.getPrinterJob().defaultPage());
    }

    public void setPrintable(Printable target, PageFormat pf) throws PrinterException {
        this.setPageable(new PageableFromPrintable(target, pf));
    }

    public void setPageable(Pageable target) {
        this.m_pageable = target;
        this.m_preview.removeAll();
        int i2 = 0;
        while (i2 < target.getNumberOfPages()) {
            this.m_preview.add(new PagePreview(100 / this.m_scale, i2));
            ++i2;
        }
    }

    private void setScale(int i2) {
        if (this.m_props != null) {
            PropertyUtilities.setInteger(this.m_props, "printPreviewScale", i2);
        }
        Component[] comps = this.m_preview.getComponents();
        int k2 = 0;
        while (k2 < comps.length) {
            if (comps[k2] instanceof PagePreview) {
                PagePreview pp = (PagePreview)comps[k2];
                pp.setScale(100 / i2);
            }
            ++k2;
        }
        this.m_preview.revalidate();
    }

    public JDialog createDialog(Component owner) {
        return this.createDialog(owner, "Print Preview");
    }

    public JDialog createDialog(Component owner, String title) {
        Window w2 = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = PrintPreview.class$("java.awt.Window")) : class$java$awt$Window, owner);
        JDialog dlg = w2 instanceof Frame ? new JDialog((Frame)w2, title, true) : new JDialog((Dialog)w2, title, true);
        dlg.setContentPane(this);
        dlg.setDefaultCloseOperation(2);
        return dlg;
    }

    protected boolean onPrint(Pageable document) throws PrinterException {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPageable(document);
        pj.print();
        return true;
    }

    protected void onError(PrinterException x2) {
        JOptionPane.showMessageDialog(this, "Print Error: " + x2.getMessage(), "Print Error...", 0);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.getPrintAction());
        menu.add(this.getCloseAction());
        return menu;
    }

    protected JToolBar createToolBar() {
        JToolBar tb = new JToolBar();
        tb.add(this.createCloseButton());
        tb.add(this.createPrintButton());
        tb.addSeparator();
        tb.add(this.createScaleChooser());
        tb.setFloatable(false);
        tb.setRollover(true);
        return tb;
    }

    private void done() {
        JDialog dlg = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = PrintPreview.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, this);
        dlg.dispose();
    }

    public Action getCloseAction() {
        return new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e2) {
                PrintPreview.this.done();
            }
        };
    }

    public Action getPrintAction() {
        return new AbstractAction("Print", ImageHandler.getIcon("/toolbarButtonGraphics/general/Print16.gif", this.getClass())){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e2) {
                Cursor oldCursor = PrintPreview.this.getCursor();
                try {
                    block4: {
                        try {
                            PrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                            if (!PrintPreview.this.onPrint(PrintPreview.this.m_pageable)) break block4;
                            PrintPreview.this.done();
                        }
                        catch (PrinterException ex) {
                            PrintPreview.this.onError(ex);
                            Object var5_4 = null;
                            PrintPreview.this.setCursor(oldCursor);
                            return;
                        }
                    }
                    Object var5_3 = null;
                    PrintPreview.this.setCursor(oldCursor);
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    PrintPreview.this.setCursor(oldCursor);
                    throw throwable;
                }
            }
        };
    }

    protected JComponent createCloseButton() {
        return new JButton(this.getCloseAction());
    }

    protected JComponent createPrintButton() {
        return new JButton(this.getPrintAction());
    }

    protected JComponent createScaleChooser() {
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        final JComboBox<String> m_cbScale = new JComboBox<String>(scales);
        m_cbScale.setMaximumSize(m_cbScale.getPreferredSize());
        m_cbScale.setEditable(true);
        m_cbScale.setSelectedItem(this.m_scale + " %");
        m_cbScale.addActionListener(new ActionListener(){
            private boolean isRentrant = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e2) {
                if (this.isRentrant) {
                    return;
                }
                try {
                    this.isRentrant = true;
                    String str = m_cbScale.getSelectedItem().toString();
                    if (str.endsWith("%")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    str = str.trim();
                    int scale = 0;
                    try {
                        scale = Integer.parseInt(str);
                        if (scale <= 0) {
                            scale = 10;
                        } else if (scale > 100) {
                            scale = 100;
                        }
                    }
                    catch (NumberFormatException ex) {
                        scale = 10;
                    }
                    String scaleString = scale + " %";
                    if (!scaleString.equals(str)) {
                        m_cbScale.setSelectedItem(scaleString);
                    }
                    PrintPreview.this.setScale(scale);
                    Object var6_6 = null;
                    this.isRentrant = false;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.isRentrant = false;
                    throw throwable;
                }
            }
        });
        return m_cbScale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PageableFromPrintable
    implements Pageable {
        private Printable printable;
        private PageFormat pf;
        private int nPages;

        PageableFromPrintable(Printable input, PageFormat pf) throws PrinterException {
            this.pf = pf;
            this.printable = input;
            BufferedImage img = new BufferedImage(1, 1, 1);
            Graphics g2 = img.getGraphics();
            this.nPages = 0;
            while (input.print(g2, pf, this.nPages) == 0) {
                ++this.nPages;
            }
        }

        public int getNumberOfPages() {
            return this.nPages;
        }

        public PageFormat getPageFormat(int pages) {
            return this.pf;
        }

        public Printable getPrintable(int page) {
            return this.printable;
        }
    }

    private class PagePreview
    extends JPanel {
        private int m_page;
        private int m_scale;
        private int m_h;
        private int m_w;

        public PagePreview(int scale, int page) {
            this.m_page = page;
            this.m_scale = scale;
            PageFormat pf = PrintPreview.this.m_pageable.getPageFormat(page);
            this.m_w = (int)(pf.getWidth() / (double)scale);
            this.m_h = (int)(pf.getHeight() / (double)scale);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public void setScale(int scale) {
            this.m_scale = scale;
            PageFormat pf = PrintPreview.this.m_pageable.getPageFormat(this.m_page);
            this.m_w = (int)(pf.getWidth() / (double)scale);
            this.m_h = (int)(pf.getHeight() / (double)scale);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.m_w + ins.left + ins.right, this.m_h + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g2) {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintBorder(g2);
            Printable print = PrintPreview.this.m_pageable.getPrintable(this.m_page);
            PageFormat pf = PrintPreview.this.m_pageable.getPageFormat(this.m_page);
            try {
                Graphics2D g22 = (Graphics2D)g2;
                Rectangle2D.Double clip = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
                g22.scale(1.0 / (double)this.m_scale, 1.0 / (double)this.m_scale);
                g22.clip(clip);
                print.print(g2, pf, this.m_page);
            }
            catch (PrinterException x2) {}
        }
    }
}

