/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import java.io.Serializable;

public class CharVector
implements Cloneable,
Serializable {
    private static final int DEFAULT_BLOCK_SIZE = 2048;
    private int BLOCK_SIZE;
    private char[] array;
    private int n;

    public CharVector() {
        this(2048);
    }

    public CharVector(int n2) {
        this.BLOCK_SIZE = n2 > 0 ? n2 : 2048;
        this.array = new char[this.BLOCK_SIZE];
        this.n = 0;
    }

    public CharVector(char[] cArray) {
        this.BLOCK_SIZE = 2048;
        this.array = cArray;
        this.n = cArray.length;
    }

    public CharVector(char[] cArray, int n2) {
        this.BLOCK_SIZE = n2 > 0 ? n2 : 2048;
        this.array = cArray;
        this.n = cArray.length;
    }

    public void clear() {
        this.n = 0;
    }

    public Object clone() {
        CharVector charVector = new CharVector((char[])this.array.clone(), this.BLOCK_SIZE);
        charVector.n = this.n;
        return charVector;
    }

    public char[] getArray() {
        return this.array;
    }

    public int length() {
        return this.n;
    }

    public int capacity() {
        return this.array.length;
    }

    public void put(int n2, char c2) {
        this.array[n2] = c2;
    }

    public char get(int n2) {
        return this.array[n2];
    }

    public int alloc(int n2) {
        int n3 = this.n;
        int n4 = this.array.length;
        if (this.n + n2 >= n4) {
            char[] cArray = new char[n4 + this.BLOCK_SIZE];
            System.arraycopy(this.array, 0, cArray, 0, n4);
            this.array = cArray;
        }
        this.n += n2;
        return n3;
    }

    public void trimToSize() {
        if (this.n < this.array.length) {
            char[] cArray = new char[this.n];
            System.arraycopy(this.array, 0, cArray, 0, this.n);
            this.array = cArray;
        }
    }
}

