/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.Magnitude;

public class WholeNumber
extends Magnitude {
    private static final NumberFormat FORMAT = NumberFormat.getNumberInstance();
    private int whole;
    private boolean isNull;

    public WholeNumber() {
        this.isNull = true;
    }

    public WholeNumber(int n) {
        this.whole = n;
        this.isNull = false;
    }

    public WholeNumber(String string) {
        try {
            this.parse(string);
            this.isNull = false;
        }
        catch (ValueParseException valueParseException) {
            // empty catch block
        }
    }

    public WholeNumber(WholeNumber wholeNumber) {
        this.whole = wholeNumber.whole;
        this.isNull = false;
    }

    public void add(int n) {
        this.checkCanOperate();
        this.whole += n;
    }

    public void add(WholeNumber wholeNumber) {
        this.checkCanOperate();
        wholeNumber.checkCanOperate();
        this.whole += wholeNumber.whole;
    }

    public void clear() {
        this.isNull = true;
    }

    public int compareTo(int n) {
        return this.whole - n;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof WholeNumber)) {
            throw new IllegalArgumentException("Can only copy the value of  a WholeNumber object");
        }
        this.isNull = ((WholeNumber)naked).isNull;
        this.whole = ((WholeNumber)naked).whole;
    }

    public void divide(int n) {
        this.checkCanOperate();
        this.whole /= n;
    }

    public void divide(WholeNumber wholeNumber) {
        this.checkCanOperate();
        wholeNumber.checkCanOperate();
        this.whole /= wholeNumber.whole;
    }

    public double doubleValue() {
        this.checkCanOperate();
        return this.whole;
    }

    public boolean equals(Object object) {
        if (object instanceof WholeNumber) {
            return ((WholeNumber)object).whole == this.whole;
        }
        return super.equals(object);
    }

    public float floatValue() {
        this.checkCanOperate();
        return this.whole;
    }

    public int getInt() {
        this.checkCanOperate();
        return this.whole;
    }

    public String getObjectHelpText() {
        return "A Whole Number object.";
    }

    public int intValue() {
        this.checkCanOperate();
        return this.whole;
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public boolean isEqualTo(Magnitude magnitude) {
        if (magnitude instanceof WholeNumber) {
            if (this.isNull) {
                return magnitude.isEmpty();
            }
            return ((WholeNumber)magnitude).whole == this.whole;
        }
        throw new IllegalArgumentException("Parameter must be of type WholeNumber");
    }

    public boolean isLessThan(Magnitude magnitude) {
        if (magnitude instanceof WholeNumber) {
            return !this.isNull && !magnitude.isEmpty() && this.whole < ((WholeNumber)magnitude).whole;
        }
        throw new IllegalArgumentException("Parameter must be of type WholeNumber");
    }

    public boolean isNegative() {
        return this.whole < 0;
    }

    public boolean isZero() {
        return this.whole == 0;
    }

    public long longValue() {
        this.checkCanOperate();
        return this.whole;
    }

    public void multiply(int n) {
        this.checkCanOperate();
        this.whole *= n;
    }

    public void multiply(WholeNumber wholeNumber) {
        this.checkCanOperate();
        wholeNumber.checkCanOperate();
        this.whole *= wholeNumber.whole;
    }

    public void parse(String string) throws ValueParseException {
        if (string.trim().equals("")) {
            this.clear();
        } else {
            try {
                this.whole = FORMAT.parse(string).intValue();
                this.isNull = false;
            }
            catch (ParseException parseException) {
                throw new ValueParseException(parseException, "Invalid number");
            }
        }
    }

    public void reset() {
        this.whole = 0;
        this.isNull = false;
    }

    public void set(int n) {
        this.whole = n;
        this.isNull = false;
    }

    public void set(WholeNumber wholeNumber) {
        this.whole = wholeNumber.whole;
        this.isNull = false;
    }

    public void setInt(int n) {
        this.whole = n;
        this.isNull = false;
    }

    public void setValue(int n) {
        this.whole = n;
        this.isNull = false;
    }

    public void setValue(WholeNumber wholeNumber) {
        this.whole = wholeNumber.whole;
        this.isNull = wholeNumber.isNull;
    }

    public short shortValue() {
        this.checkCanOperate();
        return (short)this.whole;
    }

    public void subtract(int n) {
        this.checkCanOperate();
        this.add(-n);
    }

    public void subtract(WholeNumber wholeNumber) {
        wholeNumber.checkCanOperate();
        this.add(-wholeNumber.whole);
    }

    public Title title() {
        return new Title(this.isNull ? "" : FORMAT.format(this.whole));
    }

    public void restoreString(String string) {
        this.setValue(Integer.valueOf(string));
    }

    public String saveString() {
        return String.valueOf(this.intValue());
    }

    static {
        FORMAT.setParseIntegerOnly(true);
    }
}

