#!/bin/sh
# the next line restarts using wish\
exec wish "$0" "$@" 
if {![info exist vTcl(sourcing)]} {

        # Provoke name search
        catch {package require foobar}
        set names [package names]

        # Check if Itcl is available
        if {[lsearch -exact $names Itcl] != -1} {
            package require Itcl 3.0
            namespace import itcl::*
        }

        # Check if Itk is available
        if {[lsearch -exact $names Itk] != -1} {
            package require Itk 3.0
        }

        # Check if Iwidgets is available
        if {[lsearch -exact $names Iwidgets] != -1} {
            package require Iwidgets 3.0
            namespace import iwidgets::entryfield
            namespace import iwidgets::spinint
            namespace import iwidgets::combobox
            namespace import iwidgets::scrolledlistbox
            namespace import iwidgets::calendar
            namespace import iwidgets::dateentry
            namespace import iwidgets::scrolledhtml
            namespace import iwidgets::toolbar
            namespace import iwidgets::feedback
            namespace import iwidgets::optionmenu
            namespace import iwidgets::hierarchy
            namespace import iwidgets::buttonbox
            namespace import iwidgets::checkbox
            namespace import iwidgets::radiobox
            namespace import iwidgets::tabnotebook
            namespace import iwidgets::panedwindow
            namespace import iwidgets::scrolledtext

            switch $tcl_platform(platform) {
                windows {
                    option add *Scrolledhtml.sbWidth    16
                    option add *Scrolledtext.sbWidth    16
                    option add *Scrolledlistbox.sbWidth 16
                }
                default {
                    option add *Scrolledhtml.sbWidth    10
                    option add *Scrolledtext.sbWidth    10
                    option add *Scrolledlistbox.sbWidth 10
                }
            }
        }
    
}
#############################################################################
# Visual Tcl v1.51 Project
#

#################################
# VTCL LIBRARY PROCEDURES
#

proc Window {args} {
    global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    if {$name == "."} { wm withdraw $name; return }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
	    if {$exists} { wm deiconify $name; return }
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

if {![info exists vTcl(sourcing)]} {
namespace eval ::progressbar {

proc {::progressbar::Build} {w args} {
variable widgetOptions
  variable widgetGlobals

  if {$widgetGlobals(debug)} {
    puts stderr "pb_Build '$w' '$args'"
  }

  # create the namespace for this instance, and define a few
  # variables
  namespace eval ::progressbar::$w {
    variable options
    variable widgets
    variable info
  }

  # this gives us access to the namespace variables within
  # this proc
  upvar ::progressbar::${w}::widgets widgets
  upvar ::progressbar::${w}::options options
  upvar ::progressbar::${w}::info info

  set info(rgb) ""
  set info(rgbHasChanged) 0

  # this is our widget -- a frame of class Progressbar. Naturally,
  # it will contain other widgets. We create it here because
  # we need it to be able to set our default options.
  set widgets(this) [frame $w -class Progressbar1]

  # this defines all of the default options. We get the
  # values from the option database. Note that if an array
  # value is a list of length one it is an alias to another
  # option, so we just ignore it
  foreach name [array names widgetOptions] {
    if {[llength $widgetOptions($name)] == 1} continue
    set optName  [lindex $widgetOptions($name) 0]
    set optClass [lindex $widgetOptions($name) 1]
    set options($name) [option get $w $optName $optClass]
    if {$widgetGlobals(debug) > 1} {
      puts stderr "pb_Build:Opt '$w' '$optName' '$optClass' '$options($name)'"
    }
  }

  # now apply any of the options supplied on the command
  # line. This may overwrite our defaults, which is OK
  if {[llength $args] > 0} {
    array set options $args
  }
  
  # this will only set the name of canvas's widget, we will
  # later create the canvas in our drawing procedure.
  set widgets(canvas) $w.pb

  # we will later rename the frame's widget proc to be our
  # own custom widget proc. We need to keep track of this
  # new name, so we'll define and store it here...
  set widgets(frame) ::progressbar::${w}::$w

  # this moves the original frame widget proc into our
  # namespace and gives it a handy name
  rename ::$w $widgets(frame)

  # Alias the window to our WidgetProc and pass the window name.
  interp alias {} ::$w {} ::progressbar::WidgetProc $w

  # ok, the thing exists... let's do a bit more configuration. 
  if {[catch "Configure $widgets(this) [array get options]" error]} {
    return -code error $error
    catch {destroy $w}
  }

  return $w
}

}

namespace eval ::progressbar {

proc {::progressbar::Canonize} {w object opt} {
variable widgetOptions
  variable widgetCommands
  variable widgetGlobals
  variable widgetShapes

  if {$widgetGlobals(debug)} {
    puts stderr "pb_Canonize '$w' '$object' '$opt'"
  }

  switch $object {
    command {
      if {[lsearch -exact $widgetCommands $opt] >= 0} {
	return $opt
      }

      # command names aren't stored in an array, and there
      # isn't a way to get all the matches in a list, so
      # we'll stuff the columns in a temporary array so
      # we can use [array names]
      set list $widgetCommands
      foreach element $list {
	set tmp($element) ""
      }
      set matches [array names tmp ${opt}*]
    }

    option {
      if {[info exists widgetOptions($opt)]  && [llength $widgetOptions($opt)] == 3} {
	return $opt
      }
      set list [array names widgetOptions]
      set matches [array names widgetOptions ${opt}*]
    }

    shape {
      if {[lsearch -exact $widgetShapes $opt] >= 0} {
	return $opt
      }

      # same procedure as command
      set list $widgetShapes
      foreach element $list {
	set tmp($element) ""
      }
      set matches [array names tmp ${opt}*]
    }
  }
  if {[llength $matches] == 0} {
    set choices [HumanizeList $list]
    return -code error "unknown $object \"$opt\"; must be one of $choices"
  } elseif {[llength $matches] == 1} {
    # deal with option aliases
    set opt [lindex $matches 0]
    switch $object {
      option {
	if {[llength $widgetOptions($opt)] == 1} {
	  set opt $widgetOptions($opt)
	}
      }
    }
    return $opt
  } else {
      set choices [HumanizeList $list]
      return -code error "ambiguous $object \"$opt\"; must be one of $choices"
  }
}

}

namespace eval ::progressbar {

proc {::progressbar::Configure} {w args} {
variable widgetOptions
  variable widgetGlobals

  if {$widgetGlobals(debug)} {
    puts stderr "pb_Configure '$w' '$args'"
  }

  upvar ${w}::widgets widgets
  upvar ${w}::options options
  upvar ${w}::info info
  
  if {[llength $args] == 0} {
    # hmmm. User must be wanting all configuration information
    # note that if the value of an array element is of length
    # one it is an alias, which needs to be handled slightly
    # differently
    set results {}
    foreach opt [lsort [array names widgetOptions]] {
      if {[llength $widgetOptions($opt)] == 1} {
	set alias $widgetOptions($opt)
	set optName $widgetOptions($alias)
	lappend results [list $opt $optName]
      } else {
	set optName  [lindex $widgetOptions($opt) 0]
	set optClass [lindex $widgetOptions($opt) 1]
	set default [option get $w $optName $optClass]
	lappend results [list $opt $optName $optClass $default $options($opt)]
      }
    }
    return $results
  }
  
  # one argument means we are looking for configuration
  # information on a single option
  if {[llength $args] == 1} {
    set opt [Canonize $w option [lindex $args 0]]
    set optName  [lindex $widgetOptions($opt) 0]
    set optClass [lindex $widgetOptions($opt) 1]
    set default [option get $w $optName $optClass]
    set results [list $opt $optName $optClass $default $options($opt)]
    return $results
  }

  # if we have an odd number of values, bail. 
  if {[expr {[llength $args]%2}] == 1} {
    # hmmm. An odd number of elements in args
    return -code error "value for \"[lindex $args end]\" missing"
  }
  
  # Great. An even number of options. Let's make sure they 
  # are all valid before we do anything. Note that Canonize
  # will generate an error if it finds a bogus option; otherwise
  # it returns the canonical option name
  foreach {name value} $args {
    set name [Canonize $w option $name]
    set opts($name) $value
  }

  # process all of the configuration options
  foreach option [array names opts] {
    set newValue $opts($option)
    if {[info exists options($option)]} {
      set oldValue $options($option)
    }

    if {$widgetGlobals(debug) > 2} {
      puts stderr "pb_Configure:Opt '$option' n='$newValue' o='$oldValue'"
    }
    switch -- $option {
      -background  -
      -borderwidth -
      -relief      {
	if {[winfo exists $widgets(this)]} {
	  $widgets(frame) configure $option $newValue
	  set options($option) [$widgets(frame) cget $option]
	}
      }
      -color {
        switch -- $newValue {
	  @blue0    -
	  @blue1    -
	  @blue2    -
	  @blue3    -
	  @blue4    -
	  @green0   -
	  @green1   -
	  @green2   -
	  @green3   -
	  @yellow0  -
	  @yellow1  -
	  @red0     -
	  @red1     -
	  @magenta0 -
	  @brown0   -
	  @brown1   -
	  @gray0    {
	    set info(rgb) $widgetGlobals($newValue)
	  }
	  @* {
	    set info(rgb) $widgetGlobals(@saphir)
	  }
	  default {
	    set info(rgb) [RGBs $newValue]
	  }
	}
	set info(rgbHasChanged) 1
      }
      -percent {
	set options($option) $newValue
      }
      -shape {
	set options($option) [Canonize $w shape $newValue]
	set info(rgbHasChanged) 1
      }
      -variable {
	# hmmm .. are there any traces left? Yes! Destroy!
	if {[info procs Trace($w)] != ""} {
	  uplevel #0 trace vdelete $oldValue wu ::progressbar::Trace($w)
	  unset widgetGlobals($w)
	  rename Trace($w) {}
	}
	if {$newValue != ""} {
	  # there is a new variable to trace. build a new proc to trace it.
	  proc ::progressbar::Trace($w) {name1 name2 op} "
	    variable widgetGlobals

	    if {\$widgetGlobals(debug)} {
	      puts stderr \"pb_Trace($w) '\$name1' '\$name2' '\$op'\"
	    }
	    switch -- \$op {
	      w {
		if {\$name2 != \"\"} {
		  upvar 1 \${name1}(\$name2) var
		  catch {$w configure -percent \$var}
		} else {
		  upvar 1 \$name1 var
		  catch {$w configure -percent \$var}
		}
	      }
	      u {
		if {\[info procs Trace($w)\] != \"\"} {  unset widgetGlobals($w);  rename Trace($w) {};  }
	      }
	    }
	  "
	  # install trace proc for variable
	  uplevel #0 trace variable $newValue wu ::progressbar::Trace($w)
	}
	set options($option) $newValue
	set widgetGlobals($w) $newValue
      }
      -width {
	if {$newValue < 20} {
	  return -code error "a -width of less than 20 is not supported."
	}
	if {[winfo exists $widgets(canvas)]} {
	  $widgets(canvas) configure $option $newValue
	  set options($option) [$widgets(canvas) cget $option]
	} else {
          set options($option) $newValue
	}
      }
      -textvalue {
        set options($option) $newValue
	if {![winfo exists $widgets(canvas)]} { continue }
	$widgets(canvas) itemconfigure ttxt -text $newValue
      }
      -textcolor {
        set options($option) $newValue
	if {![winfo exists $widgets(canvas)]} { continue }
	$widgets(canvas) itemconfigure ttxt -fill $newValue
      }
    }
  }

  Draw $w
}

}

namespace eval ::progressbar {

proc {::progressbar::DestroyHandler} {w} {
variable widgetGlobals

  if {$widgetGlobals(debug)} {
    puts stderr "pb_DestroyHandler '$w'"
  }

  # hmmm .. are there any traces left? Yes! Destroy!
  if {[info procs Trace($w)] != ""} {
    uplevel 1 trace vdelete $widgetGlobals($w) wu ::progressbar::Trace($w)
    unset widgetGlobals($w)
    rename Trace($w) {}
  }

  # if the widget actually being destroyed is of class Progressbar,
  # crush the namespace and kill the proc. Get it? Crush. Kill. 
  # Destroy. Heh. Danger Will Robinson! Oh, man! I'm so funny it
  # brings tears to my eyes.
  if {[string compare [winfo class $w] "Progressbar1"] == 0} {
    namespace delete ::progressbar::$w
    rename $w {}
  }
}

}

namespace eval ::progressbar {

proc {::progressbar::Draw} {w} {
variable widgetGlobals

  if {$widgetGlobals(debug) > 2} {
    puts stderr "pb_Draw '$w'"
  }

  upvar ${w}::widgets widgets
  upvar ${w}::options options
  upvar ${w}::info info

  set width   $options(-width)
  set percent $options(-percent)
  set text    $options(-textvalue)

  if {$options(-shape) == "flat"} {
    set minDisplay 0
    if {[llength $info(rgb)] == 7} {
      set rgb(0) [lindex $info(rgb) 6]
    } else {
      set rgb(0) [lindex $info(rgb) 2]
    }
    set rgb(1) $rgb(0)
    set rgb(2) $rgb(0)
    set rgb(3) $rgb(0)
    set rgb(4) $rgb(0)
    set rgb(5) $rgb(0)
  } else {
    set minDisplay 7
    set rgb(0) [lindex $info(rgb) 0]
    set rgb(1) [lindex $info(rgb) 1]
    set rgb(2) [lindex $info(rgb) 2]
    set rgb(3) [lindex $info(rgb) 3]
    set rgb(4) [lindex $info(rgb) 4]
    set rgb(5) [lindex $info(rgb) 5]
  }

  if {$percent < 0} {
    set percent 0
  } elseif {$percent > 100} {
    set percent 100
  }
  if {$percent == 0} {
    set mark $minDisplay
  } else {
    set mark [expr (($width - $minDisplay) / 100.0 * $percent) + $minDisplay]
  }

  if {![winfo exists $widgets(canvas)]} {
    canvas $widgets(canvas) -width $width -height 14 -bd 0 -highlightthickness 0
    pack $widgets(canvas) -side left -anchor nw -fill both

    foreach {type color tag coords opts} $widgetGlobals(toDraw) {
      eval $widgets(canvas) create $type $coords -fill $color -tag t$tag $opts
    }

    set info(rgbHasChanged) 0
    # nothing more to do
    return
  }

  foreach {type color tag coords opts} $widgetGlobals(toDraw) {
    eval $widgets(canvas) coords t$tag $coords
    if {$info(rgbHasChanged)} {
      eval $widgets(canvas) itemconfigure t$tag -fill $color
    }
  }
  set info(rgbHasChanged) 0
}

}

namespace eval ::progressbar {

proc {::progressbar::HumanizeList} {list} {
variable widgetGlobals

  if {$widgetGlobals(debug)} {
    puts stderr "pb_HumanizeList $list"
  }

  if {[llength $list] == 1} {
    return [lindex $list 0]
  } else {
    set list [lsort $list]
    set secondToLast [expr {[llength $list] -2}]
    set most [lrange $list 0 $secondToLast]
    set last [lindex $list end]

    return "[join $most {, }] or $last"
  }
}

}

namespace eval ::progressbar {

proc {::progressbar::Init} {} {
variable widgetOptions
  variable widgetCommands
  variable widgetGlobals
  variable widgetShapes

  if {$widgetGlobals(debug)} {
    puts stderr "pb_Init"
  }

  # here we match up command line options with option database names
  # and classes. As it turns out, this is a handy reference of all of the
  # available options. Note that if an item has a value with only one
  # item (like -bd, for example) it is a synonym and the value is the
  # actual item.

  array set widgetOptions {
    -background		{background	Background	}
    -borderwidth	{borderWidth	BorderWidth	}
    -color		{color		Color		}
    -cursor		{cursor		Cursor		}
    -percent		{percent	Percent		}
    -relief		{relief		Relief		}
    -shape		{shape		Shape		}
    -variable		{variable	Variable	}
    -width		{width		Width		}
    -textvalue		{textValue	TextValue	}
    -textcolor		{textColor	TextColor	}

    -bg			-background
    -bd			-borderwidth
    -pc			-percent
  } 

  # this defines the valid widget commands. It's important to
  # list them here; we use this list to validate commands and
  # expand abbreviations.

  set widgetCommands {
      cget
      configure
      incr
      step
  }

  # this defines the valid shape options. It's important to
  # list them here; we use this list to validate options and
  # expand abbreviations.

  set widgetShapes {
      3D
      3d
      flat
  }
      
  set widgetGlobals(toDraw) {
    rect #bdbdbd es0 {[expr $mark +3] 2 [expr $width -2] 11} {-outline ""}
    line #525252 es1 {[expr $mark +1] 2 [expr $mark +1] 11} {}
    line #8c8c8c es2 {[expr $mark +2] 11 [expr $mark +2] 2  [expr $width -4] 2} {}
    line #8c8c8c es3 {[expr $mark +3] 11 [expr $width -3] 11  [expr $width -3] 3} {}
    line $rgb(0) pb0 {4 11 [expr $mark -1] 11 [expr $mark -1] 3} {}
    line $rgb(1) pb1 {3 11 3 10 [expr $mark -2] 10 [expr $mark -2] 2  [expr $mark -1] 2 4 2} {}
    line $rgb(2) pb2 {3 2 2 2 2 11 2 10 3 10 3 9 [expr $mark -3] 9  [expr $mark -3] 3 [expr $mark -2] 3 4 3} {}
    line $rgb(3) pb3 {3 3 3 9 3 8 [expr $mark -3] 8 [expr $mark -3] 4 4 4} {}
    line $rgb(4) pb4 {3 4 3 8 3 7 [expr $mark -3] 7 [expr $mark -3] 5 4 5} {}
    line $rgb(5) pb5 {3 5 3 7 3 6 [expr $mark -3] 6} {}
    line #000000 mrk {$mark 1 $mark 12} {}
    line #adadad fr0 {0 12 0 0 [expr $width -1] 0} {}
    line #ffffff fr1 {1 13 [expr $width -1] 13 [expr $width -1] 1} {}
    line #000000 fr2 {1 1 [expr $width -2] 1 [expr $width -2] 12 1 12 1 1} {}
    text #000000 txt {[expr $width / 2] 8} {-text $text}
  }

  set widgetGlobals(@blue0) {#000052 #0031ce #3163ff #639cff #9cceff #efefef}
  set widgetGlobals(@blue1) {#000021 #00639c #009cce #00ceff #63ffff #ceffff}
  set widgetGlobals(@blue2) {#000052 #31319c #6363ce #9c9cff #ceceff #efefef}
  set widgetGlobals(@blue3)	 {#21214a #52527b #63639c #8484bd #b5b5ef #ceceff}
  set widgetGlobals(@blue4) {#29396b #4a6b9c #6384b5 #739cd6 #94b5ef #adceff}
  set widgetGlobals(@green0)	 {#003131 #08736b #318c94 #5abdad #63dece #ceffef}
  set widgetGlobals(@green1) {#001000 #003100 #316331 #639c63 #9cce9c #ceffce}
  set widgetGlobals(@green2) {#002100 #006331 #319c63 #31ce63 #63ff9c #ceffce}
  set widgetGlobals(@green3) {#003131 #316363 #427b7b #639c9c #9ccece #bdefef}
  set widgetGlobals(@yellow0) {#101010 #636300 #9c9c00 #cece00 #ffff00 #ffff9c}
  set widgetGlobals(@yellow1) {#8c7321 #cead39 #e7c642 #f7de63 #f7de63 #ffffe7}
  set widgetGlobals(@red0) {#420000 #9c0000 #ce3131 #ff6363 #ff9c9c #ffcece}
  set widgetGlobals(@red1) {#210000 #9c3100 #ce6331 #ff9c63 #ffce9c #ffffce}
  set widgetGlobals(@magenta0) {#210000 #630063 #9c319c #ce63ce #ff9cff #ffceff}
  set widgetGlobals(@brown0) {#210000 #633100 #9c6331 #ce9c63 #efb573 #ffdeb5}
  set widgetGlobals(@brown1) {#310000 #7b4242 #9c6363 #ce9c9c #efcece #ffdede}
  set widgetGlobals(@gray0) {#212121 #525252 #737373 #adadad #cecece #efefef}

  # this initializes the option database. Kinda gross, but it works
  # (I think).
  set tmpWidget ".__tmp__"

  # steal some options from frame widgets; we only want a subset
  # so we'll use a slightly different method. No harm in *not*
  # adding in the one or two that we don't use... :-)
  label $tmpWidget
  foreach option [list Background Relief] {
    set values [$tmpWidget configure -[string tolower $option]]
    option add *Progressbar1.$option [lindex $values 3]
  }
  destroy $tmpWidget

  # these are unique to us...
  option add *Progressbar1.borderWidth	5		widgetDefault
  option add *Progressbar1.color	@blue0		widgetDefault
  option add *Progressbar1.percent	0		widgetDefault
  option add *Progressbar1.shape	3D		widgetDefault
  option add *Progressbar1.variable	{}		widgetDefault
  option add *Progressbar1.width	180		widgetDefault
  option add *Progressbar1.textColor	black		widgetDefault

  # define the class bindings
  # this allows us to clean up some things when we go away
  bind Progressbar1 <Destroy> [list ::progressbar::DestroyHandler %W]
}

}

namespace eval ::progressbar {

proc {::progressbar::RGBs} {color} {
variable widgetGlobals

  if {$widgetGlobals(debug)} {
    puts stderr "pb_RGB '$color'"
  }

  # get rgb values of given color
  set color [winfo rgb . $color]

  set R [expr int([lindex $color 0] / 256)]
  set G [expr int([lindex $color 1] / 256)]
  set B [expr int([lindex $color 2] / 256)]

  set rgb {}
  foreach factor {0.13 0.32 0.45 0.68 0.8 0.93} {
    set r [expr int($R * $factor)]
    set g [expr int($G * $factor)]
    set b [expr int($B * $factor)]
    lappend rgb [format "#%02x%02x%02x" $r $g $b]
  }
  lappend rgb [format "#%02x%02x%02x" $R $G $B]

  return $rgb
}

}

namespace eval ::progressbar {

proc {::progressbar::WidgetProc} {w args} {
variable widgetOptions
  variable widgetGlobals

  if {[llength $args] == 0} {
      return -code error [vTcl:WrongNumArgs "$w option ?arg arg ...?"]
  }

  set command [lindex $args 0]
  set args [lrange $args 1 end]

  if {$widgetGlobals(debug)} {
    puts stderr "pb_WidgetProc '$w' '$command' '$args'"
  }

  upvar ::progressbar::${w}::widgets   widgets
  upvar ::progressbar::${w}::options   options
  upvar ::progressbar::${w}::info info

  set command [Canonize $w command $command]

  set result ""

  switch $command {
    cget {
      if {[llength $args] != 1} {
	return -code error "wrong # args: should be $w cget option"
      }
      set opt [Canonize $w option [lindex $args 0]]
      set result $options($opt)
    }

    configure {
      set result [eval Configure {$w} $args]
    }

    incr -
    step {
      set val 1
      if {[llength $args] > 1} {
      	return -code error "wrong # args: should be $w $command <incrValue>"
      } elseif {[llength $args] == 1} {
      	set val $args
      }
      set percent [$w cget -percent]
      set result [eval Configure $w -percent [expr $percent + $val]]
    }

    default {
	return -code error "bad option \"$command\": must be cget or configure"
    }
  }
  return $result
}

}

namespace eval ::progressbar {

proc {::progressbar::progressbar} {args} {
variable widgetOptions
  variable widgetGlobals

  # perform a one time initialization
  if {![info exists widgetOptions]} {
    __progressbar_Setup
    Init
  }

  if {$widgetGlobals(debug)} {
    puts stderr "pb_progressbar '$args'"
  }

  # make sure we at least have a widget name
  if {[llength $args] == 0} {
    return -code error  "wrong # args: should be \"progressbar pathName ?options?\""
  }

  # ... and make sure a widget doesn't already exist by that name
  if {[winfo exists [lindex $args 0]]} {
    return -code error "window name \"[lindex $args 0]\" already exists"
  }

  # and check that all of the args are valid
  foreach {name value} [lrange $args 1 end] {
    Canonize [lindex $args 0] option $name
  }

  # build it...
  set w [eval Build $args]

  # and we are done!
  return $w
}

}

proc {__progressbar_Setup} {} {
namespace eval ::progressbar {
    # this is the public interface
    namespace export progressbar

    # these contain references to available options
    variable widgetOptions

    # these contain references to available commands
    variable widgetCommands

    # these contain references to available options for shape option
    variable widgetShapes

    # these contain references to global variables
    variable widgetGlobals

    set widgetGlobals(debug) 0
  }
}

proc {vTcl:Toplevel:WidgetProc} {w args} {
if {[llength $args] == 0} {
    	return -code error [vTcl:WrongNumArgs "$w option ?arg arg ...?"]
    }

    ## The first argument is a switch, they must be doing a configure.
    if {[string index $args 0] == "-"} {
    	set command configure

	## There's only one argument, must be a cget.
	if {[llength $args] == 1} {
	    set command cget
	}
    } else {
    	set command [lindex $args 0]
	set args [lrange $args 1 end]
    }

    switch -- $command {
	"hide" -
	"Hide" {
	    Window hide $w
	}

	"show" -
	"Show" {
	    Window show $w
	}

	"ShowModal" {
	    Window show $w
          raise $w
	    grab $w
	    tkwait window $w
	    grab release $w
	}

    	default {
	    eval $w $command $args
	}
    }
}

proc {vTcl:WidgetProc} {w args} {
if {[llength $args] == 0} {
    	return -code error "wrong # args: should be \"$w option ?arg arg ...?\""
    }

    ## The first argument is a switch, they must be doing a configure.
    if {[string index $args 0] == "-"} {
    	set command configure

	## There's only one argument, must be a cget.
	if {[llength $args] == 1} {
	    set command cget
	}
    } else {
    	set command [lindex $args 0]
	set args [lrange $args 1 end]
    }

    eval $w $command $args
}
}

proc vTcl:project:info {} {
    namespace eval ::widgets::.top17 {
        array set save {-background 1}
    }
    namespace eval ::widgets::.top17.ent18 {
        array set save {-textvariable 1}
    }
    namespace eval ::widgets::.top17.mes19 {
        array set save {-anchor 1 -aspect 1 -background 1 -font 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top17.but20 {
        array set save {-command 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top17.mes21 {
        array set save {-anchor 1 -aspect 1 -background 1 -font 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top17.ent22 {
        array set save {-textvariable 1}
    }
    namespace eval ::widgets::.top17.but23 {
        array set save {-command 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top17.but24 {
        array set save {-command 1 -height 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top17.but25 {
        array set save {-command 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top17.ent27 {
        array set save {-textvariable 1}
    }
    namespace eval ::widgets::.top17.mes28 {
        array set save {-aspect 1 -background 1 -font 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top17.but18 {
        array set save {-command 1 -height 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top17.but33 {
        array set save {-command 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top17.lab19 {
        array set save {-background 1 -borderwidth 1 -highlightbackground 1 -image 1 -text 1}
    }
    namespace eval ::widgets::.top17.rad27 {
        array set save {-activebackground 1 -background 1 -disabledforeground 1 -height 1 -highlightbackground 1 -text 1 -textvariable 1 -value 1 -width 1}
    }
    namespace eval ::widgets::.top17.rad28 {
        array set save {-activebackground 1 -background 1 -disabledforeground 1 -height 1 -highlightbackground 1 -text 1 -value 1 -width 1}
    }
    namespace eval ::widgets::.top17.progressBar {
        array set save {-background 1 -width 1}
    }
    namespace eval ::widgets::.top17.m38 {
        array set save {-activeborderwidth 1 -borderwidth 1 -font 1 -tearoff 1}
    }
    namespace eval ::widgets::.top17.progressLabel {
        array set save {-background 1 -font 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top17.progressMsg {
        array set save {-background 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top18 {
        array set save {-background 1 -highlightbackground 1}
    }
    namespace eval ::widgets::.top18.mes19 {
        array set save {-aspect 1 -background 1 -font 1 -justify 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top18.mes21 {
        array set save {-aspect 1 -background 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top18.mes22 {
        array set save {-anchor 1 -aspect 1 -background 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top18.mes24 {
        array set save {-anchor 1 -aspect 1 -background 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top18.mes25 {
        array set save {-anchor 1 -aspect 1 -background 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top18.mes26 {
        array set save {-anchor 1 -aspect 1 -background 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top18.mes27 {
        array set save {-anchor 1 -aspect 1 -background 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top18.mes28 {
        array set save {-anchor 1 -aspect 1 -background 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top18.but29 {
        array set save {-command 1 -height 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top18.mes17 {
        array set save {-aspect 1 -background 1 -highlightbackground 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top20 {
        array set save {-background 1}
    }
    namespace eval ::widgets::.top20.mes21 {
        array set save {-aspect 1 -background 1 -font 1 -justify 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top20.mes22 {
        array set save {-aspect 1 -background 1 -font 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top20.mes23 {
        array set save {-background 1 -font 1 -justify 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top20.mes24 {
        array set save {-aspect 1 -background 1 -font 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top20.mes25 {
        array set save {-aspect 1 -background 1 -font 1 -justify 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top20.mes26 {
        array set save {-aspect 1 -background 1 -font 1 -justify 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top20.mes27 {
        array set save {-aspect 1 -background 1 -font 1 -justify 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top20.but28 {
        array set save {-command 1 -height 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top20.lab20 {
        array set save {-background 1 -borderwidth 1 -highlightbackground 1 -image 1 -text 1}
    }
    namespace eval ::widgets::.top20.license {
        array set save {-background 1 -justify 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top21 {
        array set save {-background 1 -highlightbackground 1}
    }
    namespace eval ::widgets::.top21.mes22 {
        array set save {-aspect 1 -background 1 -font 1 -highlightbackground 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top21.mes23 {
        array set save {-aspect 1 -background 1 -highlightbackground 1 -justify 1 -padx 1 -pady 1 -text 1 -width 1}
    }
    namespace eval ::widgets::.top21.closeErrorWindow {
        array set save {-command 1 -text 1}
    }
    namespace eval ::widgets::.top23 {
        array set save {-background 1 -highlightbackground 1}
    }
    namespace eval ::widgets::.top23.mes24 {
        array set save {-aspect 1 -background 1 -font 1 -highlightbackground 1 -padx 1 -pady 1 -text 1}
    }
    namespace eval ::widgets::.top23.but25 {
        array set save {-command 1 -text 1}
    }
    namespace eval ::widgets::.top23.rad26 {
        array set save {-text 1}
    }
    namespace eval ::widgets_bindings {
        set tagslist {}
    }
}

#################################
# USER DEFINED PROCEDURES
#

proc {main} {argc argv} {
wm protocol .top17 WM_DELETE_WINDOW {exit}
wm protocol .top18 WM_DELETE_WINDOW { wm withdraw .top18 }
wm protocol .top20 WM_DELETE_WINDOW { wm withdraw .top20 }
wm protocol .top21 WM_DELETE_WINDOW { wm withdraw .top21 }
wm protocol .top23 WM_DELETE_WINDOW { wm withdraw .top23 }
global selectedButton
set selectedButton "floppy"
}

proc init {argc argv} {
set steveData {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   }
   set logoData {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   }
   image create photo steve.gif
   steve.gif put $steveData
   image create photo logo.gif 
   logo.gif put $logoData
}

init $argc $argv

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base {container 0}} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    if {!$container} {
    wm focusmodel $base passive
    wm geometry $base 200x200+44+44; update
    wm maxsize $base 1028 753
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "vtcl"
    bindtags $base "$base Vtcl all"
    }
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.top17 {base {container 0}} {
    if {$base == ""} {
        set base .top17
    }
    if {[winfo exists $base] && (!$container)} {
        wm deiconify $base; return
    }

    global widget
    set widget(rev,$base.progressBar) {Progressbar1}
    set {widget(Progressbar1)} "$base.progressBar"
    set widget($base,Progressbar1) "$base.progressBar"
    interp alias {} Progressbar1 {} vTcl:WidgetProc $base.progressBar
    interp alias {} $base.Progressbar1 {} vTcl:WidgetProc $base.progressBar
    set widget(rev,$base.progressLabel) {Message2}
    set {widget(Message2)} "$base.progressLabel"
    set widget($base,Message2) "$base.progressLabel"
    interp alias {} Message2 {} vTcl:WidgetProc $base.progressLabel
    interp alias {} $base.Message2 {} vTcl:WidgetProc $base.progressLabel
    set widget(rev,$base.progressMsg) {Message3}
    set {widget(Message3)} "$base.progressMsg"
    set widget($base,Message3) "$base.progressMsg"
    interp alias {} Message3 {} vTcl:WidgetProc $base.progressMsg
    interp alias {} $base.Message3 {} vTcl:WidgetProc $base.progressMsg

    ###################
    # CREATING WIDGETS
    ###################
    if {!$container} {
    toplevel $base -class Toplevel \
        -background #0099cc 
    wm focusmodel $base active
    wm geometry $base 400x375+295+178; update
    wm maxsize $base 785 570
    wm minsize $base 106 2
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm deiconify $base
    wm title $base "File Splitter"
    }
    entry $base.ent18 \
        -textvariable input_file 
    message $base.mes19 \
        -anchor w -aspect 3000 -background #0099cc -font {{MS Sans Serif} 10} \
        -padx 5 -pady 2 -text {File to be split:} 
    button $base.but20 \
        -command {set input_file [tk_getOpenFile]} -padx 9 -pady 3 \
        -text Browse 
    message $base.mes21 \
        -anchor w -aspect 3000 -background #0099cc -font {{MS Sans Serif} 10} \
        -padx 5 -pady 2 -text {Path and basename for output files:} 
    entry $base.ent22 \
        -textvariable output_file 
    button $base.but23 \
        -command {set output_file [tk_getSaveFile]} -padx 9 -pady 3 \
        -text Browse 
    button $base.but24 \
        \
        -command {if {[string length $input_file] == 0} {
      errorMessage configure -text "You must select a file to split!"
      Window show $widget(errorWindow)
      return
   }
   if {[string length $output_file] == 0} {
      .top21.mes23 configure -text "You must select a path and basename for the output split files!"
      Window show $widget(errorWindow)
      return
   }
   if {$selectedButton == "custom"} {
      regsub -all {[^0-9]} $chunk_size "" chunk_size
      set chunksize [expr $chunk_size + 0]
      if {$chunk_size < 10000 || $chunk_size > 999999999} {
         errorMessage configure -text "You must select a size between 10,000 and 999,999,999 bytes!"
         Window show $widget(errorWindow)
         return
      }
   } 

   set inputID [open $input_file]
   fconfigure $inputID -translation binary
   set inputSize [file size $input_file]
   if {$selectedButton == "floppy"} {set chunk_size 1440000}
   set progressIncrement [expr [expr $chunk_size * 100] / $inputSize]
   set progressPercentage 0
   set extention 1
   set index 1
   .top17.progressBar configure -percent $progressPercentage  
   .top17.progressMsg configure -text [format "%s%s" $progressPercentage "%"]
   update idletasks
      
   set outputID [open "$output_file.$extention" w]
   fconfigure $outputID -translation binary
   while {[eof $inputID] != 1} {
      set buffer [read $inputID $chunk_size]
      puts -nonewline $outputID $buffer
      close $outputID
      incr extention
      set index 1
      set progressPercentage [expr $progressPercentage + $progressIncrement]
      if { $progressPercentage > 100 } { set progressPercentage 100 }
      .top17.progressBar configure -percent $progressPercentage  
      .top17.progressMsg configure -text [format "%s%s" $progressPercentage "%"]
      update idletasks     
      if {[eof $inputID] != 1} {
         set outputID [open "$output_file.$extention" w]
         fconfigure $outputID -translation binary  
      }    
   }

   close $inputID

   set index [string last "/" $output_file]
   if {$index == -1} {
      set index [string last "\\" $output_file]
   }
   set output_dir_substring [string range $output_file 0 $index]
   incr index
   set output_file_substring [string range $output_file $index end]

   set index [string last "/" $input_file]
   if {$index == -1} {
      set index [string last "\\" $input_file]
   }
   incr index 
   set input_file_substring [string range $input_file $index end]

   set batch_filename [format "%s%s" $output_dir_substring "rejoin.bat"]
   set batchID [open $batch_filename w]
   if {[string first " " $output_file_substring] != -1 || [string length $output_file_substring] > 8} {
      puts -nonewline $batchID "copy /b \"$output_file_substring.1\""
   } else { puts -nonewline $batchID "copy /b $output_file_substring.1"}
   for {set counter 2} {$counter <= $extention} {incr counter} {
      if {[string first " " $output_file_substring] != -1 || [string length $output_file_substring] > 8} {
         puts -nonewline $batchID "+\"$output_file_substring.$counter\""
      } else { puts -nonewline $batchID "+$output_file_substring.$counter"
      }
   }
   if {[string first " " $input_file_substring] != -1 || [string length $input_file_substring] > 12} {
      puts $batchID " \"$input_file_substring\""
   } else {puts $batchID " $input_file_substring"}
   close $batchID
   
   .top17.progressBar configure -percent "100%"  
   .top17.progressMsg configure -text "100%"
   update idletasks
   Window show $widget(complete)} \
        -height 0 -padx 9 -pady 3 -text Go! -width 0 
    button $base.but25 \
        -command exit -padx 9 -pady 3 -text Exit 
    entry $base.ent27 \
        -textvariable chunk_size 
    message $base.mes28 \
        -aspect 3000 -background #0099cc -font {{MS Sans Serif} 10} -padx 5 \
        -pady 2 -text {Number of bytes per chunk:} 
    button $base.but18 \
        -command {Window show $widget(about)} -height 0 -padx 9 -pady 3 \
        -text About -width 0 
    button $base.but33 \
        -command {Window show $widget(help)} -padx 9 -pady 3 -text Help 
    label $base.lab19 \
        -background #0099cc -borderwidth 0 -highlightbackground #0099cc \
        -image logo.gif -text label 
    radiobutton $base.rad27 \
        -activebackground #0099cc -background #0099cc \
        -disabledforeground #0099cc -height 0 -highlightbackground #0099cc \
        -text {3.5" Floppy Size} -textvariable floppy -value floppy -width 0 
    radiobutton $base.rad28 \
        -activebackground #0099cc -background #0099cc \
        -disabledforeground #0099cc -height 0 -highlightbackground #0099cc \
        -text {Custom Size:} -value custom -width 0 
    ::progressbar::progressbar $base.progressBar \
        -background #0099cc -width 260 
    menu $base.m38 \
        -activeborderwidth 1 -borderwidth 1 -font {Tahoma 8} -tearoff 1 
    message $base.progressLabel \
        -background #0099cc -font {{MS Sans Serif} 14} -padx 5 -pady 2 \
        -text Progress: -width 90 
    message $base.progressMsg \
        -background #0099cc -padx 5 -pady 2 -text 0% -width 261 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.ent18 \
        -x 10 -y 220 -width 248 -height 25 -anchor nw -bordermode ignore 
    place $base.mes19 \
        -x 5 -y 195 -width 118 -height 21 -anchor nw -bordermode ignore 
    place $base.but20 \
        -x 305 -y 220 -width 75 -height 25 -anchor nw -bordermode ignore 
    place $base.mes21 \
        -x 5 -y 260 -anchor nw -bordermode ignore 
    place $base.ent22 \
        -x 10 -y 290 -width 248 -height 25 -anchor nw -bordermode ignore 
    place $base.but23 \
        -x 305 -y 290 -width 75 -height 25 -anchor nw -bordermode ignore 
    place $base.but24 \
        -x 215 -y 100 -width 75 -height 25 -anchor nw -bordermode ignore 
    place $base.but25 \
        -x 215 -y 160 -width 75 -height 25 -anchor nw -bordermode ignore 
    place $base.ent27 \
        -x 105 -y 160 -width 88 -height 25 -anchor nw -bordermode ignore 
    place $base.mes28 \
        -x 5 -y 105 -anchor nw -bordermode ignore 
    place $base.but18 \
        -x 320 -y 160 -width 75 -height 25 -anchor nw -bordermode ignore 
    place $base.but33 \
        -x 320 -y 100 -width 75 -height 25 -anchor nw -bordermode ignore 
    place $base.lab19 \
        -x 30 -y 10 -anchor nw -bordermode ignore 
    place $base.rad27 \
        -x 5 -y 130 -anchor nw -bordermode ignore 
    place $base.rad28 \
        -x 5 -y 160 -anchor nw -bordermode ignore 
    place $base.progressBar \
        -x 115 -y 335 -width 270 -height 24 -anchor nw -bordermode ignore 
    place $base.progressLabel \
        -x 25 -y 330 -width 90 -height 31 -anchor nw -bordermode ignore 
    place $base.progressMsg \
        -x 120 -y 355 -width 261 -height 21 -anchor nw -bordermode ignore 
}

proc vTclWindow.top18 {base {container 0}} {
    if {$base == ""} {
        set base .top18
    }
    if {[winfo exists $base] && (!$container)} {
        wm deiconify $base; return
    }

    global widget
    set widget(rev,$base) {help}
    set {widget(help)} "$base"
    set widget(help,help) "$base"
    interp alias {} help {} .top18 $base

    ###################
    # CREATING WIDGETS
    ###################
    if {!$container} {
    toplevel $base -class Toplevel \
        -background #0099cc -highlightbackground #c000c000c000 
    wm withdraw .top18
    wm focusmodel $base passive
    wm geometry $base 550x450+226+165; update
    wm maxsize $base 785 570
    wm minsize $base 106 2
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm title $base "Help"
    }
    message $base.mes19 \
        -aspect 3000 -background #0099cc -font {{MS Sans Serif} 14} \
        -justify center -padx 5 -pady 2 -text Instructions 
    message $base.mes21 \
        -aspect 1500 -background #0099cc -padx 5 -pady 2 \
        -text { File Splitter takes a file and splits it up into a number of smaller "chunks", also creating a DOS batch file that will automatically rejoin the chunks back into the original file's state once tranferred to their desination.} 
    message $base.mes22 \
        -anchor w -aspect 3000 -background #0099cc -padx 5 -pady 2 \
        -text {File to be split:} 
    message $base.mes24 \
        -anchor w -aspect 1500 -background #0099cc -padx 5 -pady 2 \
        -text {Type in the path and filename for the file you would like to split, or click the Browse button to locate it visually.} 
    message $base.mes25 \
        -anchor w -aspect 3000 -background #0099cc -padx 5 -pady 2 \
        -text {Path and basename for desination files:} 
    message $base.mes26 \
        -anchor w -aspect 800 -background #0099cc -padx 5 -pady 2 \
        -text {File Splitter will create file chunks with a basename you select plus an extention number (i.e. if you select "c:\windows\desktop\output" for the basename and there are three chunks created, they will be named "output.1", "output.2", and "output.3" created on the desktop. Type in the path and basename you would like to use... or click the browse button and type in the basename, after locating the desired path visually.} \
        -width 0 
    message $base.mes27 \
        -anchor w -aspect 3000 -background #0099cc -padx 5 -pady 2 \
        -text {Number of bytes per chunk:} 
    message $base.mes28 \
        -anchor w -aspect 1500 -background #0099cc -padx 5 -pady 2 \
        -text {Check-mark the '3.5" Floppy Size' box if you want your output chunks to be sized for floppy disks, or check-mark the 'custom' box and type in a number for some other size.} 
    button $base.but29 \
        -command {Window hide $widget(help)} -height 0 -padx 9 -pady 3 \
        -text Close -width 0 
    message $base.mes17 \
        -aspect 750 -background #0099cc -highlightbackground #0099cc -padx 5 \
        -pady 2 \
        -text { When you have finished splitting your file... take 'REJOIN.BAT' and all of the chunks (from the location you had specified), and copy them to floppy disks or whatever medium you are using. Next, copy from there to the other machine, dumping all of the files in a folder together (or simply on the Desktop). Double-click on the 'REJOIN.BAT' icon, and a batch file will run and re-create the original file. After you're done, you can safely delete the chunks and 'REJOIN.BAT' file. } 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.mes19 \
        -x 5 -y 5 -width 540 -height 26 -anchor nw -bordermode ignore 
    place $base.mes21 \
        -x 5 -y 45 -width 538 -height 51 -anchor nw -bordermode ignore 
    place $base.mes22 \
        -x 5 -y 170 -width 538 -height 11 -anchor nw -bordermode ignore 
    place $base.mes24 \
        -x 20 -y 185 -width 523 -height 26 -anchor nw -bordermode ignore 
    place $base.mes25 \
        -x 5 -y 225 -width 493 -height 16 -anchor nw -bordermode ignore 
    place $base.mes26 \
        -x 20 -y 240 -width 521 -height 62 -anchor nw -bordermode ignore 
    place $base.mes27 \
        -x 5 -y 110 -width 488 -height 16 -anchor nw -bordermode ignore 
    place $base.mes28 \
        -x 20 -y 125 -width 522 -height 30 -anchor nw -bordermode ignore 
    place $base.but29 \
        -x 255 -y 410 -anchor nw -bordermode ignore 
    place $base.mes17 \
        -x 5 -y 325 -width 541 -height 73 -anchor nw -bordermode ignore 
}

proc vTclWindow.top20 {base {container 0}} {
    if {$base == ""} {
        set base .top20
    }
    if {[winfo exists $base] && (!$container)} {
        wm deiconify $base; return
    }

    global widget
    set widget(rev,$base) {about}
    set {widget(about)} "$base"
    set widget(about,about) "$base"
    interp alias {} about {} .top20 $base
    set widget(rev,$base.license) {Message1}
    set {widget(Message1)} "$base.license"
    set widget(about,Message1) "$base.license"
    interp alias {} Message1 {} vTcl:WidgetProc $base.license
    interp alias {} about.Message1 {} vTcl:WidgetProc $base.license

    ###################
    # CREATING WIDGETS
    ###################
    if {!$container} {
    toplevel $base -class Toplevel \
        -background #0099cc 
    wm withdraw .top20
    wm focusmodel $base passive
    wm geometry $base 200x350+225+135; update
    wm maxsize $base 1009 738
    wm minsize $base 106 2
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm title $base "About"
    }
    message $base.mes21 \
        -aspect 3000 -background #0099cc -font {{MS Sans Serif} 14 bold} \
        -justify center -padx 5 -pady 2 -text {File Splitter} 
    message $base.mes22 \
        -aspect 300 -background #0099cc -font {Arial 8} -padx 5 -pady 2 \
        -text {Version 1.4} -width 0 
    message $base.mes23 \
        -background #0099cc -font {Arial 8} -justify center -padx 5 -pady 2 \
        -text by 
    message $base.mes24 \
        -aspect 3000 -background #0099cc -font {Arial 10 bold} -padx 5 \
        -pady 2 -text {Steve D. Perkins} 
    message $base.mes25 \
        -aspect 3000 -background #0099cc -font {Arial 8} -justify center \
        -padx 5 -pady 2 -text steve@steveperkins.net 
    message $base.mes26 \
        -aspect 3000 -background #0099cc -font {Arial 9} -justify center \
        -padx 5 -pady 2 -text http://www.steveperkins.net 
    message $base.mes27 \
        -aspect 3000 -background #0099cc -font {Arial 8} -justify center \
        -padx 5 -pady 2 -text 2001 -width 0 
    button $base.but28 \
        -command {Window hide $widget(about)} -height 0 -padx 9 -pady 3 \
        -text Close -width 0 
    label $base.lab20 \
        -background #0099cc -borderwidth 0 -highlightbackground #0099cc \
        -image steve.gif -text label 
    message $base.license \
        -background #0099cc -justify center -padx 5 -pady 2 \
        -text {This software is distributed under the terms of the GNU General Public License (GPL)} \
        -width 191 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.mes21 \
        -x 5 -y 5 -width 193 -height 21 -anchor nw -bordermode ignore 
    place $base.mes22 \
        -x 5 -y 30 -width 190 -height 12 -anchor nw -bordermode ignore 
    place $base.mes23 \
        -x 5 -y 65 -width 193 -height 16 -anchor nw -bordermode ignore 
    place $base.mes24 \
        -x 5 -y 80 -width 193 -height 21 -anchor nw -bordermode ignore 
    place $base.mes25 \
        -x 5 -y 100 -width 193 -height 16 -anchor nw -bordermode ignore 
    place $base.mes26 \
        -x 5 -y 230 -width 192 -height 25 -anchor nw -bordermode ignore 
    place $base.mes27 \
        -x 5 -y 45 -width 191 -height 12 -anchor nw -bordermode ignore 
    place $base.but28 \
        -x 75 -y 260 -anchor nw -bordermode ignore 
    place $base.lab20 \
        -x 65 -y 120 -anchor nw -bordermode ignore 
    place $base.license \
        -x 5 -y 295 -width 191 -height 51 -anchor nw -bordermode ignore 
}

proc vTclWindow.top21 {base {container 0}} {
    if {$base == ""} {
        set base .top21
    }
    if {[winfo exists $base] && (!$container)} {
        wm deiconify $base; return
    }

    global widget
    set widget(rev,$base) {errorWindow}
    set {widget(errorWindow)} "$base"
    set widget(errorWindow,errorWindow) "$base"
    interp alias {} errorWindow {} vTcl:Toplevel:WidgetProc $base
    set widget(rev,$base.closeErrorWindow) {Button1}
    set {widget(Button1)} "$base.closeErrorWindow"
    set widget(errorWindow,Button1) "$base.closeErrorWindow"
    interp alias {} Button1 {} vTcl:WidgetProc $base.closeErrorWindow
    interp alias {} errorWindow.Button1 {} vTcl:WidgetProc $base.closeErrorWindow
    set widget(rev,$base.mes23) {errorMessage}
    set {widget(errorMessage)} "$base.mes23"
    set widget(errorWindow,errorMessage) "$base.mes23"
    interp alias {} errorMessage {} vTcl:WidgetProc $base.mes23
    interp alias {} errorWindow.errorMessage {} vTcl:WidgetProc $base.mes23

    ###################
    # CREATING WIDGETS
    ###################
    if {!$container} {
    toplevel $base -class Toplevel \
        -background #0099cc -highlightbackground #0099cc 
    wm withdraw .top21
    wm focusmodel $base passive
    wm geometry $base 200x150+256+127; update
    wm maxsize $base 1030 755
    wm minsize $base 106 2
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm title $base "Error"
    }
    message $base.mes22 \
        -aspect 3000 -background #0099cc -font {{MS Sans Serif} 18} \
        -highlightbackground #0099cc -padx 5 -pady 2 -text Error! 
    message $base.mes23 \
        -aspect 300 -background #0099cc -highlightbackground #0099cc \
        -justify center -padx 5 -pady 2 \
        -text {You must select a path and basename for the output split files!} \
        -width 0 
    button $base.closeErrorWindow \
        -command {Window hide $widget(errorWindow)} -text Close 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.mes22 \
        -x 5 -y 5 -width 189 -height 37 -anchor nw -bordermode ignore 
    place $base.mes23 \
        -x 5 -y 45 -width 190 -height 59 -anchor nw -bordermode ignore 
    place $base.closeErrorWindow \
        -x 85 -y 110 -anchor nw -bordermode ignore 
}

proc vTclWindow.top23 {base {container 0}} {
    if {$base == ""} {
        set base .top23
    }
    if {[winfo exists $base] && (!$container)} {
        wm deiconify $base; return
    }

    global widget
    set widget(rev,$base) {complete}
    set {widget(complete)} "$base"
    set widget(complete,complete) "$base"
    interp alias {} complete {} .top23 $base

    ###################
    # CREATING WIDGETS
    ###################
    if {!$container} {
    toplevel $base -class Toplevel \
        -background #0099cc -highlightbackground #0099cc 
    wm withdraw .top23
    wm focusmodel $base passive
    wm geometry $base 200x115+518+358; update
    wm maxsize $base 1030 755
    wm minsize $base 106 2
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm title $base "Complete"
    }
    message $base.mes24 \
        -aspect 1000 -background #0099cc -font {{MS Sans Serif} 18} \
        -highlightbackground #0099cc -padx 5 -pady 2 -text Complete! 
    button $base.but25 \
        -command {Window hide $widget(complete)} -text OK 
    radiobutton $base.rad26 \
        -text radio 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.mes24 \
        -x 5 -y 10 -width 190 -height 44 -anchor nw -bordermode ignore 
    place $base.but25 \
        -x 85 -y 70 -anchor nw -bordermode ignore 
    place $base.rad26 \
        -x 50 -y 200 -anchor nw -bordermode ignore 
}

Window show .
Window show .top17
Window show .top18
Window show .top20
Window show .top21
Window show .top23

main $argc $argv
