'This VB Script program installs or deletes associations for the file
'name extension assigned to variable "ext".
'
'Copyright 2001 Bent Lynggrd
'
'2001-11-24. v. 1.00
'2001-11-27. v. 1.02 - sub "delete" deletes successively to satisfy w2k.

Dim extKey, extCT, extfileType, extfileS, extfileSOC, extfileSEC, extfileDi
Dim ext, fileType, contentType, opener, shellOpen, editor, shellEdit
Dim default, icon, dotExt, extfile, crlf, crlf2
Dim WshShell
Set WshShell = WScript.CreateObject("WScript.Shell")

ext = "han"
contentType = "text/html"
fileType = "Handle file"
openerName = "Internet Explorer"
opener = "C:\Program Files\Internet Explorer\Iexplore.exe"
shellOpen = quote(opener) & " ""%1"""
editor = "notepad.exe"
shellEdit = quote(editor) & " ""%1"""
default = "Open" ' Open or Edit
icon = quote(opener) & ",1"

dotExt = "." & ext
extfile = ext & "file"
crlf = Chr(13) & Chr(10)
crlf2 = crlf & crlf

private function quote(s)
  quote = """" & s & """"
end function

private function getKey(key)
  getKey = WshShell.RegRead("HKCR\" & key)
end function

private sub putString(key, s)
  WshShell.RegWrite "HKCR\" & key, s, "REG_SZ"
end sub

private sub install
  putString extfile & "\", fileType
  putString extfile & "\Shell\", default
  putString extfile & "\Shell\Open\", "&Open"
  putString extfile & "\Shell\Open\command\", shellOpen
  putString extfile & "\Shell\Edit\", "&Edit"
  putString extfile & "\Shell\Edit\command\", shellEdit
  putString extfile & "\DefaultIcon\", icon
  putString dotExt & "\", extfile
  putString dotExt & "\Content Type", contentType
end sub

private sub delete
  WshShell.RegDelete "HKCR\" & dotExt & "\"
  WshShell.RegDelete "HKCR\" & extfile & "\DefaultIcon\"
  WshShell.RegDelete "HKCR\" & extfile & "\Shell\Edit\command\"
  WshShell.RegDelete "HKCR\" & extfile & "\Shell\Edit\"
  WshShell.RegDelete "HKCR\" & extfile & "\Shell\Open\command\"
  WshShell.RegDelete "HKCR\" & extfile & "\Shell\Open\"
  WshShell.RegDelete "HKCR\" & extfile & "\Shell\"
  WshShell.RegDelete "HKCR\" & extfile & "\"
end sub

private function test(s)
  if isEmpty(s) then test = "(No key)" else test = s
end function

private function compare
' This function returns a string that compare current and default values,
' showing groups of three lines with key, current and default values.
  compare = "Key" & crlf & "Current" & crlf & "Default" & crlf2 & _
  dotExt & crlf & test(extKey) & crlf & extfile & crlf2 & _
  "Content type" & crlf & test(extCT) & crlf & contentType & crlf2 & _
  "File type" & crlf & test(extfileType) & crlf & fileType & crlf2 & _
  "Default command" & crlf & test(extfileS) & crlf & default & crlf2 & _
  "Opener" & crlf & test(extfileSOC) & crlf & shellOpen & crlf2 & _
  "Editor" & crlf & test(extfileSEC) & crlf & shellEdit & crlf2 & _
  "Icon" & crlf & test(extfileDi) & crlf & icon
end function

private sub run
' This is the body of the program. It was made into a subroutine in order
' to enable the Exit (Exit Sub) statement

Dim s, x

On Error Resume Next

extKey = getKey(dotExt & "\")
extfileType = getKey(extfile & "\")

if isEmpty(extKey) and isEmpty(extfileType) then
  if msgBox("File type " & quote(dotExt) & " is currently not associated " _
    & "with any program." & crlf2 & "Do you want to associate it with " & _
    openerName & "?", vbYesNo, "Associating file type " & quote(dotExt)) _
    = vbYes then install
  exit sub
end if

extCT = getKey(dotExt & "\Content Type")
extfileS = getKey(extfile & "\Shell\")
extfileSOC = getKey(extfile & "\Shell\Open\command\")
extfileSEC = getKey(extfile & "\Shell\Edit\command\")
extfileDi = getKey(extfile & "\DefaultIcon\")
' we don't care about the Shell\Open\ and Shell\Edit\ values

if NOT isEmpty(extKey) and extKey <> extfile then
  s = quote(dotExt) & "'s key is not " & quote(extfile) & ", but " & quote(extKey)
  x = getKey(extKey & "\")
  if isEmpty(x) then
    s = s & "." & crlf2 & "However, no key is assigned to the latter"
    if isEmpty(extfileType) then
      s = s & ", and there is no entry for " & quote(extfile) & "." & crlf2 & _
      "You can safely install the default values."
    else
      s = s & ", but there is an entry for " & quote(extfile) & ":" & crlf2 & _
      compare
    end if
    if msgBox(s & crlf2 & _
      "Do you want to install the default associations?", vbYesNo, _
      "Associating file type " & quote(dotExt)) = vbYes then delete : install
  else
    x = msgBox(s & ", and a key is assigned to the latter." & crlf2 & _
      "Therefore this program cannot install new values for file name extension " _
      & quote(dotExt) & "." & crlf2 & _
      "You can probably use Window's file type association option to remove the " & _
      "current setting.", vbOKOnly, "Cannot update associations")
  end if
  exit sub
end if

if extKey = extfile and extCT = contentType and extfileType = fileType and _
    extfileSOC = shellOpen and extfileSEC = shellEdit and extfileDi = icon and _
    extfileS = default then
  if msgBox("The associations for file type " & quote(dotExt) & _
    " were tested identical to the default values." & crlf2 & _
    "Do you want to delete the associations?", vbYesNo, _
    "Deleting associations for " & quote(dotExt)) = vbYes then delete
else
  if msgBox("There are differences between current and default " & _
    "values for file type " & quote(dotExt) & " associations." & crlf2 & _
    compare & crlf2 & _
    "Do you want to change to the default values?", vbYesNo, "Testing file type " _
    & quote(dotExt) & " associations") = vbYes then delete : install
end if

end sub

run

