/*
 * Decompiled with CFR 0.152.
 */
package comgr;

import comgr.PaletteGreen;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;

public class Plasma
extends Canvas {
    PlasmaThread thrPlasma;
    Image imagePlasma;
    Image imageOffScreen;
    int width = 420;
    int height = 300;
    private static final int TILEX = 1;
    private static final int TILEY = 1;
    private int[] destPixels;
    private int countPixels;
    PaletteGreen palette = new PaletteGreen();
    boolean initOk = false;
    private boolean isRunning = false;

    void debug(String string) {
        System.out.println(string);
    }

    public void plasmaInit() {
        Dimension dimension = this.getSize();
        this.init(dimension.width, dimension.height);
    }

    public void init(int n, int n2) {
        if (this.initOk) {
            return;
        }
        this.width = n / 1;
        this.height = n2 / 1;
        this.drawBackground();
        this.initOk = true;
    }

    private void drawBackground() {
        this.countPixels = this.width * this.height;
        this.destPixels = new int[this.countPixels];
        for (int i = 0; i < this.countPixels; ++i) {
            this.destPixels[i] = 0;
        }
        this.destPixels[0] = 128;
        this.destPixels[this.width - 1] = 128;
        this.destPixels[this.width * (this.height - 1)] = 128;
        this.destPixels[this.width * (this.height - 1) + this.width - 1] = 128;
        this.calcPoints(0, 0, this.width - 1, this.height - 1, this.destPixels[0], this.destPixels[this.width - 1], this.destPixels[this.width * (this.height - 1)], this.destPixels[this.height * this.width - 1]);
    }

    private void calcPoints(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (n + 1 >= n3 && n2 + 1 >= n4) {
            return;
        }
        int n14 = n3 - n >> 1;
        int n15 = n4 - n2 >> 1;
        if (this.destPixels[n + n14 + this.width * n2] == 0) {
            this.destPixels[n + n14 + this.width * n2] = n13 = this.deviate(n5, n6, n14);
        } else {
            n13 = this.destPixels[n + n14 + this.width * n2];
        }
        if (this.destPixels[n + this.width * (n2 + n15)] == 0) {
            this.destPixels[n + this.width * (n2 + n15)] = n12 = this.deviate(n5, n7, n15);
        } else {
            n12 = this.destPixels[n + this.width * (n2 + n15)];
        }
        if (this.destPixels[n3 + this.width * (n2 + n15)] == 0) {
            this.destPixels[n3 + this.width * (n2 + n15)] = n11 = this.deviate(n6, n8, n15);
        } else {
            n11 = this.destPixels[n3 + this.width * (n2 + n15)];
        }
        if (this.destPixels[n + n14 + this.width * n4] == 0) {
            this.destPixels[n + n14 + this.width * n4] = n10 = this.deviate(n7, n8, n14);
        } else {
            n10 = this.destPixels[n + n14 + this.width * n4];
        }
        if (this.destPixels[n + n14 + this.width * (n2 + n15)] == 0) {
            this.destPixels[n + n14 + this.width * (n2 + n15)] = n9 = this.deviate(n13, n10, n15);
        } else {
            n9 = this.destPixels[n + n14 + this.width * n4];
        }
        this.calcPoints(n, n2, n + n14, n2 + n15, n5, n13, n12, n9);
        this.calcPoints(n + n14, n2, n3, n2 + n15, n13, n6, n9, n11);
        this.calcPoints(n, n2 + n15, n + n14, n4, n12, n9, n7, n10);
        this.calcPoints(n + n14, n2 + n15, n3, n4, n9, n11, n10, n8);
    }

    private int deviate(int n, int n2, int n3) {
        int n4 = Math.abs(n2 - n);
        int n5 = (n + n2) / 2;
        int n6 = -n3 * n5 / 255;
        n4 = (int)((double)n3 * Math.random()) + n6;
        int n7 = n5 + n4;
        if (n7 < 0) {
            n7 = -n7;
        } else if (n7 > 255) {
            n7 = 510 - n7;
        }
        return n7;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        try {
            this.makeScreen();
            if (this.imageOffScreen == null || this.palette == null) {
                return;
            }
            for (int i = 0; i < 1; ++i) {
                for (int j = 0; j < 1; ++j) {
                    graphics.drawImage(this.imageOffScreen, i * this.width, j * this.height, this);
                }
            }
            this.palette.rotate(4);
            this.palette.setColorModel();
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException: ".concat(String.valueOf(String.valueOf(interruptedException))));
            this.isRunning = false;
        }
    }

    void makePlasma() {
        try {
            this.imagePlasma = this.createImage(new MemoryImageSource(this.width, this.height, this.palette.getColorModel(), this.destPixels, 0, this.width));
            MediaTracker mediaTracker = new MediaTracker(this);
            try {
                mediaTracker.addImage(this.imagePlasma, 0);
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.isRunning = false;
        }
    }

    void makeScreen() {
        try {
            this.imageOffScreen = this.createImage(this.width, this.height);
            Graphics graphics = this.imageOffScreen.getGraphics();
            this.makePlasma();
            graphics.drawImage(this.imagePlasma, 0, 0, this);
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.isRunning = false;
        }
    }

    public void start() {
        if (this.thrPlasma == null) {
            this.isRunning = true;
            this.thrPlasma = new PlasmaThread();
            this.thrPlasma.start();
        }
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
        if (this.thrPlasma != null) {
            this.thrPlasma.interrupt();
            this.thrPlasma = null;
        }
    }

    class PlasmaThread
    extends Thread {
        PlasmaThread() {
        }

        public void run() {
            Plasma.this.plasmaInit();
            Plasma.this.isRunning = true;
            while (Plasma.this.isRunning) {
                Plasma.this.repaint();
            }
        }
    }
}

