/*********************************************************************************
 * Title:		XORcrypt
 * Description:Simple script, allowing reliably encrypt/decrypt of any files with 
 * 				the help of a key file and bitwise operation "exclusive OR" (XOR).
 * 				It is impossible to do it more reliable and easier.
 * Copyright:	Copyright (c) 2001
 * @author		Alexandr Shpirkov 
 * @version		1.2
 ********************************************************************************/

var ForReading = 1, ForWriting = 2;
// Please do not copy next line through clipboard. It can destroys the program.
var ANSI0="";
var ANSI2="";
var sName="",keyName="",oName="",tName,ask=true,another=false,onlyencrypt=false,crypt="encrypt",CRC=111,OFFSET=1111,testlength=30,prev="";
var SS,KS,OS;
var WshShell=WScript.CreateObject("WScript.Shell");
var fso = WScript.CreateObject("Scripting.FileSystemObject");
var MSCD = WScript.CreateObject("MSComDlg.CommonDialog");

testversion();
for(i=0;i<128;i++) ANSI2+=ANSI0.charAt(i);
getArgs();
defineNames();
testSource();
if(ask==false || askSure()) work();

function XOR(SourceStream,KeyStream,OutStream) {
	do {
		try { 
//------------------------------------------------------------------------------//
//*** ATTENTION!!! The basic code  *********************************************//
//    encrypted               = source               XOR     key                //
// or source                  = encrypted            XOR     key                //
		OutStream.Write(char(code(SourceStream.Read(1)) ^ code(KeyStream.Read(1))));
//------------------------------------------------------------------------------//
		} 
		catch(e) {}
	} while ( !SourceStream.AtEndOfStream )
}

function work() {
	tName=""+fso.GetParentFolderName(oName)+"\\"+fso.GetTempName();
	OS=fso.OpenTextFile( tName, ForWriting, true);
	KS=new KeyStream( keyName,OFFSET);
	SS=fso.OpenTextFile( sName, ForReading, false);
	prev="";
	if(crypt=="encrypt") {
		OS.Write("XR"+OFFSET);
		var CRCS=new StrIStream(""+CRC);
		XOR(CRCS,KS,OS);
		XOR(SS,KS,OS);
	}
	else {
		SS.Read(9); for(i=0;i<3;i++) KS.Read();
		XOR(SS,KS,OS);
	}
	KS.Close();OS.Close();SS.Close();
	fso.DeleteFile (oName);
	fso.MoveFile ( tName, oName );
}

function code(chr) {
// JScript does not work with bytes. It is necessary to deceive.
	var cnum=chr.charCodeAt(0);
	if(cnum<256) return cnum;
	return 128+ANSI2.indexOf(String.fromCharCode(cnum));
}

function char(cnum) {
	if(cnum>127 && cnum<256) return ANSI0.substr(cnum-128,1);
	return String.fromCharCode(cnum);
}

function p(s) {
   WScript.echo(s);
}

function FileGet(fName,flength) {
	var ts = fso.GetFile( fName ).OpenAsTextStream(ForReading);
	var ret="";
	var count=0;
	try { while(count++<flength) ret+=ts.Read(1); } catch(e) {}
	ts.Close( );
	return(ret);
}

function getArgs() {
var args=WScript.arguments;
if(args.length==0) arglist();
for (i=0;i<args.length;i++)  {
	switch (args(i).substr(0,2).toUpperCase( )) {
		case "/?" :
			arglist();
		case "/K" :
      	keyName=args(i).substr(3);break;
		case "/O" :
			another=true;oName=args(i).substr(3);break;
		case "/E" :
			onlyencrypt=true;	break;
		case "/Y" :
			ask=true;			break;
		case "/N" :
			ask=false;		break;
		default :
			if(args(i).substr(0,1)=="/") {
	      	p("Unknown swith: "+args(i));
				WScript.Quit();
			}
			else if(sName.length==0) sName=args(i);
	} 
}
}

function arglist() {
  	p("XORcrypt [source] [/K:keyfile] [/O[:outfile]] [/E] [/Y] [/N] [/?]"+
  	"\n\t source  - full path to source file. If it is omitted, it will be requested in dialogue."+
  	"\n\t keyfile - full path to key file. If it is omitted, it will be requested in dialogue."+
  	"\n\t outfile - full path to destination file. If it is omitted, it will be overwritten source file."+
  	"\n\t           If /O used without path, destination file will be requested in dialogue."+
  	"\n\t /E      - To encrypt file once more even if it is already encrypted."+
  	"\n\t           By default encrypted file will be decrypted."+
 	"\n\t /Y      - To carry out an encryption/decryption without confirmation."+
  	"\n\t /N      - The same with confirmation (default)."+
  	"\n\t /?      - To show options list.");
	WScript.Quit();
}

function defineNames() {
	MSCD.Flags = 4;
	MSCD.MaxFileSize =200;
	MSCD.CancelError =true;
	if(sName.length==0)			sName=getname("source");
	if(keyName.length==0)		keyName=getname("key");
	if(another ) {	if(oName.length==0)	oName=getname("destination"); }
	else oName=sName;
}

function getname(kid) {
	MSCD.DialogTitle ="Select "+kid+" file";
	MSCD.FileName="";
// Cancel (Esc) will interrupt the program
	try { MSCD.ShowOpen(); } catch(e) { nocrypt();}
	return MSCD.FileName;
}

function askSure() {
	if(WshShell.Popup("You really want to "+crypt+" \n"+sName+"\n with key file \n"+keyName,1000,"",36)==6)	return true;
	nocrypt();
	return false;
}

function testSource() {
	OFFSET=parseInt(Math.random( )*8999)+1000;
	var test=FileGet(sName,testlength+9);
	if(onlyencrypt) { CRC=defCRC(test); return;}
	if(test.substr(0,2)=="XR") {
		OFFSET=0+test.substr(2,4);
		SS= new StrIStream(test.substr(6,testlength+3));
	 	OS= new StrOStream();
		KS= new KeyStream(keyName,OFFSET);
		XOR(SS,KS,OS);
		var dectypted=OS.value;
		KS.Close();
		crypt="decrypt";
		if (0+dectypted.substr(0,3)!=defCRC(dectypted.substr(3))) {
			var WshShell=WScript.CreateObject("WScript.Shell");
			WshShell.Popup("Sorry. Decryption is impossible.\n May be you encrypt \n"+sName+"\n with another key file than \n"+keyName,1000,"",16);
			nocrypt();
		}
	}
	else { CRC=defCRC(test.substr(0,testlength)); return;}
}

function defCRC(csstr) {
	var mCRC=0;
	for(i=0;i<csstr.length;i++) mCRC+=csstr.charCodeAt(i);
	return (mCRC % 899)+100;
}

function nocrypt() {
	p("File "+sName+" is not "+crypt+"ed.");
	WScript.Quit();
}

function KeyStream(fName,offset) {
	this.file = fso.GetFile( fName );
	this.ts = this.file.OpenAsTextStream(ForReading);
	this.Read =KSRead;
	this.Close=KSClose;
	var toffset=offset % this.file.Size;
	if( toffset >0 ) this.ts.Read(toffset);
	return this;
}

function StrOStream() {
	this.value  = new String("");
	this.Write=SWrite;
	this.Close=Empty;
}

function StrIStream(istr) {
	this.value = new String(istr);
	this.index=0;
	this.AtEndOfStream=false;
	this.Read=SRead;
	this.Close=Empty;
	return this;
}

function Empty() {}

function KSRead() {
	do {
		try { ret = this.ts.Read(1); } 
		catch(e) {
			this.ts.Close();
			this.ts = this.file.OpenAsTextStream(ForReading);
			ret = prev;
		}
	} while ( ret==prev || ret.charCodeAt(0)==0 )
	prev=ret;
	return ret;
}

function KSClose() {
	this.ts.Close();
}

function SWrite(istr) {
 this.value= this.value.concat(istr);
}

function SRead() {
	this.index++;
	if(this.index>this.value.length) { this.AtEndOfStream=true; throw "end of line";   ;}
	return this.value.charAt(this.index-1);
}

function testversion() {
	if(ScriptEngineMajorVersion()<5) {
		var URL="http://www.microsoft.com/msdownload/vbscript/scripting.asp";
		if(WshShell.Popup("Excuse, but you yours Script Engine has too old Version."+
			"\nPlease update on "+URL,1000,"",17)==1) WshShell.Run(URL);
		WScript.Quit();
	}
}
