/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.smtp.SMTPOutputStream;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SMTPTransport
extends Transport {
    private MimeMessage message;
    private Address[] addresses;
    private Address[] validSentAddr;
    private Address[] validUnsentAddr;
    private Address[] invalidAddr;
    private static final String[] ignoreList = new String[]{"Bcc", "Content-Length"};
    private String name = "smtp";
    private BufferedInputStream serverInput;
    private LineInputStream lineInputStream;
    private OutputStream serverOutput;
    private String lastServerResponse;
    private Socket serverSocket;
    private static String localHostName;

    public SMTPTransport(Session session, URLName uRLName) {
        super(session, uRLName);
        if (uRLName != null) {
            this.name = uRLName.getProtocol();
        }
    }

    protected boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        if (n == -1) {
            String string4 = this.session.getProperty("mail." + this.name + ".port");
            n = string4 != null ? Integer.parseInt(string4) : 25;
        }
        if (string == null || string.length() == 0) {
            string = "localhost";
        }
        boolean bl = false;
        try {
            bl = this.openServer(string, n);
            if (bl) {
                this.helo();
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new MessagingException("Unknown SMTP host: " + string, unknownHostException);
        }
        catch (IOException iOException) {
            throw new MessagingException("Could not connect to SMTP host: " + string + ", port: " + n, iOException);
        }
        if (!bl) {
            if (this.debug) {
                System.out.println("DEBUG: SMTPTransport could not connect to host \"" + string + "\", port: " + n + "\n");
            }
            throw new MessagingException("Could not connect to SMTP host: " + string + ", port: " + n);
        }
        if (this.debug) {
            System.out.println("DEBUG: SMTPTransport connected to host \"" + string + "\", port: " + n + "\n");
        }
        return true;
    }

    public synchronized void sendMessage(Message message, Address[] addressArray) throws MessagingException, SendFailedException {
        this.checkConnected();
        if (!(message instanceof MimeMessage)) {
            if (this.debug) {
                System.out.println("DEBUG: Can only send RFC822 msgs");
            }
            throw new MessagingException("SMTP can only send RFC822 messages");
        }
        int n = 0;
        while (n < addressArray.length) {
            if (!(addressArray[n] instanceof InternetAddress)) {
                throw new MessagingException(String.valueOf(addressArray[n]) + " is not an InternetAddress");
            }
            ++n;
        }
        this.message = (MimeMessage)message;
        this.addresses = addressArray;
        try {
            try {
                this.mailFrom();
                this.rcptTo();
                this.message.writeTo(this.data(), ignoreList);
                this.finishData();
                this.notifyTransportListeners(1, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
            }
            catch (IOException iOException) {
                if (this.debug) {
                    iOException.printStackTrace();
                }
                try {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException2) {
                    }
                    Object var8_5 = null;
                    this.serverSocket = null;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    this.serverSocket = null;
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {}
                    throw throwable;
                }
                try {
                    this.close();
                }
                catch (MessagingException messagingException) {}
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                throw new MessagingException("IOException while sending message", iOException);
            }
            Object var5_8 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            throw throwable;
        }
    }

    public synchronized void close() throws MessagingException {
        block13: {
            if (!super.isConnected()) {
                return;
            }
            try {
                if (this.serverSocket == null) break block13;
                this.sendCommand("quit");
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    try {
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException iOException) {
                        throw new MessagingException("Server Close Failed", iOException);
                    }
                    {
                    }
                }
                finally {
                    Object v0 = null;
                }
            }
        }
        Object var2_1 = null;
        try {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                throw new MessagingException("Server Close Failed", iOException);
            }
            {
            }
        }
        finally {
            Object v1 = null;
        }
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            this.sendCommand("NOOP");
            int n = this.readServerResponse();
            if (n >= 0) {
                return true;
            }
            this.setConnected(false);
            this.notifyConnectionListeners(3);
            return false;
        }
        catch (Exception exception) {
            this.setConnected(false);
            this.notifyConnectionListeners(3);
            return false;
        }
    }

    protected void finalize() throws Throwable {
        if (this.serverSocket != null) {
            this.close();
        }
        super.finalize();
    }

    private void helo() throws MessagingException {
        try {
            if (localHostName == null || localHostName.length() <= 0) {
                localHostName = InetAddress.getLocalHost().getHostName();
            }
            this.issueCommand("helo " + localHostName, 250);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.issueCommand("helo", 250);
            return;
        }
    }

    private void mailFrom() throws MessagingException {
        String string = this.session.getProperty("mail." + this.name + ".user");
        if (string == null || string.length() <= 0) {
            Address[] addressArray;
            Address address = this.message != null && (addressArray = this.message.getFrom()) != null && addressArray.length > 0 ? addressArray[0] : InternetAddress.getLocalAddress(this.session);
            if (address != null) {
                string = address.getAddress();
            } else {
                throw new MessagingException("can't determine local email address");
            }
        }
        this.issueCommand("mail from: " + this.normalizeAddress(string), 250);
    }

    private void rcptTo() throws MessagingException {
        Vector<Address> vector = new Vector<Address>();
        Vector<Address> vector2 = new Vector<Address>();
        int n = -1;
        SendFailedException sendFailedException = null;
        boolean bl = false;
        this.invalidAddr = null;
        this.validUnsentAddr = null;
        this.validSentAddr = null;
        int n2 = 0;
        while (n2 < this.addresses.length) {
            this.sendCommand("rcpt to: " + this.normalizeAddress(((InternetAddress)this.addresses[n2]).getAddress()));
            n = this.readServerResponse();
            switch (n) {
                case 250: 
                case 251: {
                    vector.addElement(this.addresses[n2]);
                    break;
                }
                case 501: 
                case 503: 
                case 550: 
                case 551: 
                case 553: {
                    bl = true;
                    vector2.addElement(this.addresses[n2]);
                    SendFailedException sendFailedException2 = new SendFailedException(this.lastServerResponse);
                    if (sendFailedException == null) {
                        sendFailedException = sendFailedException2;
                        break;
                    }
                    sendFailedException.setNextException(sendFailedException2);
                    break;
                }
                case 450: 
                case 451: 
                case 452: 
                case 552: {
                    bl = true;
                    vector.addElement(this.addresses[n2]);
                    SendFailedException sendFailedException3 = new SendFailedException(this.lastServerResponse);
                    if (sendFailedException == null) {
                        sendFailedException = sendFailedException3;
                        break;
                    }
                    sendFailedException.setNextException(sendFailedException3);
                    break;
                }
                default: {
                    String string = this.lastServerResponse;
                    this.issueCommand("rset", 250);
                    throw new SendFailedException(string);
                }
            }
            ++n2;
        }
        if (bl) {
            this.invalidAddr = new Address[vector2.size()];
            vector2.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[vector.size()];
            vector.copyInto(this.validUnsentAddr);
        } else {
            this.validSentAddr = this.addresses;
        }
        if (this.debug) {
            if (this.validSentAddr != null && this.validSentAddr.length > 0) {
                System.out.println("Verified Addresses");
                int n3 = 0;
                while (n3 < this.validSentAddr.length) {
                    System.out.println("  " + this.validSentAddr[n3]);
                    ++n3;
                }
            }
            if (this.validUnsentAddr != null && this.validUnsentAddr.length > 0) {
                System.out.println("Valid Unsent Addresses");
                int n4 = 0;
                while (n4 < this.validUnsentAddr.length) {
                    System.out.println("  " + this.validUnsentAddr[n4]);
                    ++n4;
                }
            }
            if (this.invalidAddr != null && this.invalidAddr.length > 0) {
                System.out.println("Invalid Addresses");
                int n5 = 0;
                while (n5 < this.invalidAddr.length) {
                    System.out.println("  " + this.invalidAddr[n5]);
                    ++n5;
                }
            }
        }
        if (bl) {
            block23: {
                if (this.debug) {
                    System.out.println("DEBUG SMTPTransport: Sending failed because of invalid destination addresses");
                }
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                try {
                    this.issueCommand("rset", 250);
                }
                catch (MessagingException messagingException) {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException2) {
                        if (!this.debug) break block23;
                        messagingException2.printStackTrace();
                    }
                }
            }
            throw new SendFailedException("Invalid Addresses", sendFailedException, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    private OutputStream data() throws MessagingException {
        this.issueCommand("data", 354);
        return new SMTPOutputStream(this.serverOutput);
    }

    private void finishData() throws MessagingException {
        this.issueCommand("\r\n.", 250);
    }

    private boolean openServer(String string, int n) throws IOException, UnknownHostException {
        if (this.debug) {
            System.out.println("\nDEBUG: SMTPTransport trying to connect to host \"" + string + "\", port " + n + "\n");
        }
        Properties properties = this.session.getProperties();
        this.serverSocket = SocketFetcher.getSocket(string, n, properties.getProperty("mail." + this.name + ".socketFactory.class", null), properties.getProperty("mail." + this.name + ".socketFactory.fallback", null), properties.getProperty("mail." + this.name + ".socketFactory.port", null));
        this.serverOutput = new BufferedOutputStream(this.serverSocket.getOutputStream());
        this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
        this.lineInputStream = new LineInputStream(this.serverInput);
        if (this.readServerResponse() != 220) {
            try {
                this.close();
            }
            catch (MessagingException messagingException) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            return false;
        }
        return true;
    }

    private void issueCommand(String string, int n) throws MessagingException {
        this.sendCommand(string);
        if (this.readServerResponse() != n) {
            throw new MessagingException(this.lastServerResponse);
        }
    }

    private void sendCommand(String string) throws MessagingException {
        if (this.debug) {
            System.out.println("DEBUG SMTP SENT: " + string);
        }
        string = String.valueOf(string) + "\r\n";
        byte[] byArray = ASCIIUtility.getBytes(string);
        try {
            this.serverOutput.write(byArray);
            this.serverOutput.flush();
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("Can't send command to SMTP host", iOException);
        }
    }

    private int readServerResponse() {
        String string = "";
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            String string2 = null;
            do {
                if ((string2 = this.lineInputStream.readLine()) == null) {
                    return -1;
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            } while (this.isNotLastLine(string2));
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            n = -1;
        }
        if (this.debug) {
            System.out.println("DEBUG SMTP RCVD: " + string);
        }
        if (n != -1 && string != null && string.length() >= 3) {
            try {
                n = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                block14: {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!this.debug) break block14;
                        messagingException.printStackTrace();
                    }
                }
                n = -1;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                block15: {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!this.debug) break block15;
                        messagingException.printStackTrace();
                    }
                }
                n = -1;
            }
        } else {
            n = -1;
        }
        this.lastServerResponse = string;
        return n;
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private boolean isNotLastLine(String string) {
        if (string != null && string.length() > 4) {
            return string.charAt(3) == '-';
        }
        return false;
    }

    private String normalizeAddress(String string) {
        if (!string.startsWith("<") && !string.endsWith(">")) {
            return "<" + string + ">";
        }
        return string;
    }
}

