/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable identities = new Hashtable();

    IdentityDatabase() throws InvalidParameterException {
        this("restoring...");
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    public static IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            identityDatabase = (IdentityDatabase)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.debug("This should not be happening.", classNotFoundException);
            IdentityDatabase.error("The version of the database is obsolete. Cannot initialize.");
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.debug("This should not be happening.", invalidClassException);
            IdentityDatabase.error("Unable to initialize system identity scope:  InvalidClassException. \nThis is most likely due to a serialization versioning problem: a class used in key management was obsoleted");
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.debug("The serialization stream is corrupted. Unable to load.", streamCorruptedException);
            IdentityDatabase.error("Unable to initialize system identity scope. StreamCorrputedException.");
        }
        if (identityDatabase == null) {
            identityDatabase = new IdentityDatabase("uninitialized");
        }
        return identityDatabase;
    }

    public static IdentityDatabase fromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        identityDatabase.sourceFile = file;
        return identityDatabase;
    }

    public int size() {
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.localCheck("get.signer");
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.keyEqual(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.localCheck("get.signer");
            }
            return identity;
        }
        return null;
    }

    private boolean keyEqual(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        this.localCheck("add.identity");
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = "name conflict";
        }
        if (identity3 != null) {
            string = "key conflict";
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        this.localCheck("remove.identity");
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException("there is no identity named " + string + " in " + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        return this.identities.elements();
    }

    void setSourceFile(File file) {
        this.sourceFile = file;
    }

    File getSourceFile() {
        return this.sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.debug("This should not be happening.", invalidClassException);
            return;
        }
    }

    void save(File file) throws IOException {
        this.setSourceFile(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("this database has no source file");
        }
        this.save(this.sourceFile);
    }

    private static File systemDatabaseFile() {
        String string = Security.getProperty("identity.database");
        if (string == null) {
            string = System.getProperty("user.home") + File.separatorChar + "identitydb.obj";
        }
        return new File(string);
    }

    private static void initializeSystem() {
        File file = IdentityDatabase.systemDatabaseFile();
        try {
            IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.debug("loading system database from file: " + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new IdentityDatabase(file);
            }
            IdentityScope.setSystemScope(identityDatabase);
            IdentityDatabase.debug("System database initialized: " + identityDatabase);
        }
        catch (IOException iOException) {
            IdentityDatabase.debug("Error initializing identity database: " + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.debug("Error trying to instantiate a system identities db in " + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        return "sun.security.provider.IdentityDatabase, source file: " + this.sourceFile;
    }

    private static void debug(String string) {
    }

    private static void debug(String string, Throwable throwable) {
    }

    private static void error(String string) {
        System.err.println(string);
    }

    void localCheck(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            string = this.getClass().getName() + "." + string + "." + this.localFullName();
            securityManager.checkSecurityAccess(string);
        }
    }

    String localFullName() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = string + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.localCheck("serialize.identity.database");
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(this.sourceFile);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IdentityDatabase.initializeSystem();
                return null;
            }
        });
    }
}

