/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.MultiUIDefaults;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;

public class UIManager
implements Serializable {
    private static final Object lafStateACKey = new StringBuffer("LookAndFeel State");
    private static final Object classLock = new Object();
    private static Thread currentLAFStateThread = null;
    private static LAFState currentLAFState = null;
    private static final String defaultLAFKey = "swing.defaultlaf";
    private static final String auxiliaryLAFsKey = "swing.auxiliarylaf";
    private static final String multiplexingLAFKey = "swing.plaf.multiplexinglaf";
    private static final String installedLAFsKey = "swing.installedlafs";
    private static LookAndFeelInfo[] installedLAFs = new LookAndFeelInfo[]{new LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel"), new LookAndFeelInfo("CDE/Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel"), new LookAndFeelInfo("Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel")};
    static /* synthetic */ Class class$javax$swing$UIManager;

    private static LAFState getLAFState() {
        Thread thread = Thread.currentThread();
        if (thread == currentLAFStateThread) {
            return currentLAFState;
        }
        LAFState lAFState = (LAFState)SwingUtilities.appContextGet(lafStateACKey);
        if (lAFState == null) {
            Object object = classLock;
            synchronized (object) {
                lAFState = (LAFState)SwingUtilities.appContextGet(lafStateACKey);
                if (lAFState == null) {
                    lAFState = new LAFState();
                    SwingUtilities.appContextPut(lafStateACKey, lAFState);
                }
            }
        }
        currentLAFStateThread = thread;
        currentLAFState = lAFState;
        return lAFState;
    }

    private static String makeInstalledLAFKey(String string, String string2) {
        return "swing.installedlaf." + string + "." + string2;
    }

    private static String makeSwingPropertiesFilename() {
        final String[] stringArray = new String[]{"<java.home undefined>"};
        SwingUtilities.doPrivileged(new Runnable(){

            public void run() {
                stringArray[0] = System.getProperty("java.home", "<java.home undefined>");
            }
        });
        String string = File.separator;
        return stringArray[0] + string + "lib" + string + "swing.properties";
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        UIManager.maybeInitialize();
        LookAndFeelInfo[] lookAndFeelInfoArray = installedLAFs;
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        return lookAndFeelInfoArray2;
    }

    public static void setInstalledLookAndFeels(LookAndFeelInfo[] lookAndFeelInfoArray) throws SecurityException {
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        installedLAFs = lookAndFeelInfoArray2;
    }

    public static void installLookAndFeel(LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        LookAndFeelInfo[] lookAndFeelInfoArray2 = new LookAndFeelInfo[lookAndFeelInfoArray.length + 1];
        System.arraycopy(lookAndFeelInfoArray, 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray.length);
        lookAndFeelInfoArray2[lookAndFeelInfoArray.length] = lookAndFeelInfo;
        UIManager.setInstalledLookAndFeels(lookAndFeelInfoArray2);
    }

    public static void installLookAndFeel(String string, String string2) {
        UIManager.installLookAndFeel(new LookAndFeelInfo(string, string2));
    }

    public static LookAndFeel getLookAndFeel() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().lookAndFeel;
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) throws UnsupportedLookAndFeelException {
        if (lookAndFeel != null && !lookAndFeel.isSupportedLookAndFeel()) {
            String string = lookAndFeel.toString() + " not supported on this platform";
            throw new UnsupportedLookAndFeelException(string);
        }
        LookAndFeel lookAndFeel2 = UIManager.getLAFState().lookAndFeel;
        if (lookAndFeel2 != null) {
            lookAndFeel2.uninitialize();
        }
        UIManager.getLAFState().lookAndFeel = lookAndFeel;
        if (lookAndFeel != null) {
            lookAndFeel.initialize();
            UIManager.getLAFState().setLookAndFeelDefaults(lookAndFeel.getDefaults());
        } else {
            UIManager.getLAFState().setLookAndFeelDefaults(null);
        }
        UIManager.getLAFState().changeSupport.firePropertyChange("lookAndFeel", lookAndFeel2, lookAndFeel);
    }

    public static void setLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Class clazz = SwingUtilities.loadSystemClass(string);
        UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
    }

    public static String getSystemLookAndFeelClassName() {
        final String[] stringArray = new String[]{""};
        SwingUtilities.doPrivileged(new Runnable(){

            public void run() {
                stringArray[0] = System.getProperty("os.name");
            }
        });
        if (stringArray[0] != null) {
            if (stringArray[0].indexOf("Windows") != -1) {
                return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            }
            if (stringArray[0].indexOf("Solaris") != -1 || stringArray[0].indexOf("SunOS") != -1) {
                return "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
            if (stringArray[0].indexOf("Mac") != -1) {
                return "com.sun.java.swing.plaf.mac.MacLookAndFeel";
            }
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static UIDefaults getDefaults() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().multiUIDefaults;
    }

    public static Font getFont(Object object) {
        return UIManager.getDefaults().getFont(object);
    }

    public static Color getColor(Object object) {
        return UIManager.getDefaults().getColor(object);
    }

    public static Icon getIcon(Object object) {
        return UIManager.getDefaults().getIcon(object);
    }

    public static Border getBorder(Object object) {
        return UIManager.getDefaults().getBorder(object);
    }

    public static String getString(Object object) {
        return UIManager.getDefaults().getString(object);
    }

    public static int getInt(Object object) {
        return UIManager.getDefaults().getInt(object);
    }

    public static Insets getInsets(Object object) {
        return UIManager.getDefaults().getInsets(object);
    }

    public static Dimension getDimension(Object object) {
        return UIManager.getDefaults().getDimension(object);
    }

    public static Object get(Object object) {
        return UIManager.getDefaults().get(object);
    }

    public static Object put(Object object, Object object2) {
        return UIManager.getDefaults().put(object, object2);
    }

    public static ComponentUI getUI(JComponent jComponent) {
        UIManager.maybeInitialize();
        ComponentUI componentUI = null;
        LookAndFeel lookAndFeel = UIManager.getLAFState().multiLookAndFeel;
        if (lookAndFeel != null) {
            componentUI = lookAndFeel.getDefaults().getUI(jComponent);
        }
        if (componentUI == null) {
            componentUI = UIManager.getDefaults().getUI(jComponent);
        }
        return componentUI;
    }

    public static UIDefaults getLookAndFeelDefaults() {
        UIManager.maybeInitialize();
        return UIManager.getLAFState().getLookAndFeelDefaults();
    }

    private static LookAndFeel getMultiLookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLAFState().multiLookAndFeel;
        if (lookAndFeel == null) {
            String string = "javax.swing.plaf.multi.MultiLookAndFeel";
            String string2 = UIManager.getLAFState().swingProps.getProperty(multiplexingLAFKey, string);
            try {
                Class clazz = SwingUtilities.loadSystemClass(string2);
                lookAndFeel = (LookAndFeel)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("UIManager: failed loading " + string2);
            }
        }
        return lookAndFeel;
    }

    public static void addAuxiliaryLookAndFeel(LookAndFeel lookAndFeel) {
        UIManager.maybeInitialize();
        Vector vector = UIManager.getLAFState().auxLookAndFeels;
        if (vector == null) {
            vector = new Vector();
        }
        if (!vector.contains(lookAndFeel)) {
            vector.addElement(lookAndFeel);
            lookAndFeel.initialize();
            UIManager.getLAFState().auxLookAndFeels = vector;
            if (UIManager.getLAFState().multiLookAndFeel == null) {
                UIManager.getLAFState().multiLookAndFeel = UIManager.getMultiLookAndFeel();
            }
        }
    }

    public static boolean removeAuxiliaryLookAndFeel(LookAndFeel lookAndFeel) {
        UIManager.maybeInitialize();
        Vector vector = UIManager.getLAFState().auxLookAndFeels;
        if (vector == null || vector.size() == 0) {
            return false;
        }
        boolean bl = vector.removeElement(lookAndFeel);
        if (bl) {
            if (vector.size() == 0) {
                UIManager.getLAFState().auxLookAndFeels = null;
                UIManager.getLAFState().multiLookAndFeel = null;
            } else {
                UIManager.getLAFState().auxLookAndFeels = vector;
            }
        }
        lookAndFeel.uninitialize();
        return bl;
    }

    public static LookAndFeel[] getAuxiliaryLookAndFeels() {
        UIManager.maybeInitialize();
        Vector vector = UIManager.getLAFState().auxLookAndFeels;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        LookAndFeel[] lookAndFeelArray = new LookAndFeel[vector.size()];
        int n = 0;
        while (n < lookAndFeelArray.length) {
            lookAndFeelArray[n] = (LookAndFeel)vector.elementAt(n);
            ++n;
        }
        return lookAndFeelArray;
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = classLock;
        synchronized (object) {
            UIManager.getLAFState().changeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = classLock;
        synchronized (object) {
            UIManager.getLAFState().changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private static Properties loadSwingProperties() {
        if ((class$javax$swing$UIManager == null ? (class$javax$swing$UIManager = UIManager.class$("javax.swing.UIManager")) : class$javax$swing$UIManager).getClassLoader() != null) {
            return new Properties();
        }
        final Properties properties = new Properties();
        SwingUtilities.doPrivileged(new Runnable(){

            public void run() {
                try {
                    File file = new File(UIManager.makeSwingPropertiesFilename());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    properties.load(bufferedInputStream);
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                UIManager.checkProperty(properties, UIManager.defaultLAFKey);
                UIManager.checkProperty(properties, UIManager.auxiliaryLAFsKey);
                UIManager.checkProperty(properties, UIManager.multiplexingLAFKey);
                UIManager.checkProperty(properties, UIManager.installedLAFsKey);
            }
        });
        return properties;
    }

    private static void checkProperty(Properties properties, String string) {
        try {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                properties.put(string, string2);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void initializeInstalledLAFs(Properties properties) {
        String string = properties.getProperty(installedLAFsKey);
        if (string == null) {
            return;
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Vector vector2 = new Vector(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            String string3 = properties.getProperty(UIManager.makeInstalledLAFKey(string2, "name"), string2);
            String string4 = properties.getProperty(UIManager.makeInstalledLAFKey(string2, "class"));
            if (string4 != null) {
                vector2.addElement(new LookAndFeelInfo(string3, string4));
            }
            ++n;
        }
        installedLAFs = new LookAndFeelInfo[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            UIManager.installedLAFs[n2] = (LookAndFeelInfo)vector2.elementAt(n2);
            ++n2;
        }
    }

    private static void initializeDefaultLAF(Properties properties) {
        String string;
        if (UIManager.getLAFState().lookAndFeel != null) {
            return;
        }
        String string2 = string = UIManager.getCrossPlatformLookAndFeelClassName();
        String string3 = "<undefined>";
        try {
            string3 = properties.getProperty(defaultLAFKey, string2);
            UIManager.setLookAndFeel(string3);
        }
        catch (Exception exception) {
            try {
                string3 = properties.getProperty(defaultLAFKey, string);
                UIManager.setLookAndFeel(string3);
            }
            catch (Exception exception2) {
                throw new Error("can't load " + string3);
            }
        }
    }

    private static void initializeAuxiliaryLAFs(Properties properties) {
        String string = properties.getProperty(auxiliaryLAFsKey);
        if (string == null) {
            return;
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Class clazz = SwingUtilities.loadSystemClass(string2);
                LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
                lookAndFeel.initialize();
                vector.addElement(lookAndFeel);
            }
            catch (Exception exception) {
                System.err.println("UIManager: failed loading auxiliary look and feel " + string2);
            }
        }
        if (vector.size() == 0) {
            vector = null;
        } else {
            UIManager.getLAFState().multiLookAndFeel = UIManager.getMultiLookAndFeel();
            if (UIManager.getLAFState().multiLookAndFeel == null) {
                vector = null;
            }
        }
        UIManager.getLAFState().auxLookAndFeels = vector;
    }

    private static void initializeSystemDefaults(Properties properties) {
        Object[] objectArray = new Object[]{"FocusManagerClassName", "javax.swing.DefaultFocusManager"};
        UIManager.getLAFState().setSystemDefaults(new UIDefaults(objectArray));
        UIManager.getLAFState().swingProps = properties;
    }

    private static void maybeInitialize() {
        Object object = classLock;
        synchronized (object) {
            if (!UIManager.getLAFState().initialized) {
                UIManager.getLAFState().initialized = true;
                UIManager.initialize();
            }
        }
    }

    private static void initialize() {
        Properties properties = UIManager.loadSwingProperties();
        try {
            Compiler.disable();
            UIManager.initializeSystemDefaults(properties);
            UIManager.initializeDefaultLAF(properties);
            UIManager.initializeAuxiliaryLAFs(properties);
            UIManager.initializeInstalledLAFs(properties);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Compiler.enable();
            throw throwable;
        }
        Compiler.enable();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LookAndFeelInfo {
        private String name;
        private String className;

        public LookAndFeelInfo(String string, String string2) {
            this.name = string;
            this.className = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.getName() + " " + this.getClassName() + "]";
        }
    }

    private static class LAFState {
        Properties swingProps;
        private UIDefaults[] tables = new UIDefaults[2];
        boolean initialized = false;
        MultiUIDefaults multiUIDefaults = new MultiUIDefaults(this.tables);
        LookAndFeel lookAndFeel;
        LookAndFeel multiLookAndFeel = null;
        Vector auxLookAndFeels = null;
        SwingPropertyChangeSupport changeSupport = new SwingPropertyChangeSupport(class$javax$swing$UIManager == null ? (class$javax$swing$UIManager = LAFState.class$("javax.swing.UIManager")) : class$javax$swing$UIManager);
        static /* synthetic */ Class class$javax$swing$UIManager;

        private LAFState() {
        }

        UIDefaults getLookAndFeelDefaults() {
            return this.tables[0];
        }

        void setLookAndFeelDefaults(UIDefaults uIDefaults) {
            this.tables[0] = uIDefaults;
        }

        UIDefaults getSystemDefaults() {
            return this.tables[1];
        }

        void setSystemDefaults(UIDefaults uIDefaults) {
            this.tables[1] = uIDefaults;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

