/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final String uiClassID = "ComboBoxUI";
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount = 8;
    protected boolean isEditable = false;
    protected Object selectedItemReminder = null;
    protected KeySelectionManager keySelectionManager = null;
    protected String actionCommand = "comboBoxChanged";
    protected boolean lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
    boolean firedActionEventOnContentsChanged = false;
    boolean firingActionEvent = false;
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JComboBox(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
        this.init();
    }

    public JComboBox(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel(objectArray));
        this.init();
    }

    public JComboBox(Vector vector) {
        this.setModel(new DefaultComboBoxModel(vector));
        this.init();
    }

    public JComboBox() {
        this.setModel(new DefaultComboBoxModel());
        this.init();
    }

    private void init() {
        this.installAncestorListener();
        this.setOpaque(true);
        this.updateUI();
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (ancestorEvent.getSource() != JComboBox.this) {
                    JComboBox.this.hidePopup();
                }
            }
        });
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeListDataListener(this);
        }
        this.dataModel = comboBoxModel;
        this.firePropertyChange("model", comboBoxModel2, this.dataModel);
        this.dataModel.addListDataListener(this);
        this.invalidate();
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = bl != this.isEditable;
        this.isEditable = bl;
        if (bl2) {
            this.firePropertyChange("editable", !this.isEditable, this.isEditable);
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setMaximumRowCount(int n) {
        int n2 = this.maximumRowCount;
        this.maximumRowCount = n;
        this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.renderer;
        this.renderer = listCellRenderer;
        this.firePropertyChange("renderer", listCellRenderer2, this.renderer);
        this.invalidate();
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        ComboBoxEditor comboBoxEditor2 = this.editor;
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        this.editor = comboBoxEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", comboBoxEditor2, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object object) {
        this.firedActionEventOnContentsChanged = false;
        this.dataModel.setSelectedItem(object);
        if (!this.firedActionEventOnContentsChanged) {
            this.fireActionEvent();
        } else {
            this.firedActionEventOnContentsChanged = false;
        }
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n == -1) {
            this.setSelectedItem(null);
        } else {
            if (n < -1 || n >= n2) {
                throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(n));
        }
    }

    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n = 0;
        int n2 = this.dataModel.getSize();
        while (n < n2) {
            Object object2 = this.dataModel.getElementAt(n);
            if (object2.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void addItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(object);
    }

    public void insertItemAt(Object object, int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(object, n);
    }

    public void removeItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    public void removeItemAt(int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n);
    }

    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
        int n = mutableComboBoxModel.getSize();
        if (mutableComboBoxModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)mutableComboBoxModel).removeAllElements();
        } else {
            int n2 = 0;
            while (n2 < n) {
                Object object = mutableComboBoxModel.getElementAt(0);
                mutableComboBoxModel.removeElement(object);
                ++n2;
            }
        }
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public void setPopupVisible(boolean bl) {
        this.getUI().setPopupVisible(this, bl);
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl = false;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == clazz && objectArray[n + 1] == actionListener) {
                bl = true;
            }
            n -= 2;
        }
        return bl;
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        this.setEnabled(action != null ? action.isEnabled() : true);
        this.setToolTipText(action != null ? (String)action.getValue("ShortDescription") : null);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, action){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JComboBox jComboBox = (JComboBox)this.getTarget();
                if (jComboBox == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    jComboBox.setToolTipText(string2);
                } else if (string.equals("enabled")) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    jComboBox.setEnabled(bl);
                    jComboBox.repaint();
                }
            }
        };
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener == null ? JComboBox.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent);
            }
            n -= 2;
        }
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent actionEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$java$awt$event$ActionListener == null ? JComboBox.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                    if (actionEvent == null) {
                        actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
                    }
                    ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
                }
                n -= 2;
            }
            this.firingActionEvent = false;
        }
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        this.selectedItemReminder = this.getModel().getSelectedItem();
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
        this.fireActionEvent();
        this.firedActionEventOnContentsChanged = true;
    }

    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.getEditor().getItem();
        this.firedActionEventOnContentsChanged = false;
        this.getUI().setPopupVisible(this, false);
        this.getModel().setSelectedItem(object);
        if (!this.firedActionEventOnContentsChanged) {
            this.fireActionEvent();
        } else {
            this.firedActionEventOnContentsChanged = false;
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        ComboBoxModel comboBoxModel = this.getModel();
        Object object = comboBoxModel.getSelectedItem();
        if (this.selectedItemReminder == null) {
            if (object != null) {
                this.selectedItemChanged();
            }
        } else if (!this.selectedItemReminder.equals(object)) {
            this.selectedItemChanged();
        }
        if (!this.isEditable() && object != null) {
            boolean bl = true;
            Object object2 = comboBoxModel.getSelectedItem();
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Object object3 = comboBoxModel.getElementAt(n);
                if (object3.equals(object2)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                if (comboBoxModel.getSize() > 0) {
                    this.setSelectedIndex(0);
                } else {
                    this.setSelectedItem(null);
                }
            }
        }
    }

    public boolean selectWithKeyChar(char c) {
        int n;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        if ((n = this.keySelectionManager.selectionForKey(c, this.getModel())) != -1) {
            this.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        comboBoxEditor.setItem(object);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.hidePopup();
        }
        super.processKeyEvent(keyEvent);
    }

    public boolean isFocusTraversable() {
        return this.getUI().isFocusTraversable(this);
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public Object getItemAt(int n) {
        return this.dataModel.getElementAt(n);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        String string = this.selectedItemReminder != null ? this.selectedItemReminder.toString() : "";
        String string2 = this.isEditable ? "true" : "false";
        String string3 = this.lightWeightPopupEnabled ? "true" : "false";
        return super.paramString() + ",isEditable=" + string2 + ",lightWeightPopupEnabled=" + string3 + ",maximumRowCount=" + this.maximumRowCount + ",selectedItemReminder=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        protected AccessibleJComboBox() {
            super(JComboBox.this);
        }

        public int getAccessibleChildrenCount() {
            if (JComboBox.this.ui != null) {
                return JComboBox.this.ui.getAccessibleChildrenCount(JComboBox.this);
            }
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (JComboBox.this.ui != null) {
                return JComboBox.this.ui.getAccessibleChild(JComboBox.this, n);
            }
            return super.getAccessibleChild(n);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return new String("togglePopup");
            }
            return null;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                JComboBox.this.setPopupVisible(!JComboBox.this.isPopupVisible());
                return true;
            }
            return false;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            Object object = JComboBox.this.getSelectedItem();
            if (object != null) {
                return 1;
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            AccessibleSelection accessibleSelection;
            JList jList;
            AccessibleContext accessibleContext;
            Accessible accessible = JComboBox.this.getUI().getAccessibleChild(JComboBox.this, 0);
            if (accessible != null && accessible instanceof ComboPopup && (accessibleContext = (jList = ((ComboPopup)((Object)accessible)).getList()).getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                return accessibleSelection.getAccessibleSelection(n);
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return JComboBox.this.getSelectedIndex() == n;
        }

        public void addAccessibleSelection(int n) {
            JComboBox.this.setSelectedIndex(n);
        }

        public void removeAccessibleSelection(int n) {
            if (JComboBox.this.getSelectedIndex() == n) {
                this.clearAccessibleSelection();
            }
        }

        public void clearAccessibleSelection() {
            JComboBox.this.setSelectedIndex(-1);
        }

        public void selectAllAccessibleSelection() {
        }
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        DefaultKeySelectionManager() {
        }

        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            String string;
            int n;
            int n2;
            int n3 = -1;
            Object object = comboBoxModel.getSelectedItem();
            if (object != null) {
                object = object.toString();
                n2 = 0;
                n = comboBoxModel.getSize();
                while (n2 < n) {
                    if (object.equals(comboBoxModel.getElementAt(n2).toString())) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
            }
            String string2 = ("" + c).toLowerCase();
            c = string2.charAt(0);
            n2 = ++n3;
            n = comboBoxModel.getSize();
            while (n2 < n) {
                string = comboBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n3) {
                string = comboBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }
}

