/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BitSieve;
import java.math.MutableBigInteger;
import java.util.Random;

public class BigInteger
extends Number
implements Comparable {
    int signum;
    transient int[] mag;
    private byte[] magnitude;
    private int bitCount = -1;
    private int bitLength = -1;
    private int lowestSetBit = -2;
    private int firstNonzeroByteNum = -2;
    private transient int firstNonzeroIntNum = -2;
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static BigInteger smallPrimeProduct = BigInteger.valueOf(1685106581L);
    private static final int MAX_CONSTANT = 16;
    private static BigInteger[] posConst = new BigInteger[17];
    private static BigInteger[] negConst = new BigInteger[17];
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger TWO;
    static int[] bnExpModThreshTable;
    static final byte[] trailingZeroTable;
    private static String[] zeros;
    private static int[] digitsPerLong;
    private static BigInteger[] longRadix;
    private static final long serialVersionUID = -8287574255936472291L;

    public BigInteger(byte[] byArray) {
        if (byArray.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (byArray[0] < 0) {
            this.mag = BigInteger.makePositive(byArray);
            this.signum = -1;
        } else {
            this.mag = BigInteger.stripLeadingZeroBytes(byArray);
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    private BigInteger(int[] nArray) {
        if (nArray.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (nArray[0] < 0) {
            this.mag = BigInteger.makePositive(nArray);
            this.signum = -1;
        } else {
            this.mag = BigInteger.trustedStripLeadingZeroInts(nArray);
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    public BigInteger(int n, byte[] byArray) {
        this.mag = BigInteger.stripLeadingZeroBytes(byArray);
        if (n < -1 || n > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (n == 0) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            this.signum = n;
        }
    }

    private BigInteger(int n, int[] nArray) {
        this.mag = BigInteger.stripLeadingZeroInts(nArray);
        if (n < -1 || n > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (n == 0) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            this.signum = n;
        }
    }

    public BigInteger(String string, int n) {
        int n2 = 0;
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.signum = 1;
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.signum = -1;
            n2 = 1;
        }
        while (n2 < string.length() && Character.digit(string.charAt(n2), n) == 0) {
            ++n2;
        }
        if (n2 == string.length()) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int n3 = string.length() - n2;
        int n4 = n3 % digitsPerLong[n];
        if (n4 == 0) {
            n4 = digitsPerLong[n];
        }
        String string2 = string.substring(n2, n2 += n4);
        BigInteger bigInteger = BigInteger.valueOf(Long.parseLong(string2, n));
        while (n2 < string.length()) {
            long l;
            if ((l = Long.parseLong(string2 = string.substring(n2, n2 += digitsPerLong[n]), n)) < 0L) {
                throw new NumberFormatException("Illegal digit");
            }
            bigInteger = bigInteger.multiply(longRadix[n]).add(BigInteger.valueOf(l));
        }
        this.mag = bigInteger.mag;
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(int n, Random random) {
        this(1, BigInteger.randomBits(n, random));
    }

    private static byte[] randomBits(int n, Random random) {
        if (n < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            random.nextBytes(byArray);
            int n3 = 8 * n2 - n;
            byArray[0] = (byte)(byArray[0] & (1 << 8 - n3) - 1);
        }
        return byArray;
    }

    public BigInteger(int n, int n2, Random random) {
        if (n < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        if (n < 95) {
            this.initToSmallPrime(n, n2, random);
        } else {
            this.initToLargePrime(n, n2, random);
        }
    }

    private void initToSmallPrime(int n, int n2, Random random) {
        long l;
        int n3 = n + 31 >>> 5;
        this.mag = new int[n3];
        this.signum = 1;
        int n4 = 1 << (n + 31 & 0x1F);
        int n5 = (n4 << 1) - 1;
        do {
            int n6 = 0;
            while (n6 < n3) {
                this.mag[n6] = random.nextInt();
                ++n6;
            }
            this.mag[0] = this.mag[0] & n5 | n4;
            if (n <= 2) continue;
            int n7 = n3 - 1;
            this.mag[n7] = this.mag[n7] | 1;
        } while (n > 6 && ((l = this.remainder(smallPrimeProduct).longValue()) % 3L == 0L || l % 5L == 0L || l % 7L == 0L || l % 11L == 0L || l % 13L == 0L || l % 17L == 0L || l % 19L == 0L || l % 23L == 0L || l % 29L == 0L || l % 31L == 0L || l % 37L == 0L || l % 41L == 0L) || !this.isProbablePrime(n2));
    }

    private void initToLargePrime(int n, int n2, Random random) {
        BigInteger bigInteger = new BigInteger(n, random).setBit(n - 1);
        int n3 = bigInteger.mag.length - 1;
        bigInteger.mag[n3] = bigInteger.mag[n3] & 0xFFFFFFFE;
        int n4 = n / 20 * 64;
        BitSieve bitSieve = new BitSieve(bigInteger, n4);
        BigInteger bigInteger2 = bitSieve.retrieve(bigInteger, n2);
        while (bigInteger2 == null || bigInteger2.bitLength() != n) {
            if ((bigInteger = bigInteger.add(BigInteger.valueOf(2 * n4))).bitLength() != n) {
                bigInteger = new BigInteger(n, random).setBit(n - 1);
            }
            int n5 = bigInteger.mag.length - 1;
            bigInteger.mag[n5] = bigInteger.mag[n5] & 0xFFFFFFFE;
            bitSieve = new BitSieve(bigInteger, n4);
            bigInteger2 = bitSieve.retrieve(bigInteger, n2);
        }
        this.signum = 1;
        this.mag = bigInteger2.mag;
    }

    private BigInteger(int[] nArray, int n) {
        this.signum = nArray.length == 0 ? 0 : n;
        this.mag = nArray;
    }

    private BigInteger(byte[] byArray, int n) {
        this.signum = byArray.length == 0 ? 0 : n;
        this.mag = BigInteger.stripLeadingZeroBytes(byArray);
    }

    BigInteger(MutableBigInteger mutableBigInteger, int n) {
        if (mutableBigInteger.offset > 0 || mutableBigInteger.value.length != mutableBigInteger.intLen) {
            this.mag = new int[mutableBigInteger.intLen];
            int n2 = 0;
            while (n2 < mutableBigInteger.intLen) {
                this.mag[n2] = mutableBigInteger.value[mutableBigInteger.offset + n2];
                ++n2;
            }
        } else {
            this.mag = mutableBigInteger.value;
        }
        this.signum = mutableBigInteger.intLen == 0 ? 0 : n;
    }

    public static BigInteger valueOf(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l > 0L && l <= 16L) {
            return posConst[(int)l];
        }
        if (l < 0L && l >= -16L) {
            return negConst[(int)(-l)];
        }
        return new BigInteger(l);
    }

    private BigInteger(long l) {
        if (l < 0L) {
            this.signum = -1;
            l = -l;
        } else {
            this.signum = 1;
        }
        int n = (int)(l >>> 32);
        if (n == 0) {
            this.mag = new int[1];
            this.mag[0] = (int)l;
        } else {
            this.mag = new int[2];
            this.mag[0] = n;
            this.mag[1] = (int)l;
        }
    }

    private static BigInteger valueOf(int[] nArray) {
        return nArray[0] > 0 ? new BigInteger(nArray, 1) : new BigInteger(nArray);
    }

    public BigInteger add(BigInteger bigInteger) {
        if (bigInteger.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return bigInteger;
        }
        if (bigInteger.signum == this.signum) {
            return new BigInteger(BigInteger.add(this.mag, bigInteger.mag), this.signum);
        }
        int n = BigInteger.intArrayCmp(this.mag, bigInteger.mag);
        if (n == 0) {
            return ZERO;
        }
        int[] nArray = n > 0 ? BigInteger.subtract(this.mag, bigInteger.mag) : BigInteger.subtract(bigInteger.mag, this.mag);
        nArray = BigInteger.trustedStripLeadingZeroInts(nArray);
        return new BigInteger(nArray, n * this.signum);
    }

    private static int[] add(int[] nArray, int[] nArray2) {
        if (nArray.length < nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        int n = nArray.length;
        int n2 = nArray2.length;
        int[] nArray4 = new int[n];
        long l = 0L;
        while (n2 > 0) {
            l = ((long)nArray[--n] & 0xFFFFFFFFL) + ((long)nArray2[--n2] & 0xFFFFFFFFL) + (l >>> 32);
            nArray4[n] = (int)l;
        }
        boolean bl = l >>> 32 != 0L;
        while (n > 0 && bl) {
            nArray4[--n] = nArray[n] + 1;
            boolean bl2 = bl = nArray4[--n] == 0;
        }
        while (n > 0) {
            nArray4[--n] = nArray[n];
        }
        if (bl) {
            int n3 = nArray4.length + 1;
            int[] nArray5 = new int[n3];
            int n4 = 1;
            while (n4 < n3) {
                nArray5[n4] = nArray4[n4 - 1];
                ++n4;
            }
            nArray5[0] = 1;
            nArray4 = nArray5;
        }
        return nArray4;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        if (bigInteger.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return bigInteger.negate();
        }
        if (bigInteger.signum != this.signum) {
            return new BigInteger(BigInteger.add(this.mag, bigInteger.mag), this.signum);
        }
        int n = BigInteger.intArrayCmp(this.mag, bigInteger.mag);
        if (n == 0) {
            return ZERO;
        }
        int[] nArray = n > 0 ? BigInteger.subtract(this.mag, bigInteger.mag) : BigInteger.subtract(bigInteger.mag, this.mag);
        nArray = BigInteger.trustedStripLeadingZeroInts(nArray);
        return new BigInteger(nArray, n * this.signum);
    }

    private static int[] subtract(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int[] nArray3 = new int[n];
        int n2 = nArray2.length;
        long l = 0L;
        while (n2 > 0) {
            l = ((long)nArray[--n] & 0xFFFFFFFFL) - ((long)nArray2[--n2] & 0xFFFFFFFFL) + (l >> 32);
            nArray3[n] = (int)l;
        }
        boolean bl = l >> 32 != 0L;
        while (n > 0 && bl) {
            nArray3[--n] = nArray[n] - 1;
            boolean bl2 = bl = nArray3[--n] == -1;
        }
        while (n > 0) {
            nArray3[--n] = nArray[n];
        }
        return nArray3;
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (this.signum == 0 || bigInteger.signum == 0) {
            return ZERO;
        }
        int[] nArray = this.multiplyToLen(this.mag, this.mag.length, bigInteger.mag, bigInteger.mag.length, null);
        nArray = BigInteger.trustedStripLeadingZeroInts(nArray);
        return new BigInteger(nArray, this.signum * bigInteger.signum);
    }

    private int[] multiplyToLen(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        if (nArray3 == null || nArray3.length < n + n2) {
            nArray3 = new int[n + n2];
        }
        long l = 0L;
        int n5 = n4;
        int n6 = n4 + 1 + n3;
        while (n5 >= 0) {
            long l2 = ((long)nArray2[n5] & 0xFFFFFFFFL) * ((long)nArray[n3] & 0xFFFFFFFFL) + l;
            nArray3[n6] = (int)l2;
            l = l2 >>> 32;
            --n5;
            --n6;
        }
        nArray3[n3] = (int)l;
        int n7 = n3 - 1;
        while (n7 >= 0) {
            l = 0L;
            int n8 = n4;
            int n9 = n4 + 1 + n7;
            while (n8 >= 0) {
                long l3 = ((long)nArray2[n8] & 0xFFFFFFFFL) * ((long)nArray[n7] & 0xFFFFFFFFL) + ((long)nArray3[n9] & 0xFFFFFFFFL) + l;
                nArray3[n9] = (int)l3;
                l = l3 >>> 32;
                --n8;
                --n9;
            }
            nArray3[n7] = (int)l;
            --n7;
        }
        return nArray3;
    }

    private BigInteger square() {
        if (this.signum == 0) {
            return ZERO;
        }
        int[] nArray = BigInteger.squareToLen(this.mag, this.mag.length, null);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(nArray), 1);
    }

    private static final int[] squareToLen(int[] nArray, int n, int[] nArray2) {
        int n2 = n << 1;
        if (nArray2 == null || nArray2.length < n2) {
            nArray2 = new int[n2];
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            long l = (long)nArray[n4] & 0xFFFFFFFFL;
            long l2 = l * l;
            nArray2[n5++] = n3 << 31 | (int)(l2 >>> 33);
            nArray2[n5++] = (int)(l2 >>> 1);
            n3 = (int)l2;
            ++n4;
        }
        int n6 = n;
        int n7 = 1;
        while (n6 > 0) {
            int n8 = nArray[n6 - 1];
            n8 = BigInteger.mulAdd(nArray2, nArray, n7, n6 - 1, n8);
            BigInteger.addOne(nArray2, n7 - 1, n6, n8);
            --n6;
            n7 += 2;
        }
        BigInteger.primitiveLeftShift(nArray2, n2, 1);
        int n9 = n2 - 1;
        nArray2[n9] = nArray2[n9] | nArray[n - 1] & 1;
        return nArray2;
    }

    public BigInteger divide(BigInteger bigInteger) {
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this.mag);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(bigInteger.mag);
        mutableBigInteger3.divide(mutableBigInteger4, mutableBigInteger, mutableBigInteger2);
        return new BigInteger(mutableBigInteger, this.signum * bigInteger.signum);
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this.mag);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(bigInteger.mag);
        mutableBigInteger3.divide(mutableBigInteger4, mutableBigInteger, mutableBigInteger2);
        bigIntegerArray[0] = new BigInteger(mutableBigInteger, this.signum * bigInteger.signum);
        bigIntegerArray[1] = new BigInteger(mutableBigInteger2, this.signum);
        return bigIntegerArray;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this.mag);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(bigInteger.mag);
        mutableBigInteger3.divide(mutableBigInteger4, mutableBigInteger, mutableBigInteger2);
        return new BigInteger(mutableBigInteger2, this.signum);
    }

    public BigInteger pow(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.signum == 0) {
            return n == 0 ? ONE : this;
        }
        int n2 = this.signum < 0 && (n & 1) == 1 ? -1 : 1;
        int[] nArray = this.mag;
        int[] nArray2 = new int[]{1};
        while (n != 0) {
            if ((n & 1) == 1) {
                nArray2 = this.multiplyToLen(nArray2, nArray2.length, nArray, nArray.length, null);
            }
            if ((n >>>= 1) == 0) continue;
            nArray = BigInteger.squareToLen(nArray, nArray.length, null);
        }
        nArray2 = BigInteger.trustedStripLeadingZeroInts(nArray2);
        return new BigInteger(nArray2, n2);
    }

    public BigInteger gcd(BigInteger bigInteger) {
        if (bigInteger.signum == 0) {
            return this.abs();
        }
        if (this.signum == 0) {
            return bigInteger.abs();
        }
        MutableBigInteger mutableBigInteger = new MutableBigInteger(this);
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(bigInteger);
        MutableBigInteger mutableBigInteger3 = mutableBigInteger.hybridGCD(mutableBigInteger2);
        return new BigInteger(mutableBigInteger3, 1);
    }

    private static int[] leftShift(int[] nArray, int n, int n2) {
        int n3 = n2 >>> 5;
        int n4 = n2 & 0x1F;
        int n5 = BigInteger.bitLen(nArray[0]);
        if (n2 <= 32 - n5) {
            BigInteger.primitiveLeftShift(nArray, n, n4);
            return nArray;
        }
        if (n4 <= 32 - n5) {
            int[] nArray2 = new int[n3 + n];
            int n6 = 0;
            while (n6 < n) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            BigInteger.primitiveLeftShift(nArray2, nArray2.length, n4);
            return nArray2;
        }
        int[] nArray3 = new int[n3 + n + 1];
        int n7 = 0;
        while (n7 < n) {
            nArray3[n7] = nArray[n7];
            ++n7;
        }
        BigInteger.primitiveRightShift(nArray3, nArray3.length, 32 - n4);
        return nArray3;
    }

    static void primitiveRightShift(int[] nArray, int n, int n2) {
        int n3 = 32 - n2;
        int n4 = n - 1;
        int n5 = nArray[n4];
        while (n4 > 0) {
            int n6 = n5;
            n5 = nArray[n4 - 1];
            nArray[n4] = n5 << n3 | n6 >>> n2;
            --n4;
        }
        nArray[0] = nArray[0] >>> n2;
    }

    static void primitiveLeftShift(int[] nArray, int n, int n2) {
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = 32 - n2;
        int n4 = 0;
        int n5 = nArray[n4];
        int n6 = n4 + n - 1;
        while (n4 < n6) {
            int n7 = n5;
            n5 = nArray[n4 + 1];
            nArray[n4] = n7 << n2 | n5 >>> n3;
            ++n4;
        }
        int n8 = n - 1;
        nArray[n8] = nArray[n8] << n2;
    }

    private static int bitLength(int[] nArray, int n) {
        if (n == 0) {
            return 0;
        }
        return (n - 1 << 5) + BigInteger.bitLen(nArray[0]);
    }

    public BigInteger abs() {
        return this.signum >= 0 ? this : this.negate();
    }

    public BigInteger negate() {
        return new BigInteger(this.mag, -this.signum);
    }

    public int signum() {
        return this.signum;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (bigInteger.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        return bigInteger2.signum >= 0 ? bigInteger2 : bigInteger2.add(bigInteger);
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        if (bigInteger2.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (bigInteger.signum == 0) {
            return bigInteger2.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ONE)) {
            return bigInteger2.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ZERO) && bigInteger.signum >= 0) {
            return ZERO;
        }
        if (this.equals(negConst[1]) && !bigInteger.testBit(0)) {
            return bigInteger2.equals(ONE) ? ZERO : ONE;
        }
        boolean bl = bigInteger.signum < 0;
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        BigInteger bigInteger5 = bigInteger4 = this.signum < 0 || this.compareTo(bigInteger2) >= 0 ? this.mod(bigInteger2) : this;
        if (bigInteger2.testBit(0)) {
            bigInteger3 = bigInteger4.oddModPow(bigInteger, bigInteger2);
        } else {
            int n = bigInteger2.getLowestSetBit();
            BigInteger bigInteger6 = bigInteger2.shiftRight(n);
            BigInteger bigInteger7 = ONE.shiftLeft(n);
            BigInteger bigInteger8 = this.signum < 0 || this.compareTo(bigInteger6) >= 0 ? this.mod(bigInteger6) : this;
            BigInteger bigInteger9 = bigInteger6.equals(ONE) ? ZERO : bigInteger8.oddModPow(bigInteger, bigInteger6);
            BigInteger bigInteger10 = bigInteger4.modPow2(bigInteger, n);
            BigInteger bigInteger11 = bigInteger7.modInverse(bigInteger6);
            BigInteger bigInteger12 = bigInteger6.modInverse(bigInteger7);
            bigInteger3 = bigInteger9.multiply(bigInteger7).multiply(bigInteger11).add(bigInteger10.multiply(bigInteger6).multiply(bigInteger12)).mod(bigInteger2);
        }
        return bl ? bigInteger3.modInverse(bigInteger2) : bigInteger3;
    }

    private BigInteger oddModPow(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int[] nArray;
        if (bigInteger.equals(ONE)) {
            return this;
        }
        if (this.signum == 0) {
            return ZERO;
        }
        int[] nArray2 = (int[])this.mag.clone();
        int[] nArray3 = bigInteger.mag;
        int[] nArray4 = bigInteger2.mag;
        int n2 = nArray4.length;
        int n3 = 0;
        int n4 = BigInteger.bitLength(nArray3, nArray3.length);
        while (n4 > bnExpModThreshTable[n3]) {
            ++n3;
        }
        int n5 = 1 << n3;
        int[][] nArrayArray = new int[n5][];
        int n6 = 0;
        while (n6 < n5) {
            nArrayArray[n6] = new int[n2];
            ++n6;
        }
        int n7 = -MutableBigInteger.inverseMod32(nArray4[n2 - 1]);
        int[] nArray5 = BigInteger.leftShift(nArray2, nArray2.length, n2 << 5);
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(nArray5);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(nArray4);
        mutableBigInteger3.divide(mutableBigInteger4, mutableBigInteger, mutableBigInteger2);
        nArrayArray[0] = mutableBigInteger2.toIntArray();
        if (nArrayArray[0].length < n2) {
            int n8 = n2 - nArrayArray[0].length;
            nArray = new int[n2];
            n = 0;
            while (n < nArrayArray[0].length) {
                nArray[n + n8] = nArrayArray[0][n];
                ++n;
            }
            nArrayArray[0] = nArray;
        }
        int[] nArray6 = BigInteger.squareToLen(nArrayArray[0], n2, null);
        nArray6 = BigInteger.montReduce(nArray6, nArray4, n2, n7);
        nArray = new int[n2];
        n = 0;
        while (n < n2) {
            nArray[n] = nArray6[n];
            ++n;
        }
        int n9 = 1;
        while (n9 < n5) {
            int[] nArray7 = this.multiplyToLen(nArray, n2, nArrayArray[n9 - 1], n2, null);
            nArrayArray[n9] = BigInteger.montReduce(nArray7, nArray4, n2, n7);
            ++n9;
        }
        int n10 = 1 << (n4 - 1 & 0x1F);
        int n11 = 0;
        int n12 = nArray3.length;
        int n13 = 0;
        int n14 = 0;
        while (n14 <= n3) {
            n11 = n11 << 1 | ((nArray3[n13] & n10) != 0 ? 1 : 0);
            if ((n10 >>>= 1) == 0) {
                ++n13;
                n10 = Integer.MIN_VALUE;
                --n12;
            }
            ++n14;
        }
        int n15 = n4--;
        boolean bl = true;
        n15 = n4 - n3;
        while ((n11 & 1) == 0) {
            n11 >>>= 1;
            ++n15;
        }
        int[] nArray8 = nArrayArray[n11 >>> 1];
        n11 = 0;
        if (n15 == n4) {
            bl = false;
        }
        while (true) {
            --n4;
            n11 <<= 1;
            if (n12 != 0) {
                n11 |= (nArray3[n13] & n10) != 0 ? 1 : 0;
                if ((n10 >>>= 1) == 0) {
                    ++n13;
                    n10 = Integer.MIN_VALUE;
                    --n12;
                }
            }
            if ((n11 & n5) != 0) {
                n15 = n4 - n3;
                while ((n11 & 1) == 0) {
                    n11 >>>= 1;
                    ++n15;
                }
                nArray8 = nArrayArray[n11 >>> 1];
                n11 = 0;
            }
            if (n4 == n15) {
                if (bl) {
                    nArray6 = (int[])nArray8.clone();
                    bl = false;
                } else {
                    nArray = nArray6;
                    nArray5 = this.multiplyToLen(nArray, n2, nArray8, n2, nArray5);
                    nArray5 = BigInteger.montReduce(nArray5, nArray4, n2, n7);
                    nArray = nArray5;
                    nArray5 = nArray6;
                    nArray6 = nArray;
                }
            }
            if (n4 == 0) break;
            if (bl) continue;
            nArray = nArray6;
            nArray5 = BigInteger.squareToLen(nArray, n2, nArray5);
            nArray5 = BigInteger.montReduce(nArray5, nArray4, n2, n7);
            nArray = nArray5;
            nArray5 = nArray6;
            nArray6 = nArray;
        }
        int[] nArray9 = new int[2 * n2];
        int n16 = 0;
        while (n16 < n2) {
            nArray9[n16 + n2] = nArray6[n16];
            ++n16;
        }
        nArray6 = BigInteger.montReduce(nArray9, nArray4, n2, n7);
        nArray9 = new int[n2];
        int n17 = 0;
        while (n17 < n2) {
            nArray9[n17] = nArray6[n17];
            ++n17;
        }
        return new BigInteger(1, nArray9);
    }

    private static int[] montReduce(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        do {
            int n6 = nArray[nArray.length - 1 - n5];
            int n7 = BigInteger.mulAdd(nArray, nArray2, n5, n, n2 * n6);
            n3 += BigInteger.addOne(nArray, n5, n, n7);
            ++n5;
        } while (--n4 > 0);
        while (n3 > 0) {
            n3 += BigInteger.subN(nArray, nArray2, n);
        }
        while (BigInteger.intArrayCmpToLen(nArray, nArray2, n) >= 0) {
            BigInteger.subN(nArray, nArray2, n);
        }
        return nArray;
    }

    private static int intArrayCmpToLen(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            long l = (long)nArray[n2] & 0xFFFFFFFFL;
            long l2 = (long)nArray2[n2] & 0xFFFFFFFFL;
            if (l < l2) {
                return -1;
            }
            if (l > l2) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }

    private static int subN(int[] nArray, int[] nArray2, int n) {
        long l = 0L;
        while (--n >= 0) {
            l = ((long)nArray[n] & 0xFFFFFFFFL) - ((long)nArray2[n] & 0xFFFFFFFFL) + (l >> 32);
            nArray[n] = (int)l;
        }
        return (int)(l >> 32);
    }

    static int mulAdd(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        long l = (long)n3 & 0xFFFFFFFFL;
        long l2 = 0L;
        n = nArray.length - n - 1;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            long l3 = ((long)nArray2[n4] & 0xFFFFFFFFL) * l + ((long)nArray[n] & 0xFFFFFFFFL) + l2;
            nArray[n--] = (int)l3;
            l2 = l3 >>> 32;
            --n4;
        }
        return (int)l2;
    }

    /*
     * Unable to fully structure code
     */
    static int addOne(int[] var0, int var1_1, int var2_2, int var3_3) {
        var1_1 = var0.length - 1 - var2_2 - var1_1;
        var4_4 = ((long)var0[var1_1] & 0xFFFFFFFFL) + ((long)var3_3 & 0xFFFFFFFFL);
        var0[var1_1] = (int)var4_4;
        if (var4_4 >>> 32 != 0L) ** GOTO lbl12
        return 0;
lbl-1000:
        // 1 sources

        {
            if (--var1_1 < 0) {
                return 1;
            }
            v0 = var1_1;
            var0[v0] = var0[v0] + 1;
            if (var0[var1_1] == 0) continue;
            return 0;
lbl12:
            // 2 sources

            ** while (--var2_2 >= 0)
        }
lbl13:
        // 1 sources

        return 1;
    }

    private BigInteger modPow2(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        BigInteger bigInteger3 = this.mod2(n);
        int n2 = 0;
        int n3 = bigInteger.bitLength();
        if (this.testBit(0)) {
            n3 = n - 1 < n3 ? n - 1 : n3;
        }
        while (n2 < n3) {
            if (bigInteger.testBit(n2)) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod2(n);
            }
            if (++n2 >= n3) continue;
            bigInteger3 = bigInteger3.square().mod2(n);
        }
        return bigInteger2;
    }

    private BigInteger mod2(int n) {
        if (this.bitLength() <= n) {
            return this;
        }
        int n2 = (n + 31) / 32;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.mag[n3 + (this.mag.length - n2)];
            ++n3;
        }
        int n4 = (n2 << 5) - n;
        nArray[0] = (int)((long)nArray[0] & (1L << 32 - n4) - 1L);
        return nArray[0] == 0 ? new BigInteger(1, nArray) : new BigInteger(nArray, 1);
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        if (bigInteger.signum != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (bigInteger.equals(ONE)) {
            return ZERO;
        }
        BigInteger bigInteger2 = this;
        if (this.signum < 0 || BigInteger.intArrayCmp(this.mag, bigInteger.mag) >= 0) {
            bigInteger2 = this.mod(bigInteger);
        }
        if (bigInteger2.equals(ONE)) {
            return ONE;
        }
        MutableBigInteger mutableBigInteger = new MutableBigInteger(bigInteger2);
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(bigInteger);
        MutableBigInteger mutableBigInteger3 = mutableBigInteger.mutableModInverse(mutableBigInteger2);
        return new BigInteger(mutableBigInteger3, 1);
    }

    public BigInteger shiftLeft(int n) {
        if (this.signum == 0) {
            return ZERO;
        }
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftRight(-n);
        }
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = this.mag.length;
        int[] nArray = null;
        if (n3 == 0) {
            nArray = new int[n4 + n2];
            int n5 = 0;
            while (n5 < n4) {
                nArray[n5] = this.mag[n5];
                ++n5;
            }
        } else {
            int n6 = 0;
            int n7 = 32 - n3;
            int n8 = this.mag[0] >>> n7;
            if (n8 != 0) {
                nArray = new int[n4 + n2 + 1];
                nArray[n6++] = n8;
            } else {
                nArray = new int[n4 + n2];
            }
            int n9 = 0;
            while (n9 < n4 - 1) {
                nArray[n6++] = this.mag[n9++] << n3 | this.mag[n9] >>> n7;
            }
            nArray[n6] = this.mag[n9] << n3;
        }
        return new BigInteger(nArray, this.signum);
    }

    public BigInteger shiftRight(int n) {
        int n2;
        int n3;
        int n4;
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        int n5 = n >>> 5;
        int n6 = n & 0x1F;
        int n7 = this.mag.length;
        int[] nArray = null;
        if (n5 >= n7) {
            return this.signum >= 0 ? ZERO : negConst[1];
        }
        if (n6 == 0) {
            n4 = n7 - n5;
            nArray = new int[n4];
            n3 = 0;
            while (n3 < n4) {
                nArray[n3] = this.mag[n3];
                ++n3;
            }
        } else {
            n4 = 0;
            n3 = this.mag[0] >>> n6;
            if (n3 != 0) {
                nArray = new int[n7 - n5];
                nArray[n4++] = n3;
            } else {
                nArray = new int[n7 - n5 - 1];
            }
            n2 = 32 - n6;
            int n8 = 0;
            while (n8 < n7 - n5 - 1) {
                nArray[n4++] = this.mag[n8++] << n2 | this.mag[n8] >>> n6;
            }
        }
        if (this.signum < 0) {
            n4 = 0;
            n3 = n7 - 1;
            n2 = n7 - n5;
            while (n3 >= n2 && n4 == 0) {
                n4 = this.mag[n3] != 0 ? 1 : 0;
                --n3;
            }
            if (n4 == 0 && n6 != 0) {
                int n9 = n4 = this.mag[n7 - n5 - 1] << 32 - n6 != 0 ? 1 : 0;
            }
            if (n4 != 0) {
                nArray = this.javaIncrement(nArray);
            }
        }
        return new BigInteger(nArray, this.signum);
    }

    int[] javaIncrement(int[] nArray) {
        boolean bl = false;
        int n = 0;
        int n2 = nArray.length - 1;
        while (n2 >= 0 && n == 0) {
            int n3 = n2--;
            int n4 = nArray[n3] + 1;
            nArray[n3] = n4;
            n = n4;
        }
        if (n == 0) {
            nArray = new int[nArray.length + 1];
            nArray[0] = 1;
        }
        return nArray;
    }

    public BigInteger and(BigInteger bigInteger) {
        int[] nArray = new int[Math.max(this.intLength(), bigInteger.intLength())];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getInt(nArray.length - n - 1) & bigInteger.getInt(nArray.length - n - 1);
            ++n;
        }
        return BigInteger.valueOf(nArray);
    }

    public BigInteger or(BigInteger bigInteger) {
        int[] nArray = new int[Math.max(this.intLength(), bigInteger.intLength())];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getInt(nArray.length - n - 1) | bigInteger.getInt(nArray.length - n - 1);
            ++n;
        }
        return BigInteger.valueOf(nArray);
    }

    public BigInteger xor(BigInteger bigInteger) {
        int[] nArray = new int[Math.max(this.intLength(), bigInteger.intLength())];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getInt(nArray.length - n - 1) ^ bigInteger.getInt(nArray.length - n - 1);
            ++n;
        }
        return BigInteger.valueOf(nArray);
    }

    public BigInteger not() {
        int[] nArray = new int[this.intLength()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = ~this.getInt(nArray.length - n - 1);
            ++n;
        }
        return BigInteger.valueOf(nArray);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        int[] nArray = new int[Math.max(this.intLength(), bigInteger.intLength())];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getInt(nArray.length - n - 1) & ~bigInteger.getInt(nArray.length - n - 1);
            ++n;
        }
        return BigInteger.valueOf(nArray);
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return (this.getInt(n / 32) & 1 << n % 32) != 0;
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 32;
        int[] nArray = new int[Math.max(this.intLength(), n2 + 2)];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[nArray.length - n3 - 1] = this.getInt(n3);
            ++n3;
        }
        int n4 = nArray.length - n2 - 1;
        nArray[n4] = nArray[n4] | 1 << n % 32;
        return BigInteger.valueOf(nArray);
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 32;
        int[] nArray = new int[Math.max(this.intLength(), (n + 1) / 32 + 1)];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[nArray.length - n3 - 1] = this.getInt(n3);
            ++n3;
        }
        int n4 = nArray.length - n2 - 1;
        nArray[n4] = nArray[n4] & ~(1 << n % 32);
        return BigInteger.valueOf(nArray);
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 32;
        int[] nArray = new int[Math.max(this.intLength(), n2 + 2)];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[nArray.length - n3 - 1] = this.getInt(n3);
            ++n3;
        }
        int n4 = nArray.length - n2 - 1;
        nArray[n4] = nArray[n4] ^ 1 << n % 32;
        return BigInteger.valueOf(nArray);
    }

    public int getLowestSetBit() {
        if (this.lowestSetBit == -2) {
            if (this.signum == 0) {
                this.lowestSetBit = -1;
            } else {
                int n;
                int n2 = 0;
                while ((n = this.getInt(n2)) == 0) {
                    ++n2;
                }
                this.lowestSetBit = (n2 << 5) + BigInteger.trailingZeroCnt(n);
            }
        }
        return this.lowestSetBit;
    }

    public int bitLength() {
        if (this.bitLength == -1) {
            if (this.signum == 0) {
                this.bitLength = 0;
            } else {
                int n = (this.mag.length - 1 << 5) + BigInteger.bitLen(this.mag[0]);
                if (this.signum < 0) {
                    boolean bl = BigInteger.bitCnt(this.mag[0]) == 1;
                    int n2 = 1;
                    while (n2 < this.mag.length && bl) {
                        bl = this.mag[n2] == 0;
                        ++n2;
                    }
                    this.bitLength = bl ? n - 1 : n;
                } else {
                    this.bitLength = n;
                }
            }
        }
        return this.bitLength;
    }

    static int bitLen(int n) {
        return n < 32768 ? (n < 128 ? (n < 8 ? (n < 2 ? (n < 1 ? (n < 0 ? 32 : 0) : 1) : (n < 4 ? 2 : 3)) : (n < 32 ? (n < 16 ? 4 : 5) : (n < 64 ? 6 : 7))) : (n < 2048 ? (n < 512 ? (n < 256 ? 8 : 9) : (n < 1024 ? 10 : 11)) : (n < 8192 ? (n < 4096 ? 12 : 13) : (n < 16384 ? 14 : 15)))) : (n < 0x800000 ? (n < 524288 ? (n < 131072 ? (n < 65536 ? 16 : 17) : (n < 262144 ? 18 : 19)) : (n < 0x200000 ? (n < 0x100000 ? 20 : 21) : (n < 0x400000 ? 22 : 23))) : (n < 0x8000000 ? (n < 0x2000000 ? (n < 0x1000000 ? 24 : 25) : (n < 0x4000000 ? 26 : 27)) : (n < 0x20000000 ? (n < 0x10000000 ? 28 : 29) : (n < 0x40000000 ? 30 : 31))));
    }

    public int bitCount() {
        if (this.bitCount == -1) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.mag.length) {
                n += BigInteger.bitCnt(this.mag[n2]);
                ++n2;
            }
            if (this.signum < 0) {
                int n3 = 0;
                int n4 = this.mag.length - 1;
                while (this.mag[n4] == 0) {
                    n3 += 32;
                    --n4;
                }
                this.bitCount = n + (n3 += BigInteger.trailingZeroCnt(this.mag[n4])) - 1;
            } else {
                this.bitCount = n;
            }
        }
        return this.bitCount;
    }

    static int bitCnt(int n) {
        n -= (0xAAAAAAAA & n) >>> 1;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0xFF;
    }

    static int trailingZeroCnt(int n) {
        int n2 = n & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2];
        }
        n2 = n >>> 8 & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 8;
        }
        n2 = n >>> 16 & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 16;
        }
        n2 = n >>> 24 & 0xFF;
        return trailingZeroTable[n2] + 24;
    }

    public boolean isProbablePrime(int n) {
        int n2 = (n + 1) / 2;
        if (n2 <= 0) {
            return true;
        }
        BigInteger bigInteger = this.abs();
        if (bigInteger.equals(TWO)) {
            return true;
        }
        if (!bigInteger.testBit(0) || bigInteger.equals(ONE)) {
            return false;
        }
        BigInteger bigInteger2 = bigInteger.subtract(ONE);
        int n3 = bigInteger2.getLowestSetBit();
        bigInteger2 = bigInteger2.shiftRight(n3);
        Random random = new Random();
        int n4 = 0;
        while (n4 < n2) {
            BigInteger bigInteger3;
            while ((bigInteger3 = new BigInteger(bigInteger.bitLength(), random)).compareTo(ONE) <= 0 || bigInteger3.compareTo(bigInteger) >= 0) {
            }
            int n5 = 0;
            BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
            while (!(n5 == 0 && bigInteger4.equals(ONE) || bigInteger4.equals(bigInteger.subtract(ONE)))) {
                if (n5 > 0 && bigInteger4.equals(ONE) || ++n5 == n3) {
                    return false;
                }
                bigInteger4 = bigInteger4.modPow(TWO, bigInteger);
            }
            ++n4;
        }
        return true;
    }

    public int compareTo(BigInteger bigInteger) {
        return this.signum == bigInteger.signum ? this.signum * BigInteger.intArrayCmp(this.mag, bigInteger.mag) : (this.signum > bigInteger.signum ? 1 : -1);
    }

    public int compareTo(Object object) {
        return this.compareTo((BigInteger)object);
    }

    private static int intArrayCmp(int[] nArray, int[] nArray2) {
        if (nArray.length < nArray2.length) {
            return -1;
        }
        if (nArray.length > nArray2.length) {
            return 1;
        }
        int n = 0;
        while (n < nArray.length) {
            long l = (long)nArray[n] & 0xFFFFFFFFL;
            long l2 = (long)nArray2[n] & 0xFFFFFFFFL;
            if (l < l2) {
                return -1;
            }
            if (l > l2) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigInteger)) {
            return false;
        }
        BigInteger bigInteger = (BigInteger)object;
        if (bigInteger.signum != this.signum || bigInteger.mag.length != this.mag.length) {
            return false;
        }
        int n = 0;
        while (n < this.mag.length) {
            if (bigInteger.mag[n] != this.mag[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public BigInteger min(BigInteger bigInteger) {
        return this.compareTo(bigInteger) < 0 ? this : bigInteger;
    }

    public BigInteger max(BigInteger bigInteger) {
        return this.compareTo(bigInteger) > 0 ? this : bigInteger;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.mag.length) {
            n = (int)((long)(31 * n) + ((long)this.mag[n2] & 0xFFFFFFFFL));
            ++n2;
        }
        return n * this.signum;
    }

    public String toString(int n) {
        Serializable serializable;
        if (this.signum == 0) {
            return "0";
        }
        if (n < 2 || n > 36) {
            n = 10;
        }
        int n2 = (4 * this.mag.length + 6) / 7;
        String[] stringArray = new String[n2];
        BigInteger bigInteger = this.abs();
        int n3 = 0;
        while (bigInteger.signum != 0) {
            serializable = longRadix[n];
            MutableBigInteger mutableBigInteger = new MutableBigInteger();
            MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
            MutableBigInteger mutableBigInteger3 = new MutableBigInteger(bigInteger.mag);
            MutableBigInteger mutableBigInteger4 = new MutableBigInteger(((BigInteger)serializable).mag);
            mutableBigInteger3.divide(mutableBigInteger4, mutableBigInteger, mutableBigInteger2);
            BigInteger bigInteger2 = new BigInteger(mutableBigInteger, bigInteger.signum * ((BigInteger)serializable).signum);
            BigInteger bigInteger3 = new BigInteger(mutableBigInteger2, bigInteger.signum * ((BigInteger)serializable).signum);
            stringArray[n3++] = Long.toString(bigInteger3.longValue(), n);
            bigInteger = bigInteger2;
        }
        serializable = new StringBuffer(n3 * digitsPerLong[n] + 1);
        if (this.signum < 0) {
            ((StringBuffer)serializable).append('-');
        }
        ((StringBuffer)serializable).append(stringArray[n3 - 1]);
        int n4 = n3 - 2;
        while (n4 >= 0) {
            int n5 = digitsPerLong[n] - stringArray[n4].length();
            if (n5 != 0) {
                ((StringBuffer)serializable).append(zeros[n5]);
            }
            ((StringBuffer)serializable).append(stringArray[n4]);
            --n4;
        }
        return ((StringBuffer)serializable).toString();
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        int n = this.bitLength() / 8 + 1;
        byte[] byArray = new byte[n];
        int n2 = n - 1;
        int n3 = 4;
        int n4 = 0;
        int n5 = 0;
        while (n2 >= 0) {
            if (n3 == 4) {
                n4 = this.getInt(n5++);
                n3 = 1;
            } else {
                n4 >>>= 8;
                ++n3;
            }
            byArray[n2] = (byte)n4;
            --n2;
        }
        return byArray;
    }

    public int intValue() {
        int n = 0;
        n = this.getInt(0);
        return n;
    }

    public long longValue() {
        long l = 0L;
        int n = 1;
        while (n >= 0) {
            l = (l << 32) + ((long)this.getInt(n) & 0xFFFFFFFFL);
            --n;
        }
        return l;
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    private static int[] stripLeadingZeroInts(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < nArray.length && nArray[n2] == 0) {
            ++n2;
        }
        int[] nArray2 = new int[nArray.length - n2];
        int n3 = 0;
        while (n3 < nArray.length - n2) {
            nArray2[n3] = nArray[n2 + n3];
            ++n3;
        }
        return nArray2;
    }

    private static int[] trustedStripLeadingZeroInts(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < nArray.length && nArray[n2] == 0) {
            ++n2;
        }
        if (n2 > 0) {
            int[] nArray2 = new int[nArray.length - n2];
            int n3 = 0;
            while (n3 < nArray.length - n2) {
                nArray2[n3] = nArray[n2 + n3];
                ++n3;
            }
            return nArray2;
        }
        return nArray;
    }

    private static int[] stripLeadingZeroBytes(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < byArray.length && byArray[n2] == 0) {
            ++n2;
        }
        int n3 = (n - n2 + 3) / 4;
        int[] nArray = new int[n3];
        int n4 = n - 1;
        int n5 = n3 - 1;
        while (n5 >= 0) {
            nArray[n5] = byArray[n4--] & 0xFF;
            int n6 = n4 - n2 + 1;
            int n7 = Math.min(3, n6);
            int n8 = 8;
            while (n8 <= 8 * n7) {
                int n9 = n5;
                nArray[n9] = nArray[n9] | (byArray[n4--] & 0xFF) << n8;
                n8 += 8;
            }
            --n5;
        }
        return nArray;
    }

    private static int[] makePositive(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2 && byArray[n3] == -1) {
            ++n3;
        }
        int n4 = n3;
        while (n4 < n2 && byArray[n4] == 0) {
            ++n4;
        }
        int n5 = n4 == n2 ? 1 : 0;
        int n6 = (n2 - n3 + n5 + 3) / 4;
        int[] nArray = new int[n6];
        int n7 = n2 - 1;
        int n8 = n6 - 1;
        while (n8 >= 0) {
            nArray[n8] = byArray[n7--] & 0xFF;
            n = Math.min(3, n7 - n3 + 1);
            if (n < 0) {
                n = 0;
            }
            int n9 = 8;
            while (n9 <= 8 * n) {
                int n10 = n8;
                nArray[n10] = nArray[n10] | (byArray[n7--] & 0xFF) << n9;
                n9 += 8;
            }
            int n11 = -1 >>> 8 * (3 - n);
            nArray[n8] = ~nArray[n8] & n11;
            --n8;
        }
        n = nArray.length - 1;
        while (n >= 0) {
            nArray[n] = (int)(((long)nArray[n] & 0xFFFFFFFFL) + 1L);
            if (nArray[n] != 0) break;
            --n;
        }
        return nArray;
    }

    private static int[] makePositive(int[] nArray) {
        int n;
        int n2 = 0;
        while (n2 < nArray.length && nArray[n2] == -1) {
            ++n2;
        }
        int n3 = n2;
        while (n3 < nArray.length && nArray[n3] == 0) {
            ++n3;
        }
        int n4 = n3 == nArray.length ? 1 : 0;
        int[] nArray2 = new int[nArray.length - n2 + n4];
        int n5 = n2;
        while (n5 < nArray.length) {
            nArray2[n5 - n2 + n4] = ~nArray[n5];
            ++n5;
        }
        int n6 = nArray2.length - 1;
        do {
            n = n6--;
        } while ((nArray2[n] = nArray2[n] + 1) == 0);
        return nArray2;
    }

    private int intLength() {
        return this.bitLength() / 32 + 1;
    }

    private int signBit() {
        return this.signum < 0 ? 1 : 0;
    }

    private int signInt() {
        return this.signum < 0 ? -1 : 0;
    }

    private int getInt(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.mag.length) {
            return this.signInt();
        }
        int n2 = this.mag[this.mag.length - n - 1];
        return this.signum >= 0 ? n2 : (n <= this.firstNonzeroIntNum() ? -n2 : ~n2);
    }

    private int firstNonzeroIntNum() {
        if (this.firstNonzeroIntNum == -2) {
            int n = this.mag.length - 1;
            while (n >= 0 && this.mag[n] == 0) {
                --n;
            }
            this.firstNonzeroIntNum = this.mag.length - n - 1;
        }
        return this.firstNonzeroIntNum;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.signum < -1 || this.signum > 1) {
            throw new StreamCorruptedException("BigInteger: Invalid signum value");
        }
        if (this.magnitude.length == 0 != (this.signum == 0)) {
            throw new StreamCorruptedException("BigInteger: signum-magnitude mismatch");
        }
        this.bitLength = -1;
        this.bitCount = -1;
        this.firstNonzeroByteNum = -2;
        this.lowestSetBit = -2;
        this.mag = BigInteger.stripLeadingZeroBytes(this.magnitude);
        this.magnitude = null;
    }

    private synchronized Object writeReplace() {
        if (this.magnitude == null) {
            this.magnitude = this.magSerializedForm();
        }
        return this;
    }

    private byte[] magSerializedForm() {
        int n = this.mag.length == 0 ? 0 : (this.mag.length - 1 << 5) + BigInteger.bitLen(this.mag[0]);
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = n2 - 1;
        int n4 = 4;
        int n5 = this.mag.length - 1;
        int n6 = 0;
        while (n3 >= 0) {
            if (n4 == 4) {
                n6 = this.mag[n5--];
                n4 = 1;
            } else {
                n6 >>>= 8;
                ++n4;
            }
            byArray[n3] = (byte)n6;
            --n3;
        }
        return byArray;
    }

    static {
        int n = 1;
        while (n <= 16) {
            int[] nArray = new int[]{n};
            BigInteger.posConst[n] = new BigInteger(nArray, 1);
            BigInteger.negConst[n] = new BigInteger(nArray, -1);
            ++n;
        }
        ZERO = new BigInteger(new int[0], 0);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        bnExpModThreshTable = new int[]{7, 25, 81, 241, 673, 1793, Integer.MAX_VALUE};
        trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
        zeros = new String[64];
        BigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        n = 0;
        while (n < 63) {
            BigInteger.zeros[n] = zeros[63].substring(0, n);
            ++n;
        }
        digitsPerLong = new int[]{0, 0, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
        longRadix = new BigInteger[]{null, null, BigInteger.valueOf(0x4000000000000000L), BigInteger.valueOf(4052555153018976267L), BigInteger.valueOf(0x4000000000000000L), BigInteger.valueOf(7450580596923828125L), BigInteger.valueOf(4738381338321616896L), BigInteger.valueOf(3909821048582988049L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(1350851717672992089L), BigInteger.valueOf(1000000000000000000L), BigInteger.valueOf(5559917313492231481L), BigInteger.valueOf(2218611106740436992L), BigInteger.valueOf(8650415919381337933L), BigInteger.valueOf(2177953337809371136L), BigInteger.valueOf(6568408355712890625L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(2862423051509815793L), BigInteger.valueOf(6746640616477458432L), BigInteger.valueOf(799006685782884121L), BigInteger.valueOf(1638400000000000000L), BigInteger.valueOf(3243919932521508681L), BigInteger.valueOf(6221821273427820544L), BigInteger.valueOf(504036361936467383L), BigInteger.valueOf(876488338465357824L), BigInteger.valueOf(1490116119384765625L), BigInteger.valueOf(2481152873203736576L), BigInteger.valueOf(4052555153018976267L), BigInteger.valueOf(6502111422497947648L), BigInteger.valueOf(353814783205469041L), BigInteger.valueOf(531441000000000000L), BigInteger.valueOf(787662783788549761L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(1667889514952984961L), BigInteger.valueOf(2386420683693101056L), BigInteger.valueOf(3379220508056640625L), BigInteger.valueOf(4738381338321616896L)};
    }
}

