/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.geom.Rectangle2D;

public final class GlyphMetrics {
    private float advance;
    private Rectangle2D.Float bounds;
    private byte glyphType;
    public static final byte STANDARD = 0;
    public static final byte LIGATURE = 1;
    public static final byte COMBINING = 2;
    public static final byte COMPONENT = 3;
    public static final byte WHITESPACE = 4;

    public GlyphMetrics(float f, Rectangle2D rectangle2D, byte by) {
        this.advance = f;
        this.bounds = new Rectangle2D.Float();
        this.bounds.setRect(rectangle2D);
        this.glyphType = by;
    }

    public float getAdvance() {
        return this.advance;
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public float getLSB() {
        return this.bounds.x;
    }

    public float getRSB() {
        return this.advance - this.bounds.x - this.bounds.width;
    }

    public int getType() {
        return this.glyphType;
    }

    public boolean isStandard() {
        return (this.glyphType & 3) == 0;
    }

    public boolean isLigature() {
        return (this.glyphType & 3) == 1;
    }

    public boolean isCombining() {
        return (this.glyphType & 3) == 2;
    }

    public boolean isComponent() {
        return (this.glyphType & 3) == 3;
    }

    public boolean isWhitespace() {
        return (this.glyphType & 4) == 4;
    }
}

