/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunFileWriter;
import com.sun.media.sound.WaveFileFormat;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WaveFileWriter
extends SunFileWriter {
    static final int RIFF_MAGIC = 1380533830;
    static final int WAVE_MAGIC = 1463899717;
    static final int FMT_MAGIC = 1718449184;
    static final int DATA_MAGIC = 1684108385;
    static final int WAVE_FORMAT_UNKNOWN = 0;
    static final int WAVE_FORMAT_PCM = 1;
    static final int WAVE_FORMAT_ADPCM = 2;
    static final int WAVE_FORMAT_ALAW = 6;
    static final int WAVE_FORMAT_MULAW = 7;
    static final int WAVE_FORMAT_OKI_ADPCM = 16;
    static final int WAVE_FORMAT_DIGISTD = 21;
    static final int WAVE_FORMAT_DIGIFIX = 22;
    static final int WAVE_IBM_FORMAT_MULAW = 257;
    static final int WAVE_IBM_FORMAT_ALAW = 258;
    static final int WAVE_IBM_FORMAT_ADPCM = 259;
    static final int WAVE_FORMAT_DVI_ADPCM = 17;
    static final int WAVE_FORMAT_SX7383 = 7175;
    static final int WAVE_HEADERSIZE = 44;
    static final int WAVE_DATASIZE_OFFSET = 40;
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFileFormat.Type[] typeArray = new AudioFileFormat.Type[types.length];
        System.arraycopy(types, 0, typeArray, 0, types.length);
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (encoding == AudioFormat.Encoding.ALAW || encoding == AudioFormat.Encoding.ULAW || encoding == AudioFormat.Encoding.PCM_SIGNED || encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            return typeArray;
        }
        return new AudioFileFormat.Type[0];
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        if (audioInputStream.getFrameLength() == -1L) {
            throw new IOException("stream length not specified");
        }
        WaveFileFormat waveFileFormat = (WaveFileFormat)this.getAudioFileFormat(type, audioInputStream);
        int n = this.writeWaveFile(audioInputStream, waveFileFormat, outputStream);
        return n;
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        WaveFileFormat waveFileFormat = (WaveFileFormat)this.getAudioFileFormat(type, audioInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 4096);
        int n = this.writeWaveFile(audioInputStream, waveFileFormat, bufferedOutputStream);
        bufferedOutputStream.close();
        if (waveFileFormat.getByteLength() == -1) {
            // empty if block
        }
        return n;
    }

    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        int n;
        AudioFormat audioFormat = null;
        WaveFileFormat waveFileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat2.getEncoding();
        if (type != types[0]) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (encoding2 == AudioFormat.Encoding.ALAW || encoding2 == AudioFormat.Encoding.ULAW) {
            encoding = encoding2;
            n = audioFormat2.getSampleSizeInBits();
        } else if (audioFormat2.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            n = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n = audioFormat2.getSampleSizeInBits();
        }
        audioFormat = new AudioFormat(encoding, audioFormat2.getSampleRate(), n, audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), false);
        int n2 = audioInputStream.getFrameLength() != -1L ? (int)audioInputStream.getFrameLength() * audioFormat2.getFrameSize() + 44 : -1;
        waveFileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, n2, audioFormat, (int)audioInputStream.getFrameLength());
        return waveFileFormat;
    }

    private int writeWaveFile(InputStream inputStream, WaveFileFormat waveFileFormat, OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        InputStream inputStream2 = this.getFileStream(waveFileFormat, inputStream);
        byte[] byArray = new byte[4096];
        int n3 = waveFileFormat.getByteLength();
        while ((n = inputStream2.read(byArray)) >= 0) {
            if (n3 > 0) {
                if (n < n3) {
                    outputStream.write(byArray, 0, n);
                    n2 += n;
                    n3 -= n;
                    continue;
                }
                outputStream.write(byArray, 0, n3);
                n2 += n3;
                n3 = 0;
                break;
            }
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        return n2;
    }

    private InputStream getFileStream(WaveFileFormat waveFileFormat, InputStream inputStream) throws IOException {
        AudioFormat audioFormat = waveFileFormat.getFormat();
        int n = 44;
        int n2 = 1380533830;
        int n3 = 1463899717;
        int n4 = 1718449184;
        int n5 = 16;
        short s = (short)waveFileFormat.getWaveType();
        short s2 = (short)audioFormat.getChannels();
        short s3 = (short)audioFormat.getSampleSizeInBits();
        int n6 = (int)audioFormat.getSampleRate();
        int n7 = audioFormat.getFrameSize();
        int n8 = (int)audioFormat.getFrameRate();
        int n9 = s2 * s3 * n6 / 8;
        short s4 = (short)(s3 / 8 * s2);
        int n10 = 1684108385;
        int n11 = waveFileFormat.getFrameLength() * n7;
        int n12 = waveFileFormat.getByteLength();
        int n13 = n11 + n - 8;
        byte[] byArray = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        SequenceInputStream sequenceInputStream = null;
        AudioFormat audioFormat2 = null;
        AudioFormat.Encoding encoding = null;
        InputStream inputStream2 = inputStream;
        if (inputStream instanceof AudioInputStream) {
            audioFormat2 = ((AudioInputStream)inputStream).getFormat();
            encoding = audioFormat2.getEncoding();
            if (encoding == AudioFormat.Encoding.PCM_SIGNED && s3 == 8) {
                s = 1;
                inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), false), (AudioInputStream)inputStream);
            }
            if ((encoding == AudioFormat.Encoding.PCM_SIGNED && audioFormat2.isBigEndian() || encoding == AudioFormat.Encoding.PCM_UNSIGNED && !audioFormat2.isBigEndian() || encoding == AudioFormat.Encoding.PCM_UNSIGNED && audioFormat2.isBigEndian()) && s3 != 8) {
                s = 1;
                inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), false), (AudioInputStream)inputStream);
            }
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(this.big2little(n13));
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeInt(this.big2little(n5));
        dataOutputStream.writeShort(this.big2littleShort(s));
        dataOutputStream.writeShort(this.big2littleShort(s2));
        dataOutputStream.writeInt(this.big2little(n6));
        dataOutputStream.writeInt(this.big2little(n9));
        dataOutputStream.writeShort(this.big2littleShort(s4));
        dataOutputStream.writeShort(this.big2littleShort(s3));
        dataOutputStream.writeInt(n10);
        dataOutputStream.writeInt(this.big2little(n11));
        dataOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream2);
        return sequenceInputStream;
    }
}

