/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AuFileFormat;
import com.sun.media.sound.SunFileWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AuFileWriter
extends SunFileWriter {
    static final int AU_HEADERSIZE = 24;
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.AU};

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFileFormat.Type[] typeArray = new AudioFileFormat.Type[types.length];
        System.arraycopy(types, 0, typeArray, 0, types.length);
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (encoding == AudioFormat.Encoding.ALAW || encoding == AudioFormat.Encoding.ULAW || encoding == AudioFormat.Encoding.PCM_SIGNED || encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            return typeArray;
        }
        return new AudioFileFormat.Type[0];
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        if (audioInputStream.getFrameLength() == -1L) {
            throw new IOException("stream length not specified");
        }
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(type, audioInputStream);
        int n = this.writeAuFile(audioInputStream, auFileFormat, outputStream);
        return n;
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(type, audioInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 4096);
        int n = this.writeAuFile(audioInputStream, auFileFormat, bufferedOutputStream);
        bufferedOutputStream.close();
        if (auFileFormat.getByteLength() == -1) {
            // empty if block
        }
        return n;
    }

    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        int n;
        AudioFormat audioFormat = null;
        AuFileFormat auFileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat2.getEncoding();
        if (type != types[0]) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (encoding2 == AudioFormat.Encoding.ALAW || encoding2 == AudioFormat.Encoding.ULAW) {
            encoding = encoding2;
            n = audioFormat2.getSampleSizeInBits();
        } else if (audioFormat2.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n = audioFormat2.getSampleSizeInBits();
        }
        audioFormat = new AudioFormat(encoding, audioFormat2.getSampleRate(), n, audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), true);
        int n2 = audioInputStream.getFrameLength() != -1L ? (int)audioInputStream.getFrameLength() * audioFormat2.getFrameSize() + 24 : -1;
        auFileFormat = new AuFileFormat(AudioFileFormat.Type.AU, n2, audioFormat, (int)audioInputStream.getFrameLength());
        return auFileFormat;
    }

    private InputStream getFileStream(AuFileFormat auFileFormat, InputStream inputStream) throws IOException {
        AudioFormat audioFormat = auFileFormat.getFormat();
        int n = 779316836;
        int n2 = 24;
        int n3 = auFileFormat.getFrameLength();
        int n4 = n3 * audioFormat.getFrameSize();
        int n5 = auFileFormat.getAuType();
        int n6 = (int)audioFormat.getSampleRate();
        int n7 = audioFormat.getChannels();
        boolean bl = true;
        byte[] byArray = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        SequenceInputStream sequenceInputStream = null;
        AudioFormat audioFormat2 = null;
        AudioFormat.Encoding encoding = null;
        InputStream inputStream2 = inputStream;
        inputStream2 = inputStream;
        if (inputStream instanceof AudioInputStream && ((encoding = (audioFormat2 = ((AudioInputStream)inputStream).getFormat()).getEncoding()) == AudioFormat.Encoding.PCM_UNSIGNED || bl != audioFormat2.isBigEndian())) {
            inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), bl), (AudioInputStream)inputStream);
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (bl) {
            dataOutputStream.writeInt(779316836);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n5);
            dataOutputStream.writeInt(n6);
            dataOutputStream.writeInt(n7);
        } else {
            dataOutputStream.writeInt(1684960046);
            dataOutputStream.writeInt(this.big2little(n2));
            dataOutputStream.writeInt(this.big2little(n4));
            dataOutputStream.writeInt(this.big2little(n5));
            dataOutputStream.writeInt(this.big2little(n6));
            dataOutputStream.writeInt(this.big2little(n7));
        }
        dataOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream2);
        return sequenceInputStream;
    }

    private int writeAuFile(InputStream inputStream, AuFileFormat auFileFormat, OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        InputStream inputStream2 = this.getFileStream(auFileFormat, inputStream);
        byte[] byArray = new byte[4096];
        int n3 = auFileFormat.getByteLength();
        while ((n = inputStream2.read(byArray)) >= 0) {
            if (n3 > 0) {
                if (n < n3) {
                    outputStream.write(byArray, 0, n);
                    n2 += n;
                    n3 -= n;
                    continue;
                }
                outputStream.write(byArray, 0, n3);
                n2 += n3;
                n3 = 0;
                break;
            }
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        return n2;
    }
}

