/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.SourceTextItem;
import org.mozilla.javascript.SourceTextManager;

public class DebugReader
extends BufferedReader {
    private BufferedReader reader;
    private SourceTextManager stm;
    private SourceTextItem sti;

    public DebugReader(Reader reader, SourceTextManager sourceTextManager, String string) {
        super(null);
        this.reader = new BufferedReader(reader);
        this.stm = sourceTextManager;
        this.sti = sourceTextManager.newItem(string);
    }

    public void close() throws IOException {
        this.reader.close();
        if (this.sti != null) {
            this.sti.complete();
            this.sti = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.sti != null) {
            this.sti.complete();
            this.sti = null;
        }
        this.reader = null;
    }

    public void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public int read() throws IOException {
        int n = this.reader.read();
        if (this.sti != null) {
            if (n == -1) {
                this.sti.complete();
                this.sti = null;
            } else {
                this.sti.append((char)n);
            }
        }
        return n;
    }

    public int read(char[] cArray) throws IOException {
        int n = this.reader.read(cArray);
        if (this.sti != null) {
            if (n == -1) {
                this.sti.complete();
                this.sti = null;
            } else if (n != 0) {
                this.sti.append(cArray, 0, n);
            }
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.reader.read(cArray, n, n2);
        if (this.sti != null) {
            if (n3 == -1) {
                this.sti.complete();
                this.sti = null;
            } else if (n3 != 0) {
                this.sti.append(cArray, n, n3);
            }
        }
        return n3;
    }

    public String readLine() throws IOException {
        String string = this.reader.readLine();
        if (this.sti != null) {
            if (string == null) {
                this.sti.complete();
                this.sti = null;
            } else {
                this.sti.append(String.valueOf(string) + "\n");
            }
        }
        return string;
    }

    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public long skip(long l) throws IOException {
        return this.reader.skip(l);
    }
}

