/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.classfile.Utf8StringIndexPair;
import org.mozilla.javascript.WrappedException;

class ConstantPool {
    private static final int ConstantPoolSize = 256;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private Hashtable itsUtf8Hash = new Hashtable();
    private Hashtable itsFieldRefHash = new Hashtable();
    private Hashtable itsMethodRefHash = new Hashtable();
    private Hashtable itsClassHash = new Hashtable();
    private int itsTop = 0;
    private int itsTopIndex = 1;
    private byte[] itsPool = new byte[256];

    ConstantPool() {
    }

    short addClass(String string) {
        short s = this.addUtf8(ClassFileWriter.fullyQualifiedForm(string));
        return this.addClass(s);
    }

    short addClass(short s) {
        Short s2 = new Short(s);
        Short s3 = (Short)this.itsClassHash.get(s2);
        if (s3 == null) {
            this.ensure(3);
            this.itsPool[this.itsTop++] = 7;
            this.itsPool[this.itsTop++] = (byte)(s >> 8);
            this.itsPool[this.itsTop++] = (byte)s;
            s3 = new Short((short)this.itsTopIndex++);
            this.itsClassHash.put(s2, s3);
        }
        return s3;
    }

    short addConstant(double d) {
        this.ensure(9);
        this.itsPool[this.itsTop++] = 6;
        long l = Double.doubleToLongBits(d);
        this.itsPool[this.itsTop++] = (byte)(l >> 56);
        this.itsPool[this.itsTop++] = (byte)(l >> 48);
        this.itsPool[this.itsTop++] = (byte)(l >> 40);
        this.itsPool[this.itsTop++] = (byte)(l >> 32);
        this.itsPool[this.itsTop++] = (byte)(l >> 24);
        this.itsPool[this.itsTop++] = (byte)(l >> 16);
        this.itsPool[this.itsTop++] = (byte)(l >> 8);
        this.itsPool[this.itsTop++] = (byte)l;
        short s = (short)this.itsTopIndex;
        this.itsTopIndex += 2;
        return s;
    }

    short addConstant(float f) {
        this.ensure(5);
        this.itsPool[this.itsTop++] = 4;
        int n = Float.floatToIntBits(f);
        this.itsPool[this.itsTop++] = (byte)(n >> 24);
        this.itsPool[this.itsTop++] = (byte)(n >> 16);
        this.itsPool[this.itsTop++] = (byte)(n >> 8);
        this.itsPool[this.itsTop++] = (byte)n;
        return (short)this.itsTopIndex++;
    }

    short addConstant(int n) {
        this.ensure(5);
        this.itsPool[this.itsTop++] = 3;
        this.itsPool[this.itsTop++] = (byte)(n >> 24);
        this.itsPool[this.itsTop++] = (byte)(n >> 16);
        this.itsPool[this.itsTop++] = (byte)(n >> 8);
        this.itsPool[this.itsTop++] = (byte)n;
        return (short)this.itsTopIndex++;
    }

    short addConstant(long l) {
        this.ensure(9);
        this.itsPool[this.itsTop++] = 5;
        this.itsPool[this.itsTop++] = (byte)(l >> 56);
        this.itsPool[this.itsTop++] = (byte)(l >> 48);
        this.itsPool[this.itsTop++] = (byte)(l >> 40);
        this.itsPool[this.itsTop++] = (byte)(l >> 32);
        this.itsPool[this.itsTop++] = (byte)(l >> 24);
        this.itsPool[this.itsTop++] = (byte)(l >> 16);
        this.itsPool[this.itsTop++] = (byte)(l >> 8);
        this.itsPool[this.itsTop++] = (byte)l;
        short s = (short)this.itsTopIndex;
        this.itsTopIndex += 2;
        return s;
    }

    short addConstant(String string) {
        Utf8StringIndexPair utf8StringIndexPair = (Utf8StringIndexPair)this.itsUtf8Hash.get(string);
        if (utf8StringIndexPair == null) {
            this.addUtf8(string);
            utf8StringIndexPair = (Utf8StringIndexPair)this.itsUtf8Hash.get(string);
        }
        if (utf8StringIndexPair.itsStringIndex == -1) {
            utf8StringIndexPair.itsStringIndex = (short)this.itsTopIndex++;
            this.ensure(3);
            this.itsPool[this.itsTop++] = 8;
            this.itsPool[this.itsTop++] = (byte)(utf8StringIndexPair.itsUtf8Index >> 8);
            this.itsPool[this.itsTop++] = (byte)utf8StringIndexPair.itsUtf8Index;
        }
        return utf8StringIndexPair.itsStringIndex;
    }

    short addFieldRef(String string, String string2, String string3) {
        String string4 = String.valueOf(string) + " " + string2 + " " + string3;
        Short s = (Short)this.itsFieldRefHash.get(string4);
        if (s == null) {
            short s2 = this.addUtf8(string2);
            short s3 = this.addUtf8(string3);
            short s4 = this.addNameAndType(s2, s3);
            short s5 = this.addClass(string);
            this.ensure(5);
            this.itsPool[this.itsTop++] = 9;
            this.itsPool[this.itsTop++] = (byte)(s5 >> 8);
            this.itsPool[this.itsTop++] = (byte)s5;
            this.itsPool[this.itsTop++] = (byte)(s4 >> 8);
            this.itsPool[this.itsTop++] = (byte)s4;
            s = new Short((short)this.itsTopIndex++);
            this.itsFieldRefHash.put(string4, s);
        }
        return s;
    }

    short addInterfaceMethodRef(String string, String string2, String string3) {
        short s = this.addUtf8(string2);
        short s2 = this.addUtf8(string3);
        short s3 = this.addNameAndType(s, s2);
        short s4 = this.addClass(string);
        this.ensure(5);
        this.itsPool[this.itsTop++] = 11;
        this.itsPool[this.itsTop++] = (byte)(s4 >> 8);
        this.itsPool[this.itsTop++] = (byte)s4;
        this.itsPool[this.itsTop++] = (byte)(s3 >> 8);
        this.itsPool[this.itsTop++] = (byte)s3;
        return (short)this.itsTopIndex++;
    }

    short addMethodRef(String string, String string2, String string3) {
        String string4 = String.valueOf(string) + " " + string2 + " " + string3;
        Short s = (Short)this.itsMethodRefHash.get(string4);
        if (s == null) {
            short s2 = this.addUtf8(string2);
            short s3 = this.addUtf8(string3);
            short s4 = this.addNameAndType(s2, s3);
            short s5 = this.addClass(string);
            this.ensure(5);
            this.itsPool[this.itsTop++] = 10;
            this.itsPool[this.itsTop++] = (byte)(s5 >> 8);
            this.itsPool[this.itsTop++] = (byte)s5;
            this.itsPool[this.itsTop++] = (byte)(s4 >> 8);
            this.itsPool[this.itsTop++] = (byte)s4;
            s = new Short((short)this.itsTopIndex++);
            this.itsMethodRefHash.put(string4, s);
        }
        return s;
    }

    short addNameAndType(short s, short s2) {
        this.ensure(5);
        this.itsPool[this.itsTop++] = 12;
        this.itsPool[this.itsTop++] = (byte)(s >> 8);
        this.itsPool[this.itsTop++] = (byte)s;
        this.itsPool[this.itsTop++] = (byte)(s2 >> 8);
        this.itsPool[this.itsTop++] = (byte)s2;
        return (short)this.itsTopIndex++;
    }

    short addUtf8(String string) {
        Utf8StringIndexPair utf8StringIndexPair = (Utf8StringIndexPair)this.itsUtf8Hash.get(string);
        if (utf8StringIndexPair == null) {
            utf8StringIndexPair = new Utf8StringIndexPair((short)this.itsTopIndex++, -1);
            this.itsUtf8Hash.put(string, utf8StringIndexPair);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeUTF(string);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.ensure(1 + byArray.length);
                this.itsPool[this.itsTop++] = 1;
                System.arraycopy(byArray, 0, this.itsPool, this.itsTop, byArray.length);
                this.itsTop += byArray.length;
            }
            catch (IOException iOException) {
                throw WrappedException.wrapException(iOException);
            }
        }
        return utf8StringIndexPair.itsUtf8Index;
    }

    void ensure(int n) {
        while (this.itsTop + n >= this.itsPool.length) {
            byte[] byArray = this.itsPool;
            this.itsPool = new byte[this.itsPool.length * 2];
            System.arraycopy(byArray, 0, this.itsPool, 0, this.itsTop);
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort((short)this.itsTopIndex);
        dataOutputStream.write(this.itsPool, 0, this.itsTop);
    }
}

