/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.classfile.ByteCode;
import org.mozilla.classfile.ClassFileField;
import org.mozilla.classfile.ClassFileMethod;
import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.ExceptionTableEntry;
import org.mozilla.javascript.LabelTable;
import org.mozilla.javascript.LocalVariable;
import org.mozilla.javascript.VariableTable;

public class ClassFileWriter
extends LabelTable {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    private static final int LineNumberTableSize = 16;
    private static final int ExceptionTableSize = 4;
    private static final long FileHeaderConstant = -3819410108756852691L;
    private static final boolean DEBUG = false;
    private static final boolean DEBUGSTACK = false;
    private static final boolean DEBUGLABELS = false;
    private static final boolean DEBUGCODE = false;
    private static final int CodeBufferSize = 128;
    private ExceptionTableEntry[] itsExceptionTable;
    private int itsExceptionTableTop;
    private int[] itsLineNumberTable;
    private int itsLineNumberTableTop;
    private byte[] itsCodeBuffer;
    private int itsCodeBufferTop;
    private ConstantPool itsConstantPool;
    private short itsSourceFileAttributeIndex;
    private ClassFileMethod itsCurrentMethod;
    private short itsStackTop;
    private short itsMaxStack;
    private short itsMaxLocals;
    private Vector itsMethods = new Vector();
    private Vector itsFields = new Vector();
    private Vector itsInterfaces = new Vector();
    private short itsFlags;
    private short itsThisClassIndex;
    private short itsSuperClassIndex;
    private short itsSourceFileNameIndex;

    public ClassFileWriter(String string, String string2, String string3) {
        this.itsConstantPool = new ConstantPool();
        this.itsThisClassIndex = this.itsConstantPool.addClass(string);
        this.itsSuperClassIndex = this.itsConstantPool.addClass(string2);
        if (string3 != null) {
            this.itsSourceFileNameIndex = this.itsConstantPool.addUtf8(string3);
        }
        this.itsFlags = 1;
    }

    public void add(byte by) {
        this.addToCodeBuffer(by);
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[by & 0xFF]);
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte by, int n) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[by & 0xFF]);
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        switch (by) {
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -58: 
            case -57: {
                int n2 = this.itsCodeBufferTop;
                this.addToCodeBuffer(by);
                if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                    int n3 = this.acquireLabel();
                    int n4 = n3 & Integer.MAX_VALUE;
                    this.itsLabelTable[n4].setPC((short)(n2 + n));
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                int n5 = n & Integer.MAX_VALUE;
                short s = this.itsLabelTable[n5].getPC();
                if (s != -1) {
                    short s2 = (short)(s - n2);
                    this.addToCodeBuffer((byte)(s2 >> 8));
                    this.addToCodeBuffer((byte)s2);
                    break;
                }
                this.itsLabelTable[n5].addFixup(n2 + 1);
                this.addToCodeBuffer((byte)0);
                this.addToCodeBuffer((byte)0);
                break;
            }
            case 16: {
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case 17: {
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -68: {
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -76: 
            case -75: {
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                if (n >= 256 || by == 19 || by == 20) {
                    if (by == 18) {
                        this.addToCodeBuffer((byte)19);
                    } else {
                        this.addToCodeBuffer(by);
                    }
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -87: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (n >= 256) {
                    this.addToCodeBuffer((byte)-60);
                    this.addToCodeBuffer(by);
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected opcode for 1 operand");
            }
        }
    }

    public void add(byte by, int n, int n2) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[by & 0xFF]);
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        if (by == -124) {
            if (n > 255 || n2 < -128 || n2 > 127) {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                this.addToCodeBuffer((byte)(n2 >> 8));
                this.addToCodeBuffer((byte)n2);
            } else {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)n);
                this.addToCodeBuffer((byte)n2);
            }
        } else if (by == -59) {
            this.addToCodeBuffer((byte)-59);
            this.addToCodeBuffer((byte)(n >> 8));
            this.addToCodeBuffer((byte)n);
            this.addToCodeBuffer((byte)n2);
        } else {
            throw new RuntimeException("Unexpected opcode for 2 operands");
        }
    }

    public void add(byte by, String string) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[by & 0xFF]);
        switch (by) {
            case -69: 
            case -67: 
            case -64: 
            case -63: {
                short s = this.itsConstantPool.addClass(string);
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(s >> 8));
                this.addToCodeBuffer((byte)s);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for class reference");
            }
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte by, String string, String string2, String string3) {
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[by & 0xFF]);
        char c = string3.charAt(0);
        int n = c == 'J' || c == 'D' ? 2 : 1;
        switch (by) {
            case -78: 
            case -76: {
                this.itsStackTop = (short)(this.itsStackTop + n);
                break;
            }
            case -77: 
            case -75: {
                this.itsStackTop = (short)(this.itsStackTop - n);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for field reference");
            }
        }
        short s = this.itsConstantPool.addFieldRef(string, string2, string3);
        this.addToCodeBuffer(by);
        this.addToCodeBuffer((byte)(s >> 8));
        this.addToCodeBuffer((byte)s);
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void add(byte by, String string, String string2, String string3, String string4) {
        int n = this.sizeOfParameters(string3);
        this.itsStackTop = (short)(this.itsStackTop - (n & 0xFFFF));
        this.itsStackTop = (short)(this.itsStackTop + ByteCode.stackChange[by & 0xFF]);
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
        switch (by) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                char c = string4.charAt(0);
                if (c != 'V') {
                    this.itsStackTop = c == 'J' || c == 'D' ? (short)(this.itsStackTop + 2) : (short)(this.itsStackTop + 1);
                }
                this.addToCodeBuffer(by);
                if (by == -71) {
                    short s = this.itsConstantPool.addInterfaceMethodRef(string, string2, String.valueOf(string3) + string4);
                    this.addToCodeBuffer((byte)(s >> 8));
                    this.addToCodeBuffer((byte)s);
                    this.addToCodeBuffer((byte)((n >> 16) + 1));
                    this.addToCodeBuffer((byte)0);
                    break;
                }
                short s = this.itsConstantPool.addMethodRef(string, string2, String.valueOf(string3) + string4);
                this.addToCodeBuffer((byte)(s >> 8));
                this.addToCodeBuffer((byte)s);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for method reference");
            }
        }
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public void addExceptionHandler(int n, int n2, int n3, String string) {
        if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad startLabel");
        }
        if ((n2 & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad endLabel");
        }
        if ((n3 & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad handlerLabel");
        }
        ExceptionTableEntry exceptionTableEntry = new ExceptionTableEntry(n, n2, n3, string == null ? (short)0 : this.itsConstantPool.addClass(string));
        if (this.itsExceptionTable == null) {
            this.itsExceptionTable = new ExceptionTableEntry[4];
            this.itsExceptionTable[0] = exceptionTableEntry;
            this.itsExceptionTableTop = 1;
        } else {
            if (this.itsExceptionTableTop == this.itsExceptionTable.length) {
                ExceptionTableEntry[] exceptionTableEntryArray = this.itsExceptionTable;
                this.itsExceptionTable = new ExceptionTableEntry[this.itsExceptionTableTop * 2];
                System.arraycopy(exceptionTableEntryArray, 0, this.itsExceptionTable, 0, this.itsExceptionTableTop);
            }
            this.itsExceptionTable[this.itsExceptionTableTop++] = exceptionTableEntry;
        }
    }

    public void addField(String string, String string2, short s) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        this.itsFields.addElement(new ClassFileField(s2, s3, s));
    }

    public void addField(String string, String string2, short s, double d) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        short[] sArray = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(d)};
        this.itsFields.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void addField(String string, String string2, short s, int n) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        short[] sArray = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(n)};
        this.itsFields.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void addField(String string, String string2, short s, long l) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        short[] sArray = new short[]{this.itsConstantPool.addUtf8("ConstantValue"), 0, 2, this.itsConstantPool.addConstant(l)};
        this.itsFields.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void addInterface(String string) {
        short s = this.itsConstantPool.addClass(string);
        this.itsInterfaces.addElement(new Short(s));
    }

    public void addLineNumberEntry(short s) {
        if (this.itsLineNumberTable == null) {
            this.itsLineNumberTable = new int[16];
            this.itsLineNumberTable[0] = (this.itsCodeBufferTop << 16) + s;
            this.itsLineNumberTableTop = 1;
        } else {
            if (this.itsLineNumberTableTop == this.itsLineNumberTable.length) {
                int[] nArray = this.itsLineNumberTable;
                this.itsLineNumberTable = new int[this.itsLineNumberTableTop * 2];
                System.arraycopy(nArray, 0, this.itsLineNumberTable, 0, this.itsLineNumberTableTop);
            }
            this.itsLineNumberTable[this.itsLineNumberTableTop++] = (this.itsCodeBufferTop << 16) + s;
        }
    }

    public void addLoadConstant(double d) {
        this.add((byte)20, this.itsConstantPool.addConstant(d));
    }

    public void addLoadConstant(float f) {
        this.add((byte)18, this.itsConstantPool.addConstant(f));
    }

    public void addLoadConstant(int n) {
        this.add((byte)18, this.itsConstantPool.addConstant(n));
    }

    public void addLoadConstant(long l) {
        this.add((byte)20, this.itsConstantPool.addConstant(l));
    }

    public void addLoadConstant(String string) {
        this.add((byte)18, this.itsConstantPool.addConstant(string));
    }

    public void addToCodeBuffer(byte by) {
        if (this.itsCodeBuffer == null) {
            this.itsCodeBuffer = new byte[128];
            this.itsCodeBuffer[0] = by;
            this.itsCodeBufferTop = 1;
        } else {
            if (this.itsCodeBufferTop == this.itsCodeBuffer.length) {
                byte[] byArray = this.itsCodeBuffer;
                this.itsCodeBuffer = new byte[this.itsCodeBufferTop * 2];
                System.arraycopy(byArray, 0, this.itsCodeBuffer, 0, this.itsCodeBufferTop);
            }
            this.itsCodeBuffer[this.itsCodeBufferTop++] = by;
        }
    }

    public void adjustStackTop(int n) {
        this.itsStackTop = (short)(this.itsStackTop + n);
        if (this.itsStackTop > this.itsMaxStack) {
            this.itsMaxStack = this.itsStackTop;
        }
    }

    public static String fullyQualifiedForm(String string) {
        return string.replace('.', '/');
    }

    public int getCurrentCodeOffset() {
        return this.itsCodeBufferTop;
    }

    public short getStackTop() {
        return this.itsStackTop;
    }

    public int markHandler(int n) {
        this.itsStackTop = 1;
        return this.markLabel(n);
    }

    public int markLabel(int n) {
        return super.markLabel(n, (short)this.itsCodeBufferTop);
    }

    public int markLabel(int n, short s) {
        this.itsStackTop = s;
        return super.markLabel(n, (short)this.itsCodeBufferTop);
    }

    public void setFlags(short s) {
        this.itsFlags = s;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private int sizeOfParameters(String var1_1) {
        var2_2 = 1;
        var3_3 = 0;
        var4_4 = 0;
        block6: while (var1_1.charAt(var2_2) != ')') {
            cfr_temp_0 = '\u0000';
            do {
                switch (cfr_temp_0 == '\u0000' ? var1_1.charAt(var2_2) : cfr_temp_0) {
                    case 'D': 
                    case 'J': {
                        ++var3_3;
                    }
                    case 'B': 
                    case 'C': 
                    case 'F': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        ++var3_3;
                        ++var4_4;
                        ++var2_2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bad signature character");
                    }
                    while (true) {
                        cfr_temp_0 = '[';
                        ++var2_2;
                        break;
                    }
                    case '[': {
                        if (var1_1.charAt(var2_2) == '[') ** continue;
                        if (var1_1.charAt(var2_2) != 'L') {
                            ++var3_3;
                            ++var4_4;
                            ++var2_2;
                            break;
                        }
                    }
                    case 'L': {
                        ++var3_3;
                        ++var4_4;
                        while (var1_1.charAt(var2_2++) != ';') {
                        }
                        break;
                    }
                }
                continue block6;
            } while (true);
        }
        return var4_4 << 16 | var3_3;
    }

    public void startMethod(String string, String string2, short s) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        this.itsCurrentMethod = new ClassFileMethod(s2, s3, s);
        this.itsMethods.addElement(this.itsCurrentMethod);
    }

    public void stopMethod(short s, VariableTable variableTable) {
        int n;
        int n2;
        int n3;
        short s2;
        int n4;
        int n5 = 0;
        while (n5 < this.itsLabelTableTop) {
            this.itsLabelTable[n5].fixGotos(this.itsCodeBuffer);
            ++n5;
        }
        this.itsMaxLocals = s;
        int n6 = 0;
        if (this.itsLineNumberTable != null) {
            n6 = 8 + this.itsLineNumberTableTop * 4;
        }
        int n7 = 0;
        if (variableTable != null) {
            n7 = 8 + variableTable.size() * 10;
        }
        int n8 = 14 + this.itsCodeBufferTop + 2 + this.itsExceptionTableTop * 8 + 2 + n6 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        short s3 = this.itsConstantPool.addUtf8("Code");
        byArray[n9++] = (byte)(s3 >> 8);
        byArray[n9++] = (byte)s3;
        byArray[n9++] = (byte)((n8 -= 6) >> 24);
        byArray[n9++] = (byte)(n8 >> 16);
        byArray[n9++] = (byte)(n8 >> 8);
        byArray[n9++] = (byte)n8;
        byArray[n9++] = (byte)(this.itsMaxStack >> 8);
        byArray[n9++] = (byte)this.itsMaxStack;
        byArray[n9++] = (byte)(this.itsMaxLocals >> 8);
        byArray[n9++] = (byte)this.itsMaxLocals;
        byArray[n9++] = (byte)(this.itsCodeBufferTop >> 24);
        byArray[n9++] = (byte)(this.itsCodeBufferTop >> 16);
        byArray[n9++] = (byte)(this.itsCodeBufferTop >> 8);
        byArray[n9++] = (byte)this.itsCodeBufferTop;
        System.arraycopy(this.itsCodeBuffer, 0, byArray, n9, this.itsCodeBufferTop);
        n9 += this.itsCodeBufferTop;
        if (this.itsExceptionTableTop > 0) {
            byArray[n9++] = (byte)(this.itsExceptionTableTop >> 8);
            byArray[n9++] = (byte)this.itsExceptionTableTop;
            n4 = 0;
            while (n4 < this.itsExceptionTableTop) {
                s2 = this.itsExceptionTable[n4].getStartPC(this.itsLabelTable);
                byArray[n9++] = (byte)(s2 >> 8);
                byArray[n9++] = (byte)s2;
                n3 = this.itsExceptionTable[n4].getEndPC(this.itsLabelTable);
                byArray[n9++] = (byte)(n3 >> 8);
                byArray[n9++] = (byte)n3;
                n2 = this.itsExceptionTable[n4].getHandlerPC(this.itsLabelTable);
                byArray[n9++] = (byte)(n2 >> 8);
                byArray[n9++] = (byte)n2;
                n = this.itsExceptionTable[n4].getCatchType();
                byArray[n9++] = (byte)(n >> 8);
                byArray[n9++] = (byte)n;
                ++n4;
            }
        } else {
            byArray[n9++] = 0;
            byArray[n9++] = 0;
        }
        n4 = 0;
        if (this.itsLineNumberTable != null) {
            ++n4;
        }
        if (variableTable != null) {
            ++n4;
        }
        byArray[n9++] = 0;
        byArray[n9++] = (byte)n4;
        if (this.itsLineNumberTable != null) {
            s2 = this.itsConstantPool.addUtf8("LineNumberTable");
            byArray[n9++] = (byte)(s2 >> 8);
            byArray[n9++] = (byte)s2;
            n3 = 2 + this.itsLineNumberTableTop * 4;
            byArray[n9++] = (byte)(n3 >> 24);
            byArray[n9++] = (byte)(n3 >> 16);
            byArray[n9++] = (byte)(n3 >> 8);
            byArray[n9++] = (byte)n3;
            byArray[n9++] = (byte)(this.itsLineNumberTableTop >> 8);
            byArray[n9++] = (byte)this.itsLineNumberTableTop;
            n2 = 0;
            while (n2 < this.itsLineNumberTableTop) {
                byArray[n9++] = (byte)(this.itsLineNumberTable[n2] >> 24);
                byArray[n9++] = (byte)(this.itsLineNumberTable[n2] >> 16);
                byArray[n9++] = (byte)(this.itsLineNumberTable[n2] >> 8);
                byArray[n9++] = (byte)this.itsLineNumberTable[n2];
                ++n2;
            }
        }
        if (variableTable != null) {
            s2 = this.itsConstantPool.addUtf8("LocalVariableTable");
            byArray[n9++] = (byte)(s2 >> 8);
            byArray[n9++] = (byte)s2;
            n3 = variableTable.size();
            n2 = 2 + n3 * 10;
            byArray[n9++] = (byte)(n2 >> 24);
            byArray[n9++] = (byte)(n2 >> 16);
            byArray[n9++] = (byte)(n2 >> 8);
            byArray[n9++] = (byte)n2;
            byArray[n9++] = (byte)(n3 >> 8);
            byArray[n9++] = (byte)n3;
            n = 0;
            while (n < n3) {
                LocalVariable localVariable = variableTable.get(n);
                int n10 = localVariable.getStartPC();
                byArray[n9++] = (byte)(n10 >> 8);
                byArray[n9++] = (byte)n10;
                int n11 = this.itsCodeBufferTop - n10;
                byArray[n9++] = (byte)(n11 >> 8);
                byArray[n9++] = (byte)n11;
                short s4 = this.itsConstantPool.addUtf8(localVariable.getName());
                byArray[n9++] = (byte)(s4 >> 8);
                byArray[n9++] = (byte)s4;
                short s5 = this.itsConstantPool.addUtf8(localVariable.isNumber() ? "D" : "Ljava/lang/Object;");
                byArray[n9++] = (byte)(s5 >> 8);
                byArray[n9++] = (byte)s5;
                short s6 = localVariable.getJRegister();
                byArray[n9++] = (byte)(s6 >> 8);
                byArray[n9++] = (byte)s6;
                ++n;
            }
        }
        this.itsCurrentMethod.setCodeAttribute(byArray);
        this.itsExceptionTable = null;
        this.itsExceptionTableTop = 0;
        this.itsLabelTableTop = 0;
        this.itsLineNumberTable = null;
        this.itsCodeBufferTop = 0;
        this.itsCurrentMethod = null;
        this.itsMaxStack = 0;
        this.itsStackTop = 0;
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        short s = 0;
        if (this.itsSourceFileNameIndex != 0) {
            s = this.itsConstantPool.addUtf8("SourceFile");
        }
        dataOutputStream.writeLong(-3819410108756852691L);
        this.itsConstantPool.write(dataOutputStream);
        dataOutputStream.writeShort(this.itsFlags);
        dataOutputStream.writeShort(this.itsThisClassIndex);
        dataOutputStream.writeShort(this.itsSuperClassIndex);
        dataOutputStream.writeShort(this.itsInterfaces.size());
        int n = 0;
        while (n < this.itsInterfaces.size()) {
            dataOutputStream.writeShort(((Short)this.itsInterfaces.elementAt(n)).shortValue());
            ++n;
        }
        dataOutputStream.writeShort(this.itsFields.size());
        int n2 = 0;
        while (n2 < this.itsFields.size()) {
            ((ClassFileField)this.itsFields.elementAt(n2)).write(dataOutputStream);
            ++n2;
        }
        dataOutputStream.writeShort(this.itsMethods.size());
        int n3 = 0;
        while (n3 < this.itsMethods.size()) {
            ((ClassFileMethod)this.itsMethods.elementAt(n3)).write(dataOutputStream);
            ++n3;
        }
        if (this.itsSourceFileNameIndex != 0) {
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(s);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeShort(this.itsSourceFileNameIndex);
        } else {
            dataOutputStream.writeShort(0);
        }
    }
}

