/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.plugin.panel.MessageHandler;

public class ConfigurationInfo {
    private static File theUserPropertiesFile;
    private Properties props;
    private boolean debugMode;
    private boolean javapluginEnabled;
    private boolean showConsole;
    private int jarCacheSize;
    private boolean useJIT = false;
    private String JITPath;
    private String debugPort;
    private String[][] installedJREs;
    private String[][] installedJDKs;
    private boolean useDefaultProxy;
    private boolean useSameProxy;
    private String proxySettings;
    private String javaParms;
    private String javaVersion;
    private String javaRuntime;
    private Vector activeCertsVector = new Vector();
    private Vector inactiveCertsVector = new Vector();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private MessageHandler mh = new MessageHandler("config");

    public ConfigurationInfo() {
        if (theUserPropertiesFile == null) {
            String string = File.separator;
            theUserPropertiesFile = new File(System.getProperty("user.home") + string + ".java" + string + "properties");
            new File(theUserPropertiesFile.getParent()).mkdirs();
        }
        this.reset();
    }

    public void setJavaEnabled(boolean bl) {
        this.javapluginEnabled = bl;
        this.firePropertyChange();
    }

    public boolean isJavaEnabled() {
        return this.javapluginEnabled;
    }

    public void setConsoleEnabled(boolean bl) {
        this.showConsole = bl;
        this.firePropertyChange();
    }

    public boolean isConsoleEnabled() {
        return this.showConsole;
    }

    public void setJarCacheEnabled(boolean bl) {
        this.jarCacheSize = bl ? 100 : 0;
        this.firePropertyChange();
    }

    public boolean isJarCacheEnabled() {
        return this.jarCacheSize > 0;
    }

    public boolean isJITEnabled() {
        return this.useJIT;
    }

    public void setJITEnabled(boolean bl) {
        this.useJIT = bl;
        this.firePropertyChange();
    }

    public String getJITPath() {
        return this.JITPath;
    }

    public void setJITPath(String string) {
        this.JITPath = string;
        this.firePropertyChange();
    }

    public void setDebugEnabled(boolean bl) {
        this.debugMode = bl;
        this.firePropertyChange();
    }

    public boolean isDebugEnabled() {
        return this.debugMode;
    }

    public void setDebugPort(String string) {
        this.debugPort = string;
        this.firePropertyChange();
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    public void setInstalledJREList(Vector vector) {
        this.installedJREs = new String[vector.size() / 2][2];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.installedJREs[n][0] = (String)enumeration.nextElement();
            this.installedJREs[n][1] = (String)enumeration.nextElement();
            ++n;
        }
    }

    public String[][] getInstalledJREList() {
        return this.installedJREs;
    }

    public void setInstalledJDKList(Vector vector) {
        this.installedJDKs = new String[vector.size() / 2][2];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.installedJDKs[n][0] = (String)enumeration.nextElement();
            this.installedJDKs[n][1] = (String)enumeration.nextElement();
            ++n;
        }
    }

    public String[][] getInstalledJDKList() {
        return this.installedJDKs;
    }

    public void setJavaRuntimeVersion(String string) {
        if (this.javaVersion == string) {
            return;
        }
        this.javaVersion = string;
        this.firePropertyChange();
    }

    public String getJavaRuntimeVersion() {
        return this.javaVersion;
    }

    public void setJavaRuntime(String string) {
        if (this.javaRuntime == string) {
            return;
        }
        this.javaRuntime = string;
        this.firePropertyChange();
    }

    public String getJavaRuntime() {
        return this.javaRuntime;
    }

    public boolean useDefaultProxy() {
        return this.useDefaultProxy;
    }

    public void setDefaultProxySettings(boolean bl) {
        this.useDefaultProxy = bl;
        this.firePropertyChange();
    }

    public void setUseSameProxy(boolean bl) {
        this.useSameProxy = bl;
        this.firePropertyChange();
    }

    public boolean useSameProxy() {
        return this.useSameProxy;
    }

    public void setProxySettingsString(String string) {
        this.proxySettings = string;
        this.firePropertyChange();
    }

    public String getProxySettingsString() {
        return this.proxySettings;
    }

    public void setJavaParms(String string) {
        this.javaParms = string;
        this.firePropertyChange();
    }

    public String getJavaParms() {
        return this.javaParms;
    }

    public void setActiveCertificatesSet(byte[][] byArray) {
        this.activeCertsVector.clear();
        if (byArray.length > 0) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                int n = 0;
                while (n < byArray.length) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[n]);
                    while (byteArrayInputStream.available() > 0) {
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                        this.activeCertsVector.addElement(x509Certificate);
                    }
                    byteArrayInputStream.close();
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public X509Certificate[] getActiveCertificatesSet() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.activeCertsVector.size()];
        return this.activeCertsVector.toArray(x509CertificateArray);
    }

    public void changeCertificatesToInactive(int n) {
        Object e = this.activeCertsVector.remove(n);
        this.inactiveCertsVector.addElement(e);
        this.firePropertyChange();
    }

    public void cleanInactiveCertificatesSet() {
        this.inactiveCertsVector.clear();
    }

    public byte[][] getInactiveCertificatesSet() {
        byte[][] byArrayArray = new byte[this.inactiveCertsVector.size()][];
        int n = 0;
        while (n < byArrayArray.length) {
            X509Certificate x509Certificate = (X509Certificate)this.inactiveCertsVector.get(n);
            try {
                byArrayArray[n] = x509Certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                certificateEncodingException.printStackTrace();
                byArrayArray[n] = null;
            }
            ++n;
        }
        return byArrayArray;
    }

    public void applyChanges() throws IOException {
        Object object;
        Object object2;
        ((Hashtable)this.props).put("javaplugin.console", this.showConsole ? "true" : "false");
        ((Hashtable)this.props).put("javaplugin.jar.cache.size", "" + this.jarCacheSize);
        ((Hashtable)this.props).put("javaplugin.enabled", this.javapluginEnabled ? "true" : "false");
        if (this.debugMode) {
            ((Hashtable)this.props).put("javaplugin.debug.mode", "true");
            ((Hashtable)this.props).put("javaplugin.debug.port", this.debugPort);
        } else {
            ((Hashtable)this.props).put("javaplugin.debug.mode", "false");
        }
        if (this.useDefaultProxy) {
            ((Hashtable)this.props).put("javaplugin.proxy.usebrowsersettings", "true");
        } else {
            ((Hashtable)this.props).put("javaplugin.proxy.usebrowsersettings", "false");
        }
        if (this.proxySettings != null) {
            ((Hashtable)this.props).put("javaplugin.proxy.settings", this.proxySettings);
        } else {
            ((Hashtable)this.props).remove("javaplugin.proxy.settings");
        }
        if (this.useSameProxy) {
            ((Hashtable)this.props).put("javaplugin.proxy.forallprotocols", "true");
        } else {
            ((Hashtable)this.props).put("javaplugin.proxy.forallprotocols", "false");
        }
        if (this.javaRuntime != null && this.javaRuntime.length() > 0) {
            object2 = this.javaRuntime;
            if (this.javaVersion != null && this.javaVersion.length() > 0) {
                object = null;
                if (this.javaRuntime.equalsIgnoreCase("JRE")) {
                    object = this.getInstalledJREList();
                }
                if (this.javaRuntime.equalsIgnoreCase("JDK")) {
                    object = this.getInstalledJDKList();
                }
                if (object != null) {
                    int n = 0;
                    while (n < ((String[][])object).length) {
                        if (((String)object[n][0]).equalsIgnoreCase(this.javaVersion)) {
                            object2 = object[n][1];
                        }
                        ++n;
                    }
                }
            }
            if (object2 != null) {
                ((Hashtable)this.props).put("javaplugin.jre.path", object2);
            }
        } else {
            ((Hashtable)this.props).remove("javaplugin.jre.path");
        }
        if (this.javaVersion != null && this.javaVersion.length() > 0) {
            ((Hashtable)this.props).put("javaplugin.jre.version", this.javaVersion);
        } else {
            ((Hashtable)this.props).remove("javaplugin.jre.version");
        }
        if (this.javaParms != null && this.javaParms.length() > 0) {
            ((Hashtable)this.props).put("javaplugin.jre.params", this.javaParms);
        } else {
            ((Hashtable)this.props).remove("javaplugin.jre.params");
        }
        object2 = new FileOutputStream(theUserPropertiesFile);
        object = new PrintWriter((OutputStream)object2);
        ((PrintWriter)object).println(this.mh.getMessage("property_file_header"));
        ((PrintWriter)object).flush();
        this.props.store((OutputStream)object2, "");
        ((FileOutputStream)object2).close();
    }

    public void reset() {
        Object object;
        this.firePropertyChange();
        this.props = new Properties();
        try {
            object = new FileInputStream(theUserPropertiesFile);
            this.props.load(new BufferedInputStream((InputStream)object));
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.props.getProperty("javaplugin.console");
        this.showConsole = object != null && ((String)object).equals("true");
        this.jarCacheSize = 100;
        try {
            object = this.props.getProperty("javaplugin.jar.cache.size");
            this.jarCacheSize = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.props.getProperty("javaplugin.enabled");
        this.javapluginEnabled = object == null || ((String)object).equals("true");
        object = this.props.getProperty("javaplugin.debug.mode");
        this.debugMode = object != null && ((String)object).equals("true");
        this.debugPort = this.props.getProperty("javaplugin.debug.port");
        if (this.debugPort == null) {
            this.debugPort = "2502";
        }
        this.useDefaultProxy = (object = this.props.getProperty("javaplugin.proxy.usebrowsersettings")) == null || ((String)object).equals("true");
        this.proxySettings = this.props.getProperty("javaplugin.proxy.settings");
        object = this.props.getProperty("javaplugin.proxy.forallprotocols");
        this.useSameProxy = "true".equals(object);
        this.javaRuntime = this.props.getProperty("javaplugin.jre.path");
        if (null == this.javaRuntime) {
            this.javaRuntime = "Default";
        }
        this.javaVersion = this.props.getProperty("javaplugin.jre.version");
        this.javaParms = this.props.getProperty("javaplugin.jre.params");
        this.activeCertsVector.addAll(this.inactiveCertsVector);
        this.inactiveCertsVector.clear();
    }

    protected void firePropertyChange() {
        this.pcs.firePropertyChange(null, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }
}

