/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.ExtensionInfo;
import sun.misc.ExtensionInstallationException;
import sun.misc.ExtensionInstallationProvider;
import sun.misc.Launcher;

public class ExtensionDependency {
    private static Vector providers;
    static final boolean DEBUG = false;

    public static synchronized void addExtensionInstallationProvider(ExtensionInstallationProvider extensionInstallationProvider) {
        if (providers == null) {
            providers = new Vector();
        }
        providers.add(extensionInstallationProvider);
    }

    public static synchronized void removeExtensionInstallationProvider(ExtensionInstallationProvider extensionInstallationProvider) {
        providers.remove(extensionInstallationProvider);
    }

    public static synchronized boolean checkExtensionsDependencies(JarFile jarFile) {
        if (providers == null) {
            return true;
        }
        try {
            ExtensionDependency extensionDependency = new ExtensionDependency();
            return extensionDependency.checkExtensions(jarFile);
        }
        catch (ExtensionInstallationException extensionInstallationException) {
            ExtensionDependency.debug(extensionInstallationException.getMessage());
            return false;
        }
    }

    protected boolean checkExtensions(JarFile jarFile) throws ExtensionInstallationException {
        Manifest manifest;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException iOException) {
            return false;
        }
        if (manifest == null) {
            return true;
        }
        boolean bl = true;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null) {
            String string = attributes.getValue(Attributes.Name.EXTENSION_LIST);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    ExtensionDependency.debug("The file " + jarFile.getName() + " appears to depend on " + string2);
                    String string3 = string2 + "-" + Attributes.Name.EXTENSION_NAME.toString();
                    if (attributes.getValue(string3) == null) {
                        ExtensionDependency.debug("The jar file " + jarFile.getName() + " appers to depend on " + string2 + " but does not define the " + string3 + " attribute in its manifest ");
                        continue;
                    }
                    if (this.checkExtension(string2, attributes)) continue;
                    ExtensionDependency.debug("Failed installing " + string2);
                    bl = false;
                }
            } else {
                ExtensionDependency.debug("No dependencies for " + jarFile.getName());
            }
        }
        return bl;
    }

    protected boolean checkExtension(String string, Attributes attributes) throws ExtensionInstallationException {
        ExtensionDependency.debug("Checking extension " + string);
        if (this.checkExtensionAgainstInstalled(string, attributes)) {
            return true;
        }
        ExtensionDependency.debug("Extension not currently installed ");
        ExtensionInfo extensionInfo = new ExtensionInfo(string, attributes);
        return this.installExtension(extensionInfo, null);
    }

    boolean checkExtensionAgainstInstalled(String string, Attributes attributes) throws ExtensionInstallationException {
        File[] fileArray;
        try {
            fileArray = this.getInstalledExtensions();
        }
        catch (IOException iOException) {
            this.debugException(iOException);
            return false;
        }
        int n = 0;
        while (n < fileArray.length) {
            try {
                if (this.checkExtensionAgainst(string, attributes, fileArray[n])) {
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.debugException(fileNotFoundException);
            }
            catch (IOException iOException) {
                this.debugException(iOException);
            }
            ++n;
        }
        return false;
    }

    protected boolean checkExtensionAgainst(String string, Attributes attributes, final File file) throws IOException, FileNotFoundException, ExtensionInstallationException {
        Attributes attributes2;
        Manifest manifest;
        ExtensionDependency.debug("Checking extension " + string + " against " + file.getName());
        try {
            manifest = (Manifest)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, FileNotFoundException {
                    if (!file.exists()) {
                        throw new FileNotFoundException(file.getName());
                    }
                    JarFile jarFile = new JarFile(file);
                    return jarFile.getManifest();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)privilegedActionException.getException();
            }
            throw (IOException)privilegedActionException.getException();
        }
        ExtensionInfo extensionInfo = new ExtensionInfo(string, attributes);
        ExtensionDependency.debug("Requested Extension : " + extensionInfo);
        int n = 4;
        ExtensionInfo extensionInfo2 = null;
        if (manifest != null && (attributes2 = manifest.getMainAttributes()) != null) {
            extensionInfo2 = new ExtensionInfo(null, attributes2);
            ExtensionDependency.debug("Extension Installed " + extensionInfo2);
            n = extensionInfo2.isCompatibleWith(extensionInfo);
            switch (n) {
                case 0: {
                    ExtensionDependency.debug("Extensions are compatible");
                    return true;
                }
                case 4: {
                    ExtensionDependency.debug("Extensions are incompatible");
                    return false;
                }
            }
            ExtensionDependency.debug("Extensions require an upgrade or vendor switch");
            return this.installExtension(extensionInfo, extensionInfo2);
        }
        return true;
    }

    protected boolean installExtension(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) throws ExtensionInstallationException {
        Vector vector;
        Vector vector2 = providers;
        synchronized (vector2) {
            vector = (Vector)providers.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ExtensionInstallationProvider extensionInstallationProvider = (ExtensionInstallationProvider)enumeration.nextElement();
            if (extensionInstallationProvider == null || !extensionInstallationProvider.installExtension(extensionInfo, extensionInfo2)) continue;
            System.out.println("Installation successful");
            Launcher.ExtClassLoader extClassLoader = (Launcher.ExtClassLoader)Launcher.getLauncher().getClassLoader().getParent();
            this.addNewExtensionsToClassLoader(extClassLoader);
            return true;
        }
        return false;
    }

    private static File[] getExtDirs() {
        File[] fileArray;
        String string = System.getProperty("java.ext.dirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            int n = stringTokenizer.countTokens();
            fileArray = new File[n];
            int n2 = 0;
            while (n2 < n) {
                fileArray[n2] = new File(stringTokenizer.nextToken());
                ++n2;
            }
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    private static File[] getExtFiles(File[] fileArray) throws IOException {
        Object[] objectArray;
        Vector vector = new Vector();
        int n = 0;
        while (n < fileArray.length) {
            objectArray = fileArray[n].list();
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    File file = new File(fileArray[n], (String)objectArray[n2]);
                    vector.add(file);
                    ++n2;
                }
            }
            ++n;
        }
        objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private File[] getInstalledExtensions() throws IOException {
        return (File[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ExtensionDependency.getExtFiles(ExtensionDependency.getExtDirs());
                }
                catch (IOException iOException) {
                    ExtensionDependency.debug("Cannot get list of installed extensions");
                    ExtensionDependency.this.debugException(iOException);
                    return new URL[0];
                }
            }
        });
    }

    private Boolean addNewExtensionsToClassLoader(Launcher.ExtClassLoader extClassLoader) {
        try {
            File[] fileArray = this.getInstalledExtensions();
            int n = 0;
            while (n < fileArray.length) {
                final File file = fileArray[n];
                URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return file.toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            ExtensionDependency.this.debugException(malformedURLException);
                            return null;
                        }
                    }
                });
                if (uRL != null) {
                    URL[] uRLArray = extClassLoader.getURLs();
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < uRLArray.length) {
                        ExtensionDependency.debug("URL[" + n2 + "] is " + uRLArray[n2] + " looking for " + uRL);
                        if (uRLArray[n2].toString().compareToIgnoreCase(uRL.toString()) == 0) {
                            bl = true;
                            ExtensionDependency.debug("Found !");
                        }
                        ++n2;
                    }
                    if (!bl) {
                        ExtensionDependency.debug("Not Found ! adding to the classloader " + uRL);
                        extClassLoader.addExtURL(uRL);
                    }
                }
                ++n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return Boolean.TRUE;
    }

    private static void debug(String string) {
    }

    private void debugException(Throwable throwable) {
    }
}

