// ------------------------------------------------------------------
// -- PLUGINS.C
// -- PLUGIN library for DOLIST Mailing List Server
// -- Copyright  Denis Olivier 1998-1999
// -- Denis Olivier : dolivier@povlab.org
// ------------------------------------------------------------------

#include <WINDOWS.H>
#include <SYS\STAT.H>
#include <FCNTL.H>
#include <STDLIB.H>
#include <STDIO.H>
#include <STDARG.H>
#include <DOS.H>
#include <DIRECT.H>
#include <TIME.H>
#include <IO.H>
#include <STRING.H>
#include <MALLOC.H>

#include "PLUGINS.H"

char MsgName[16];
char LogPath[256];

// ----------------------------------------------------------------------- 
// -- UNFOLDING HEADER FIELD ---------------------------------------------
// -----------------------------------------------------------------------
void unfolding_header_field(char *String,FILE *File,long StrSize) {
  char *Temp=NULL;
  fpos_t Pos;

  if (String==NULL || File==NULL) return;

  Temp=(char *) malloc(StrSize);

  while (!feof(File)) {
    fgetpos(File,&Pos);
    fgets(Temp,StrSize,File);
    if (Temp[0]==32 || Temp[0]==9) {
      if ((long) (strlen(String)+strlen(Temp)-1)>=StrSize) {
        strncat(String,Temp,StrSize-strlen(String)-1);
        break;
      } else {
        strcat(String,Temp);
      }
    } else {
      fsetpos(File,&Pos);
      break;
    }
  }
  
  free(Temp);
}



// -----------------------------------------------------------------------
// -- RETURN DATE --------------------------------------------------------
// -----------------------------------------------------------------------
void get_date(char *Chaine) {
  time_t time_of_day;
  char Date[3];
  char Day[20];
  char Month[20];
  char Year[5];
   
  time_of_day=time(NULL); strftime(Date,3,"%d",localtime(&time_of_day));
  time_of_day=time(NULL); strftime(Day,20,"%w",localtime(&time_of_day));
  time_of_day=time(NULL); strftime(Month,20,"%m",localtime(&time_of_day));
  time_of_day=time(NULL); strftime(Year,5,"%Y",localtime(&time_of_day));

  sprintf(Chaine,"%d-%02d-%02d",atoi(Year),atoi(Month),atoi(Date));
}

// ----------------------------------------------------------------------- 
// -- RETURN TIME -------------------------------------------------------- 
// ----------------------------------------------------------------------- 
void get_time(char *Time) {
  time_t time_of_day;
  
  time_of_day=time(NULL);
  strftime(Time,9,"%T",localtime(&time_of_day));
} 

// -----------------------------------------------------------------------
// -- WRITE LOG FILE WITH PARAMETER --------------------------------------
// -----------------------------------------------------------------------
void log_out(char *String,...) {
  char *Sortie;
  va_list parametre;
  FILE *LogFile;
  char Time[9];
  char Date[11];
  
  Sortie=(char *) malloc(1024);
  
  get_time(Time);
  get_date(Date);
  
  if ((LogFile=fopen(LogPath,"at"))) {
    va_start(parametre,String);
    vsprintf(Sortie,String,parametre);
    va_end(parametre);
  
    fprintf(LogFile,"%s [%s]>%s\n",Date,Time,Sortie);
  }

  free(Sortie);
  fclose(LogFile);
}

// ---------------------------------------------------------------------------------------
// -- SEARCH A TAG IN A LINE -------------------------------------------------------------
// ---------------------------------------------------------------------------------------
byte search_tag(FILE *File,char *Tag,char *Buffer) {
  char Line[1027];
  while (1) {
    fgets(Line,1024,File);
    unfolding_header_field(Line,File,1024);
    if (!strcmp(Line,"\n")) break;
    if (!strnicmp(Line,Tag,strlen(Tag))) {
      strcpy(Buffer,Line);
      return TAG_OK;
    }
    if (feof(File)) break;
  }
  return TAG_ERROR;
}

// -----------------------------------------------------------------------
// -- WRITE LOG FILE WITH PARAMETER --------------------------------------
// -----------------------------------------------------------------------
void extract_email_address(char *String) {
  byte Pos1,Pos2,Where1,Where2;
  char *Tokens="\"'<> \n";

  Where1=strcspn(String,"@");
  Pos1=strcspn(String+Where1,Tokens)-1;
  strrev(String);
  Where2=strcspn(String,"@");
  Pos2=strcspn(String+Where2,Tokens);
  strrev(String);
  strcpy(String,String+Where1-Pos2+1);
  String[Pos1+Pos2]='\0';
}

