using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Configuration;
using System.Windows.Forms;
using System.Xml;

namespace My
{
	/// <summary>
	/// Summary description for IMAPClient.
	/// </summary>
	public class IMAPClient : System.Windows.Forms.Form
	{
        private TcpClient oConn = null;
        private Stream oActiveStream = null;
        private const String sFailureTimeout = "failure timeout";
        private Boolean isChecking = false;
        private Hashtable oMsgs = new Hashtable();
        private Boolean isConnected = false;

        private System.Windows.Forms.TextBox textBox1;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.TextBox textBox2;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.TextBox textBox4;
        private System.Windows.Forms.TextBox textBox3;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.TextBox textBox5;
        private System.Windows.Forms.Button button1;
        private System.Windows.Forms.Button button2;
        private System.Windows.Forms.Button button3;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.TextBox textBox6;
        private System.Windows.Forms.Label label8;
        private System.Windows.Forms.CheckBox checkBox1;
        private System.ComponentModel.IContainer components;

        private System.Windows.Forms.Label label7;
        private System.Windows.Forms.TextBox textBox7;
        private System.Windows.Forms.Label label9;
        private System.Windows.Forms.Button button4;
        private System.Windows.Forms.Button button5;
        private System.Windows.Forms.Timer timer1;

		public IMAPClient()
		{
			InitializeComponent();
			button5_Click(null, null);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.textBox2 = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.label4 = new System.Windows.Forms.Label();
            this.textBox4 = new System.Windows.Forms.TextBox();
            this.textBox3 = new System.Windows.Forms.TextBox();
            this.label5 = new System.Windows.Forms.Label();
            this.textBox5 = new System.Windows.Forms.TextBox();
            this.button1 = new System.Windows.Forms.Button();
            this.button2 = new System.Windows.Forms.Button();
            this.button3 = new System.Windows.Forms.Button();
            this.label6 = new System.Windows.Forms.Label();
            this.textBox6 = new System.Windows.Forms.TextBox();
            this.label8 = new System.Windows.Forms.Label();
            this.checkBox1 = new System.Windows.Forms.CheckBox();
            this.label7 = new System.Windows.Forms.Label();
            this.textBox7 = new System.Windows.Forms.TextBox();
            this.label9 = new System.Windows.Forms.Label();
            this.timer1 = new System.Windows.Forms.Timer(this.components);
            this.button4 = new System.Windows.Forms.Button();
            this.button5 = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // textBox1
            // 
            this.textBox1.Location = new System.Drawing.Point(128, 8);
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(224, 20);
            this.textBox1.TabIndex = 1;
            this.textBox1.Text = "your IMAP Server IP Address or Name goes here";
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(8, 11);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(120, 23);
            this.label1.TabIndex = 0;
            this.label1.Text = "IMAP Server &Address";
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(8, 43);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(96, 23);
            this.label2.TabIndex = 2;
            this.label2.Text = "IMAP Server Po&rt";
            // 
            // textBox2
            // 
            this.textBox2.Location = new System.Drawing.Point(128, 40);
            this.textBox2.Name = "textBox2";
            this.textBox2.Size = new System.Drawing.Size(40, 20);
            this.textBox2.TabIndex = 3;
            this.textBox2.Text = "143";
            // 
            // label3
            // 
            this.label3.Location = new System.Drawing.Point(8, 106);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(56, 23);
            this.label3.TabIndex = 9;
            this.label3.Text = "&Password";
            // 
            // label4
            // 
            this.label4.Location = new System.Drawing.Point(8, 74);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(64, 23);
            this.label4.TabIndex = 7;
            this.label4.Text = "&User Name";
            // 
            // textBox4
            // 
            this.textBox4.Location = new System.Drawing.Point(128, 72);
            this.textBox4.Name = "textBox4";
            this.textBox4.Size = new System.Drawing.Size(160, 20);
            this.textBox4.TabIndex = 8;
            this.textBox4.Text = "";
            // 
            // textBox3
            // 
            this.textBox3.Location = new System.Drawing.Point(128, 104);
            this.textBox3.Name = "textBox3";
            this.textBox3.PasswordChar = '*';
            this.textBox3.Size = new System.Drawing.Size(136, 20);
            this.textBox3.TabIndex = 10;
            this.textBox3.Text = "";
            // 
            // label5
            // 
            this.label5.Location = new System.Drawing.Point(8, 138);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(80, 23);
            this.label5.TabIndex = 12;
            this.label5.Text = "&EMail Program";
            // 
            // textBox5
            // 
            this.textBox5.Location = new System.Drawing.Point(128, 136);
            this.textBox5.Name = "textBox5";
            this.textBox5.Size = new System.Drawing.Size(168, 20);
            this.textBox5.TabIndex = 13;
            this.textBox5.Text = "C:\\Program Files\\Outlook Express\\msimn.exe";
            // 
            // button1
            // 
            this.button1.Location = new System.Drawing.Point(299, 135);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(48, 22);
            this.button1.TabIndex = 14;
            this.button1.Text = "&Invoke";
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // button2
            // 
            this.button2.Location = new System.Drawing.Point(8, 200);
            this.button2.Name = "button2";
            this.button2.Size = new System.Drawing.Size(60, 23);
            this.button2.TabIndex = 18;
            this.button2.Text = "&Connect";
            this.button2.Click += new System.EventHandler(this.button2_Click);
            // 
            // button3
            // 
            this.button3.Location = new System.Drawing.Point(77, 200);
            this.button3.Name = "button3";
            this.button3.TabIndex = 19;
            this.button3.Text = "&Disconnect";
            this.button3.Click += new System.EventHandler(this.button3_Click);
            // 
            // label6
            // 
            this.label6.Location = new System.Drawing.Point(8, 169);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(72, 23);
            this.label6.TabIndex = 15;
            this.label6.Text = "C&heck every";
            // 
            // textBox6
            // 
            this.textBox6.Location = new System.Drawing.Point(128, 168);
            this.textBox6.Name = "textBox6";
            this.textBox6.Size = new System.Drawing.Size(32, 20);
            this.textBox6.TabIndex = 16;
            this.textBox6.Text = "300";
            this.textBox6.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // label8
            // 
            this.label8.Location = new System.Drawing.Point(160, 172);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(56, 13);
            this.label8.TabIndex = 17;
            this.label8.Text = "seconds";
            // 
            // checkBox1
            // 
            this.checkBox1.Location = new System.Drawing.Point(272, 104);
            this.checkBox1.Name = "checkBox1";
            this.checkBox1.Size = new System.Drawing.Size(88, 24);
            this.checkBox1.TabIndex = 11;
            this.checkBox1.Text = "Re&member?";
            // 
            // label7
            // 
            this.label7.Location = new System.Drawing.Point(176, 44);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(82, 16);
            this.label7.TabIndex = 4;
            this.label7.Text = "Server Time&out";
            // 
            // textBox7
            // 
            this.textBox7.Location = new System.Drawing.Point(264, 40);
            this.textBox7.Name = "textBox7";
            this.textBox7.Size = new System.Drawing.Size(32, 20);
            this.textBox7.TabIndex = 5;
            this.textBox7.Text = "60";
            this.textBox7.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // label9
            // 
            this.label9.Location = new System.Drawing.Point(296, 44);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(48, 16);
            this.label9.TabIndex = 6;
            this.label9.Text = "seconds";
            // 
            // timer1
            // 
            this.timer1.Enabled = true;
            this.timer1.Interval = 300000;
            this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
            // 
            // button4
            // 
            this.button4.Location = new System.Drawing.Point(161, 200);
            this.button4.Name = "button4";
            this.button4.Size = new System.Drawing.Size(85, 23);
            this.button4.TabIndex = 20;
            this.button4.Text = "&Save Settings";
            this.button4.Click += new System.EventHandler(this.button4_Click);
            // 
            // button5
            // 
            this.button5.Location = new System.Drawing.Point(255, 200);
            this.button5.Name = "button5";
            this.button5.Size = new System.Drawing.Size(92, 23);
            this.button5.TabIndex = 21;
            this.button5.Text = "&Revert Settings";
            this.button5.Click += new System.EventHandler(this.button5_Click);
            // 
            // IMAPClient
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(360, 229);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.label9,
                                                                          this.label7,
                                                                          this.textBox7,
                                                                          this.checkBox1,
                                                                          this.label6,
                                                                          this.textBox6,
                                                                          this.button2,
                                                                          this.button1,
                                                                          this.label5,
                                                                          this.textBox5,
                                                                          this.label3,
                                                                          this.textBox3,
                                                                          this.label4,
                                                                          this.textBox4,
                                                                          this.label2,
                                                                          this.textBox2,
                                                                          this.label1,
                                                                          this.textBox1,
                                                                          this.button3,
                                                                          this.label8,
                                                                          this.button4,
                                                                          this.button5});
            this.Name = "IMAPClient";
            this.Text = "IMAPClient";
            this.Load += new System.EventHandler(this.IMAPClient_Load);
            this.Closed += new System.EventHandler(this.IMAPClient_Closed);
            this.ResumeLayout(false);

        }
		#endregion

        private void IMAPClient_Closed(object sender, System.EventArgs e)
        {
            button3_Click(null, null);
            ((MyMain)(this.MdiParent)).oIMAPClient = null;
        }

        private void IMAPClient_Load(object sender, System.EventArgs e)
        {
        
        }

        private void button1_Click(object sender, System.EventArgs e)
        {
            
        }

        public void button2_Click(object sender, System.EventArgs e)
        {
            if (textBox4.Text.Equals(""))
               return;
            button2.Enabled = false;
            try {
                oConn = new System.Net.Sockets.TcpClient(textBox1.Text, Int32.Parse(textBox2.Text));
                oActiveStream = oConn.GetStream();
                if (sFailureTimeout.IndexOf(WaitFor("ready", Int32.Parse(textBox7.Text))) != -1)
                   return;
                String sCommand = "A001 LOGIN "+textBox4.Text+" "+textBox3.Text+"\n";
                for (int iByteCtr=0; iByteCtr<sCommand.Length; iByteCtr++)
                    oActiveStream.WriteByte((byte)sCommand[iByteCtr]);
                String sResult = WaitFor("A001 OK LOGIN", Int32.Parse(textBox7.Text), "A001 NO LOGIN");
                if (sFailureTimeout.IndexOf(sResult) != -1)
                   return;
                if (sResult.IndexOf("A001 NO LOGIN") != -1)
                   {
                   MessageBox.Show("Login Failed");
                   return;
                   }
                ToggleAll(false);
                isConnected = true;
                timer1_Tick(null, null);
                timer1.Interval = Int32.Parse(textBox6.Text)*1000;
                timer1.Enabled = true;
                }
            catch (Exception ex)
                  {
                  MessageBox.Show(ex.StackTrace);
                  button3_Click(null, null);
                  return;
                  }
        }

        private void ToggleAll(Boolean isTrue)
        {
            textBox1.Enabled = isTrue;
            textBox2.Enabled = isTrue;
            textBox3.Enabled = isTrue;
            textBox4.Enabled = isTrue;
        }

        private void button3_Click(object sender, System.EventArgs e)
        {
            button2.Enabled = true;
            if (oActiveStream != null)
               {
               if (sender != null)
                  {
                  String sCommand = "A007 LOGOUT\n";
                  for (int iByteCtr=0; iByteCtr<sCommand.Length; iByteCtr++)
                      oActiveStream.WriteByte((byte)sCommand[iByteCtr]);
                  }
               oActiveStream.Close();
               oActiveStream = null;
               }
            if (oConn != null)
               {
               oConn.Close();
               oConn = null;
               }
            isChecking = false;
            isConnected = false;
            ToggleAll(true);
        }

        private String WaitFor(String strToWait, long iTimeOut)
        {
            return WaitFor(strToWait, iTimeOut, null);
        }

        private String WaitFor(String strToWait, long iTimeOut, String strFailure)
        {
            StringBuilder oSB = new StringBuilder();
            long iStart = System.DateTime.Now.Ticks;
            StreamReader oReader = new StreamReader(oActiveStream);
            for (; ((System.DateTime.Now.Ticks-iStart)/10000000)<iTimeOut; )
                {
                try {
                    if (oReader.Peek() != -1)
                       oSB.Append((char)oReader.Read());
                    }
                catch (Exception ex)
                      {
                      MessageBox.Show(ex.StackTrace);
                      button3_Click(null, null);
                      return "failure";
                      }
                if (oSB.ToString().IndexOf(strToWait) != -1 ||
                    (strFailure != null && oSB.ToString().IndexOf(strFailure) != -1))
                   {
                   for (;oReader.Peek()!=-1;)
                       oSB.Append((char)oReader.Read());
                   break;
                   }
                if (oActiveStream == null)
                   break;
                //Application.DoEvents();
                }
            if ((System.DateTime.Now.Ticks-iStart)/10000000 >= iTimeOut)
               return "timeout";
            return oSB.ToString();
        }

        private void timer1_Tick(object sender, System.EventArgs e)
        {
            if (isChecking)
               return;
            if (!isConnected)
               {
               isChecking = false;
               button2_Click(null, null);
               return;
               }
            isChecking = true;
            try {
                String sCommand = "A002 SELECT INBOX\n";
                for (int iByteCtr=0; iByteCtr<sCommand.Length; iByteCtr++)
                    oActiveStream.WriteByte((byte)sCommand[iByteCtr]);
                String sResult = WaitFor("A002 OK", Int32.Parse(textBox7.Text));
                if (sFailureTimeout.IndexOf(sResult) != -1)
                   return;
                int iExists = sResult.IndexOf(" EXISTS\r");
                int iExistsStart = sResult.LastIndexOf(' ', iExists-1)+1;
                String sTotalMsgs = sResult.Substring(iExistsStart, iExists-iExistsStart);
                int iRecent = sResult.IndexOf(" RECENT\r");
                int iRecentStart = sResult.LastIndexOf(' ', iRecent-1)+1;
                String sRecent = sResult.Substring(iRecentStart, iRecent-iRecentStart);
                iRecent = Int32.Parse(sRecent);
                int iTotalMsgs = Int32.Parse(sTotalMsgs);
                for (int iRCtr=0; iRCtr<iRecent; iRCtr++)
                    {
                    sCommand = "A004 FETCH "+(iTotalMsgs-iRCtr)+" RFC822\n";
                    for (int iByteCtr=0; iByteCtr<sCommand.Length; iByteCtr++)
                        oActiveStream.WriteByte((byte)sCommand[iByteCtr]);
                    String sRFC822 = WaitFor("A004 OK", Int32.Parse(textBox7.Text));
                    if (sFailureTimeout.IndexOf(sRFC822) != -1)
                       {
                       isChecking = false;
                       return;
                       }
                    String sMsgKey = (iTotalMsgs-iRCtr).ToString();
                    MailMessage oMailMessage = new MailMessage(sMsgKey, sRFC822, oMsgs, textBox5.Text);
                    oMsgs.Add(sMsgKey, oMailMessage);
                    oMailMessage.Show();
                    }
                }
            catch (Exception ex)
                  {
                  //MessageBox.Show(ex.StackTrace);
                  button3_Click(null, null);
                  }
            isChecking = false;
        }

        private void button4_Click(object sender, System.EventArgs e)
        {
            XmlDocument oConfigDoc = new XmlDocument();
            XmlElement oConfig = oConfigDoc.CreateElement("configuration");
            oConfigDoc.AppendChild(oConfig);
            XmlNode oAppSettings = oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "appSettings", null));
            XmlElement oSetting = null;
            oSetting = (XmlElement) oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "add", null));
            oSetting.SetAttribute("key", "IMAPServerIPAddr");
            oSetting.SetAttribute("value", textBox1.Text);
            oSetting = (XmlElement) oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "add", null));
            oSetting.SetAttribute("key", "IMAPServerPort");
            oSetting.SetAttribute("value", textBox2.Text);
            oSetting = (XmlElement) oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "add", null));
            oSetting.SetAttribute("key", "userName");
            oSetting.SetAttribute("value", textBox4.Text);
            oSetting = (XmlElement) oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "add", null));
            oSetting.SetAttribute("key", "rememberPassword");
            oSetting.SetAttribute("value", checkBox1.Checked?"yes":"no");
            if (checkBox1.Checked)
               {
               oSetting = (XmlElement) oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "add", null));
               oSetting.SetAttribute("key", "password");
               oSetting.SetAttribute("value", textBox3.Text);
               }
            oSetting = (XmlElement) oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "add", null));
            oSetting.SetAttribute("key", "eMailProgram");
            oSetting.SetAttribute("value", textBox5.Text);
            oSetting = (XmlElement) oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "add", null));
            oSetting.SetAttribute("key", "mailCheckFrequency");
            oSetting.SetAttribute("value", textBox6.Text);
            oSetting = (XmlElement) oConfig.AppendChild(oConfigDoc.CreateNode(XmlNodeType.Element, "add", null));
            oSetting.SetAttribute("key", "IMAPServerTimeout");
            oSetting.SetAttribute("value", textBox7.Text);
            
            Stream oStream = new FileStream("MySettings.xml", FileMode.Create, FileAccess.Write);
            String sXML = oConfigDoc.OuterXml;
            for (int iXCtr=0; iXCtr<sXML.Length; iXCtr++)
                oStream.WriteByte((byte)sXML[iXCtr]);
            oStream.Close();

        }

        private void button5_Click(object sender, System.EventArgs e)
        {
            if (!File.Exists("MySettings.xml"))
               return;
            Stream oStream = new FileStream("MySettings.xml", FileMode.Open, FileAccess.Read);
            StringBuilder sXML = new StringBuilder((int)oStream.Length);
            int iRead = 0;
            for (iRead = oStream.ReadByte(); iRead != -1; iRead = oStream.ReadByte())
                sXML.Append((char)iRead);
            oStream.Close();
            XmlDocument oConfigDoc = new XmlDocument();
            oConfigDoc.LoadXml(sXML.ToString());
            XmlElement oConfig = (XmlElement) oConfigDoc.FirstChild;
            String sPassword = null;
            foreach (XmlElement oSetting in oConfig.ChildNodes)
               {
               if (oSetting.GetAttribute("key").Equals("IMAPServerIPAddr"))
                   textBox1.Text = oSetting.GetAttribute("value");
               else if (oSetting.GetAttribute("key").Equals("IMAPServerPort"))
                   textBox2.Text = oSetting.GetAttribute("value");
               else if (oSetting.GetAttribute("key").Equals("password"))
                   sPassword = oSetting.GetAttribute("value");
               else if (oSetting.GetAttribute("key").Equals("userName"))
                   textBox4.Text = oSetting.GetAttribute("value");
               else if (oSetting.GetAttribute("key").Equals("rememberPassword"))
                   checkBox1.Checked = oSetting.GetAttribute("value").Equals("yes");
               else if (oSetting.GetAttribute("key").Equals("eMailProgram"))
                   textBox5.Text = oSetting.GetAttribute("value");
               else if (oSetting.GetAttribute("key").Equals("mailCheckFrequency"))
                   textBox6.Text = oSetting.GetAttribute("value");
               else if (oSetting.GetAttribute("key").Equals("IMAPServerTimeout"))
                   textBox7.Text = oSetting.GetAttribute("value");
               }
            if (checkBox1.Checked)
               textBox3.Text = sPassword;
        }

    }

}
