/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;

public class GVarNameDialog
extends GOkCancelHelpDialog {
    private TextField varName;
    private GNotepad notepad;
    private GCalculator calculator;
    private GExpression expr;
    private double value;
    private GLog log;

    public GVarNameDialog(GFrame gFrame, GNotepad gNotepad, GCalculator gCalculator, GExpression gExpression, double d, GLog gLog) {
        super(gFrame, "Assign Variable");
        this.helpTopic = "variable assignment";
        this.notepad = gNotepad;
        this.calculator = gCalculator;
        this.expr = gExpression;
        this.value = d;
        this.log = gLog;
        this.varName = new TextField(5);
        this.varName.setFont(gFrame.labelFont);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        Label label = new Label("Assign label to the expression:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.varName, gridBagConstraints);
        this.dataPanel.add(this.varName);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        String string = this.varName.getText().trim();
        String string2 = GVariable.checkName(string);
        if (string2 != null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Invalid Variable", string2);
            return false;
        }
        GVariable gVariable = new GVariable(string, this.value);
        if (!this.notepad.add(gVariable, this.expr, this.calculator, 0)) {
            new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA Notepad", "Variable " + string + " in use");
            return false;
        }
        if (this.log != null) {
            Object[] objectArray = new Object[]{gVariable, this.expr};
            this.log.add("Calculator", objectArray, null);
        }
        return true;
    }
}

