'
'   Goto next line which different between current and next file
'   Start compare beyond current line positions
'   Mark the line that is different in the first file
'
Function GotoDiff

  nr1   = pe32.Lines                    ' Get lines and current line in File1
  row1 = pe32.Row

  pe32.command "e"                      ' File2

  nr2   = pe32.Lines                    ' Get lines and current line in File12
  row2 = pe32.Row

  pe32.command "e -"                    ' File1

  nrmin = nr1 - row1                    ' Get shortest remaining length
  if nr2 - row2 < nrmin then
    nrmin = nr2 - row2
  end if

  pe32.command "[unmark]"               ' Clear last mark

  '   Search current line up to first end of file
  for i=1 to nrmin

    str1=pe32.getline(i + row1)

    pe32.command "e"                    ' File2

    str2=pe32.getline(i + row2)

    pe32.command "e -"                  ' File1

    if str1 <> str2 then
      pe32.row = i + row1               ' Move File1

      pe32.command "e"                  ' File2

      pe32.row = i + row2               ' Move File2

      pe32.command "e -"                ' File1

      pe32.command "[mark line]"        ' Mark File1 and exit
      exit for
    end if

  next

end function


'
'   Visual flash 2 files
'   (Wait switch back to prior file, wait)
'
'   First argument is amount to wait, second is number of times to flash
'
Function Flash (Wait_Time, Num_Flash)

  If Wait_Time <= 0 Then
    Wait_Time = 100000                    ' Default wait counter
  End If

  If Num_Flash <= 0 Then
    Num_Flash = 1                         ' Set > 1 for multiple flash
  End If

  for k=1 to Num_Flash-1

'   pe32.command "[wait &Wait_Time&]"
    for i=1 to Wait_Time
      j=j+1
    next

    pe32.command "e -"

'   pe32.command "[wait &Wait_Time&]"
    for i=1 to Wait_Time
      j=j+1
    next

    pe32.command "e"

  next

' pe32.command "[wait &Wait_Time&]"
  for i=1 to Wait_Time
    j=j+1
  next

  pe32.command "e -"

' pe32.command "[wait &Wait_Time&]"
  for i=1 to Wait_Time
    j=j+1
  next

end function


'
'   Visual flash compare 2 files
'
'   Cursor movement keys scroll both files
'      PgUp, PgDn, Home, End, Left, Right
'
'   Esc exits compare
'
'   + goes to next difference
'
'   Ins scrolls first file up   (it has less lines)
'   Del scrolls first file down (it has more lines)
'
'   Shift cursor keys just move File1       (NOT implemented)
'   Ctrl  cursor keys just move File2       (NOT implemented)
'   Alt   cursor keys scroll in both files  (NOT implemented)
'
Function Compare

' wait_time=250                         ' Milleseconds to wait
  wait_time=50000                       ' Burn counter:  adjust for your computers speed
  num_flash=5

  exitloop=0
  do

    key=pe32.key                        ' Get command

    select case key
      case 27                           ' Esc
        exitloop=1

      case &H2200                       ' PgDn
        pe32.command "[page down]"
        pe32.command "e"
        pe32.command "[page down]"
        Call Flash(wait_time, num_flash)

      case &H2100                       ' PgUp
        pe32.command "[page up]"
        pe32.command "e"
        pe32.command "[page up]"
        Call Flash(wait_time, num_flash)

      case &H2600                       ' Up
        pe32.command "[scrolldown]"
        pe32.command "e"
        pe32.command "[scrolldown]"
        Call Flash(wait_time, num_flash)

      case &H2800                       ' Dn
        pe32.command "[scrollup]"
        pe32.command "e"
        pe32.command "[scrollup]"
        Call Flash(wait_time, num_flash)

      case &H2500                       ' Left
        pe32.command "[left]"
        pe32.command "e"
        pe32.command "[left]"
        Call Flash(wait_time, num_flash)

      case &H2700                       ' Right
        pe32.command "[right]"
        pe32.command "e"
        pe32.command "[right]"
        Call Flash(wait_time, num_flash)

      case &H2300                       ' End  Bottom of files
        pe32.command "[bottom]"
        pe32.command "[begin line]"
        pe32.command "e"
        pe32.command "[bottom]"
        pe32.command "[begin line]"
        Call Flash(wait_time, num_flash)

      case &H2D00                       ' Ins  First file has less lines
        pe32.command "[scrollup]"
        pe32.command "e"
        Call Flash(wait_time, num_flash)

      case &H2E00                       ' Del  First file has more lines
        pe32.command "[scrolldown]"
        pe32.command "e"
        Call Flash(wait_time, num_flash)

      case &H2400                       ' Home Top of files
        pe32.command "[top]"
        pe32.command "[begin line]"
        pe32.command "e"
        pe32.command "[top]"
        pe32.command "[begin line]"
        Call Flash(wait_time, num_flash)

      case &H6B00,43                    ' +
        pe32.command "[ve GotoDiff][unmark]"

      case else
        pe32.command "e"                ' Flash toggle files
        Call Flash(wait_time, num_flash)

    end select

  loop until exitloop=1                 ' Repeat loop

end function


'
'   Capture key code for next keystroke as text (preceeded by a blank).
'   Will overwrite current cursor position (or insert at current position
'       if in insert mode).
'
Function KeyCode

  key         = pe32.Key                ' Get next keystroke
  pe32.Insert = " "&key&""              ' Insert as text

end function


'
'   Parse C error line
'   Pick off filename (and line number if it exists)
'      and open that file (at that line number).
'
Function GotoErr

  Dim regEx, Matches, Match
  Set regEx = New RegExp                ' Use regular expression
  regEx.IgnoreCase = True
  regEx.Global = False

  str=pe32.line                         ' Line with Filename(line) etc. on it

  '   Find start of line number
  regEx.Pattern = "\("                  ' Set pattern
  Set Matches = regEx.Execute(str)      ' Execute search

  if Matches.count > 0 then
    for each Match in Matches
      exit for
    next

    file = left(str, Match.FirstIndex)  ' Extract Filename
    pos = Match.FirstIndex+2

    '   Find end of line number
    regEx.Pattern = "\)"
    Set Matches = regEx.Execute(str)

    row = "1"
    if Matches.count > 0 then
      for each Match in Matches
        exit for
      next
      row = mid(str, pos, Match.FirstIndex) ' Extract line number
    end if
  else
    file = str                          ' No line number assume just Filename
    row = "1"                           '   at top of file
  end if

  pe32.command "e "+file                ' Edit Filename
  pe32.command "line "+row              '   at line number

end function


'
'   Comment out (with block comments) a single word
'
Function RemWord

  pe32.word = "/* "+pe32.word+" */"

end function


'
'   Comment out (add // rem to start of line) all of file
'   Do not double comment lines
'
Function RemAll

  for i=1 to pe32.lines

    str=pe32.getline(i)

    if left( str, 7 ) <> "// rem " then
      str="// rem "+str
      pe32.setline str, i               ' Add comment
    end if

  next

end function


'
'   Comment out (add // rem to start of line) marked lines
'   Do not double comment lines
'
Function RemMark

  for i=1 to pe32.markedlines

    str=pe32.getmarkedline(i)

    if left( str, 7 ) <> "// rem " then
      str="// rem "+str
      pe32.setmarkedline str, i
    end if

  next

end function


'
'   From current position until matching C block depth
'      comment out (add // rem to start of line) all source lines.
'
'   Note:  Will comment all leadin lines before first block mark ({).
'
Function RemFun

  Dim regEx, Matches
  Set regEx = New RegExp                ' Use regular expression
  regEx.IgnoreCase = True               ' Set ignore case
  regEx.Global = True                   ' Set global search

  brace=0
  exitloop=0

  '  Loop over block (or until EOF)
  do                                    ' Loop until end

    str=pe32.line                       ' Get pe32 current line

    '   Increment count for blocks opened
    regEx.Pattern = "{"                 ' Set pattern
    Set Matches = regEx.Execute(str)    ' Execute search
    brace=brace+Matches.count           ' Count braces

    ' Decrement count for blocks closed
    regEx.Pattern = "}"                 ' Set pattern
    Set Matches = regEx.Execute(str)    ' Execute search
    brace=brace-Matches.count           ' Count braces

    ' Comment the line
    str="// rem "+str                   ' Add a C remark
    pe32.line=str                       ' Set current pe32 line
    newrow=pe32.row+1                   ' Increment row

    ' Exit if EOF
    if newrow>pe32.lines then           ' If eof exit
      exitloop=1
    end if

    ' Exit at matching depth
    if brace=0 and Matches.count>0 then ' If end function exit
      exitloop=1
    end if

    pe32.row=newrow                     ' Set new row

  loop until exitloop=1                 ' Repeat loop

end function


'
'   Search for all occurances of current word and try to align them
'      Note:  will use cursor position to align (even if not at start of word)
'
Function Align_Word


  Dim regEx, Matches
  Set regEx = New RegExp                ' Use regular expressions
  regEx.IgnoreCase = False
  regEx.Global = False


  ' Get state
  str1  = pe32.word                     ' Get current word
  row1  = pe32.Row                      '  and position
  col1  = pe32.Col
  mode1 = pe32.InsertMode               '  and mode

  pe32.InsertMode = 1                   ' Set to insert

  lines1 = pe32.Lines - row1            ' Get lines and current line in File1

  for i=1 to lines1                     ' Loop over rest of lines in file

    pe32.Row = pe32.Row + 1             ' Get next line
    str      = pe32.Line

    ' Find match
    regEx.Pattern = str1                ' Set pattern
    Set Matches   = regEx.Execute(str)  ' Execute search

    if Matches.count > 0 then           ' If found

      for each Match in Matches         ' Load match information
        exit for
      next

      find1    = Match.FirstIndex+1     ' Goto that column
      pe32.Col = find1

      if find1 < col1 then              ' Before alignment word?

        ' Add blanks
        for j=1 to col1-find1

          pe32.Insert = " "             ' Align word

        next

      elseif find1 > col1 then          ' After alignment word?


        ' Count deletable blanks
        for j=find1-1 to col1 step -1

          char = mid(str, j, 1)         ' Extract j'th character

          if char <> " " then
           exit for
          end if

        next

        ' Remove deletable blanks
        pe32.Line = left(str, j) + mid(str, find1)

      end if

    end if

  next                                  ' Repeat loop

  ' Restore state
  pe32.Row        = row1                ' Restore position
  pe32.Col        = col1
  pe32.InsertMode = mode1               '  and mode

end function


'
'   For jagged columns:  align blank / non-blank transition at cursor (columns
'      past column being aligned are shifted in unison).
'
'   Align column to cursor:  if over text add blanks else remove blanks
'
'   Apply to rest of file if no marked lines else apply to rest of mark
'
Function Align_Col


  ' Get state
  row1  = pe32.Row                      ' Position
  col1  = pe32.Col
  mode1 = pe32.InsertMode               '  and mode

  pe32.InsertMode = 1                   ' Set to insert

  lines1 = pe32.Lines - row1            ' Get lines and current line in File1

  ' Restrict loop to marked lines
  if pe32.markedlines > 0 then

    pe32.command "[begin mark]"         ' Goto start of mark
    row2 = pe32.row

    if (row2 < row1) then row2 = row1   ' Use lower of row1 and row2

    pe32.command "[end mark]"           ' Goto end of mark
    lines1 = pe32.Row - row2            ' Shorten loop to end of mark

    pe32.Row = row2                     ' Restore start position

  end if

  ' Loop over current and rest of lines
  for i=1 to lines1+1                   ' Loop over rest of lines in file

    str = pe32.Line

    char = mid(str, col1-1, 1)          ' Extract align character

    if char = " " then

      ' Count deletable blanks
      for j=col1 to len(str)

        char = mid(str, j, 1)           ' Extract j'th character

        if char <> " " then
         exit for
        end if

      next

      ' Remove deletable blanks
      pe32.Line = left(str, col1-1) + mid(str, j)
    else

      ' Count blanks to insert
      for j=col1-1 to 1 step -1

        char = mid(str, j, 1)           ' Extract j'th character

        if char = " " then
         exit for
        end if

      next

      ' Add blanks
      pe32.Col = j

      for k=1 to col1-j-1

        pe32.Insert = " "               ' Align word

      next

    end if

    pe32.Row = pe32.Row + 1             ' Get next line
  next                                  ' Repeat loop

  ' Restore state
  pe32.Row        = row1                ' Restore position
  pe32.Col        = col1
  pe32.InsertMode = mode1               '  and mode

end function


'
'   Place cursor a left edge of field to be left justified.
'   Blanks under the cursor will be moved beyond the following word.
'
'   Apply to rest of file if no marked lines else apply to rest of mark
'
Function Left_Justify


  ' Get state
  row1  = pe32.Row                      ' Position
  col1  = pe32.Col
  mode1 = pe32.InsertMode               '  and mode

  pe32.InsertMode = 1                   ' Set to insert

  lines1 = pe32.Lines - row1            ' Get lines and current line in File1

  ' Restrict loop to marked lines
  if pe32.markedlines > 0 then

    pe32.command "[begin mark]"         ' Goto start of mark
    row2 = pe32.row

    if (row2 < row1) then row2 = row1   ' Use lower of row1 and row2

    pe32.command "[end mark]"           ' Goto end of mark
    lines1 = pe32.Row - row2            ' Shorten loop to end of mark

    pe32.Row = row2                     ' Restore start position

  end if

  ' Loop over current and rest of lines
  for i=1 to lines1+1                   ' Loop over rest of lines in file

    str = pe32.Line

    char = mid(str, col1-1, 1)          ' Extract align character

    if char = " " then

      ' Count moveable blanks
      for j=col1 to len(str)

        char = mid(str, j, 1)           ' Extract j'th character

        if char <> " " then
         exit for
        end if

      next

      ' Find end of next word
      for k=j+1 to len(str)

        char = mid(str, k, 1)           ' Extract k'th character

        if char = " " then
         exit for
        end if

      next

      ' Move blanks
      '           Before column    next word      blanks moved         rest
      pe32.Line = left(str,col1-1)+mid(str,j,k-j)+mid(str,col1,j-col1)+mid(str,k)
    end if

    pe32.Row = pe32.Row + 1             ' Get next line
  next                                  ' Repeat loop

  ' Restore state
  pe32.Row        = row1                ' Restore position
  pe32.Col        = col1
  pe32.InsertMode = mode1               '  and mode

end function


'
'   Place cursor a rightt edge of field to be right justified.
'   Blanks under the cursor will be moved before the preceeding word.
'
'   Apply to rest of file if no marked lines else apply to rest of mark
'
Function Right_Justify


  ' Get state
  row1  = pe32.Row                      ' Position
  col1  = pe32.Col
  mode1 = pe32.InsertMode               '  and mode

  pe32.InsertMode = 1                   ' Set to insert

  lines1 = pe32.Lines - row1            ' Get lines and current line in File1

  ' Restrict loop to marked lines
  if pe32.markedlines > 0 then

    pe32.command "[begin mark]"         ' Goto start of mark
    row2 = pe32.row

    if (row2 < row1) then row2 = row1   ' Use lower of row1 and row2

    pe32.command "[end mark]"           ' Goto end of mark
    lines1 = pe32.Row - row2            ' Shorten loop to end of mark

    pe32.Row = row2                     ' Restore start position

  end if

  ' Loop over current and rest of lines
  for i=1 to lines1+1                   ' Loop over rest of lines in file

    str = pe32.Line

    if col1 > len(str) then

      ' Count moveable blanks
      for j=len(str) to 1 step -1

        char = mid(str, j, 1)           ' Extract j'th character

        if char <> " " then
         exit for
        end if

      next

      ' Find end of next word
      for k=j-1 to 1 step -1

        char = mid(str, k, 1)           ' Extract k'th character

        if char = " " then
         exit for
        end if

      next

      ' Insert blanks
      pe32.Col = k-1

      for l=1 to col1-j

        pe32.Insert = " "               ' Align word

      next
    else
      char = mid(str, col1+1, 1)        ' Extract align character

      if char = " " then

        ' Count moveable blanks
        for j=col1 to 1 step -1

          char = mid(str, j, 1)         ' Extract j'th character

          if char <> " " then
           exit for
          end if

        next

        ' Find end of next word
        for k=j-1 to 1 step -1

          char = mid(str, k, 1)         ' Extract k'th character

          if char = " " then
           exit for
          end if

        next

        ' Move blanks
        '          Before word   blanks moved       prior word       rest
        pe32.Line = left(str,k)+mid(str,j+1,col1-j)+mid(str,k+1,j-k)+mid(str,col1+1)
      end if
    end if

    pe32.Row = pe32.Row + 1             ' Get next line
  next                                  ' Repeat loop

  ' Restore state
  pe32.Row        = row1                ' Restore position
  pe32.Col        = col1
  pe32.InsertMode = mode1               '  and mode

end function


'
'   Execute a FILE of PE32 and/or VBS commands
'   Each line is a sequence of commands
'
'   Unless a line starts with $ it is assumed to be a set of PE32 commands
'
'   Special commands that start with $:
'       $VBScript VBS-command(s)
'       $ExitIf   VBS-expression
'
'   Special commands that start with $ that control execution of following line:
'       $While    VBS-expression
'       $If       VBS-expression
'       $IfNot    VBS-expression
'       $Repeat   VBS-expression
'
'       This allows one line blocks (multiple commands on a line) and avoids
'          all complications with block marks and nesting.
'
'   Special commands that start with $ that set flags for all PE32 lines:
'       $Global                         ' Repeat each line on all files
'       $EndGlobal
'       $Demo     VBS-expression        ' Zero implies wait for keystroke <> escape
'                                       ' Else wait time in seconds
'       $EndDemo                        ' Same as $Demo negative
'
'   Line continuation ("\") is supported on PE32 lines.
'
'   This allows unlimited length command sequences with complete documentation
'       and limited control flow.
'
'   Example:
'   [ve Ex_Commands("EditTask.cmd")]
'
Function Ex_Commands (FileSpec)

Dim FSO, TextStream, Command, FullCommand, Special, Rest
Dim LCSpecial, WhileText, StartFile, ThisFile, FileCount

Set FSO = CreateObject("Scripting.FileSystemObject") ' Setup to read

' If empty filename is passed then use Default.cmd
If FileSpec = "" Then
  FileSpec = "Default.cmd"
End If

' Verify that passed file exists
If (FSO.FileExists(FileSpec)) Then

  ' Open passed filename
  Set TextStream = FSO.OpenTextFile(FileSpec, 1) ' Open filename to read

  IsGlobal    = FALSE                            ' Off
  DemoSpeed   = -1                               ' Off
  RepeatCount = 1                                ' Off
  WhileText   = ""                               ' Off

  Do While Not TextStream.AtEndOfStream
    Command = TextStream.ReadLine                ' Get next command

    '
    ' Process the line form the passed file
    '
    If Left(Command, 1) = "$" Then
                                                 ' Not implemented yet
      ' Remove keyword
      For j=2 To Len(Command)

        If Mid(Command, j, 1) = " " Then         ' Check j'th character
          Exit For
        End If
      Next

      Special = Mid (Command, 2, j-2)            ' Extract special command
      Rest    = Mid (Command, j)                 ' Extract any arguement

      LCSpecial = LCase (Special)
      '
      ' Parse special control extensions
      '
      Select Case LCSpecial
        Case "vbscript"
          ExecuteGlobal (Rest)                   ' Execute rest (assume VBScript)

        Case "exitif"
          If Eval(Rest) Then Exit Function

        Case "while"
          WhileText   = Rest                     ' Save condition
          RepeatCount = 1                        ' Only one of While and Repeat

        Case "if"
          If Not Eval(Rest) Then
            If TextStream.AtEndOfStream Then Exit Function
            Command = TextStream.ReadLine        ' Toss next line
          End If

        Case "ifnot"
          If Eval(Rest) Then
            If TextStream.AtEndOfStream Then Exit Function
            Command = TextStream.ReadLine        ' Toss next line
          End If

        Case "repeat"
          RepeatCount = Eval(Rest)
          WhileText   = ""                       ' Only one of While and Repeat

        Case "global"
          IsGlobal = TRUE

        Case "endglobal"
          IsGlobal = FALSE

        Case "demo"
           DemoSpeed = Eval (Rest)               ' Save time

           If DemoSpeed > 10 Then                ' Not too big
             DemoSpeed = 10
           End If

        Case "enddemo"
           DemoSpeed = -1                        ' Off

        Case Else
          Answer = MsgBox ("Unknown command: $"+Special+Rest, vbOKCancel)
          If Answer=2 Then Exit Function

      End Select
    Else
      '
      ' Support line continuation
      '
      FullCommand = ""

      Do While Right (Command, 1) = "\" and Not TextStream.AtEndOfStream

        FullCommand = FullCommand + Left (Command, Len(Command)-1)
        Command = TextStream.ReadLine            ' Continue to next line

      Loop

      FullCommand = FullCommand + Command        ' Add part of line without continuation

      '
      ' Handle any debug requests
      '
      If DemoSpeed = 0 Then
        If FullCommand <> "" And Left(FullCommand, 1) <> "*" Then ' Not dummy
          Answer = MsgBox ("Step "&RepeatCount&": "+FullCommand, vbOKCancel)
          If Answer=2 Then Exit Function
        End If
      End If

      '
      ' If requested, slow it down (badly)
      '
      If DemoSpeed > 0 Then
        If FullCommand <> "" And Left(FullCommand, 1) <> "*" Then ' Not dummy
          StartTime = Timer
          Do
            Elapsed = Timer - StartTime
          Loop Until Elapsed > DemoSpeed
        End If
      End If

      '
      ' Remember on which file we started (and start with next one)
      '
      If IsGlobal Then
         StartFile    = pe32.Filename            ' For global
         pe32.command "e"                        ' Start with second file
         FileCount    = 0
      End If

      Do_loop = IsGlobal                         ' Save looping status

      '
      ' Loop over files
      '
      Do
        ThisFile = pe32.Filename                 ' Copy current filename (incase released)

        If WhileText <> "" Then
          '
          ' Handle While condition
          '
          Do While Eval (WhileText)
            pe32.command FullCommand             ' Execute the PE32 command(s)
          Loop
        Else
          '
          ' Handle repeat looping
          '
          If RepeatCount <= 0 Then               ' Validate step counter
            RepeatCount = 1
          End If

          For Ex_Loop = 1 To RepeatCount         ' Support repeat
            pe32.command FullCommand             ' Execute the PE32 command(s)
          Next
        End If

        '
        ' Handle Global looping and termination
        '
        If IsGlobal Then
          '
          ' Warning:  Due to current PE32 ring ordering this is not failsafe
          '           A new file can be opened and closed resulting in a new
          '           current file and a possible infinite loop.
          '           Also if more files are opened than closed we may never
          '           get back to the first file.
          '
          If StartFile = ThisFile Then           ' Back to original file?
            Do_loop = FALSE                      ' If yes then stop
          Else
            pe32.command "e"                     ' Next global file
            FileCount    = FileCount+1           ' Failsafe
          End If
        End If

      Loop Until Do_loop = FALSE Or FileCount > 500 ' Exit when processed first file

      RepeatCount = 1                            ' Clear count for next command
    End If
  Loop

  TextStream.Close

Else
  MsgBox FileSpec+" does not exist"
End If

end function


'
'   Save all files where cursor is not at upper left corner
'
'   Designed to save changed files by using side effect that change command
'   moves the cursor.
'
Function Save_Changed

Dim FirstFile

FirstFile = pe32.Filename                 ' Loop control
'
' Loop over files
'
Do
  If pe32.Row+pe32.Col <> 2 then          ' At top left corner?
    pe32.command "save"                   ' Save the file
  End if

  pe32.command "e"                        ' Next file

Loop Until pe32.Filename = FirstFile      ' Exit when back to first file

end function


'
'   Move cursor to beginning of line on all files
'
Function Home_All

Dim FirstFile

FirstFile = pe32.Filename                 ' Loop control
'
' Loop over files
'
Do
  pe32.command "[bl]"                     ' Home
  pe32.command "e"                        ' Next file

Loop Until pe32.Filename = FirstFile      ' Exit when back to first file

end function


'
'   Move cursor to end of line on all files
'
Function End_All

Dim FirstFile

FirstFile = pe32.Filename                 ' Loop control
'
' Loop over files
'
Do
  pe32.command "[el]"                     ' End
  pe32.command "e"                        ' Next file

Loop Until pe32.Filename = FirstFile      ' Exit when back to first file

end function


'
'   Save all files
'
Function Save_All

Dim FirstFile

FirstFile = pe32.Filename                 ' Loop control
'
' Loop over files
'
Do
  pe32.command "save"                     ' Save
  pe32.command "e"                        ' Next file

Loop Until pe32.Filename = FirstFile      ' Exit when back to first file

end function

