#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <string.h>

#include <windows.h>

#include "wimadll.h"

HIMA TryLoadFloppyIma(LPCSTR lpszImageFileName)
{
    BOOL fCompr=FALSE;
    HIMA hIma = CreateMemFatHima();
    if (hIma!=NULL)
    {
        if (!ReadImaFile(hIma,/*NULL*/HWND_NO_PROGRESS,(LPSTR)lpszImageFileName,&fCompr,0))
        {
            DeleteIma(hIma);
            hIma=NULL;
        }
    }
    return hIma;
}


HIMA TryLoadIsoIma(LPCSTR lpszImageFileName)
{
    return CreateCDIsoIma((LPSTR)lpszImageFileName);
}

    
BOOL DoDirImage(LPCSTR lpszImageFileName)
{
    HIMA hIma;
    DWORD dwNbFileRoot,i;
    LPDIRINFO lpdi;

    hIma = TryLoadIsoIma(lpszImageFileName);
    if (hIma!=NULL)
        printf("ISO CdRom image %s opened\n",lpszImageFileName);
    else
    {
        DWORD dwSizeIma,dwSizeImaHigh;
        BOOL fOpenLargeFat=FALSE;
        DWORD dwPosInFile=0;
        if (GetFatImaSizeFileName(lpszImageFileName,&dwSizeIma,&dwSizeImaHigh,&fOpenLargeFat,&dwPosInFile))
        {
            hIma = OpenFatLargeFile(NULL,lpszImageFileName,0,0,TRUE);
            if (hIma!=NULL)
                printf("Hard disk image %s opened\n",lpszImageFileName);
        }

        if ((hIma==NULL) && (!fOpenLargeFat))
        {
            hIma = TryLoadFloppyIma(lpszImageFileName);
            if (hIma!=NULL)
                printf("Fat Floppy image %s opened\n",lpszImageFileName);
        }
    }

    if (hIma!=NULL)
    {
        dwNbFileRoot=GetNbEntryCurDir(hIma);
        lpdi = (LPDIRINFO)malloc(sizeof(DIRINFO)*(dwNbFileRoot+1));
        if (lpdi!=NULL)
        {
            if (GetDirInfo(hIma,lpdi,SORT_NAME))
                for (i=0;i<dwNbFileRoot;i++)
                {
                    printf("%s\t%u\n",(lpdi+i)->longname,(lpdi+i)->dwSize);
                }
            free(lpdi);
        }
        DeleteIma(hIma);
    }

    return hIma!=NULL;
}

int main(int argc,char *argv[])
{
  printf("DirImage - a WinImage DLL sample - http://www.winimage.com/wima_sdk.htm\n");
  if (argc <= 1)
  {
      printf("Usage : DirImage <image_filename>\n\n");
      return 0;
  }
  else
      return DoDirImage(argv[1]);
}
