<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- f2xml custom transformation.                                   -->

  <!-- Email  : help@boulderwall.com                                  -->
  <!-- Web    : http://www.boulderwall.com                            -->
  <!-- Name   : empty.xsl                                             -->
  <!-- Purpose: Transform XML filelist into an HTML listing of empty, -->
  <!--          zero length, files.                                   -->

  <xsl:output method="html"/>

  <xsl:template match="file[size=0]">
    <li>
      <b><xsl:value-of select="@name"/></b>
      <xsl:text> </xsl:text>
      <xsl:value-of select="fullpath"/>
    </li>
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="/">
    <xsl:comment>
    Created by empty.xsl. Input XML created by f2xml from www.boulderwall.com 
    </xsl:comment>
    <html>
      <body>
        <center>
          <h2>Empty file list for<br/>
            <font color="blue">
              <xsl:value-of select="filetree/folder/@name"/>
            </font>
          </h2>
          <h4>created by f2xml via empty.xsl<br/>
            <font size="-1">
              <a href="http://www.boulderwall.com">www.boulderwall.com</a>
            </font>
          </h4>
        </center>

        <xsl:if test="//file[@name='BOULDERWALL.com']">
          <h4>NOTE: XML output is from an unlicensed version of f2xml. Some files may be missing</h4>
        </xsl:if>

        <p>There are <xsl:value-of select="count(//file[size=0])"/> empty files:</p>
        <ol>
          <xsl:apply-templates />
        </ol>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="text()"/>

</xsl:stylesheet>
