{ This program decompresses all the data in a drivespace CVF, }
{ putting it in a different file. Note that many of the var.  }
{ names, etc. and overall structure are taken from an example }
{ in the "MS-DOS Resource kit" DoubleSpace chapter (ch. 3).   }
{ **NOTE: DriveSpace MUST be loaded for this program to work! }

{============================================================================}

{ VARIOUS MRCI CONSTANTS ("Microsoft Realtime Compression Interface") }

const intMRCI = $2F;          { MRCI interrupt number }
      mrciDETECT = $4A12;     { intMRCI ax for detecting MRCI engine }
      intMRCIROM = $1A;       { ROM MRCI interrupt number }
      mrciDETECTROM = $B001;  { intMRCIROM ax for detecting hardware MRCI engine }

      mcAPPLICATION = 0;
      mcSYSTEM = 1;

      micapNONE = 0;          { bit codes for the various operations }
      micapSTANDARD = 1;
      micapDECOMPRESS = 2;
      micapRESERVED_1 = 4;
      micapMAX = 8;
      micapRESERVED_2 = 16;
      micapINCDECOMP = 32;
      micapREADONLY = $8000;
      micapDEINSTALL = $FFFF;

{ ERRORS RETURNED BY THE DECOMPRESSION OPERATION }

      MRCI_ERROR_NOT_SUPPORTED = 1;   { decompression unavailable }
      MRCI_ERROR_BUSY = 2;            { drivespace busy - try again later }
      MRCI_ERROR_BUFFER_OVERFLOW = 3; { desination buffer was too small }
      MRCI_ERROR_BAD_MRC_FORMAT = 5;  { some error in the compressed data }

{ VARIOUS MRCI RECORD TYPES }

type MRCrequest =
       record
         mr_pbSrc:pointer;     { address of source buffer }
         mr_cbSrc:word;        { length of source buffer }
         mr_RESERVED:word;     { unused }
         mr_pbDst:pointer;     { address of destination buffer }
         mr_cbDst:word;        { length of destination buffer }
         mr_cbChunk:word;      { chunk size - doesn't matter for decompress }
         mr_dwIncDecomp:pointer;  { used only for incremental decompression }
       end;

     MRCrequestPtr = ^MRCrequest;

     MRCinfo =
       record
         mi_lVendor:longint;     { Vendor ID.  Microsoft's is "MSFT" }
         mi_wVendorVersion:word;
         mi_wMRCIVersion:word;
         mi_pfnOperate:pointer;  { entry point for MRCI engine }
         mi_flCapability:word;   { available capabilities bit field }
         mi_flHWAssist:word;     { hardware assisted capabilities bit field }
         mi_cbMax:word;          { maximum buffer lengths }
       end;

     MRCinfoPtr = ^MRCinfo;

{============================================================================}

function getMRCinfo:MRCinfoPtr;
{ Returns a pointer to an MRCinfo record, null if no MRCI engine is present }
const sigOLD_CX=$4D52;   { To let you check that it is the MRCI responding, }
      sigOLD_DX=$4349;   { it reverses the order of the 4 bytes you pass to }
      sigNEW_CX=$4943;   { it in CX,DX.                                     }
      sigNEW_DX=$524D;
label mdr,mdp,mde,mdx,exitpoint;
begin
  asm
    push   bp
    push   ds
    xor    ax,ax               { set default return value of zero }
    mov    word ptr [@Result],ax
    mov    word ptr [@Result+2],ax

    mov    ds,ax               { verify that interrupt vector is in use }
    lds    si,[ds:(intMRCI*4)]
    mov    ax,ds
    or     ax,ax
    jz     mdr

    mov    ax,mrciDETECT       { call the interrupt }
    mov    cx,sigOLD_CX
    mov    dx,sigOLD_DX
    int    intMRCI

    cmp    cx,sigNEW_CX        { check the response }
    jne    mdr
    cmp    dx,sigNEW_DX
    je     mdp

mdr:                           { negative response...             }
    xor    ax,ax               { so next check for ROM-based MRCI }
    mov    ds,ax
    lds    si,[ds:(intMRCIROM*4)]
    mov    ax,ds
    or     ax,ax
    jz     mde

    mov    ax,mrciDETECTROM    { call the interrupt }
    mov    cx,sigOLD_CX
    mov    dx,sigOLD_DX
    int    intMRCIROM

    cmp    cx,sigNEW_CX        { check the response }
    jne    mde
    cmp    dx,sigNEW_DX
    jne    mde

mdp:                           { MRCI found! }
    xor    ax,ax
    jmp    mdx

mde:                           { error - not found }
    mov    ax,1

mdx:
    pop    ds                  { get back old ds,bp }
    pop    bp

    or     ax,ax
    jnz    exitpoint
    mov    word ptr [@Result],di
    mov    ax,es
    mov    word ptr [@Result+2],ax

exitpoint:
  end;
end;




function DoDecompress(info:MRCinfoPtr; var request:MRCrequest):integer;
begin
  asm
    push   bp
    push   ds

    push   ax          { necessary... something to do with }
    mov    ax,8001h    { "Windows disk critical section".  }
    int    2ah
    pop    ax

    mov    ax,micapDECOMPRESS
    mov    cx,mcAPPLICATION
    les    bx,[info]
    lds    si,dword ptr [request]
    call   MRCinfo([es:bx]).mi_pfnOperate

    push   ax          { release disk critical section }
    mov    ax,8101h
    int    2ah
    pop    ax

    pop    ds
    pop    bp
    mov    [@result],ax   { set result variable }
  end;
end;


{============================================================================}
{$I+}

const sectorlength = 512;
      clusterlength = sectorlength*64;

type sector = array[0..((sectorlength div 4)-1)] of longint;
     cluster = array[0..63] of sector;

var srcbuffer,destbuffer:^cluster;
    inputsector:sector;
    info:MRCinfoPtr;
    request:MRCrequest;
    srcfile:file of sector;
    destfile:file of cluster;
    datafile:file of longint;
    sectorcount,clustercount:longint;
    sectors_waiting:byte;





procedure cleanup;
{ close files & deallocate memory }
begin
  close(srcfile);
  close(destfile);
  close(datafile);
  dispose(srcbuffer);
  dispose(destbuffer);
end;





procedure flushbuffer;
{ decompress and write a cluster to destination file }
var DecompErr:integer;
begin
  { init buffers, request info }
  fillchar(destbuffer^,clusterlength,0);
  if sectors_waiting<64 then
    fillchar(srcbuffer^[sectors_waiting],
             clusterlength-sectorlength*sectors_waiting,
             0);
  request.mr_cbDst:=clusterlength;

  { decompress }
  repeat
    DecompErr:=DoDecompress(info,request);
  until (DecompErr<>MRCI_ERROR_BUSY);
  if (DecompErr<>0) and (DecompErr<>MRCI_ERROR_BAD_MRC_FORMAT) then
    begin
      case DecompErr of
        MRCI_ERROR_NOT_SUPPORTED:
          writeln('ERROR: Decompression not supported!');
        MRCI_ERROR_BUFFER_OVERFLOW:
          writeln('ERROR: Destination buffer overflow!');
        else writeln('ERROR: Unknown decompression error!');
      end;
      cleanup;
      halt(1);
    end;

  { write output data }
  if DecompErr<>0 then write(datafile,clustercount);
  write(destfile,destbuffer^);
  inc(clustercount);
end;





{ --- MAIN PROGRAM --- }

begin
  if paramcount<>3 then
    begin
      writeln;
      writeln('Usage:  DECMPRSS <corrupt CVF> <decompressed output file> <cluster info file>');
      writeln;
      writeln('See accompanying README.TXT file for more information');
      halt;
    end;


  { get entry point to decompression engine }
  info:=getMRCinfo;
  if info=nil then
    begin
      writeln('ERROR: NO DECOMPRESSION ENGINE PRESENT');
      halt(1);
    end;

  { init buffers, files, and counters }
  new(srcbuffer);
  new(destbuffer);
  assign(srcfile,paramstr(1));
  assign(destfile,paramstr(2));
  assign(datafile,paramstr(3));
  rewrite(datafile);
  rewrite(destfile);
  reset(srcfile);
  sectors_waiting:=0;
  sectorcount:=0;
  clustercount:=0;

  { init decompression request info }
  with request do
    begin
      mr_pbSrc:=srcbuffer;
      mr_cbSrc:=clusterlength;
      mr_RESERVED:=0;
      mr_pbDst:=destbuffer;
      mr_cbChunk:=sectorlength;
      mr_dwIncDecomp:=nil;
    end;

  { main loop }
  while not(eof(srcfile)) do
    begin
      read(srcfile,inputsector);
      inc(sectorcount);
      if (sectorcount and $7FF)=0 then writeln(sectorcount shr 11,' Mb');
      if (inputsector[0]=$4D4A) or      { "compressed sector" headers for }
         (inputsector[0]=$1004D4A) or   { standard, hipack, and ultrapack }
         (inputsector[0]=$5153)         { compression, respectively       }
        then
          begin
            if sectors_waiting>0 then flushbuffer;
            move(inputsector,srcbuffer^[0],sectorlength);
            sectors_waiting:=1;
          end
        else if sectors_waiting>0 then
          begin
            move(inputsector,srcbuffer^[sectors_waiting],sectorlength);
            inc(sectors_waiting);
            if sectors_waiting=64 then
              begin
                flushbuffer;
                sectors_waiting:=0;
              end;
          end;
    end;
  if sectors_waiting>0 then flushbuffer;

  cleanup;
end.