unit Trexdm03;

{
$Log:   W:/users/prodigy/prodig~1/archive/trex/trexdm03.pav  $
 * 
 *    Rev 1.0   07 Apr 1996 18:30:52   PaulK
 * Work in progress on demos
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, T_Rex, ExtCtrls;

type
  TForm1 = class(TForm)
    edtPattern: TEdit;
    edtOriginal: TEdit;
    edtReplacement: TEdit;
    edtResult: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Bevel1: TBevel;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    re: TRegExp;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);

var
  s: string;

begin
{This procedure creates and destroys the finite state
 recognizer for the regular expression each time the button
 is pressed. This is necessary here because the regular expression
 could be different each time.

 But in many programs, the regular
 expression is known at design time, or can be determined once
 at runtime. In these cases it is inefficient to repeatedly
 compile and throw away the finite state recognizer, and the
 calls to TRegExp.Create and TRegExp.Free can be moved to points
 in the program where they are executed once.

 You could use SubstImmediate instead of Create/Subst/Free.
 We do it the long way here because this is a demo.}

re := TRegExp.Create(edtPattern.Text);
s := edtOriginal.Text;
re.Subst(s,edtReplacement.Text,maxint);
edtResult.Text := s;
re.Free;

end;

end.

