unit unlock;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Slock, Spin;

type
  TfrmCreateUnlock = class(TForm)
    grpUnlockCode: TGroupBox;
    edtChallenge: TEdit;
    lblChallenge: TLabel;
    GroupBox1: TGroupBox;
    lblUnlock: TLabel;
    edtUnlock: TEdit;
    grpUnlockType: TGroupBox;
    rdbRegister: TRadioButton;
    rdbExtend: TRadioButton;
    speExtension: TSpinEdit;
    Label1: TLabel;
    edtPrivateKey: TEdit;
    procedure rdbExtendClick(Sender: TObject);
    procedure rdbRegisterClick(Sender: TObject);
    procedure edtChallengeChange(Sender: TObject);
  private
    procedure CalculateUnlock;
  public
    { Public declarations }
  end;

var
  frmCreateUnlock: TfrmCreateUnlock;

implementation

uses
     SlokUtil;
{$R *.DFM}

{*******************************************************************************
* Procedure : rdbExtendClick                                                   *
********************************************************************************
* Purpose   : Sets the 'unlock mode' radio button to extend mode               *
********************************************************************************
* Paramters : None                                                             *
********************************************************************************
* Returns   : None                                                             *
*******************************************************************************}
procedure TfrmCreateUnlock.rdbExtendClick(Sender: TObject);
begin
     // set the mode
     speExtension.Enabled := True;

     // recalculate the unlock code based on the new mode
     CalculateUnlock;
end; {rdbExtendClick}

{*******************************************************************************
* Procedure : rdbRegisterClick                                                 *
********************************************************************************
* Purpose   : Sets the 'unlock mode' radio button to register mode             *
********************************************************************************
* Paramters : None                                                             *
********************************************************************************
* Returns   : None                                                             *
*******************************************************************************}
procedure TfrmCreateUnlock.rdbRegisterClick(Sender: TObject);
begin
     // set the mode
     speExtension.Enabled := False;

     // recalculate the unlock code based on the new mode
     CalculateUnlock;
end; {rdbRegisterClick}

{*******************************************************************************
* Procedure : edtChallengeChange                                               *
********************************************************************************
* Purpose   : Calculates the unlock string when the challenge info changes     *
********************************************************************************
* Paramters : None                                                             *
********************************************************************************
* Returns   : None                                                             *
*******************************************************************************}
procedure TfrmCreateUnlock.edtChallengeChange(Sender: TObject);
begin
     // recalculate the unlock string
     CalculateUnlock;
end; {edtChallengeChange}

{*******************************************************************************
* Procedure : CalculateUnlock                                                  *
********************************************************************************
* Purpose   : Calculates the unlock string based on the challenge string, the  *
*             Application Private Key and the extension value and mode         *
********************************************************************************
* Paramters : None                                                             *
********************************************************************************
* Returns   : None                                                             *
*******************************************************************************}
procedure TfrmCreateUnlock.CalculateUnlock;
begin
     if rdbExtend.Checked then
     begin
          // we are creating an extension code
          edtUnlock.Text := GetUnlockString(edtChallenge.Text,
                                            edtPrivateKey.Text,
                                            speExtension.Value);
     end
     else
     begin
          // we are creating a registration code
          edtUnlock.Text := GetUnlockString(edtChallenge.Text,
                                            edtPrivateKey.Text,
                                            0);
     end;
end; {CalculateUnlock}

end.
