// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Param2d.pas' rev: 3.00

#ifndef Param2dHPP
#define Param2dHPP
#include <Menus.hpp>
#include <StdCtrls.hpp>
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysUtils.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Param2d
{
//-- type declarations -------------------------------------------------------
typedef double __fastcall (__closure *TOnParseFunc)(System::TObject* Sender, const System::AnsiString 
	Expression, int &Code);

class DELPHICLASS TParShape;
class DELPHICLASS TParModel;
class DELPHICLASS TParView;
class PASCALIMPLEMENTATION TParModel : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TOnParseFunc FOnParse;
	Classes::TStrings* FVars;
	Classes::TStrings* FDesc;
	Classes::TStrings* FParShapes;
	Classes::TStrings* FErrors;
	Classes::TStrings* FSelection;
	Classes::TNotifyEvent FOnError;
	void __fastcall SetStrings(Classes::TStrings* Value);
	Classes::TStrings* __fastcall GetStrings(void);
	void __fastcall SetVars(Classes::TStrings* Value);
	
protected:
	void __fastcall Update(void);
	
public:
	__fastcall virtual TParModel(Classes::TComponent* AOwner);
	__fastcall virtual ~TParModel(void);
	void __fastcall Clear(void);
	void __fastcall Draw(TParView* v);
	void __fastcall RegError(const System::AnsiString Msg, TParShape* Sender);
	double __fastcall GetVal(const System::AnsiString name);
	void __fastcall SelWindow(Windows::TRect &r, TParView* v);
	void __fastcall SelCross(Windows::TRect &r, TParView* v);
	System::AnsiString __fastcall SelSingle(Windows::TRect &r, TParView* v);
	void __fastcall GetExt(double &minx, double &miny, double &maxx, double &maxy);
	void __fastcall SaveToFile(const System::AnsiString FileName);
	void __fastcall LoadFromFile(const System::AnsiString FileName);
	__property Classes::TStrings* Shapes = {read=FParShapes};
	__property Classes::TStrings* Selection = {read=FSelection};
	__property Classes::TStrings* Errors = {read=FErrors};
	
__published:
	__property Classes::TStrings* Vars = {read=FVars, write=SetVars};
	__property Classes::TStrings* Desc = {read=GetStrings, write=SetStrings};
	__property Classes::TNotifyEvent OnError = {read=FOnError, write=FOnError};
	__property TOnParseFunc OnParse = {read=FOnParse, write=FOnParse};
};

class PASCALIMPLEMENTATION TParShape : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Graphics::TPen* FPen;
	Graphics::TBrush* FBrush;
	TParModel* FParModel;
	bool FSolid;
	void __fastcall SetBrush(Graphics::TBrush* Value);
	void __fastcall SetPen(Graphics::TPen* Value);
	
protected:
	virtual void __fastcall SetString(const System::AnsiString Value);
	virtual System::AnsiString __fastcall GetString();
	void __fastcall RegError(const System::AnsiString Msg);
	
public:
	__fastcall TParShape(void);
	virtual TParShape* __fastcall CreateInstance(void) = 0;
	void __fastcall Register(void);
	__fastcall ~TParShape(void);
	virtual double __fastcall GetVal(const System::AnsiString name);
	virtual void __fastcall Draw(TParView* v) = 0;
	bool __fastcall IsInside(Windows::TRect &r, TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
	virtual void __fastcall GetExt(double &minx, double &miny, double &maxx, double &maxy) = 0;
	__property Graphics::TPen* Pen = {read=FPen, write=SetPen};
	__property Graphics::TBrush* Brush = {read=FBrush, write=SetBrush};
	__property bool Solid = {read=FSolid, write=FSolid, nodefault};
	__property TParModel* Model = {read=FParModel, write=FParModel};
	__property System::AnsiString Desc = {read=GetString, write=SetString};
};

class DELPHICLASS TParPoint;
class PASCALIMPLEMENTATION TParPoint : public Param2d::TParShape 
{
	typedef Param2d::TParShape inherited;
	
private:
	char FStl;
	System::AnsiString FX;
	System::AnsiString FY;
	
protected:
	virtual void __fastcall SetString(const System::AnsiString Value);
	virtual System::AnsiString __fastcall GetString();
	
public:
	__fastcall TParPoint(void);
	virtual TParShape* __fastcall CreateInstance(void);
	virtual double __fastcall GetVal(const System::AnsiString name);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
	virtual void __fastcall GetExt(double &minx, double &miny, double &maxx, double &maxy);
public:
	/* TParShape.Destroy */ __fastcall ~TParPoint(void) { }
	
};

class DELPHICLASS TParLine;
class PASCALIMPLEMENTATION TParLine : public Param2d::TParShape 
{
	typedef Param2d::TParShape inherited;
	
private:
	System::AnsiString FX1;
	System::AnsiString FY1;
	System::AnsiString FX2;
	System::AnsiString FY2;
	
protected:
	virtual void __fastcall SetString(const System::AnsiString Value);
	virtual System::AnsiString __fastcall GetString();
	
public:
	__fastcall TParLine(void);
	virtual TParShape* __fastcall CreateInstance(void);
	virtual double __fastcall GetVal(const System::AnsiString name);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
	virtual void __fastcall GetExt(double &minx, double &miny, double &maxx, double &maxy);
public:
	/* TParShape.Destroy */ __fastcall ~TParLine(void) { }
	
};

class DELPHICLASS TParRect;
class PASCALIMPLEMENTATION TParRect : public Param2d::TParLine 
{
	typedef Param2d::TParLine inherited;
	
public:
	virtual TParShape* __fastcall CreateInstance(void);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
public:
	/* TParLine.Create */ __fastcall TParRect(void) : Param2d::TParLine() { }
	
public:
	/* TParShape.Destroy */ __fastcall ~TParRect(void) { }
	
};

class DELPHICLASS TParRoundRect;
class PASCALIMPLEMENTATION TParRoundRect : public Param2d::TParRect 
{
	typedef Param2d::TParRect inherited;
	
private:
	System::AnsiString FX3;
	System::AnsiString FY3;
	
protected:
	virtual void __fastcall SetString(const System::AnsiString Value);
	virtual System::AnsiString __fastcall GetString();
	
public:
	__fastcall TParRoundRect(void);
	virtual TParShape* __fastcall CreateInstance(void);
	virtual double __fastcall GetVal(const System::AnsiString name);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
public:
	/* TParShape.Destroy */ __fastcall ~TParRoundRect(void) { }
	
};

class DELPHICLASS TParEllipse;
class PASCALIMPLEMENTATION TParEllipse : public Param2d::TParLine 
{
	typedef Param2d::TParLine inherited;
	
public:
	virtual TParShape* __fastcall CreateInstance(void);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
public:
	/* TParLine.Create */ __fastcall TParEllipse(void) : Param2d::TParLine() { }
	
public:
	/* TParShape.Destroy */ __fastcall ~TParEllipse(void) { }
	
};

class DELPHICLASS TParArc;
class PASCALIMPLEMENTATION TParArc : public Param2d::TParLine 
{
	typedef Param2d::TParLine inherited;
	
private:
	System::AnsiString FX3;
	System::AnsiString FY3;
	System::AnsiString FX4;
	System::AnsiString FY4;
	
protected:
	virtual void __fastcall SetString(const System::AnsiString Value);
	virtual System::AnsiString __fastcall GetString();
	
public:
	__fastcall TParArc(void);
	virtual TParShape* __fastcall CreateInstance(void);
	virtual double __fastcall GetVal(const System::AnsiString name);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
	virtual void __fastcall GetExt(double &minx, double &miny, double &maxx, double &maxy);
public:
	/* TParShape.Destroy */ __fastcall ~TParArc(void) { }
	
};

class DELPHICLASS TParChord;
class PASCALIMPLEMENTATION TParChord : public Param2d::TParArc 
{
	typedef Param2d::TParArc inherited;
	
public:
	virtual TParShape* __fastcall CreateInstance(void);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
public:
	/* TParArc.Create */ __fastcall TParChord(void) : Param2d::TParArc() { }
	
public:
	/* TParShape.Destroy */ __fastcall ~TParChord(void) { }
	
};

class DELPHICLASS TParPie;
class PASCALIMPLEMENTATION TParPie : public Param2d::TParArc 
{
	typedef Param2d::TParArc inherited;
	
public:
	virtual TParShape* __fastcall CreateInstance(void);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
public:
	/* TParArc.Create */ __fastcall TParPie(void) : Param2d::TParArc() { }
	
public:
	/* TParShape.Destroy */ __fastcall ~TParPie(void) { }
	
};

class DELPHICLASS TParPolyline;
class PASCALIMPLEMENTATION TParPolyline : public Param2d::TParShape 
{
	typedef Param2d::TParShape inherited;
	
private:
	Classes::TStrings* FX;
	Classes::TStrings* FY;
	
protected:
	virtual void __fastcall SetString(const System::AnsiString Value);
	virtual System::AnsiString __fastcall GetString();
	
public:
	__fastcall TParPolyline(void);
	virtual TParShape* __fastcall CreateInstance(void);
	__fastcall ~TParPolyline(void);
	virtual double __fastcall GetVal(const System::AnsiString name);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
	virtual void __fastcall GetExt(double &minx, double &miny, double &maxx, double &maxy);
};

class DELPHICLASS TParPolygon;
class PASCALIMPLEMENTATION TParPolygon : public Param2d::TParPolyline 
{
	typedef Param2d::TParPolyline inherited;
	
public:
	virtual TParShape* __fastcall CreateInstance(void);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
public:
	/* TParPolyline.Create */ __fastcall TParPolygon(void) : Param2d::TParPolyline() { }
	/* TParPolyline.Destroy */ __fastcall ~TParPolygon(void) { }
	
};

class DELPHICLASS TParText;
class PASCALIMPLEMENTATION TParText : public Param2d::TParShape 
{
	typedef Param2d::TParShape inherited;
	
private:
	System::SmallString<2>  FAl;
	System::AnsiString FX;
	System::AnsiString FY;
	System::AnsiString FFmt;
	System::AnsiString FVal;
	
protected:
	virtual void __fastcall SetString(const System::AnsiString Value);
	virtual System::AnsiString __fastcall GetString();
	
public:
	__fastcall TParText(void);
	virtual TParShape* __fastcall CreateInstance(void);
	virtual double __fastcall GetVal(const System::AnsiString name);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
	virtual void __fastcall GetExt(double &minx, double &miny, double &maxx, double &maxy);
public:
	/* TParShape.Destroy */ __fastcall ~TParText(void) { }
	
};

class DELPHICLASS TParDim;
class PASCALIMPLEMENTATION TParDim : public Param2d::TParShape 
{
	typedef Param2d::TParShape inherited;
	
private:
	char FA;
	System::AnsiString FX1;
	System::AnsiString FY1;
	System::AnsiString FX2;
	System::AnsiString FY2;
	System::AnsiString FGL;
	System::AnsiString FFmt;
	double m_dx[5];
	double m_dy[5];
	double m_dw;
	
protected:
	virtual void __fastcall SetString(const System::AnsiString Value);
	virtual System::AnsiString __fastcall GetString();
	
public:
	__fastcall TParDim(void);
	virtual TParShape* __fastcall CreateInstance(void);
	virtual double __fastcall GetVal(const System::AnsiString name);
	virtual void __fastcall Draw(TParView* v);
	virtual bool __fastcall IsCrossing(Windows::TRect &r, TParView* v);
	virtual void __fastcall GetExt(double &minx, double &miny, double &maxx, double &maxy);
public:
	/* TParShape.Destroy */ __fastcall ~TParDim(void) { }
	
};

class PASCALIMPLEMENTATION TParView : public Controls::TGraphicControl 
{
	typedef Controls::TGraphicControl inherited;
	
private:
	Graphics::TPen* FSelPen;
	TParModel* FParModel;
	double FOrgX;
	double FOrgY;
	double FZoom;
	Graphics::TColor FGridColor;
	double FGridMajor;
	double FGridMinor;
	void __fastcall SetSelPen(Graphics::TPen* Value);
	void __fastcall SetModel(TParModel* Value);
	void __fastcall SetGridMajor(double Value);
	void __fastcall SetGridMinor(double Value);
	void __fastcall SetGridColor(Graphics::TColor Value);
	
protected:
	virtual void __fastcall DrawCS(void);
	virtual void __fastcall DrawGrid(void);
	virtual void __fastcall Draw(void);
	virtual void __fastcall DrawFast(void);
	
public:
	virtual void __fastcall Paint(void);
	__fastcall virtual TParView(Classes::TComponent* AOwner);
	__fastcall virtual ~TParView(void);
	void __fastcall SetOrgX(double Value);
	void __fastcall SetOrgY(double Value);
	void __fastcall SetOrg(double x, double y);
	void __fastcall SetZoom(double Value);
	int __fastcall GetViewX(double dx);
	int __fastcall GetViewY(double dy);
	double __fastcall GetPaperX(int x);
	double __fastcall GetPaperY(int y);
	void __fastcall SelWindow(Windows::TRect &r);
	void __fastcall SelCross(Windows::TRect &r);
	System::AnsiString __fastcall SelSingle(tagPOINT &p);
	void __fastcall SelPoint(tagPOINT &p);
	void __fastcall ZoomAll(void);
	__property Canvas ;
	
__published:
	__property Width ;
	__property Height ;
	__property Color ;
	__property Align ;
	__property DragCursor ;
	__property DragMode ;
	__property Font ;
	__property ParentColor ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property PopupMenu ;
	__property ShowHint ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property Graphics::TPen* SelPen = {read=FSelPen, write=SetSelPen};
	__property TParModel* Model = {read=FParModel, write=SetModel};
	__property double OrgX = {read=FOrgX, write=SetOrgX};
	__property double OrgY = {read=FOrgY, write=SetOrgY};
	__property double Zoom = {read=FZoom, write=SetZoom};
	__property double GridMajor = {read=FGridMajor, write=SetGridMajor};
	__property double GridMinor = {read=FGridMinor, write=SetGridMinor};
	__property Graphics::TColor GridColor = {read=FGridColor, write=SetGridColor, nodefault};
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Param2d */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Param2d;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// Param2d
