unit MAUSHtmU;

{ Author: maussoft
          The program is given as is, without any warranties }
interface

uses
  Windows, Messages, SysUtils,  Classes, Graphics, Controls, Forms,
  Dialogs, FileCtrl, StdCtrls, Buttons, ExtCtrls, ComCtrls;

type
  THtmU = class(TForm)

    SaveDialog       : TSaveDialog;

    Panel1           : TPanel;
    Panel2           : TPanel;

    FileListBox      : TFileListBox;
    DirectoryListBox : TDirectoryListBox;

    Memo1            : TRichEdit;
    Memo2            : TRichEdit;

    LinkBtn          : TSpeedButton;
    RunBtn           : TSpeedButton;
    SaveBtn          : TSpeedButton;
    SelBtn           : TSpeedButton;
    SoloBtn          : TSpeedButton;
    BookBtn          : TSpeedButton;   

    procedure FormCreate  (Sender: TObject);
    procedure FormDestroy (Sender: TObject);
    procedure RunBtnClick (Sender: TObject);
    procedure SelBtnClick (Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
  end;

var
  HtmU  : THtmU;
  ListO : TStrings;

implementation

{$R *.dfm}

procedure THtmU.FormCreate(Sender: TObject);
begin
  ListO := TStringList.Create;
end;

procedure THtmU.FormDestroy(Sender: TObject);
begin
  ListO.Free;
end;

// create Index ----------------------------------------------------------------

procedure THtmU.RunBtnClick(Sender: TObject);
var
  List, List1, List2 : TStringList;
  f, i, n, p, x, y   : Integer;
  FlagHead, FlagTopic,FlagMulti, FlagWas : Boolean;
  Title, Name, Link, Link1, Tag, NewName, OldName, OneName, s, t  : string;
  s7   : string[7];
  s8   : string[8];
  BL8  : string[8];
  B16  : string[16];
  B24  : string[24];

begin
  BL8   := '        ';
  B16   := BL8 + BL8;
  B24   := B16 + BL8;
  List  := TStringList.Create;
  List1 := TStringList.Create;
  List2 := TStringList.Create;
  List1.Sorted  := True;
  List2.Sorted  := True;
  Screen.Cursor := crHourGlass;
  Memo2.Enabled := False;
  SaveDialog.InitialDir := FileListBox.Directory;

  try   // for finally
//---                        // for all .htm. files ============================
  for f := 0 to FileListBox.Items.Count -1 do
  if FileListBox.Selected[f]             then
  begin
    Memo1.Lines.LoadFromFile(FileListBox.Items[f]);
  //------------------------

  { p := 25;                           // Delete Generator + ProgID. -----------
    if Memo1.Lines.Count < 25 then     // ==========================
       p := Memo1.Lines.Count;
    for i := p downto 0 do
    begin
      if Pos('META NAME="PROGID"', Uppercase(Memo1.Lines[i])) > 0 then
         Memo1.Lines.Delete(i)
      else
        if Pos('META NAME="GENERATOR"', Uppercase(Memo1.Lines[i])) > 0 then
        begin
          Memo1.Lines.Delete(i);
          Memo1.Lines.SaveToFile(FileListBox.Items[f]);
        //----------------------
          break;
        end;
    end;                   }

    i        := 0;
    Title    := '';
    t        := Memo1.Text;
    Link     := ExtractFileName(FileListBox.Items[f]);
    FlagHead := False;

    if LinkBtn.Down then                  // all Files in List2 for Link-Check
       List2.Add(Uppercase(Link));        // =================================

    while i < Length(t) do             // one file repeat
    begin                              // ===============
      i := i + 1;

      if t[i] = '<' then                  // '<' only is relevant
      begin
        s8 := Copy(t, i, 8);
        s7 := s8;

        if Lowercase(s7) = '<title>' then // Title
        begin
          s := Copy(t, i+7, 100);
          p := Pos('</title>', Lowercase(s));
          if p > 0 then
          begin
            Delete(s, p, 100);
            Title := s;
          end;
        end;

        if LinkBtn.Down then       // Links - only for Check -------------------
        begin                      // for example: <A HREF="Topic.htm#Bookmark">
          if Lowercase(s8) = '<a href=' then
          begin
            s := Copy(t, i+9, 150);         // Get Link
            p := Pos('>', s);

            if p > 0 then
            begin
              if Uppercase(Copy(s, 1, 4)) <> '#TOP' then   // no #Top's
              begin
                if s[1]   = '#' then
                   Link1 := Link + Copy(s, 1, p-2)
                else
                   Link1 := Copy(s, 1, p-2);
                 Link1 := Link + '--->' + Link1;
                 List1.Add(Uppercase(Link1));  // in List1
               end;
            end;
          end;
        end;

        Tag  := '';
        Name := '';                    // Bookmarks ----------------------------
        if Lowercase(s8) = '<a name=' then// for example: <A NAME="key">key</A>
        begin
          s := Copy(t, i+9, 150);         // Get Bookmark
          p := Pos('>', s);

          if p > 0 then
          begin
            Tag := '#' + Copy(s, 1, p-2);    // #Bookmark

            if LinkBtn.Down then             // in List2 for Link-Check
               List2.Add(Uppercase(Link + Tag));

            s   := Copy(s, p+1, 150);     // Get Name
            p   := Pos('</a>', Lowercase(s));

            if p > 0 then
            begin
              Delete(s, p, 150);
                                             // Names clean it -------
              x := 999;                         // CR/LF
              while x > 0 do
              begin
                x := Pos(#13, s);
                if x > 0 then
                   Delete(s, x, 1);
                x := Pos(#10, s);
                if x > 0 then
                   s[x] := ' ';
              end;

              x := 999;                         // all <..>
              while x > 0 do
              begin
                x := Pos('<', s);
                if x > 0 then
                begin
                  s[x] := '!';                     // set of done
                  y := Pos('>', s);
                  if y > 0 then
                     Delete(s, x, y-x+1);
                end;
              end;

              x := Pos('&quot;', Lowercase(s)); // &quot; do it 2 times
              if x > 0 then
              begin
                s[x] := '"';
                Delete(s, x+1, 5);
              end;
              x := Pos('&quot;', Lowercase(s));
              if x > 0 then
              begin
                s[x] := '"';
                Delete(s, x+1, 5);
              end;

              x := Pos('&nbsp;', Lowercase(s)); // &nbsp; do it 3 times
              if x > 0 then
              begin
                s[x] := ' ';
                Delete(s, x+1, 5);
              end;
              x := Pos('&nbsp;', Lowercase(s));
              if x > 0 then
              begin
                s[x] := ' ';
                Delete(s, x+1, 5);
              end;
              x := Pos('&nbsp;', Lowercase(s));
              if x > 0 then
              begin
                s[x] := ' ';
                Delete(s, x+1, 5);
              end;

              Name := s;                     // Name
            end;
          end;

          if (SoloBtn.Down)   or          // W a n t ?
             (BookBtn.Down) then
          begin
            if Name > '' then             // Name is there
            begin                         // #14= for Topic + #15 solo #Bookmark
              if Title  = '' then
              begin
                Title := Link;
                x := Pos('.', Title);
                if x > 0 then
                   Delete(Title, x, 10);
              end;

              if not FlagHead then          // Topic Title one times
                 List.Add(Title + ' >' + #14 + '   ' + B16  + #16 + Link + #17);
              FlagHead := True;

              if SoloBtn.Down then          // solo Bookmark #15
                 List.Add(Name + #15 + '   ' + Title + #16 + Link + #17 + Tag);

              if BookBtn.Down then          // Topic/Bookmark #14
                 List.Add(Title + ' >' + #14 + '   ' + Name + #16 + Link + #17 + Tag);
            end;
          end;
          i := i + p + 3;
        end;
      end;
    end;
  end;

  List.Sort;                      // S O R T
//---------                       // -------

  for f := 0 to List.Count -1 do  // look all - for multi defined Bookmarks ----
  begin
    s := List[f];
    i := Pos(#15, s);                          // Select solo Bookmark
    if i > 0 then
    begin
      Name := Copy(s, 1, i-1);

      if f < List.Count -1 then                  // wegen last item
      begin
        p := Pos(#15, List[f+1]);
        if p  = 0 then
           p := Pos(#14, List[f+1]);
        if p > 0 then
           NewName := Copy(List[f+1], 1, p-1);   // new Name is next Item
        if NewName  = Name then
           OldName := Name;
      end;

      if Name = OldName then                     // more as one same Name
      begin
        s[i]    := #18;                             // set of multi #18
        List[f] := s;
      end;
    end;
  end;

  Memo2.Clear;                    // in stringlist -----------------------------
  ListO.Clear;

  ListO.Add('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">');
  ListO.Add('<HTML>');
  ListO.Add('<HEAD>');
  ListO.Add('<meta name="GENERATOR" ' +
                  'content="maussoft Creator for HTML-Help Index.hhk">');
  ListO.Add('<!-- Sitemap 1.0 -->');
  ListO.Add('</HEAD>');
  ListO.Add('');
  ListO.Add('<BODY>');
  ListO.Add('<OBJECT type="text/site properties">');
  ListO.Add('   <param name="FrameName" value="Main">');        // <-- Frame
  ListO.Add('   <param name="Font" value="MS Sans Serif,8,0">');// <-- Font
  ListO.Add('</OBJECT>');
  ListO.Add('<UL>');

  OneName := '$%$';
  FlagWas := False;
  n       := 0;

  for f := 0 to List.Count -1 do            // Edit in Memo
  begin
    FlagTopic := False;
    FlagMulti := False;

    i := Pos(#14, List[f]);                    // is Topic #14
    if i > 0 then
       FlagTopic := True
    else
    begin
      i := Pos(#18, List[f]);                  // is multi Bookmark #18
      if i > 0 then
         FlagMulti := True
      else
         i := Pos(#15, List[f]);               // is solo Bookmark #15
    end;
    if i > 0 then
       Name  := Copy(List[f], 1, i-1);
    if Name  = '- ' then                       // Korrektur '- ' ?
       Name := '-';
    p     := Pos(#16, List[f]);
    Title := Copy(List[f], i+4, p-i-4);        // 4 because 3 Blank
    i     := Pos(#17, List[f]);
    Link  := Copy(List[f], p+1, i-p-1);
    Tag   := Copy(List[f], i+1, 100);

    if FlagTopic then                       // Topics
    begin                                   // ======
      OneName := '$%$';                        // for group_change
      if Title = B16 then
      begin
        if FlagWas then
           ListO.Add(Bl8 + '</UL>');
        FlagWas := False;                       // title ' ' is Topic-Header
        ListO.Add(Bl8 + '<LI> <OBJECT type="text/sitemap">');
        ListO.Add(B16 + '<param name="Name" value="'  + Name + '">');//' >">');
        ListO.Add(B16 + '<param name="Name" value="'  + Name + '">');                            // for Topic Header
        ListO.Add(B16 + '<param name="Local" value="' + Link + '">');
        ListO.Add(B16 + '</OBJECT>');
        if BookBtn.Down then
           ListO.Add(Bl8 + '<UL>');
        n := n + 1;
      end
      else
      begin
        FlagWas := True;                        // and there Bookmarks
        ListO.Add(B16 + '<LI> <OBJECT type="text/sitemap">');
        ListO.Add(B24 + '<param name="Name" value="'  + Title + '">');
        ListO.Add(B24 + '<param name="Name" value="'  + Name  + '">');
        ListO.Add(B24 + '<param name="Local" value="' + Link  + Tag + '">');
        ListO.Add(B24 + '</OBJECT>');
        n := n + 1;
      end;
    end
    else
      if FlagMulti then                     // multi Bookmarks(generate from solo)
      begin                                 // ===============
        if Name <> OneName then                // one times create Header
        begin
          OneName := Name;
          if FlagWas then
             ListO.Add(Bl8 + '</UL>');         // this them Bookmark
          ListO.Add(Bl8 + '<LI> <OBJECT type="text/sitemap">');
          ListO.Add(B16 + '<param name="Name" value="'     + Name + '">');
          ListO.Add(B16 + '<param name="Name" value="'     + Name + '">');                            // for Topic Header
          ListO.Add(B16 + '<param name="See Also" value="' + Name + '">');
          ListO.Add(B16 + '</OBJECT>');
          ListO.Add(Bl8 + '<UL>');
          n := n + 1;
        end;
        FlagWas := True;                        // is in all these Topics
        ListO.Add(B16 + '<LI> <OBJECT type="text/sitemap">'); //change T <--> B
        ListO.Add(B24 + '<param name="Name" value="'  + Title + '">');
        ListO.Add(B24 + '<param name="Name" value="'  + Name  + '">');
        ListO.Add(B24 + '<param name="Local" value="' + Link  + Tag + '">');
        ListO.Add(B24 + '</OBJECT>');
        n := n + 1;
      end
      else
      begin                                 // solo Bookmarks (was not multi)
        OneName := '$%$';                   // ==============
        if FlagWas then
           ListO.Add(Bl8 + '</UL>');
        FlagWas := False;
        ListO.Add(Bl8 + '<LI> <OBJECT type="text/sitemap">');
        ListO.Add(B16 + '<param name="Name" value="'  + Name  + '">');
        ListO.Add(B16 + '<param name="Name" value="'  + Title + '">');
        ListO.Add(B16 + '<param name="Local" value="' + Link  + Tag + '">');
        ListO.Add(B16 + '</OBJECT>');
        n := n + 1;
      end;
  end;

  if List.Count > 0 then
  begin
    if FlagWas then
       ListO.Add(Bl8 + '</UL>');
    ListO.Add('</UL>');               // Ende
    ListO.Add('</BODY>');
    ListO.Add('</HTML>');
    ListO.Insert(4, '<meta name="COUNT OF INDICES" content="' +
                     IntToStr(n) + '">');
    Memo2.Lines.Add('<meta name="COUNT OF INDICES" content="' +
                     IntToStr(n) + '">');
  end;

  if LinkBtn.Down then            // Check Hyperlinks with Bookmarks -----------
  begin
    Memo2.Lines.Add(' ');
    Memo2.Lines.Add('Result from Hyperlink Check:');
    for i := 0 to List1.Count -1 do
    begin
      s := List1[i];
      p := Pos('--->', s);
      s := Copy(s, p+4, Length(s)-p-3);
      if List2.IndexOf(s) = -1 then
         Memo2.Lines.Add(List1[i]);
    end;
  end;

  finally
    Screen.Cursor := crDefault;
    Memo2.Enabled := True;
    List.Free;
    List1.Free;
    List2.Free;
  end;
end;

// toggle - Select all HTM.-files ----------------------------------------------

procedure THtmU.SelBtnClick(Sender: TObject);
var
  f : Integer;
begin
  for f := 0 to FileListBox.Items.Count -1 do
    if SelBtn.Down then
       FileListBox.Selected[f] := True
    else
       FileListBox.Selected[f] := False;
end;

// Save to - Index.HHK ---------------------------------------------------------

procedure THtmU.SaveBtnClick(Sender: TObject);
begin
  if SaveDialog.Execute then
     ListO.SaveToFile(SaveDialog.FileName);
end;

// End
end.



