{$INCLUDE ..\cDefines.inc}
unit cUtils;

{                                                                              }
{                    Miscellaneous utility functions v3.29                     }
{                                                                              }
{      This unit is copyright  2000-2002 by David Butler (david@e.co.za)      }
{                                                                              }
{                  This unit is part of Delphi Fundamentals.                   }
{                     Its original file name is cUtils.pas                     }
{                      It was generated 1 Nov 2002 19:28.                      }
{       The latest version is available from the Fundamentals home page        }
{                     http://fundementals.sourceforge.net/                     }
{                                                                              }
{                I invite you to use this unit, free of charge.                }
{        I invite you to distibute this unit, but it must be for free.         }
{             I also invite you to contribute to its development,              }
{             but do not distribute a modified copy of this file.              }
{                                                                              }
{          A forum is available on SourceForge for general discussion          }
{             http://sourceforge.net/forum/forum.php?forum_id=2117             }
{                                                                              }
{                                                                              }
{ Revision history:                                                            }
{   2000/02/02  v0.01  Initial version                                         }
{   2000/03/08  v1.02  Moved RealArray / IntegerArray functions from cMaths.   }
{   2000/04/10  v1.03  Added Append, Renamed Delete to Remove and added        }
{                      StringArrays.                                           }
{   2000/05/03  v1.04  Added Path functions.                                   }
{                      Added locked integer manipulation functions.            }
{   2000/05/08  v1.05  Cleaned up unit.                                        }
{                      188 lines interface. 1171 lines implementation.         }
{   2000/06/01  v1.06  Added Range and Dup constructors for dynamic arrays.    }
{   2000/06/03  v1.07  Added ArrayInsert functions.                            }
{   2000/06/06  v1.08  Moved bit functions from cMaths.                        }
{   2000/06/08  v1.09  Removed TInteger, TReal, TRealArray, TIntegerArray.     }
{                      299 lines interface. 2019 lines implementations.        }
{   2000/06/10  v1.10  Added linked lists for Integer, Int64, Extended and     }
{                      String.                                                 }
{                      518 lines interface. 3396 lines implementation.         }
{   2000/06/14  v1.11  cUtils now generated from a template using a source     }
{                      pre-processor that uses cUtils.                         }
{                      560 lines interface. 1328 lines implementation.         }
{                      Produced source: 644 lines interface, 4716 lines        }
{                      implementation.                                         }
{   2000/07/04  v1.12  Revision for Fundamentals release.                      }
{   2000/07/24  v1.13  Added TrimArray functions.                              }
{   2000/07/26  v1.14  Added Difference functions.                             }
{   2000/09/02  v1.15  Added RemoveDuplicates functions.                       }
{                      Added Count functions.                                  }
{                      Fixed bug in Sort.                                      }
{   2000/09/27  v1.16  Fixed bug in ArrayInsert.                               }
{   2000/11/29  v1.17  Moved SetFPUPrecision to cSysUtils.                     }
{   2001/05/03  v1.18  Improved bit functions. Added Pascal versions of        }
{                      assembly routines.                                      }
{                      Templ: 867 lines interface, 2886 lines implementation.  }
{                      Source: 939 lines interface, 9796 lines implementation. }
{   2001/05/13  v1.19  Added CharCount.                                        }
{   2001/05/15  v1.20  Added PosNext (ClassType, ObjectArray).                 }
{   2001/05/18  v1.21  Added hashing functions from cMaths.                    }
{   2001/07/07  v1.22  Added TBinaryTreeNode.                                  }
{   2001/11/11  v2.23  Revision.                                               }
{   2002/01/03  v2.24  Moved EncodeBase64, DecodeBase64 from cMaths and        }
{                      optimized. Added LongWordToHex, HexToLongWord.          }
{   2002/03/30  v2.25  Fixed bug in DecodeBase64.                              }
{   2002/04/02  v2.26  Removed dependencies on all other units (incl. Delphi   )
{                      units) to remove initialization code associated with    }
{                      SysUtils. This allows usage of cUtils in projects       }
{                      and still have very small binaries.                     }
{                      Fixed bug in LongWordToHex.                             }
{   2002/05/31  v3.27  Refactored for Fundamentals 3.                          }
{                      Moved linked lists to cLinkedLists.                     }
{   2002/08/09  v3.28  Added HashInteger.                                      }
{   2002/10/06  v3.29  Renamed Cond to iif.                                    }
{                                                                              }
interface

const
  UnitName      = 'cUtils';
  UnitVersion   = '3.29';
  UnitDesc      = 'Miscelleanous utility functions';
  UnitCopyright = '(c) 2000-2002 David J Butler';



{                                                                              }
{ Integer types                                                                }
{   Byte      unsigned 8 bits                                                  }
{   Word      unsigned 16 bits                                                 }
{   LongWord  unsigned 32 bits                                                 }
{   ShortInt  signed 8 bits                                                    }
{   SmallInt  signed 16 bits                                                   }
{   LongInt   signed 32 bits                                                   }
{   Int64     signed 64 bits                                                   }
{   Integer   signed system word                                               }
{   Cardinal  unsigned system word                                             }
{                                                                              }
type
  Int8  = ShortInt;
  Int16 = SmallInt;
  Int32 = LongInt;

  {$IFNDEF DELPHI6_UP}
  PBoolean  = ^Boolean;
  PByte     = ^Byte;
  PWord     = ^Word;
  PLongWord = ^LongWord;
  PShortInt = ^ShortInt;
  PSmallInt = ^SmallInt;
  PLongInt  = ^LongInt;
  PInteger  = ^Integer;
  PInt64    = ^Int64;
  {$ENDIF}

const
  MinByte     = Low (Byte);
  MaxByte     = High (Byte);
  MinWord     = Low (Word);
  MaxWord     = High (Word);
  MinLongWord = Low (LongWord);
  MaxLongWord = High (LongWord);
  MinShortInt = Low (ShortInt);
  MaxShortInt = High (ShortInt);
  MinSmallInt = Low (SmallInt);
  MaxSmallInt = High (SmallInt);
  MinLongInt  = Low (LongInt);
  MaxLongInt  = High (LongInt);
  MaxInt64    = High (Int64);
  MinInt64    = Low (Int64);
  MinInteger  = Low (Integer);
  MaxInteger  = High (Integer);
  MinCardinal = Low (Cardinal);
  MaxCardinal = High (Cardinal);

  BitsPerByte      = 8;
  BitsPerWord      = 16;
  BitsPerLongWord  = 32;
  BytesPerCardinal = Sizeof (Cardinal);
  BitsPerCardinal  = BytesPerCardinal * 8;

Function  MinI (const A, B : Integer) : Integer;
Function  MaxI (const A, B : Integer) : Integer;

Function  Clip (const Value : Integer; const Low, High : Integer) : Integer; overload;
Function  ClipByte (const Value : Integer) : Integer;
Function  ClipWord (const Value : Integer) : Integer;

Function  RangeAdjacent (const Low1, High1, Low2, High2 : Integer) : Boolean;
Function  RangeOverlap (const Low1, High1, Low2, High2 : Integer) : Boolean;



{                                                                              }
{ Floating point types                                                         }
{   Single    32 bits                                                          }
{   Double    64 bits                                                          }
{   Extended  80 bits                                                          }
{                                                                              }
const
  MinSingle   = 1.5E-45;
  MaxSingle   = 3.4E+38;
  MinDouble   = 5.0E-324;
  MaxDouble   = 1.7E+308;
  MinExtended = 3.4E-4932;
  MaxExtended = 1.1E+4932;

{$IFNDEF DELPHI6_UP}
type
  PSingle   = ^Single;
  PDouble   = ^Double;
  PExtended = ^Extended;
{$ENDIF}

{ Approximate comparison functions                                             }
type
  TCompareResult = (crLess,          // <
                    crEqual,         // =
                    crGreater,       // >
                    crUndefined);
  TCompareResultSet = Set of TCompareResult;

const
  DefaultCompareEpsilon = 1E-9;

Function  ApproxZero (const Value : Extended; const CompareEpsilon : Double = DefaultCompareEpsilon) : Boolean;
Function  ApproxEqual (const A, B : Extended; const CompareEpsilon : Double = DefaultCompareEpsilon) : Boolean;
Function  ApproxCompare (const A, B : Extended; const CompareEpsilon : Double = DefaultCompareEpsilon) : TCompareResult;



{                                                                              }
{ Bit functions                                                                }
{   All bit functions work on 32-bit values (LongWord).                        }
{                                                                              }
Function  ClearBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
Function  SetBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
Function  IsBitSet (const Value : LongWord; const BitIndex : LongWord) : Boolean;
Function  ToggleBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
Function  IsHighBitSet (const Value : LongWord) : Boolean;

Function  SetBitScanForward (const Value : LongWord) : Integer; overload;
Function  SetBitScanForward (const Value : LongWord; const StartBitIndex : LongWord) : Integer; overload;
Function  SetBitScanReverse (const Value : LongWord) : Integer; overload;
Function  SetBitScanReverse (const Value : LongWord; const StartBitIndex : LongWord) : Integer; overload;
Function  ClearBitScanForward (const Value : LongWord) : Integer; overload;
Function  ClearBitScanForward (const Value : LongWord; const StartBitIndex : LongWord) : Integer; overload;
Function  ClearBitScanReverse (const Value : LongWord) : Integer; overload;
Function  ClearBitScanReverse (const Value : LongWord; const StartBitIndex : LongWord) : Integer; overload;

Function  ReverseBits (const Value : LongWord) : LongWord; overload;
Function  ReverseBits (const Value : LongWord; const BitCount : Integer) : LongWord; overload;
Function  SwapEndian (const Value : LongWord) : LongWord;
Procedure SwapEndianBuf (var Buf; const Count : Integer);
Function  TwosComplement (const Value : LongWord) : LongWord;

Function  RotateLeftBits (const Value : LongWord; const Bits : Byte) : LongWord;
Function  RotateRightBits (const Value : LongWord; const Bits : Byte) : LongWord;

Function  BitCount (const Value : LongWord) : LongWord;
Function  IsPowerOfTwo (const Value : LongWord) : Boolean;

Function  LowBitMask (const HighBitIndex : LongWord) : LongWord;
Function  HighBitMask (const LowBitIndex : LongWord) : LongWord;
Function  RangeBitMask (const LowBitIndex, HighBitIndex : LongWord) : LongWord;

Function  SetBitRange (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : LongWord;
Function  ClearBitRange (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : LongWord;
Function  ToggleBitRange (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : LongWord;
Function  IsBitRangeSet (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : Boolean;
Function  IsBitRangeClear (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : Boolean;

const
  BitMaskTable : array [0..31] of LongWord =
    ($00000001, $00000002, $00000004, $00000008, $00000010, $00000020, $00000040, $00000080,
     $00000100, $00000200, $00000400, $00000800, $00001000, $00002000, $00004000, $00008000,
     $00010000, $00020000, $00040000, $00080000, $00100000, $00200000, $00400000, $00800000,
     $01000000, $02000000, $04000000, $08000000, $10000000, $20000000, $40000000, $80000000);



{                                                                              }
{ Sets                                                                         }
{                                                                              }
type
  CharSet = Set of Char;
  ByteSet = Set of Byte;
  PCharSet = ^CharSet;
  PByteSet = ^ByteSet;

const
  CompleteCharSet = [#0..#255];
  CompleteByteSet = [0..255];

Function  AsCharSet (const C : Array of Char) : CharSet;
Function  AsByteSet (const C : Array of Byte) : ByteSet;
Procedure ComplementChar (var C : CharSet; const Ch : Char);
Procedure ClearCharSet (var C : CharSet);
Procedure FillCharSet (var C : CharSet);
Procedure ComplementCharSet (var C : CharSet);
Procedure AssignCharSet (var DestSet : CharSet; const SourceSet : CharSet); overload;
Procedure Union (var DestSet : CharSet; const SourceSet : CharSet); overload;
Procedure Difference (var DestSet : CharSet; const SourceSet : CharSet); overload;
Procedure Intersection (var DestSet : CharSet; const SourceSet : CharSet); overload;
Procedure XORCharSet (var DestSet : CharSet; const SourceSet : CharSet);
Function  IsSubSet (const A, B : CharSet) : Boolean;
Function  IsEqual (const A, B : CharSet) : Boolean; overload;
Function  IsEmpty (const C : CharSet) : Boolean;
Function  IsComplete (const C : CharSet) : Boolean;
Function  CharCount (const C : CharSet) : Integer; overload;
Procedure ConvertCaseInsensitive (var C : CharSet);
Function  CaseInsensitiveCharSet (const C : CharSet) : CharSet;



{                                                                              }
{ Swap                                                                         }
{                                                                              }
Procedure Swap (var X, Y : Boolean); overload;
Procedure Swap (var X, Y : Byte); overload;
Procedure Swap (var X, Y : Word); overload;
Procedure Swap (var X, Y : LongWord); overload;
Procedure Swap (var X, Y : ShortInt); overload;
Procedure Swap (var X, Y : SmallInt); overload;
Procedure Swap (var X, Y : LongInt); overload;
Procedure Swap (var X, Y : Int64); overload;
Procedure Swap (var X, Y : Single); overload;
Procedure Swap (var X, Y : Double); overload;
Procedure Swap (var X, Y : Extended); overload;
Procedure Swap (var X, Y : String); overload;
Procedure Swap (var X, Y : Pointer); overload;
Procedure Swap (var X, Y : TObject); overload;
Procedure SwapObjects (var X, Y);



{                                                                              }
{ iif                                                                          }
{   iif (inline if) returns TrueValue if Expr is True, otherwise it returns    }
{   FalseValue.                                                                }
{                                                                              }
Function  iif (const Expr : Boolean; const TrueValue : LongWord; const FalseValue : LongWord = 0) : LongWord; overload;
Function  iif (const Expr : Boolean; const TrueValue : Int64; const FalseValue : Int64 = 0) : Int64; overload;
Function  iif (const Expr : Boolean; const TrueValue : Single; const FalseValue : Single = 0.0) : Single; overload;
Function  iif (const Expr : Boolean; const TrueValue : Double; const FalseValue : Double = 0.0) : Double; overload;
Function  iif (const Expr : Boolean; const TrueValue : Extended; const FalseValue : Extended = 0.0) : Extended; overload;
Function  iif (const Expr : Boolean; const TrueValue : String; const FalseValue : String = '') : String; overload;
Function  iif (const Expr : Boolean; const TrueValue : Pointer; const FalseValue : Pointer = nil) : Pointer; overload;
Function  iif (const Expr : Boolean; const TrueValue : TObject; const FalseValue : TObject = nil) : TObject; overload;



{                                                                              }
{ Compare                                                                      }
{                                                                              }
Function  Compare (const I1, I2 : Boolean) : TCompareResult; overload;
Function  Compare (const I1, I2 : Integer) : TCompareResult; overload;
Function  Compare (const I1, I2 : Int64) : TCompareResult; overload;
Function  Compare (const I1, I2 : Single) : TCompareResult; overload;
Function  Compare (const I1, I2 : Double) : TCompareResult; overload;
Function  Compare (const I1, I2 : Extended) : TCompareResult; overload;
Function  Compare (const I1, I2 : String) : TCompareResult; overload;
Function  Compare (const I1, I2 : TObject) : TCompareResult; overload;
Function  NegatedCompareResult (const C : TCompareResult) : TCompareResult;



{                                                                              }
{ Base Conversion                                                              }
{   EncodeBase64 converts a binary string (S) to a base 64 string using        }
{   Alphabet. if Pad is True, the result will be padded with PadChar to be a   }
{   multiple of PadMultiple.                                                   }
{   DecodeBase64 converts a base 64 string using Alphabet (64 characters for   }
{   values 0-63) to a binary string.                                           }
{                                                                              }
const
  s_HexDigitsUpper : String [16] = '0123456789ABCDEF';
  s_HexDigitsLower : String [16] = '0123456789abcdef';

Function  HexCharValue (const Ch : Char) : Byte;

Function  LongWordToBin (const I : LongWord; const Digits : Byte = 0) : String;
Function  LongWordToOct (const I : LongWord; const Digits : Byte = 0) : String;
Function  LongWordToHex (const I : LongWord; const Digits : Byte = 0) : String;
Function  LongWordToStr (const I : LongWord; const Digits : Byte = 0) : String;

Function  BinToLongWord (const S : String) : LongWord;
Function  OctToLongWord (const S : String) : LongWord;
Function  HexToLongWord (const S : String) : LongWord;
Function  StrToLongWord (const S : String) : LongWord;

Function  EncodeBase64 (const S, Alphabet : String; const Pad : Boolean = False;
          const PadMultiple : Integer = 4; const PadChar : Char = '=') : String;
Function  DecodeBase64 (const S, Alphabet : String; const PadSet : CharSet = []) : String;

const
  b64_MIMEBase64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  b64_UUEncode   = ' !"#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_';
  b64_XXEncode   = '+-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';

Function  MIMEBase64Decode (const S : String) : String;
Function  MIMEBase64Encode (const S : String) : String;
Function  UUDecode (const S : String) : String;
Function  XXDecode (const S : String) : String;

Function  BytesToHex (const P : Pointer; const Count : Integer) : String;



{                                                                              }
{ Type conversion                                                              }
{                                                                              }
Function  PointerToStr (const P : Pointer) : String;
Function  StrToPointer (const S : String) : Pointer;
Function  ObjectClassName (const O : TObject) : String;
Function  ClassClassName (const C : TClass) : String;
Function  ObjectToStr (const O : TObject) : String;
Function  ClassToStr (const C : TClass) : String;
Function  CharSetToStr (const C : CharSet) : String;
Function  StrToCharSet (const S : String) : CharSet;



{                                                                              }
{ Hash functions                                                               }
{                                                                              }
Function  HashBuf (const Buf; const BufSize : Integer;
          const Slots : LongWord = 0) : LongWord;
Function  HashStr (const StrBuf : Pointer; const StrLength : Integer;
          const Slots : LongWord = 0; const CaseSensitive : Boolean = True) : LongWord; overload;
Function  HashStr (const S : String; const Slots : LongWord = 0;
          const CaseSensitive : Boolean = True) : LongWord; overload;
Function  HashInteger (const I : Integer; const Slots : LongWord = 0) : LongWord;



{                                                                              }
{ Memory                                                                       }
{                                                                              }
Procedure MoveMem (const Source; var Dest; const Count : Integer);
Function  CompareMem (const Buf1; const Buf2; const Count : Integer) : Boolean;
Function  CompareMemNoCase (const Buf1; const Buf2; const Count : Integer) : Boolean;
Procedure ReverseMem (var Buf; const Size : Integer);



{                                                                              }
{ Dynamic Arrays                                                               }
{                                                                              }
type
  ByteArray = Array of Byte;
  WordArray = Array of Word;
  LongWordArray = Array of LongWord;
  ShortIntArray = Array of ShortInt;
  SmallIntArray = Array of SmallInt;
  LongIntArray = Array of LongInt;
  Int64Array = Array of Int64;
  SingleArray = Array of Single;
  DoubleArray = Array of Double;
  ExtendedArray = Array of Extended;
  StringArray = Array of String;
  PointerArray = Array of Pointer;
  ObjectArray = Array of TObject;
  BooleanArray = Array of Boolean;
  CharSetArray = Array of CharSet;
  ByteSetArray = Array of ByteSet;
  IntegerArray = LongIntArray;
  CardinalArray = LongWordArray;


Function  Append (var V : ByteArray; const R : Byte) : Integer; overload;
Function  Append (var V : WordArray; const R : Word) : Integer; overload;
Function  Append (var V : LongWordArray; const R : LongWord) : Integer; overload;
Function  Append (var V : ShortIntArray; const R : ShortInt) : Integer; overload;
Function  Append (var V : SmallIntArray; const R : SmallInt) : Integer; overload;
Function  Append (var V : LongIntArray; const R : LongInt) : Integer; overload;
Function  Append (var V : Int64Array; const R : Int64) : Integer; overload;
Function  Append (var V : SingleArray; const R : Single) : Integer; overload;
Function  Append (var V : DoubleArray; const R : Double) : Integer; overload;
Function  Append (var V : ExtendedArray; const R : Extended) : Integer; overload;
Function  Append (var V : StringArray; const R : String) : Integer; overload;
Function  Append (var V : BooleanArray; const R : Boolean) : Integer; overload;
Function  Append (var V : PointerArray; const R : Pointer) : Integer; overload;
Function  Append (var V : ObjectArray; const R : TObject) : Integer; overload;
Function  Append (var V : ByteSetArray; const R : ByteSet) : Integer; overload;
Function  Append (var V : CharSetArray; const R : CharSet) : Integer; overload;
Function  AppendByteArray (var V : ByteArray; const R : Array of Byte) : Integer; overload;
Function  AppendWordArray (var V : WordArray; const R : Array of Word) : Integer; overload;
Function  AppendCardinalArray (var V : CardinalArray; const R : Array of LongWord) : Integer; overload;
Function  AppendShortIntArray (var V : ShortIntArray; const R : Array of ShortInt) : Integer; overload;
Function  AppendSmallIntArray (var V : SmallIntArray; const R : Array of SmallInt) : Integer; overload;
Function  AppendIntegerArray (var V : IntegerArray; const R : Array of LongInt) : Integer; overload;
Function  AppendInt64Array (var V : Int64Array; const R : Array of Int64) : Integer; overload;
Function  AppendSingleArray (var V : SingleArray; const R : Array of Single) : Integer; overload;
Function  AppendDoubleArray (var V : DoubleArray; const R : Array of Double) : Integer; overload;
Function  AppendExtendedArray (var V : ExtendedArray; const R : Array of Extended) : Integer; overload;
Function  AppendStringArray (var V : StringArray; const R : Array of String) : Integer; overload;
Function  AppendPointerArray (var V : PointerArray; const R : Array of Pointer) : Integer; overload;
Function  AppendObjectArray (var V : ObjectArray; const R : Array of TObject) : Integer; overload;
Function  AppendCharSetArray (var V : CharSetArray; const R : Array of CharSet) : Integer; overload;
Function  AppendByteSetArray (var V : ByteSetArray; const R : Array of ByteSet) : Integer; overload;


Function  Remove (var V : ByteArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : WordArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : LongWordArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : ShortIntArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : SmallIntArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : LongIntArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : Int64Array; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : SingleArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : DoubleArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : ExtendedArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : StringArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : PointerArray; const Idx : Integer; const Count : Integer = 1) : Integer; overload;
Function  Remove (var V : ObjectArray; const Idx : Integer; const Count : Integer = 1;
          const FreeObjects : Boolean = False) : Integer; overload;

Procedure RemoveDuplicates (var V : ByteArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : WordArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : LongWordArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : ShortIntArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : SmallIntArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : LongIntArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : Int64Array; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : SingleArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : DoubleArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : ExtendedArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : StringArray; const IsSorted : Boolean); overload;
Procedure RemoveDuplicates (var V : PointerArray; const IsSorted : Boolean); overload;

Procedure TrimArrayLeft (var S : ByteArray; const TrimList : Array of Byte); overload;
Procedure TrimArrayLeft (var S : WordArray; const TrimList : Array of Word); overload;
Procedure TrimArrayLeft (var S : LongWordArray; const TrimList : Array of LongWord); overload;
Procedure TrimArrayLeft (var S : ShortIntArray; const TrimList : Array of ShortInt); overload;
Procedure TrimArrayLeft (var S : SmallIntArray; const TrimList : Array of SmallInt); overload;
Procedure TrimArrayLeft (var S : LongIntArray; const TrimList : Array of LongInt); overload;
Procedure TrimArrayLeft (var S : Int64Array; const TrimList : Array of Int64); overload;
Procedure TrimArrayLeft (var S : SingleArray; const TrimList : Array of Single); overload;
Procedure TrimArrayLeft (var S : DoubleArray; const TrimList : Array of Double); overload;
Procedure TrimArrayLeft (var S : ExtendedArray; const TrimList : Array of Extended); overload;
Procedure TrimArrayLeft (var S : StringArray; const TrimList : Array of String); overload;
Procedure TrimArrayLeft (var S : PointerArray; const TrimList : Array of Pointer); overload;

Procedure TrimArrayRight (var S : ByteArray; const TrimList : Array of Byte); overload;
Procedure TrimArrayRight (var S : WordArray; const TrimList : Array of Word); overload;
Procedure TrimArrayRight (var S : LongWordArray; const TrimList : Array of LongWord); overload;
Procedure TrimArrayRight (var S : ShortIntArray; const TrimList : Array of ShortInt); overload;
Procedure TrimArrayRight (var S : SmallIntArray; const TrimList : Array of SmallInt); overload;
Procedure TrimArrayRight (var S : LongIntArray; const TrimList : Array of LongInt); overload;
Procedure TrimArrayRight (var S : Int64Array; const TrimList : Array of Int64); overload;
Procedure TrimArrayRight (var S : SingleArray; const TrimList : Array of Single); overload;
Procedure TrimArrayRight (var S : DoubleArray; const TrimList : Array of Double); overload;
Procedure TrimArrayRight (var S : ExtendedArray; const TrimList : Array of Extended); overload;
Procedure TrimArrayRight (var S : StringArray; const TrimList : Array of String); overload;
Procedure TrimArrayRight (var S : PointerArray; const TrimList : Array of Pointer); overload;

Function  ArrayInsert (var V : ByteArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : WordArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : LongWordArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : ShortIntArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : SmallIntArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : LongIntArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : Int64Array; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : SingleArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : DoubleArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : ExtendedArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : StringArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : PointerArray; const Idx : Integer; const Count : Integer) : Integer; overload;
Function  ArrayInsert (var V : ObjectArray; const Idx : Integer; const Count : Integer) : Integer; overload;

Procedure FreeObjectArray (var V); overload;
Procedure FreeObjectArray (var V; const LoIdx, HiIdx : Integer); overload;
Procedure FreeAndNilObjectArray (var V : ObjectArray);

Function  PosNext (const Find : Byte; const V : ByteArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : Word; const V : WordArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : LongWord; const V : LongWordArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : ShortInt; const V : ShortIntArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : SmallInt; const V : SmallIntArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : LongInt; const V : LongIntArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : Int64; const V : Int64Array; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : Single; const V : SingleArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : Double; const V : DoubleArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : Extended; const V : ExtendedArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : Boolean; const V : BooleanArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : String; const V : StringArray; const PrevPos : Integer = -1;
          const IsSortedAscending : Boolean = False) : Integer; overload;
Function  PosNext (const Find : Pointer; const V : PointerArray; const PrevPos : Integer = -1) : Integer; overload;
Function  PosNext (const Find : TObject; const V : ObjectArray; const PrevPos : Integer = -1) : Integer; overload;
Function  PosNext (const ClassType : TClass; const V : ObjectArray; const PrevPos : Integer = -1) : Integer; overload;
Function  PosNext (const ClassName : String; const V : ObjectArray; const PrevPos : Integer = -1) : Integer; overload;

Function  Count (const Find : Byte; const V : ByteArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : Word; const V : WordArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : LongWord; const V : LongWordArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : ShortInt; const V : ShortIntArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : SmallInt; const V : SmallIntArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : LongInt; const V : LongIntArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : Int64; const V : Int64Array; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : Single; const V : SingleArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : Double; const V : DoubleArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : Extended; const V : ExtendedArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : String; const V : StringArray; const IsSortedAscending : Boolean = False) : Integer; overload;
Function  Count (const Find : Boolean; const V : BooleanArray; const IsSortedAscending : Boolean = False) : Integer; overload;

Procedure RemoveAll (const Find : Byte; var V : ByteArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : Word; var V : WordArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : LongWord; var V : LongWordArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : ShortInt; var V : ShortIntArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : SmallInt; var V : SmallIntArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : LongInt; var V : LongIntArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : Int64; var V : Int64Array; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : Single; var V : SingleArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : Double; var V : DoubleArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : Extended; var V : ExtendedArray; const IsSortedAscending : Boolean = False); overload; 
Procedure RemoveAll (const Find : String; var V : StringArray; const IsSortedAscending : Boolean = False); overload; 

Function  Intersection (const V1, V2 : ByteArray; const IsSortedAscending : Boolean = False) : ByteArray; overload;
Function  Intersection (const V1, V2 : WordArray; const IsSortedAscending : Boolean = False) : WordArray; overload;
Function  Intersection (const V1, V2 : LongWordArray; const IsSortedAscending : Boolean = False) : LongWordArray; overload;
Function  Intersection (const V1, V2 : ShortIntArray; const IsSortedAscending : Boolean = False) : ShortIntArray; overload;
Function  Intersection (const V1, V2 : SmallIntArray; const IsSortedAscending : Boolean = False) : SmallIntArray; overload;
Function  Intersection (const V1, V2 : LongIntArray; const IsSortedAscending : Boolean = False) : LongIntArray; overload;
Function  Intersection (const V1, V2 : Int64Array; const IsSortedAscending : Boolean = False) : Int64Array; overload;
Function  Intersection (const V1, V2 : SingleArray; const IsSortedAscending : Boolean = False) : SingleArray; overload;
Function  Intersection (const V1, V2 : DoubleArray; const IsSortedAscending : Boolean = False) : DoubleArray; overload;
Function  Intersection (const V1, V2 : ExtendedArray; const IsSortedAscending : Boolean = False) : ExtendedArray; overload;
Function  Intersection (const V1, V2 : StringArray; const IsSortedAscending : Boolean = False) : StringArray; overload;

Function  Difference (const V1, V2 : ByteArray; const IsSortedAscending : Boolean = False) : ByteArray; overload;
Function  Difference (const V1, V2 : WordArray; const IsSortedAscending : Boolean = False) : WordArray; overload;
Function  Difference (const V1, V2 : LongWordArray; const IsSortedAscending : Boolean = False) : LongWordArray; overload;
Function  Difference (const V1, V2 : ShortIntArray; const IsSortedAscending : Boolean = False) : ShortIntArray; overload;
Function  Difference (const V1, V2 : SmallIntArray; const IsSortedAscending : Boolean = False) : SmallIntArray; overload;
Function  Difference (const V1, V2 : LongIntArray; const IsSortedAscending : Boolean = False) : LongIntArray; overload;
Function  Difference (const V1, V2 : Int64Array; const IsSortedAscending : Boolean = False) : Int64Array; overload;
Function  Difference (const V1, V2 : SingleArray; const IsSortedAscending : Boolean = False) : SingleArray; overload;
Function  Difference (const V1, V2 : DoubleArray; const IsSortedAscending : Boolean = False) : DoubleArray; overload;
Function  Difference (const V1, V2 : ExtendedArray; const IsSortedAscending : Boolean = False) : ExtendedArray; overload;
Function  Difference (const V1, V2 : StringArray; const IsSortedAscending : Boolean = False) : StringArray; overload;

Procedure Reverse (var V : ByteArray); overload;
Procedure Reverse (var V : WordArray); overload;
Procedure Reverse (var V : LongWordArray); overload;
Procedure Reverse (var V : ShortIntArray); overload;
Procedure Reverse (var V : SmallIntArray); overload;
Procedure Reverse (var V : LongIntArray); overload;
Procedure Reverse (var V : Int64Array); overload;
Procedure Reverse (var V : SingleArray); overload;
Procedure Reverse (var V : DoubleArray); overload;
Procedure Reverse (var V : ExtendedArray); overload;
Procedure Reverse (var V : StringArray); overload;
Procedure Reverse (var V : PointerArray); overload;
Procedure Reverse (var V : ObjectArray); overload;

Function  AsBooleanArray (const V : Array of Boolean) : BooleanArray; overload;
Function  AsByteArray (const V : Array of Byte) : ByteArray; overload;
Function  AsWordArray (const V : Array of Word) : WordArray; overload;
Function  AsLongWordArray (const V : Array of LongWord) : LongWordArray; overload;
Function  AsCardinalArray (const V : Array of Cardinal) : CardinalArray; overload;
Function  AsShortIntArray (const V : Array of ShortInt) : ShortIntArray; overload;
Function  AsSmallIntArray (const V : Array of SmallInt) : SmallIntArray; overload;
Function  AsLongIntArray (const V : Array of LongInt) : LongIntArray; overload;
Function  AsIntegerArray (const V : Array of Integer) : IntegerArray; overload;
Function  AsInt64Array (const V : Array of Int64) : Int64Array; overload;
Function  AsSingleArray (const V : Array of Single) : SingleArray; overload;
Function  AsDoubleArray (const V : Array of Double) : DoubleArray; overload;
Function  AsExtendedArray (const V : Array of Extended) : ExtendedArray; overload;
Function  AsStringArray (const V : Array of String) : StringArray; overload;
Function  AsPointerArray (const V : Array of Pointer) : PointerArray; overload;
Function  AsCharSetArray (const V : Array of CharSet) : CharSetArray; overload;
Function  AsObjectArray (const V : Array of TObject) : ObjectArray; overload;

Function  RangeByte (const First : Byte; const Count : Integer; const Increment : Byte = 1) : ByteArray;
Function  RangeWord (const First : Word; const Count : Integer; const Increment : Word = 1) : WordArray;
Function  RangeLongWord (const First : LongWord; const Count : Integer; const Increment : LongWord = 1) : LongWordArray;
Function  RangeCardinal (const First : Cardinal; const Count : Integer; const Increment : Cardinal = 1) : CardinalArray;
Function  RangeShortInt (const First : ShortInt; const Count : Integer; const Increment : ShortInt = 1) : ShortIntArray;
Function  RangeSmallInt (const First : SmallInt; const Count : Integer; const Increment : SmallInt = 1) : SmallIntArray;
Function  RangeLongInt (const First : LongInt; const Count : Integer; const Increment : LongInt = 1) : LongIntArray;
Function  RangeInteger (const First : Integer; const Count : Integer; const Increment : Integer = 1) : IntegerArray;
Function  RangeInt64 (const First : Int64; const Count : Integer; const Increment : Int64 = 1) : Int64Array;
Function  RangeSingle (const First : Single; const Count : Integer; const Increment : Single = 1) : SingleArray;
Function  RangeDouble (const First : Double; const Count : Integer; const Increment : Double = 1) : DoubleArray;
Function  RangeExtended (const First : Extended; const Count : Integer; const Increment : Extended = 1) : ExtendedArray;

Function  DupByte (const V : Byte; const Count : Integer) : ByteArray;
Function  DupWord (const V : Word; const Count : Integer) : WordArray;
Function  DupLongWord (const V : LongWord; const Count : Integer) : LongWordArray;
Function  DupCardinal (const V : Cardinal; const Count : Integer) : CardinalArray;
Function  DupShortInt (const V : ShortInt; const Count : Integer) : ShortIntArray;
Function  DupSmallInt (const V : SmallInt; const Count : Integer) : SmallIntArray;
Function  DupLongInt (const V : LongInt; const Count : Integer) : LongIntArray;
Function  DupInteger (const V : Integer; const Count : Integer) : IntegerArray;
Function  DupInt64 (const V : Int64; const Count : Integer) : Int64Array;
Function  DupSingle (const V : Single; const Count : Integer) : SingleArray;
Function  DupDouble (const V : Double; const Count : Integer) : DoubleArray;
Function  DupExtended (const V : Extended; const Count : Integer) : ExtendedArray;
Function  DupString (const V : String; const Count : Integer) : StringArray;
Function  DupCharSet (const V : CharSet; const Count : Integer) : CharSetArray;
Function  DupObject (const V : TObject; const Count : Integer) : ObjectArray;

Procedure SetLengthAndZero (var V : ByteArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : WordArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : LongWordArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : ShortIntArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : SmallIntArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : LongIntArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : Int64Array; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : SingleArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : DoubleArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : ExtendedArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : CharSetArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : BooleanArray; const NewLength : Integer); overload;
Procedure SetLengthAndZero (var V : ObjectArray; const NewLength : Integer;
    const FreeObjects : Boolean = False); overload;

Function  IsEqual (const V1, V2 : ByteArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : WordArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : LongWordArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : ShortIntArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : SmallIntArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : LongIntArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : Int64Array) : Boolean; overload;
Function  IsEqual (const V1, V2 : SingleArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : DoubleArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : ExtendedArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : StringArray) : Boolean; overload;
Function  IsEqual (const V1, V2 : CharSetArray) : Boolean; overload;

Function  ByteArrayToLongIntArray (const V : ByteArray) : LongIntArray;
Function  WordArrayToLongIntArray (const V : WordArray) : LongIntArray;
Function  ShortIntArrayToLongIntArray (const V : ShortIntArray) : LongIntArray;
Function  SmallIntArrayToLongIntArray (const V : SmallIntArray) : LongIntArray;
Function  LongIntArrayToInt64Array (const V : LongIntArray) : Int64Array;
Function  LongIntArrayToSingleArray (const V : LongIntArray) : SingleArray;
Function  LongIntArrayToDoubleArray (const V : LongIntArray) : DoubleArray;
Function  LongIntArrayToExtendedArray (const V : LongIntArray) : ExtendedArray;
Function  SingleArrayToExtendedArray (const V : SingleArray) : ExtendedArray;
Function  SingleArrayToDoubleArray (const V : SingleArray) : DoubleArray;
Function  SingleArrayToLongIntArray (const V : SingleArray) : LongIntArray;
Function  SingleArrayToInt64Array (const V : SingleArray) : Int64Array;
Function  DoubleArrayToSingleArray (const V : DoubleArray) : SingleArray;
Function  DoubleArrayToExtendedArray (const V : DoubleArray) : ExtendedArray;
Function  DoubleArrayToLongIntArray (const V : DoubleArray) : LongIntArray;
Function  DoubleArrayToInt64Array (const V : DoubleArray) : Int64Array;
Function  ExtendedArrayToSingleArray (const V : ExtendedArray) : SingleArray;
Function  ExtendedArrayToDoubleArray (const V : ExtendedArray) : DoubleArray;
Function  ExtendedArrayToLongIntArray (const V : ExtendedArray) : LongIntArray;
Function  ExtendedArrayToInt64Array (const V : ExtendedArray) : Int64Array;

Function  ByteArrayFromIndexes (const V : ByteArray; const Indexes : IntegerArray) : ByteArray;
Function  WordArrayFromIndexes (const V : WordArray; const Indexes : IntegerArray) : WordArray;
Function  LongWordArrayFromIndexes (const V : LongWordArray; const Indexes : IntegerArray) : LongWordArray;
Function  CardinalArrayFromIndexes (const V : CardinalArray; const Indexes : IntegerArray) : CardinalArray;
Function  ShortIntArrayFromIndexes (const V : ShortIntArray; const Indexes : IntegerArray) : ShortIntArray;
Function  SmallIntArrayFromIndexes (const V : SmallIntArray; const Indexes : IntegerArray) : SmallIntArray;
Function  LongIntArrayFromIndexes (const V : LongIntArray; const Indexes : IntegerArray) : LongIntArray;
Function  IntegerArrayFromIndexes (const V : IntegerArray; const Indexes : IntegerArray) : IntegerArray;
Function  Int64ArrayFromIndexes (const V : Int64Array; const Indexes : IntegerArray) : Int64Array;
Function  SingleArrayFromIndexes (const V : SingleArray; const Indexes : IntegerArray) : SingleArray;
Function  DoubleArrayFromIndexes (const V : DoubleArray; const Indexes : IntegerArray) : DoubleArray;
Function  ExtendedArrayFromIndexes (const V : ExtendedArray; const Indexes : IntegerArray) : ExtendedArray;
Function  StringArrayFromIndexes (const V : StringArray; const Indexes : IntegerArray) : StringArray;

Procedure Sort (var V : ByteArray); overload;
Procedure Sort (var V : WordArray); overload;
Procedure Sort (var V : LongWordArray); overload;
Procedure Sort (var V : ShortIntArray); overload;
Procedure Sort (var V : SmallIntArray); overload;
Procedure Sort (var V : LongIntArray); overload;
Procedure Sort (var V : Int64Array); overload;
Procedure Sort (var V : SingleArray); overload;
Procedure Sort (var V : DoubleArray); overload;
Procedure Sort (var V : ExtendedArray); overload;
Procedure Sort (var V : StringArray); overload;

Procedure Sort (var Key : IntegerArray; var Data : IntegerArray); overload;
Procedure Sort (var Key : IntegerArray; var Data : Int64Array); overload;
Procedure Sort (var Key : IntegerArray; var Data : StringArray); overload;
Procedure Sort (var Key : IntegerArray; var Data : ExtendedArray); overload;
Procedure Sort (var Key : IntegerArray; var Data : PointerArray); overload;
Procedure Sort (var Key : StringArray; var Data : IntegerArray); overload;
Procedure Sort (var Key : StringArray; var Data : Int64Array); overload;
Procedure Sort (var Key : StringArray; var Data : StringArray); overload;
Procedure Sort (var Key : StringArray; var Data : ExtendedArray); overload;
Procedure Sort (var Key : StringArray; var Data : PointerArray); overload;
Procedure Sort (var Key : ExtendedArray; var Data : IntegerArray); overload;
Procedure Sort (var Key : ExtendedArray; var Data : Int64Array); overload;
Procedure Sort (var Key : ExtendedArray; var Data : StringArray); overload;
Procedure Sort (var Key : ExtendedArray; var Data : ExtendedArray); overload;
Procedure Sort (var Key : ExtendedArray; var Data : PointerArray); overload;



{                                                                              }
{ Self testing code                                                            }
{                                                                              }
Procedure SelfTest;



implementation



{                                                                              }
{ Integer                                                                      }
{                                                                              }
Function MinI (const A, B : Integer) : Integer;
  Begin
    if A < B then
      Result := A else
      Result := B;
  End;

Function MaxI (const A, B : Integer) : Integer;
  Begin
    if A > B then
      Result := A else
      Result := B;
  End;

Function Clip (const Value : Integer; const Low, High : Integer) : Integer;
  Begin
    if Value < Low then
      Result := Low else
    if Value > High then
      Result := High else
      Result := Value;
  End;

Function ClipByte (const Value : Integer) : Integer;
  Begin
    if Value < MinByte then
      Result := MinByte else
    if Value > MaxByte then
      Result := MaxByte else
      Result := Value;
  End;

Function ClipWord (const Value : Integer) : Integer;
  Begin
    if Value < MinWord then
      Result := MinWord else
    if Value > MaxWord then
      Result := MaxWord else
      Result := Value;
  End;

Function RangeAdjacent (const Low1, High1, Low2, High2 : Integer) : Boolean;
  Begin
    Result := ((Low2 > MinInteger) and (High1 = Low2 - 1)) or
              ((High2 < MaxInteger) and (Low1 = High2 + 1));
  End;

Function RangeOverlap (const Low1, High1, Low2, High2 : Integer) : Boolean;
  Begin
    Result := ((Low1 >= Low2) and (Low1 <= High2)) or
              ((Low2 >= Low1) and (Low2 <= High1));
  End;



{                                                                              }
{ Float                                                                        }
{                                                                              }

{ Approximate comparison functions taken from FltMath by Tempest Software as   }
{ taken from Knuth, Seminumerical Algorithms, 2nd ed., Addison-Wesley,         }
{ 1981, pp. 217-20.                                                            }
{$IFDEF CPU_INTEL386}
type
  TExtended = packed record
    Case Boolean of
    True : (
      Mantissa : packed Array [0..1] of LongWord; { MSB of [1] is the normalized 1 bit }
      Exponent : Word; { MSB is the sign bit }
    );
    False:
      (Value: Extended);
  end;
{$ENDIF}

{$IFDEF CPU_INTEL386}
Function ApproxEqual (const A, B : Extended; const CompareEpsilon : Double) : Boolean;
var ExtA : TExtended absolute A;
    ExtB : TExtended absolute B;
    ExpA, ExpB : Word;
    Exp : TExtended;
  Begin
    ExpA := ExtA.Exponent and $7FFF;
    ExpB := ExtB.Exponent and $7FFF;
    if (ExpA = $7FFF) and ((ExtA.Mantissa[1] <> $80000000) or (ExtA.Mantissa[0] <> 0)) then
      { A is NaN }
      Result := False else
    if (ExpB = $7FFF) and ((ExtB.Mantissa[1] <> $80000000) or (ExtB.Mantissa[0] <> 0)) then
      { B is NaN }
      Result := False else
    if (ExpA = $7FFF) or (ExpB = $7FFF) then
      { A or B is infinity. Use the builtin comparison, which will       }
      { properly account for signed infinities, comparing infinity with  }
      { infinity, or comparing infinity with a finite value.             }
      Result := A = B else
    begin
      { We are comparing two finite values, so take the difference and   }
      { compare that against the scaled Epsilon.                         }
      Exp.Value := 1.0;
      if ExpA < ExpB then
        Exp.Exponent := ExpB else
        Exp.Exponent := ExpA;
      Result := Abs (A - B) <= (CompareEpsilon * Exp.Value);
    end;
  End;
{$ELSE}
Function ApproxEqual (const A, B : Extended; const CompareEpsilon : Double) : Boolean;
  Begin
    Result := Abs (A - B) <= CompareEpsilon;
  End;
{$ENDIF}

{$IFDEF CPU_INTEL386}
Function ApproxCompare (const A, B : Extended; const CompareEpsilon : Double = DefaultCompareEpsilon) : TCompareResult;
var ExtA : TExtended absolute A;
    ExtB : TExtended absolute B;
    ExpA, ExpB : Word;
    Exp : TExtended;
    V : Extended;
  Begin
    ExpA := ExtA.Exponent and $7FFF;
    ExpB := ExtB.Exponent and $7FFF;
    if (ExpA = $7FFF) and ((ExtA.Mantissa[1] <> $80000000) or (ExtA.Mantissa[0] <> 0)) then
      { A is NaN }
      Result := crUndefined else
    if (ExpB = $7FFF) and ((ExtB.Mantissa[1] <> $80000000) or (ExtB.Mantissa[0] <> 0)) then
      { B is NaN }
      Result := crUndefined else
    if (ExpA = $7FFF) or (ExpB = $7FFF) then
      { A or B is infinity. Use the builtin comparison, which will       }
      { properly account for signed infinities, comparing infinity with  }
      { infinity, or comparing infinity with a finite value.             }
      Result := Compare (A, B) else
    begin
      { We are comparing two finite values, so take the difference and   }
      { compare that against the scaled Epsilon.                         }
      Exp.Value := 1.0;
      if ExpA < ExpB then
        Exp.Exponent := ExpB else
        Exp.Exponent := ExpA;
      V := CompareEpsilon * Exp.Value;
      if Abs (A - B) <= V then
        Result := crEqual else
      if A - B >= V then
        Result := crGreater else
        Result := crLess;
    end;
  End;
{$ELSE}
Function ApproxCompare (const A, B : Extended; const CompareEpsilon : Double = DefaultCompareEpsilon) : TCompareResult;
var V : Extended;
  Begin
    V := A - B;
    if Abs (V) <= CompareEpsilon then
      Result := crEqual else
    if V >= CompareEpsilon then
      Result := crGreater else
      Result := crLess;
  End;
{$ENDIF}

Function ApproxZero (const Value : Extended; const CompareEpsilon : Double) : Boolean;
  Begin
    Result := ApproxEqual (Value, 0.0, CompareEpsilon);
  End;



{                                                                              }
{ Bit functions                                                                }
{                                                                              }

{ Assembly versions of ReverseBits and SwapEndian taken from the               }
{ Delphi Encryption Compendium 3.0 by Hagen Reddmann (HaReddmann@AOL.COM)      }
{$IFDEF WINTEL}
Function ReverseBits (const Value : LongWord) : LongWord;
  Asm
        BSWAP   EAX
        MOV     EDX, EAX
        AND     EAX, 0AAAAAAAAh
        SHR     EAX, 1
        AND     EDX, 055555555h
        SHL     EDX, 1
        OR      EAX, EDX
        MOV     EDX, EAX
        AND     EAX, 0CCCCCCCCh
        SHR     EAX, 2
        AND     EDX, 033333333h
        SHL     EDX, 2
        OR      EAX, EDX
        MOV     EDX, EAX
        AND     EAX, 0F0F0F0F0h
        SHR     EAX, 4
        AND     EDX, 00F0F0F0Fh
        SHL     EDX, 4
        OR      EAX, EDX
  End;
{$ELSE}
Function ReverseBits (const Value : LongWord) : LongWord;
var I : Byte;
  Begin
    Result := 0;
    For I := 0 to 31 do
      if Value and BitMaskTable [I] <> 0 then
        Result := Result or BitMaskTable [31 - I];
  End;
{$ENDIF}

Function ReverseBits (const Value : LongWord; const BitCount : Integer) : LongWord;
var I : Integer;
    V : LongWord;
  Begin
    V := Value;
    Result := 0;
    For I := 0 to MinI (BitCount, BitsPerLongWord) - 1 do
      begin
        Result := (Result shl 1) or (V and 1);
        V := V shr 1;
      end;
  End;

{$IFDEF WINTEL}
Function SwapEndian (const Value : LongWord) : LongWord;
  Asm
        XCHG    AH, AL
        ROL     EAX, 16
        XCHG    AH, AL
  End;
{$ELSE}
Function SwapEndian (const Value : LongWord) : LongWord;
type Bytes4 = packed record
       B1, B2, B3, B4 : Byte;
     end;
var Val : Bytes4 absolute Value;
    Res : Bytes4 absolute Result;
  Begin
    Res.B4 := Val.B1;
    Res.B3 := Val.B2;
    Res.B2 := Val.B3;
    Res.B1 := Val.B4;
  End;
{$ENDIF}

Procedure SwapEndianBuf (var Buf; const Count : Integer);
var P : PLongWord;
    I : Integer;
  Begin
    P := @Buf;
    For I := 1 to Count do
      begin
        P^ := SwapEndian (P^);
        Inc (P);
      end;
  End;

{$IFDEF WINTEL}
Function TwosComplement (const Value : LongWord) : LongWord;
  Asm
        NEG EAX
  End;
{$ELSE}
Function TwosComplement (const Value : LongWord) : LongWord;
  Begin
    Result := not Value + 1;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function RotateLeftBits (const Value : LongWord; const Bits : Byte) : LongWord;
  Asm
     MOV   CL, DL
     ROL   EAX, CL
  End;
{$ELSE}
Function RotateLeftBits (const Value : LongWord; const Bits : Byte) : LongWord;
var I : Integer;
  Begin
    Result := Value;
    For I := 1 to Bits do
      if Value and $80000000 = 0 then
        Result := Value shl 1 else
        Result := (Value shl 1) or 1;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function RotateRightBits (const Value : LongWord; const Bits : Byte) : LongWord;
  Asm
     MOV   CL, DL
     ROL   EAX, CL
  End;
{$ELSE}
Function RotateRightBits (const Value : LongWord; const Bits : Byte) : LongWord;
var I : Integer;
  Begin
    Result := Value;
    For I := 1 to Bits do
      if Value and 1 = 0 then
        Result := Value shr 1 else
        Result := (Value shr 1) or $80000000;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function SetBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
  Asm
        {$IFOPT R+}
        CMP     BitIndex, BitsPerLongWord
        JAE     @Fin
        {$ENDIF}
        OR      EAX, DWORD PTR [BitIndex * 4 + BitMaskTable]
      @Fin:
  End;
{$ELSE}
Function SetBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
  Begin
    Result := Value or BitMaskTable [BitIndex];
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function ClearBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
  Asm
        {$IFOPT R+}
        CMP     BitIndex, BitsPerLongWord
        JAE     @Fin
        {$ENDIF}
        MOV     ECX, DWORD PTR [BitIndex * 4 + BitMaskTable]
        NOT     ECX
        AND     EAX, ECX
      @Fin:
  End;
{$ELSE}
Function ClearBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
  Begin
    Result := Value and not BitMaskTable [BitIndex];
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function ToggleBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
  Asm
        {$IFOPT R+}
        CMP     BitIndex, BitsPerLongWord
        JAE     @Fin
        {$ENDIF}
        XOR     EAX, DWORD PTR [BitIndex * 4 + BitMaskTable]
      @Fin:  
  End;
{$ELSE}
Function ToggleBit (const Value : LongWord; const BitIndex : LongWord) : LongWord;
  Begin
    Result := Value xor BitMaskTable [BitIndex];
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function IsHighBitSet (const Value : LongWord) : Boolean;
  Asm
        TEST    Value, $80000000
        SETNZ   AL
  End;
{$ELSE}
Function IsHighBitSet (const Value : LongWord) : Boolean;
  Begin
    Result := Value and $80000000 <> 0;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function IsBitSet (const Value : LongWord; const BitIndex : LongWord) : Boolean;
  Asm
        {$IFOPT R+}
        CMP     BitIndex, BitsPerLongWord
        JAE     @Fin
        {$ENDIF}
        MOV     ECX, DWORD PTR BitMaskTable [BitIndex * 4]
        TEST    Value, ECX
        SETNZ   AL
      @Fin:
  End;
{$ELSE}
Function IsBitSet (const Value : LongWord; const BitIndex : LongWord) : Boolean;
  Begin
    Result := Value and BitMaskTable [BitIndex] <> 0;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function SetBitScanForward (const Value : LongWord) : Integer;
  Asm
        OR      EAX, EAX
        JZ      @NoBits
        BSF     EAX, EAX
        RET
    @NoBits:
        MOV     EAX, -1
  End;

Function SetBitScanForward (const Value : LongWord; const StartBitIndex : LongWord) : Integer;
  Asm
        {$IFOPT R+}
        CMP     StartBitIndex, BitsPerLongWord
        JAE     @@zq
        {$ENDIF}
        MOV     ECX, StartBitIndex
        MOV     EDX, $FFFFFFFF
        SHL     EDX, CL
        AND     EDX, EAX
        JE      @@zq
        BSF     EAX, EDX
        RET
@@zq:   MOV     EAX, -1
  End;
{$ELSE}
Function SetBitScanForward (const Value : LongWord; const StartBitIndex : LongWord) : Integer;
var I : Byte;
  Begin
    For I := StartBitIndex to 31 do
      if Value and BitMaskTable [I] <> 0 then
        begin
          Result := I;
          exit;
        end;
    Result := -1;
  End;

Function SetBitScanForward (const Value : LongWord) : Integer;
  Begin
    Result := SetBitScanForward (Value, 0);
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function SetBitScanReverse (const Value : LongWord) : Integer;
  Asm
        OR      EAX, EAX
        JZ      @NoBits
        BSR     EAX, EAX
        RET
    @NoBits:
        MOV     EAX, -1
  End;

Function SetBitScanReverse (const Value : LongWord; const StartBitIndex : LongWord) : Integer;
  Asm
        {$IFOPT R+}
        CMP     EDX, BitsPerLongWord
        JAE     @@zq
        {$ENDIF}
        LEA     ECX, [EDX-31]
        MOV     EDX, $FFFFFFFF
        NEG     ECX
        SHR     EDX, CL
        AND     EDX, EAX
        JE      @@zq
        BSR     EAX, EDX
        RET
@@zq:   MOV     EAX, -1
  End;
{$ELSE}
Function SetBitScanReverse (const Value : LongWord; const StartBitIndex : LongWord) : Integer;
var I : Byte;
  Begin
    For I := StartBitIndex downto 0 do
      if Value and BitMaskTable [I] <> 0 then
        begin
          Result := I;
          exit;
        end;
    Result := -1;
  End;

Function SetBitScanReverse (const Value : LongWord) : Integer;
  Begin
    SetBitScanReverse (Value, 31);
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function ClearBitScanForward (const Value : LongWord) : Integer;
  Asm
        NOT     EAX
        OR      EAX, EAX
        JZ      @NoBits
        BSF     EAX, EAX
        RET
    @NoBits:
        MOV     EAX, -1
  End;

Function ClearBitScanForward (const Value : LongWord; const StartBitIndex : LongWord) : Integer;
  Asm
        {$IFOPT R+}
        CMP     EDX, BitsPerLongWord
        JAE     @@zq
        {$ENDIF}
        MOV     ECX, EDX
        MOV     EDX, $FFFFFFFF
        NOT     EAX
        SHL     EDX, CL
        AND     EDX, EAX
        JE      @@zq
        BSF     EAX, EDX
        RET
@@zq:   MOV     EAX, -1
  End;
{$ELSE}
Function ClearBitScanForward (const Value : LongWord; const StartBitIndex : LongWord) : Integer;
var I : Byte;
  Begin
    For I := StartBitIndex to 31 do
      if Value and BitMaskTable [I] = 0 then
        begin
          Result := I;
          exit;
        end;
    Result := -1;
  End;

Function ClearBitScanForward (const Value : LongWord) : Integer;
  Begin
    ClearBitScanForward (Value, 0);
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function ClearBitScanReverse (const Value : LongWord) : Integer;
  Asm
        NOT     EAX
        OR      EAX, EAX
        JZ      @NoBits
        BSR     EAX, EAX
        RET
    @NoBits:
        MOV     EAX, -1
  End;

Function ClearBitScanReverse (const Value : LongWord; const StartBitIndex : LongWord) : Integer;
  Asm
        {$IFOPT R+}
        CMP     EDX, BitsPerLongWord
        JAE     @@zq
        {$ENDIF}
        LEA     ECX, [EDX-31]
        MOV     EDX, $FFFFFFFF
        NEG     ECX
        NOT     EAX
        SHR     EDX, CL
        AND     EDX, EAX
        JE      @@zq
        BSR     EAX, EDX
        RET
@@zq:   MOV     EAX, -1
  End;
{$ELSE}
Function ClearBitScanReverse (const Value : LongWord; const StartBitIndex : LongWord) : Integer;
var I : Byte;
  Begin
    For I := StartBitIndex downto 0 do
      if Value and BitMaskTable [I] = 0 then
        begin
          Result := I;
          exit;
        end;
    Result := -1;
  End;

Function ClearBitScanReverse (const Value : LongWord) : Integer;
  Begin
    ClearBitScanReverse (Value, 31);
  End;
{$ENDIF}

const
  BitCountTable : array [0..255] of Byte =
    (0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
     1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
     1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
     2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
     1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
     2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
     2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
     3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8);

{$IFDEF WINTEL}
Function BitCount (const Value : LongWord) : LongWord;
  Asm
        MOVZX   EDX, AL
        MOVZX   EDX, BYTE PTR [EDX + BitCountTable]
        MOVZX   ECX, AH
        ADD     DL, BYTE PTR [ECX + BitCountTable]
        SHR     EAX, 16
        MOVZX   ECX, AH
        ADD     DL, BYTE PTR [ECX + BitCountTable]
        AND     EAX, $FF
        ADD     DL, BYTE PTR [EAX + BitCountTable]
        MOV     AL, DL
  End;
{$ELSE}
Function BitCount (const Value : LongWord) : LongWord;
var V : Array [0..3] of Byte absolute Value;
  Begin
    Result := BitCountTable [V [0]] + BitCountTable [V [1]] +
              BitCountTable [V [2]] + BitCountTable [V [3]];
  End;
{$ENDIF}

Function IsPowerOfTwo (const Value : LongWord) : Boolean;
  Begin
    Result := BitCount (Value) = 1;
  End;

Function LowBitMask (const HighBitIndex : LongWord) : LongWord;
  Begin
    {$IFOPT R+}
    if HighBitIndex >= BitsPerLongWord then
      Result := 0 else
    {$ENDIF}
    Result := BitMaskTable [HighBitIndex] - 1;
  End;

Function HighBitMask (const LowBitIndex : LongWord) : LongWord;
  Begin
    {$IFOPT R+}
    if LowBitIndex >= BitsPerLongWord then
      Result := 0 else
    {$ENDIF}
    Result := not BitMaskTable [LowBitIndex] + 1;
  End;

Function RangeBitMask (const LowBitIndex, HighBitIndex : LongWord) : LongWord;
  Begin
    {$IFOPT R+}
    if (LowBitIndex >= BitsPerLongWord) and (HighBitIndex >= BitsPerLongWord) then
      begin
        Result := 0;
        exit;
      end;
    {$ENDIF}
    Result := $FFFFFFFF;
    if LowBitIndex > 0 then
      Result := Result xor (BitMaskTable [LowBitIndex] - 1);
    if HighBitIndex < 31 then
      Result := Result xor (not BitMaskTable [HighBitIndex + 1] + 1);
  End;

Function SetBitRange (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : LongWord;
  Begin
    Result := Value or RangeBitMask (LowBitIndex, HighBitIndex);
  End;

Function ClearBitRange (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : LongWord;
  Begin
    Result := Value and not RangeBitMask (LowBitIndex, HighBitIndex);
  End;

Function ToggleBitRange (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : LongWord;
  Begin
    Result := Value xor RangeBitMask (LowBitIndex, HighBitIndex);
  End;

Function IsBitRangeSet (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : Boolean;
var M : LongWord;
  Begin
    M := RangeBitMask (LowBitIndex, HighBitIndex);
    Result := Value and M = M;
  End;

Function IsBitRangeClear (const Value : LongWord; const LowBitIndex, HighBitIndex : LongWord) : Boolean;
  Begin
    Result := Value and RangeBitMask (LowBitIndex, HighBitIndex) = 0;
  End;



{                                                                              }
{ Sets                                                                         }
{                                                                              }
Function AsCharSet (const C : Array of Char) : CharSet;
var I : Integer;
  Begin
    Result := [];
    For I := 0 to High (C) do
      Result := Result + [C [I]];
  End;

Function AsByteSet (const C : Array of Byte) : ByteSet;
var I : Integer;
  Begin
    Result := [];
    For I := 0 to High (C) do
      Result := Result + [C [I]];
  End;

{$IFDEF WINTEL}
Procedure ComplementChar (var C : CharSet; const Ch : Char);
  Asm
        MOVZX   ECX, DL
        BTC     [EAX], ECX
  End;
{$ELSE}
Procedure ComplementChar (var C : CharSet; const Ch : Char);
  Begin
    if Ch in C then
      Exclude (C, Ch) else
      Include (C, Ch);
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure ClearCharSet (var C : CharSet);
  Asm
        XOR     EDX, EDX
        MOV     [EAX], EDX
        MOV     [EAX + 4], EDX
        MOV     [EAX + 8], EDX
        MOV     [EAX + 12], EDX
        MOV     [EAX + 16], EDX
        MOV     [EAX + 20], EDX
        MOV     [EAX + 24], EDX
        MOV     [EAX + 28], EDX
  End;
{$ELSE}
Procedure ClearCharSet (var C : CharSet);
  Begin
    C := [];
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure FillCharSet (var C : CharSet);
  Asm
        MOV     EDX, $FFFFFFFF
        MOV     [EAX], EDX
        MOV     [EAX + 4], EDX
        MOV     [EAX + 8], EDX
        MOV     [EAX + 12], EDX
        MOV     [EAX + 16], EDX
        MOV     [EAX + 20], EDX
        MOV     [EAX + 24], EDX
        MOV     [EAX + 28], EDX
  End;
{$ELSE}
Procedure FillCharSet (var C : CharSet);
  Begin
    C := [#0..#255];
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure ComplementCharSet (var C : CharSet);
  Asm
        NOT     DWORD PTR [EAX]
        NOT     DWORD PTR [EAX + 4]
        NOT     DWORD PTR [EAX + 8]
        NOT     DWORD PTR [EAX + 12]
        NOT     DWORD PTR [EAX + 16]
        NOT     DWORD PTR [EAX + 20]
        NOT     DWORD PTR [EAX + 24]
        NOT     DWORD PTR [EAX + 28]
  End;
{$ELSE}
Procedure ComplementCharSet (var C : CharSet);
  Begin
    C := [#0..#255] - C;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure AssignCharSet (var DestSet : CharSet; const SourceSet : CharSet);
  Asm
        MOV     ECX, [EDX]
        MOV     [EAX], ECX
        MOV     ECX, [EDX + 4]
        MOV     [EAX + 4], ECX
        MOV     ECX, [EDX + 8]
        MOV     [EAX + 8], ECX
        MOV     ECX, [EDX + 12]
        MOV     [EAX + 12], ECX
        MOV     ECX, [EDX + 16]
        MOV     [EAX + 16], ECX
        MOV     ECX, [EDX + 20]
        MOV     [EAX + 20], ECX
        MOV     ECX, [EDX + 24]
        MOV     [EAX + 24], ECX
        MOV     ECX, [EDX + 28]
        MOV     [EAX + 28], ECX
  End;
{$ELSE}
Procedure AssignCharSet (var DestSet : CharSet; const SourceSet : CharSet);
  Begin
    DestSet := SourceSet;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Union (var DestSet : CharSet; const SourceSet : CharSet);
  Asm
        MOV     ECX, [EDX]
        OR      [EAX], ECX
        MOV     ECX, [EDX + 4]
        OR      [EAX + 4], ECX
        MOV     ECX, [EDX + 8]
        OR      [EAX + 8], ECX
        MOV     ECX, [EDX + 12]
        OR      [EAX + 12], ECX
        MOV     ECX, [EDX + 16]
        OR      [EAX + 16], ECX
        MOV     ECX, [EDX + 20]
        OR      [EAX + 20], ECX
        MOV     ECX, [EDX + 24]
        OR      [EAX + 24], ECX
        MOV     ECX, [EDX + 28]
        OR      [EAX + 28], ECX
  End;
{$ELSE}
Procedure Union (var DestSet : CharSet; const SourceSet : CharSet);
  Begin
    DestSet := DestSet + SourceSet;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Difference (var DestSet : CharSet; const SourceSet : CharSet);
  Asm
        MOV     ECX, [EDX]
        NOT     ECX
        AND     [EAX], ECX
        MOV     ECX, [EDX + 4]
        NOT     ECX
        AND     [EAX + 4], ECX
        MOV     ECX, [EDX + 8]
        NOT     ECX
        AND     [EAX + 8],ECX
        MOV     ECX, [EDX + 12]
        NOT     ECX
        AND     [EAX + 12], ECX
        MOV     ECX, [EDX + 16]
        NOT     ECX
        AND     [EAX + 16], ECX
        MOV     ECX, [EDX + 20]
        NOT     ECX
        AND     [EAX + 20], ECX
        MOV     ECX, [EDX + 24]
        NOT     ECX
        AND     [EAX + 24], ECX
        MOV     ECX, [EDX + 28]
        NOT     ECX
        AND     [EAX + 28], ECX
  End;
{$ELSE}
Procedure Difference (var DestSet : CharSet; const SourceSet : CharSet);
  Begin
    DestSet := DestSet - SourceSet;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Intersection (var DestSet : CharSet; const SourceSet : CharSet);
  Asm
        MOV     ECX, [EDX]
        AND     [EAX], ECX
        MOV     ECX, [EDX + 4]
        AND     [EAX + 4], ECX
        MOV     ECX, [EDX + 8]
        AND     [EAX + 8], ECX
        MOV     ECX, [EDX + 12]
        AND     [EAX + 12], ECX
        MOV     ECX, [EDX + 16]
        AND     [EAX + 16], ECX
        MOV     ECX, [EDX + 20]
        AND     [EAX + 20], ECX
        MOV     ECX, [EDX + 24]
        AND     [EAX + 24], ECX
        MOV     ECX, [EDX + 28]
        AND     [EAX + 28], ECX
  End;
{$ELSE}
Procedure Intersection (var DestSet : CharSet; const SourceSet : CharSet);
  Begin
    DestSet := DestSet * SourceSet;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure XORCharSet (var DestSet : CharSet; const SourceSet : CharSet);
  Asm
        MOV     ECX, [EDX]
        XOR     [EAX], ECX
        MOV     ECX, [EDX + 4]
        XOR     [EAX + 4], ECX
        MOV     ECX, [EDX + 8]
        XOR     [EAX + 8], ECX
        MOV     ECX, [EDX + 12]
        XOR     [EAX + 12], ECX
        MOV     ECX, [EDX + 16]
        XOR     [EAX + 16], ECX
        MOV     ECX, [EDX + 20]
        XOR     [EAX + 20], ECX
        MOV     ECX, [EDX + 24]
        XOR     [EAX + 24], ECX
        MOV     ECX, [EDX + 28]
        XOR     [EAX + 28], ECX
  End;
{$ELSE}
Procedure XORCharSet (var DestSet : CharSet; const SourceSet : CharSet);
var Ch : Char;
  Begin
    For Ch := #0 to #255 do
      if Ch in DestSet then
        begin
          if Ch in SourceSet then
            Exclude (DestSet, Ch);
        end else
        if Ch in SourceSet then
          Include (DestSet, Ch);
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function IsSubSet (const A, B : CharSet) : Boolean;
  Asm
        MOV     ECX, [EDX]
        NOT     ECX
        AND     ECX, [EAX]
        JNE     @Fin0
        MOV     ECX, [EDX + 4]
        NOT     ECX
        AND     ECX, [EAX + 4]
        JNE     @Fin0
        MOV     ECX, [EDX + 8]
        NOT     ECX
        AND     ECX, [EAX + 8]
        JNE     @Fin0
        MOV     ECX, [EDX + 12]
        NOT     ECX
        AND     ECX, [EAX + 12]
        JNE     @Fin0
        MOV     ECX, [EDX + 16]
        NOT     ECX
        AND     ECX, [EAX + 16]
        JNE     @Fin0
        MOV     ECX, [EDX + 20]
        NOT     ECX
        AND     ECX, [EAX + 20]
        JNE     @Fin0
        MOV     ECX, [EDX + 24]
        NOT     ECX
        AND     ECX, [EAX + 24]
        JNE     @Fin0
        MOV     ECX, [EDX + 28]
        NOT     ECX
        AND     ECX, [EAX + 28]
        JNE     @Fin0
        MOV     EAX, 1
        RET
@Fin0:  XOR     EAX, EAX
  End;
{$ELSE}
Function IsSubSet (const A, B : CharSet) : Boolean;
  Begin
    Result := A <= B;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function IsEqual (const A, B : CharSet) : Boolean;
  Asm
        MOV     ECX, [EDX]
        XOR     ECX, [EAX]
        JNE     @Fin0
        MOV     ECX, [EDX + 4]
        XOR     ECX, [EAX + 4]
        JNE     @Fin0
        MOV     ECX, [EDX + 8]
        XOR     ECX, [EAX + 8]
        JNE     @Fin0
        MOV     ECX, [EDX + 12]
        XOR     ECX, [EAX + 12]
        JNE     @Fin0
        MOV     ECX, [EDX + 16]
        XOR     ECX, [EAX + 16]
        JNE     @Fin0
        MOV     ECX, [EDX + 20]
        XOR     ECX, [EAX + 20]
        JNE     @Fin0
        MOV     ECX, [EDX + 24]
        XOR     ECX, [EAX + 24]
        JNE     @Fin0
        MOV     ECX, [EDX + 28]
        XOR     ECX, [EAX + 28]
        JNE     @Fin0
        MOV     EAX, 1
        RET
@Fin0:  XOR     EAX, EAX
  End;
{$ELSE}
Function IsEqual (const A, B : CharSet) : Boolean;
  Begin
    Result := A = B;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function IsEmpty (const C : CharSet) : Boolean;
  Asm
        MOV     EDX, [EAX]
        OR      EDX, [EAX + 4]
        OR      EDX, [EAX + 8]
        OR      EDX, [EAX + 12]
        OR      EDX, [EAX + 16]
        OR      EDX, [EAX + 20]
        OR      EDX, [EAX + 24]
        OR      EDX, [EAX + 28]
        JNE     @Fin0
        MOV     EAX, 1
        RET
@Fin0:  XOR     EAX,EAX
  End;
{$ELSE}
Function IsEmpty (const C : CharSet) : Boolean;
  Begin
    Result := C = [];
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function IsComplete (const C : CharSet) : Boolean;
  Asm
        MOV     EDX, [EAX]
        AND     EDX, [EAX + 4]
        AND     EDX, [EAX + 8]
        AND     EDX, [EAX + 12]
        AND     EDX, [EAX + 16]
        AND     EDX, [EAX + 20]
        AND     EDX, [EAX + 24]
        AND     EDX, [EAX + 28]
        CMP     EDX, $FFFFFFFF
        JNE     @Fin0
        MOV     EAX, 1
        RET
@Fin0:  XOR     EAX, EAX
  End;
{$ELSE}
Function IsComplete (const C : CharSet) : Boolean;
  Begin
    Result := C = CompleteCharSet;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function CharCount (const C : CharSet) : Integer;
  Asm
        PUSH    EBX
        PUSH    ESI
        MOV     EBX, EAX
        XOR     ESI, ESI
        MOV     EAX, [EBX]
        CALL    BitCount
        ADD     ESI, EAX
        MOV     EAX, [EBX + 4]
        CALL    BitCount
        ADD     ESI, EAX
        MOV     EAX, [EBX + 8]
        CALL    BitCount
        ADD     ESI, EAX
        MOV     EAX, [EBX + 12]
        CALL    BitCount
        ADD     ESI, EAX
        MOV     EAX, [EBX + 16]
        CALL    BitCount
        ADD     ESI, EAX
        MOV     EAX, [EBX + 20]
        CALL    BitCount
        ADD     ESI, EAX
        MOV     EAX, [EBX + 24]
        CALL    BitCount
        ADD     ESI, EAX
        MOV     EAX, [EBX + 28]
        CALL    BitCount
        ADD     EAX, ESI
        POP     ESI
        POP     EBX
  End;
{$ELSE}
Function CharCount (const C : CharSet) : Integer;
var I : Char;
  Begin
    Result := 0;
    For I := #0 to #255 do
      if I in C then
        Inc (Result);
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure ConvertCaseInsensitive (var C : CharSet);
  Asm
        MOV     ECX, [EAX + 12]
        AND     ECX, $3FFFFFF
        OR      [EAX + 8], ECX
        MOV     ECX, [EAX + 8]
        AND     ECX, $3FFFFFF
        OR      [EAX + 12], ECX
  End;
{$ELSE}
Procedure ConvertCaseInsensitive (var C : CharSet);
var Ch : Char;
  Begin
    For Ch := 'A' to 'Z' do
      if Ch in C then
        Include (C, Char (Byte (Ch) + 32));
    For Ch := 'a' to 'z' do
      if Ch in C then
        Include (C, Char (Byte (Ch) - 32));
  End;
{$ENDIF}

Function CaseInsensitiveCharSet (const C : CharSet) : CharSet;
  Begin
    AssignCharSet (Result, C);
    ConvertCaseInsensitive (Result);
  End;



{                                                                              }
{ Swap                                                                         }
{                                                                              }
{$IFDEF WINTEL}
Procedure Swap (var X, Y : Boolean);
  Asm
      mov cl, [edx]
      xchg byte ptr [eax], cl
      mov [edx], cl
  End;
{$ELSE}
Procedure Swap (var X, Y : Boolean);
var F : Boolean;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Swap (var X, Y : Byte);
  Asm
      mov cl, [edx]
      xchg byte ptr [eax], cl
      mov [edx], cl
  End;
{$ELSE}
Procedure Swap (var X, Y : Byte);
var F : Byte;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Swap (var X, Y : ShortInt);
  Asm
      mov cl, [edx]
      xchg byte ptr [eax], cl
      mov [edx], cl
  End;
{$ELSE}
Procedure Swap (var X, Y : ShortInt);
var F : ShortInt;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Swap (var X, Y : Word);
  Asm
      mov cx, [edx]
      xchg word ptr [eax], cx
      mov [edx], cx
  End;
{$ELSE}
Procedure Swap (var X, Y : Word);
var F : Word;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Swap (var X, Y : SmallInt);
  Asm
      mov cx, [edx]
      xchg word ptr [eax], cx
      mov [edx], cx
  End;
{$ELSE}
Procedure Swap (var X, Y : SmallInt);
var F : SmallInt;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Swap (var X, Y : LongInt);
  Asm
      mov ecx, [edx]
      xchg [eax], ecx
      mov [edx], ecx
  End;
{$ELSE}
Procedure Swap (var X, Y : LongInt);
var F : LongInt;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Swap (var X, Y : LongWord);
  Asm
      mov ecx, [edx]
      xchg [eax], ecx
      mov [edx], ecx
  End;
{$ELSE}
Procedure Swap (var X, Y : LongWord);
var F : LongWord;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Swap (var X, Y : Pointer);
  Asm
      mov ecx, [edx]
      xchg [eax], ecx
      mov [edx], ecx
  End;
{$ELSE}
Procedure Swap (var X, Y : Pointer);
var F : Pointer;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Procedure Swap (var X, Y : TObject);
  Asm
      mov ecx, [edx]
      xchg [eax], ecx
      mov [edx], ecx
  End;
{$ELSE}
Procedure Swap (var X, Y : TObject);
var F : TObject;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;
{$ENDIF}

Procedure Swap (var X, Y : Int64);
var F : Int64;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;

Procedure Swap (var X, Y : Single);
var F : Single;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;

Procedure Swap (var X, Y : Double);
var F : Double;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;

Procedure Swap (var X, Y : Extended);
var F : Extended;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;

Procedure Swap (var X, Y : String);
var F : String;
  Begin
    F := X;
    X := Y;
    Y := F;
  End;

{$IFDEF WINTEL}
Procedure SwapObjects (var X, Y);
  Asm
      mov ecx, [edx]
      xchg [eax], ecx
      mov [edx], ecx
  End;
{$ELSE}
Procedure SwapObjects (var X, Y);
var F : TObject;
  Begin
    F := TObject (X);
    TObject (X) := TObject (Y);
    TObject (Y) := F;
  End;
{$ENDIF}



{                                                                              }
{ iif                                                                          }
{                                                                              }
Function iif (const Expr : Boolean; const TrueValue, FalseValue : LongWord) : LongWord;
  Begin
    if Expr then
      Result := TrueValue else
      Result := FalseValue;
  End;

Function iif (const Expr : Boolean; const TrueValue, FalseValue : Int64) : Int64;
  Begin
    if Expr then
      Result := TrueValue else
      Result := FalseValue;
  End;

Function iif (const Expr : Boolean; const TrueValue, FalseValue : Single) : Single;
  Begin
    if Expr then
      Result := TrueValue else
      Result := FalseValue;
  End;

Function iif (const Expr : Boolean; const TrueValue, FalseValue : Double) : Double;
  Begin
    if Expr then
      Result := TrueValue else
      Result := FalseValue;
  End;

Function iif (const Expr : Boolean; const TrueValue, FalseValue : Extended) : Extended;
  Begin
    if Expr then
      Result := TrueValue else
      Result := FalseValue;
  End;

Function iif (const Expr : Boolean; const TrueValue, FalseValue : String) : String;
  Begin
    if Expr then
      Result := TrueValue else
      Result := FalseValue;
  End;

Function iif (const Expr : Boolean; const TrueValue, FalseValue : Pointer) : Pointer;
  Begin
    if Expr then
      Result := TrueValue else
      Result := FalseValue;
  End;

Function iif (const Expr : Boolean; const TrueValue, FalseValue : TObject) : TObject;
  Begin
    if Expr then
      Result := TrueValue else
      Result := FalseValue;
  End;



{                                                                              }
{ Compare                                                                      }
{                                                                              }
Function Compare (const I1, I2 : Integer) : TCompareResult;
  Begin
    if I1 < I2 then
      Result := crLess else
    if I1 > I2 then
      Result := crGreater else
      Result := crEqual;
  End;

Function Compare (const I1, I2 : Int64) : TCompareResult;
  Begin
    if I1 < I2 then
      Result := crLess else
    if I1 > I2 then
      Result := crGreater else
      Result := crEqual;
  End;

Function Compare (const I1, I2 : Single) : TCompareResult;
  Begin
    if I1 < I2 then
      Result := crLess else
    if I1 > I2 then
      Result := crGreater else
      Result := crEqual;
  End;

Function Compare (const I1, I2 : Double) : TCompareResult;
  Begin
    if I1 < I2 then
      Result := crLess else
    if I1 > I2 then
      Result := crGreater else
      Result := crEqual;
  End;

Function Compare (const I1, I2 : Extended) : TCompareResult;
  Begin
    if I1 < I2 then
      Result := crLess else
    if I1 > I2 then
      Result := crGreater else
      Result := crEqual;
  End;

Function Compare (const I1, I2 : Boolean) : TCompareResult;
  Begin
    if I1 = I2 then
      Result := crEqual else
    if I1 then
      Result := crGreater else
      Result := crLess;
  End;

Function Compare (const I1, I2 : String) : TCompareResult;
  Begin
    if I1 = I2 then
      Result := crEqual else
    if I1 > I2 then
      Result := crGreater else
      Result := crLess;
  End;

Function Compare (const I1, I2 : TObject) : TCompareResult;
  Begin
    Result := Compare (Integer (I1), Integer (I2));
  End;

Function NegatedCompareResult (const C : TCompareResult) : TCompareResult;
  Begin
    if C = crLess then
      Result := crGreater else
    if C = crGreater then
      Result := crLess else
      Result := C;
  End;



{                                                                              }
{ Base Conversion                                                              }
{                                                                              }
Function LongWordToBase (const I : LongWord; const Digits, Base : Byte) : String;
var D : LongWord;
    L : Byte;
    P : PChar;
  Begin
    Assert (Base <= 16, 'Base <= 16');
    if I = 0 then
      begin
        if Digits = 0 then
          L := 1 else
          L := Digits;
        SetLength (Result, L);
        FillChar (Pointer (Result)^, L, '0');
        exit;
      end;
    L := 0;
    D := I;
    While D > 0 do
      begin
        Inc (L);
        D := D div Base;
      end;
    if L < Digits then
      L := Digits;
    SetLength (Result, L);
    P := Pointer (Result);
    Inc (P, L - 1);
    D := I;
    While D > 0 do
      begin
        P^ := s_HexDigitsUpper [D mod Base + 1];
        Dec (P);
        Dec (L);
        D := D div Base;
      end;
    While L > 0 do
      begin
        P^ := '0';
        Dec (P);
        Dec (L);
      end;
  End;

Function LongWordToBin (const I : LongWord; const Digits : Byte) : String;
  Begin
    Result := LongWordToBase (I, Digits, 2);
  End;

Function LongWordToOct (const I : LongWord; const Digits : Byte) : String;
  Begin
    Result := LongWordToBase (I, Digits, 8);
  End;

Function LongWordToHex (const I : LongWord; const Digits : Byte) : String;
  Begin
    Result := LongWordToBase (I, Digits, 16);
  End;

Function LongWordToStr (const I : LongWord; const Digits : Byte) : String;
  Begin
    Result := LongWordToBase (I, Digits, 10);
  End;

const
  HexLookup : Array [0..255] of Byte = (
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, 10,  11,  12,  13,  14,  15,  $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, 10,  11,  12,  13,  14,  15,  $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
      $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF);

Function HexCharValue (const Ch : Char) : Byte;
  Begin
    Result := HexLookup [Byte (Ch)];
  End;

Function BaseToLongWord (const S : String; const BaseLog2 : Byte) : LongWord;
var L : LongWord;
    P : Byte;
    C : Byte;
    Q : PChar;
  Begin
    Assert (BaseLog2 <= 4, 'BaseLog2 <= 4');
    P := Length (S);
    if P = 0 then
      begin
        Result := 0;
        exit;
      end;
    L := 0;
    Result := 0;
    Q := Pointer (S);
    Inc (Q, P - 1);
    Repeat
      C := HexLookup [Ord (Q^)];
      if C <> $FF then
        Inc (Result, LongWord (C) shl L);
      Inc (L, BaseLog2);
      Dec (P);
      Dec (Q);
    Until (P = 0) or (L = 32);
  End;

Function BinToLongWord (const S : String) : LongWord;
  Begin
    Result := BaseToLongWord (S, 1);
  End;

Function OctToLongWord (const S : String) : LongWord;
  Begin
    Result := BaseToLongWord (S, 3);
  End;

Function HexToLongWord (const S : String) : LongWord;
  Begin
    Result := BaseToLongWord (S, 4);
  End;

Function StrToLongWord (const S : String) : LongWord;
var L : Integer;
    P : PChar;
    C : Char;
    F : LongWord;
  Begin
    L := Length (S);
    if L = 0 then
      begin
        Result := 0;
        exit;
      end;
    Result := 0;
    F := 1;
    P := Pointer (S);
    Inc (P, L - 1);
    Repeat
      C := P^;
      if C in ['0'..'9'] then
        Inc (Result, Byte (Ord (C) - Ord ('0')) * F);
      if F = 1000000000 then
        exit;
      F := F * 10;
      Dec (P);
      Dec (L);
    Until L = 0;
  End;

Function EncodeBase64 (const S, Alphabet : String; const Pad : Boolean; const PadMultiple : Integer; const PadChar : Char) : String;
var R, C : Byte;
    F, L, M, N, U : Integer;
    P : PChar;
    T : Boolean;
  Begin
    Assert (Length (Alphabet) = 64, 'Alphabet must contain 64 characters.');
    L := Length (S);
    if L = 0 then
      begin
        Result := '';
        exit;
      end;
    M := L mod 3;
    N := (L div 3) * 4 + M;
    if M > 0 then
      Inc (N);
    T := Pad and (PadMultiple > 1);
    if T then
      begin
        U := N mod PadMultiple;
        if U > 0 then
          begin
            U := PadMultiple - U;
            Inc (N, U);
          end;
      end else
      U := 0;
    SetLength (Result, N);
    P := Pointer (Result);
    R := 0;
    For F := 0 to L - 1 do
      begin
        C := Byte (S [F + 1]);
        Case F mod 3 of
          0 : begin
                P^ := Alphabet [C shr 2 + 1];
                Inc (P);
                R := (C and 3) shl 4;
              end;
          1 : begin
                P^ := Alphabet [C shr 4 + R + 1];
                Inc (P);
                R := (C and $0F) shl 2;
              end;
          2 : begin
                P^ := Alphabet [C shr 6 + R + 1];
                Inc (P);
                P^ := Alphabet [C and $3F + 1];
                Inc (P);
              end;
        end;
      end;
    if M > 0 then
      begin
        P^ := Alphabet [R + 1];
        Inc (P);
      end;
    For F := 1 to U do
      begin
        P^ := PadChar;
        Inc (P);
      end;
  End;

Function DecodeBase64 (const S, Alphabet : String; const PadSet : CharSet) : String;
var F, L, M, P : Integer;
    B : Byte;
    OutPos : Byte;
    OutB : Array [1..3] of Byte;
    Lookup : Array [0..255] of Byte;
    R : PChar;
  Begin
    Assert (Length (Alphabet) = 64, 'Alphabet must contain 64 characters.');
    L := Length (S);
    P := 0;
    if PadSet <> [] then
      While (L - P > 0) and (S [L - P] in PadSet) do
        Inc (P);
    M := L - P;
    if M = 0 then
      begin
        Result := '';
        exit;
      end;
    SetLength (Result, (M * 3) div 4);
    FillChar (Lookup, Sizeof (Lookup), #0);
    For F := 0 to 63 do
      Lookup [Ord (Alphabet [F + 1])] := F;
    R := Pointer (Result);
    OutPos := 0;
    For F := 1 to L - P do
      begin
        B := Lookup [Ord (S [F])];
        Case OutPos of
            0 : OutB [1] := B shl 2;
            1 : begin
                  OutB [1] := OutB [1] or (B shr 4);
                  R^ := Char (OutB [1]);
                  Inc (R);
                  OutB [2] := (B shl 4) and $FF;
                end;
            2 : begin
                  OutB [2] := OutB [2] or (B shr 2);
                  R^ := Char (OutB [2]);
                  Inc (R);
                  OutB [3] := (B shl 6) and $FF;
                end;
            3 : begin
                  OutB [3] := OutB [3] or B;
                  R^ := Char (OutB [3]);
                  Inc (R);
                end;
          end;
        OutPos := (OutPos + 1) mod 4;
      end;
    if (OutPos > 0) and (P = 0) then // incomplete encoding, add the partial byte if not 0
      if OutB [OutPos] <> 0 then
        Result := Result + Char (OutB [OutPos]);
  End;

Function MIMEBase64Encode (const S : String) : String;
  Begin
    Result := EncodeBase64 (S, b64_MIMEBase64, True, 4, '=');
  End;

Function UUDecode (const S : String) : String;
  Begin
    // Line without size indicator (first byte = length + 32)
    Result := DecodeBase64 (S, b64_UUEncode, ['`']);
  End;

Function MIMEBase64Decode (const S : String) : String;
  Begin
    Result := DecodeBase64 (S, b64_MIMEBase64, ['=']);
  End;

Function XXDecode (const S : String) : String;
  Begin
    Result := DecodeBase64 (S, b64_XXEncode, []);
  End;

Function BytesToHex (const P : Pointer; const Count : Integer) : String;
var Q : PByte;
    D : PChar;
    L : Integer;
  Begin
    Q := P;
    L := Count;
    if (L <= 0) or not Assigned (Q) then
      begin
        Result := '';
        exit;
      end;
    SetLength (Result, Count * 2);
    D := Pointer (Result);
    While L > 0 do
      begin
        D^ := s_HexDigitsUpper [Q^ shr 4 + 1];
        Inc (D);
        D^ := s_HexDigitsUpper [Q^ and $F + 1];
        Inc (D);
        Inc (Q);
        Dec (L);
      end;
  End;



{                                                                              }
{ Type conversion                                                              }
{                                                                              }
Function PointerToStr (const P : Pointer) : String;
  Begin
    Result := '$' + LongWordToHex (LongWord (P), 8);
  End;

Function StrToPointer (const S : String) : Pointer;
  Begin
    Result := Pointer (HexToLongWord (S));
  End;

Function ObjectClassName (const O : TObject) : String;
  Begin
    if not Assigned (O) then
      Result := 'nil' else
      Result := O.ClassName;
  End;

Function ClassClassName (const C : TClass) : String;
  Begin
    if not Assigned (C) then
      Result := 'nil' else
      Result := C.ClassName;
  End;

Function ObjectToStr (const O : TObject) : String;
  Begin
    if not Assigned (O) then
      Result := 'nil' else
      Result := O.ClassName + '@' + LongWordToHex (LongWord (O), 8);
  End;

Function ClassToStr (const C : TClass) : String;
  Begin
    if not Assigned (C) then
      Result := 'nil' else
      Result := C.ClassName + '@' + LongWordToHex (LongWord (C), 8);
  End;

{$IFDEF WINTEL}
Function CharSetToStr (const C : CharSet) : String; // Andrew N. Driazgov
  Asm
        PUSH    EBX
        MOV     ECX, $100
        MOV     EBX, EAX
        PUSH    ESI
        MOV     EAX, EDX
        SUB     ESP, ECX
        XOR     ESI, ESI
        XOR     EDX, EDX
@@lp:   BT      [EBX], EDX
        JC      @@mm
@@nx:   INC     EDX
        DEC     ECX
        JNE     @@lp
        MOV     ECX, ESI
        MOV     EDX, ESP
        CALL    System.@LStrFromPCharLen
        ADD     ESP, $100
        POP     ESI
        POP     EBX
        RET
@@mm:   MOV     [ESP + ESI], DL
        INC     ESI
        JMP     @@nx
  End;
{$ELSE}
Function CharSetToStr (const C : CharSet) : String;
// Implemented recursively to avoid multiple memory allocations
  Procedure CharMatch (const Start : Char; const Count : Integer);
  var Ch : Char;
    Begin
      For Ch := Start to #255 do
        if Ch in C then
          begin
            if Ch = #255 then
              SetLength (Result, Count + 1) else
              CharMatch (Char (Byte (Ch) + 1), Count + 1);
            Result [Count + 1] := Ch;
            exit;
          end;
      SetLength (Result, Count);
    End;
  Begin
    CharMatch (#0, 0);
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function StrToCharSet (const S : String) : CharSet; // Andrew N. Driazgov
  Asm
        XOR     ECX, ECX
        MOV     [EDX], ECX
        MOV     [EDX + 4], ECX
        MOV     [EDX + 8], ECX
        MOV     [EDX + 12], ECX
        MOV     [EDX + 16], ECX
        MOV     [EDX + 20], ECX
        MOV     [EDX + 24], ECX
        MOV     [EDX + 28], ECX
        TEST    EAX, EAX
        JE      @@qt
        MOV     ECX, [EAX - 4]
        PUSH    EBX
        SUB     ECX, 8
        JS      @@nx
@@lp:   MOVZX   EBX, BYTE PTR [EAX]
        BTS     [EDX], EBX
        MOVZX   EBX, BYTE PTR [EAX + 1]
        BTS     [EDX], EBX
        MOVZX   EBX, BYTE PTR [EAX + 2]
        BTS     [EDX], EBX
        MOVZX   EBX, BYTE PTR [EAX + 3]
        BTS     [EDX], EBX
        MOVZX   EBX, BYTE PTR [EAX + 4]
        BTS     [EDX], EBX
        MOVZX   EBX, BYTE PTR [EAX + 5]
        BTS     [EDX], EBX
        MOVZX   EBX, BYTE PTR [EAX + 6]
        BTS     [EDX], EBX
        MOVZX   EBX, BYTE PTR [EAX + 7]
        BTS     [EDX], EBX
        ADD     EAX, 8
        SUB     ECX, 8
        JNS     @@lp
@@nx:   JMP     DWORD PTR @@tV[ECX * 4 + 32]
@@tV:   DD      @@ex, @@t1, @@t2, @@t3
        DD      @@t4, @@t5, @@t6, @@t7
@@t7:   MOVZX   EBX, BYTE PTR [EAX + 6]
        BTS     [EDX], EBX
@@t6:   MOVZX   EBX, BYTE PTR [EAX + 5]
        BTS     [EDX], EBX
@@t5:   MOVZX   EBX, BYTE PTR [EAX + 4]
        BTS     [EDX], EBX
@@t4:   MOVZX   EBX, BYTE PTR [EAX + 3]
        BTS     [EDX], EBX
@@t3:   MOVZX   EBX, BYTE PTR [EAX + 2]
        BTS     [EDX], EBX
@@t2:   MOVZX   EBX, BYTE PTR [EAX + 1]
        BTS     [EDX], EBX
@@t1:   MOVZX   EBX, BYTE PTR [EAX]
        BTS     [EDX], EBX
@@ex:   POP     EBX
@@qt:
  End;
{$ELSE}
Function StrToCharSet (const S : String) : CharSet;
var I : Integer;
  Begin
    ClearCharSet (Result);
    For I := 1 to Length (S) do
      Include (Result, S [I]);
  End;
{$ENDIF}



{                                                                              }
{ Hash functions                                                               }
{   Based on CRC32 algorithm                                                   }
{                                                                              }
var
  CRC32TableInit : Boolean = False;
  CRC32Table     : Array [Byte] of LongWord;
  CRC32Poly      : LongWord = $EDB88320;

Procedure InitCRC32Table;
var I, J : Byte;
    R    : LongWord;
  Begin
    For I := $00 to $FF do
      begin
        R := I;
        For J := 8 downto 1 do
          if R and 1 <> 0 then
            R := (R shr 1) xor CRC32Poly else
            R := R shr 1;
        CRC32Table [I] := R;
      end;
    CRC32TableInit := True;
  End;

Procedure SetCRC32Poly (const Poly : LongWord);
  Begin
    CRC32Poly := Poly;
    CRC32TableInit := False;
  End;

Function CalcCRC32Byte (const CRC32 : LongWord; const Octet : Byte) : LongWord;
  Begin
    Result := CRC32Table [Byte (CRC32) xor Octet] xor ((CRC32 shr 8) and $00FFFFFF);
  End;

Function CRC32Byte (const CRC32 : LongWord; const Octet : Byte) : LongWord;
  Begin
    if not CRC32TableInit then
      InitCRC32Table;
    Result := CalcCRC32Byte (CRC32, Octet);
  End;

Function CRC32Buf (const CRC32 : LongWord; const Buf; const BufSize : Integer) : LongWord;
var P : PByte;
    I : Integer;
  Begin
    if not CRC32TableInit then
      InitCRC32Table;
    P := @Buf;
    Result := CRC32;
    For I := 1 to BufSize do
      begin
        Result := CalcCRC32Byte (Result, P^);
        Inc (P);
      end;
  End;

Function CRC32BufNoCase (const CRC32 : LongWord; const Buf; const BufSize : Integer) : LongWord;
var P : PByte;
    I : Integer;
    C : Byte;
  Begin
    if not CRC32TableInit then
      InitCRC32Table;
    P := @Buf;
    Result := CRC32;
    For I := 1 to BufSize do
      begin
        C := P^;
        if Char (C) in ['A'..'Z'] then
          C := C or 32;
        Result := CalcCRC32Byte (Result, C);
        Inc (P);
      end;
  End;

Procedure CRC32Init (var CRC32 : LongWord);
  Begin
    CRC32 := $FFFFFFFF;
  End;

Function CalcCRC32 (const Buf; const BufSize : Integer) : LongWord; overload;
  Begin
    CRC32Init (Result);
    Result := not CRC32Buf (Result, Buf, BufSize);
  End;

Function CalcCRC32 (const Buf : String) : LongWord; overload;
  Begin
    Result := CalcCRC32 (Pointer (Buf)^, Length (Buf));
  End;

Function HashBuf (const Buf; const BufSize : Integer; const Slots : LongWord) : LongWord;
  Begin
    if BufSize <= 0 then
      Result := 0 else
      Result := CalcCRC32 (Buf, BufSize);
    // Mod into slots
    if (Slots <> 0) and (Slots <> High (LongWord)) then
      Result := Result mod Slots;
  End;

Function HashStr (const StrBuf : Pointer; const StrLength : Integer; const Slots : LongWord; const CaseSensitive : Boolean) : LongWord;
var P    : PChar;
    I, J : Integer;

  Procedure CRC32StrBuf (const Size : Integer);
    Begin
      if CaseSensitive then
        Result := CRC32Buf (Result, P^, Size) else
        Result := CRC32BufNoCase (Result, P^, Size);
    End;

  Begin
    // Return 0 for an empty string
    Result := 0;
    if (StrLength <= 0) or not Assigned (StrBuf) then
      exit;

    if not CRC32TableInit then
      InitCRC32Table;
    Result := $FFFFFFFF;
    P := StrBuf;

    if StrLength <= 48 then // Hash everything for short strings
      CRC32StrBuf (StrLength) else
      begin
        // Hash first 16 bytes
        CRC32StrBuf (16);

        // Hash last 16 bytes
        Inc (P, StrLength - 16);
        CRC32StrBuf (16);

        // Hash 16 bytes sampled from rest of string
        I := (StrLength - 48) div 16;
        P := StrBuf;
        Inc (P, 16);
        For J := 1 to 16 do
          begin
            CRC32StrBuf (1);
            Inc (P, I + 1);
          end;
      end;

    // Mod into slots
    if (Slots <> 0) and (Slots <> High (LongWord)) then
      Result := Result mod Slots;
  End;

Function HashStr (const S : String; const Slots : LongWord; const CaseSensitive : Boolean) : LongWord;
  Begin
    Result := HashStr (Pointer (S), Length (S), Slots, CaseSensitive);
  End;

{ HashInteger based on the CRC32 algorithm. It is a very good all purpose hash }
{ with a highly uniform distribution of results.                               }
Function HashInteger (const I : Integer; const Slots : LongWord) : LongWord;
var P    : PByte;
    F    : Integer;
    Hash : LongWord;
  Begin
    if not CRC32TableInit then
      InitCRC32Table;
    Hash := $FFFFFFFF;
    P := @I;
    For F := 1 to Sizeof (Integer) do
      begin
        Hash := CalcCRC32Byte (Hash, P^);
        Inc (P);
      end;
    Hash := not Hash;
    if (Slots <> 0) and (Slots <> High (LongWord)) then
      Hash := Hash mod Slots;
    Result := Hash;
  End;



{                                                                              }
{ Memory                                                                       }
{                                                                              }
{$IFDEF WINTEL}
Procedure MoveMem (const Source; var Dest; const Count : Integer);
  Asm
      CMP    ECX, 4
      JA     @GeneralMove
      JE     @Move4
      TEST   ECX, ECX
      JLE    @Fin
      DEC    ECX
      JZ     @Move1
      DEC    ECX
      JZ     @Move2
    @Move3:
      MOV    CX, [EAX]
      MOV    AL, [EAX + 2]
      MOV    [EDX], CX
      MOV    [EDX + 2], AL
      RET
    @Move4:
      MOV    EAX, [EAX]
      MOV    [EDX], EAX
      RET
    @Move1:
      MOV    AL, [EAX]
      MOV    [EDX], AL
      RET
    @Move2:
      MOV    AX, [EAX]
      MOV    [EDX], AX
      RET
    @GeneralMove:
      CALL   Move
    @Fin:
      RET
  End;
{$ELSE}
Procedure MoveMem (const Source; var Dest; const Count : Integer);
  Begin
    if Count <= 0 then
      exit;
    if Count > 4 then
      Move (Source, Dest, Count) else
      Case Count of // optimization for small moves
        1 : PByte (@Source)^ := PByte (@Dest)^;
        2 : PWord (@Source)^ := PWord (@Dest)^;
        4 : PLongWord (@Source)^ := PLongWord (@Dest)^;
      else
        Move (Source, Dest, Count);
      end;
  End;
{$ENDIF}

{$IFDEF WINTEL}
Function CompareMem (const Buf1; const Buf2; const Count : Integer) : Boolean; assembler;
  Asm
      PUSH    ESI
      PUSH    EDI
      MOV     ESI, Buf1
      MOV     EDI, Buf2
      MOV     EDX, ECX
      XOR     EAX, EAX
      AND     EDX, 3
      SHR     ECX, 1
      SHR     ECX, 1
      REPE    CMPSD
      JNE     @Fin
      MOV     ECX, EDX
      REPE    CMPSB
      JNE     @Fin
      INC     EAX
    @Fin:
      POP     EDI
      POP     ESI
  End;
{$ELSE}
Function CompareMem (const Buf1; const Buf2; const Count : Integer) : Boolean;
var P, Q : Pointer;
    D, I : Integer;
  Begin
    if Count <= 0 then
      begin
        Result := True;
        exit;
      end;
    P := @Buf1;
    Q := @Buf2;
    D := LongWord (Count) div 4;
    For I := 1 to D do
      if PLongWord (P)^ = PLongWord (Q)^ then
        begin
          Inc (PLongWord (P));
          Inc (PLongWord (Q));
        end else
        begin
          Result := False;
          exit;
        end;
    D := LongWord (Count) and 3;
    For I := 1 to D do
      if PByte (P)^ = PByte (Q)^ then
        begin
          Inc (PByte (P));
          Inc (PByte (Q));
        end else
        begin
          Result := False;
          exit;
        end;
    Result := True;
  End;
{$ENDIF}

Function CompareMemNoCase (const Buf1; const Buf2; const Count : Integer) : Boolean;
var P, Q : Pointer;
    I : Integer;
    C, D : Byte;
  Begin
    if Count <= 0 then
      begin
        Result := True;
        exit;
      end;
    P := @Buf1;
    Q := @Buf2;
    For I := 1 to Count do
      begin
        C := PByte (P)^;
        D := PByte (Q)^;
        if C in [Ord ('A')..Ord ('Z')] then
          C := C or 32;
        if D in [Ord ('A')..Ord ('Z')] then
          D := D or 32;
        if C = D then
          begin
            Inc (PByte (P));
            Inc (PByte (Q));
          end else
          begin
            Result := False;
            exit;
          end;
      end;
    Result := True;
  End;

Procedure ReverseMem (var Buf; const Size : Integer);
var I : Integer;
    P : PByte;
    Q : PByte;
    T : Byte;
  Begin
    P := @Buf;
    Q := P;
    Inc (Q, Size - 1);
    For I := 1 to Size div 2 do
      begin
        T := P^;
        P^ := Q^;
        Q^ := T;
        Inc (P);
        Dec (Q);
      end;
  End;



{                                                                              }
{ Append                                                                       }
{                                                                              }
Function Append (var V : ByteArray; const R : Byte) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : WordArray; const R : Word) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : LongWordArray; const R : LongWord) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : ShortIntArray; const R : ShortInt) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : SmallIntArray; const R : SmallInt) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : LongIntArray; const R : LongInt) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : Int64Array; const R : Int64) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : SingleArray; const R : Single) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : DoubleArray; const R : Double) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : ExtendedArray; const R : Extended) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : StringArray; const R : String) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : BooleanArray; const R : Boolean) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : PointerArray; const R : Pointer) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : ObjectArray; const R : TObject) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : ByteSetArray; const R : ByteSet) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;

Function Append (var V : CharSetArray; const R : CharSet) : Integer;
  Begin
    Result := Length (V);
    SetLength (V, Result + 1);
    V [Result] := R;
  End;


Function AppendByteArray (var V : ByteArray; const R : Array of Byte) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendWordArray (var V : WordArray; const R : Array of Word) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendCardinalArray (var V : CardinalArray; const R : Array of LongWord) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendShortIntArray (var V : ShortIntArray; const R : Array of ShortInt) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendSmallIntArray (var V : SmallIntArray; const R : Array of SmallInt) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendIntegerArray (var V : IntegerArray; const R : Array of LongInt) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendInt64Array (var V : Int64Array; const R : Array of Int64) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendSingleArray (var V : SingleArray; const R : Array of Single) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendDoubleArray (var V : DoubleArray; const R : Array of Double) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendExtendedArray (var V : ExtendedArray; const R : Array of Extended) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendPointerArray (var V : PointerArray; const R : Array of Pointer) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendCharSetArray (var V : CharSetArray; const R : Array of CharSet) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;

Function AppendByteSetArray (var V : ByteSetArray; const R : Array of ByteSet) : Integer;
var L : Integer;
  Begin
    Result := Length (V);
    L := Length (R);
    if L > 0 then
      begin
        SetLength (V, Result + L);
        Move (R [0], V [Result], Sizeof (R [0]) * L);
      end;
  End;


Function AppendObjectArray (var V : ObjectArray; const R : Array of TObject) : Integer;
var I, LR : Integer;
  Begin
    Result := Length (V);
    LR := Length (R);
    if LR > 0 then
      begin
        SetLength (V, Result + LR);
        For I := 0 to LR - 1 do
          V [Result + I] := R [I];
      end;
  End;

Function AppendStringArray (var V : StringArray; const R : Array of String) : Integer;
var I, LR : Integer;
  Begin
    Result := Length (V);
    LR := Length (R);
    if LR > 0 then
      begin
        SetLength (V, Result + LR);
        For I := 0 to LR - 1 do
          V [Result + I] := R [I];
      end;
  End;


  
{                                                                              }
{ FreeAndNil                                                                   }
{                                                                              }
Procedure FreeAndNil (var Obj);
var Temp : TObject;
  Begin
    Temp := TObject (Obj);
    Pointer (Obj) := nil;
    Temp.Free;
  End;



{                                                                              }
{ Remove                                                                       }
{                                                                              }
Function Remove (var V : ByteArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (Byte));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : WordArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (Word));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : LongWordArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (LongWord));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : ShortIntArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (ShortInt));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : SmallIntArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (SmallInt));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : LongIntArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (LongInt));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : Int64Array; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (Int64));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : SingleArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (Single));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : DoubleArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (Double));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : ExtendedArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (Extended));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : PointerArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (Pointer));
    SetLength (V, L - J);
    Result := J;
  End;


Function Remove (var V : ObjectArray; const Idx : Integer; const Count : Integer; const FreeObjects : Boolean) : Integer;
var I, J, K, L, M : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    if FreeObjects then
      For K := I to I + J - 1 do
        FreeAndNil (V [K]);
    M := L - J - I;
    if M > 0 then
      Move (V [I + J], V [I], M * SizeOf (Pointer));
    SetLength (V, L - J);
    Result := J;
  End;

Function Remove (var V : StringArray; const Idx : Integer; const Count : Integer) : Integer;
var I, J, K, L : Integer;
  Begin
    L := Length (V);
    if (Idx >= L) or (Idx + Count <= 0) or (L = 0) or (Count = 0) then
      begin
        Result := 0;
        exit;
      end;
    I := MaxI (Idx, 0);
    J := MinI (Count, L - I);
    For K := I to L - J - 1 do
      V [K] := V [K + J];
    SetLength (V, L - J);
    Result := J;
  End;

Procedure FreeObjectArray (var V);
var I : Integer;
    A : ObjectArray absolute V;
  Begin
    For I := Length (A) - 1 downto 0 do
      FreeAndNil (A [I]);
  End;

Procedure FreeObjectArray (var V; const LoIdx, HiIdx : Integer);
var I : Integer;
    A : ObjectArray absolute V;
  Begin
    For I := HiIdx downto LoIdx do
      FreeAndNil (A [I]);
  End;

// Note: The parameter can not be changed to be untyped and then typecasted
// using an absolute variable, as in FreeObjectArray. The reference counting
// will be done incorrectly.
Procedure FreeAndNilObjectArray (var V : ObjectArray);
var W : ObjectArray;
  Begin
    W := V;
    V := nil;
    FreeObjectArray (W);
  End;


{                                                                              }
{ RemoveDuplicates                                                             }
{                                                                              }
Procedure RemoveDuplicates (var V : ByteArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : Byte;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : WordArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : Word;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : LongWordArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : LongWord;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : ShortIntArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : ShortInt;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : SmallIntArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : SmallInt;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : LongIntArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : LongInt;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : Int64Array; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : Int64;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : SingleArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : Single;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : DoubleArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : Double;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : ExtendedArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : Extended;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : StringArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : String;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;

Procedure RemoveDuplicates (var V : PointerArray; const IsSorted : Boolean);
var I, C, J, L : Integer;
    F          : Pointer;
  Begin
    L := Length (V);
    if L = 0 then
      exit;

    if IsSorted then
      begin
        J := 0;
        Repeat
          F := V [J];
          I := J + 1;
          While (I < L) and (V [I] = F) do
            Inc (I);
          C := I - J;
          if C > 1 then
            begin
              Remove (V, J + 1, C - 1);
              Dec (L, C - 1);
              Inc (J);
            end else
            J := I;
        Until J >= L;
      end else
      begin
        J := 0;
        Repeat
          Repeat
            I := PosNext (V [J], V, J);
            if I >= 0 then
              Remove (V, I, 1);
          Until I < 0;
          Inc (J);
        Until J >= Length (V);
      end;
  End;



Procedure TrimArrayLeft (var S : ByteArray; const TrimList : Array of Byte); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : WordArray; const TrimList : Array of Word); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : LongWordArray; const TrimList : Array of LongWord); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : ShortIntArray; const TrimList : Array of ShortInt); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : SmallIntArray; const TrimList : Array of SmallInt); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : LongIntArray; const TrimList : Array of LongInt); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : Int64Array; const TrimList : Array of Int64); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : SingleArray; const TrimList : Array of Single); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : DoubleArray; const TrimList : Array of Double); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : ExtendedArray; const TrimList : Array of Extended); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : StringArray; const TrimList : Array of String); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;


Procedure TrimArrayLeft (var S : PointerArray; const TrimList : Array of Pointer); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := 0;
    R := True;
    While R and (I < Length (S)) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Inc (I);
              break;
            end;
      end;
    if I > 0 then
      Remove (S, 0, I - 1);
  End;



Procedure TrimArrayRight (var S : ByteArray; const TrimList : Array of Byte); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : WordArray; const TrimList : Array of Word); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : LongWordArray; const TrimList : Array of LongWord); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : ShortIntArray; const TrimList : Array of ShortInt); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : SmallIntArray; const TrimList : Array of SmallInt); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : LongIntArray; const TrimList : Array of LongInt); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : Int64Array; const TrimList : Array of Int64); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : SingleArray; const TrimList : Array of Single); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : DoubleArray; const TrimList : Array of Double); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : ExtendedArray; const TrimList : Array of Extended); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : StringArray; const TrimList : Array of String); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;


Procedure TrimArrayRight (var S : PointerArray; const TrimList : Array of Pointer); overload;
var I, J : Integer;
    R    : Boolean;
  Begin
    I := Length (S) - 1;
    R := True;
    While R and (I >= 0) do
      begin
        R := False;
        For J := 0 to High (TrimList) do
          if S [I] = TrimList [J] then
            begin
              R := True;
              Dec (I);
              break;
            end;
      end;
    if I < Length (S) - 1 then
      SetLength (S, I + 1);
  End;



{                                                                              }
{ ArrayInsert                                                                  }
{                                                                              }
Function ArrayInsert (var V : ByteArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (Byte);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (Byte));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : WordArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (Word);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (Word));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : LongWordArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (LongWord);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (LongWord));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : ShortIntArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (ShortInt);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (ShortInt));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : SmallIntArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (SmallInt);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (SmallInt));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : LongIntArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (LongInt);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (LongInt));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : Int64Array; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (Int64);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (Int64));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : SingleArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (Single);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (Single));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : DoubleArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (Double);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (Double));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : ExtendedArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (Extended);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (Extended));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : StringArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (String);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (String));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : PointerArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (Pointer);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (Pointer));
    FillChar (V [I], C, #0);
    Result := I;
  End;

Function ArrayInsert (var V : ObjectArray; const Idx : Integer; const Count : Integer) : Integer;
var I, L, C : Integer;
  Begin
    L := Length (V);
    if (Idx > L) or (Idx + Count <= 0) or (Count = 0) then
      begin
        Result := -1;
        exit;
      end;
    I := MaxI (Idx, 0);
    SetLength (V, L + Count);
    C := Count * Sizeof (Pointer);
    if I < L then
      Move (V [I], V [I + Count], (L - I) * Sizeof (Pointer));
    FillChar (V [I], C, #0);
    Result := I;
  End;



{                                                                              }
{ PosNext                                                                      }
{   PosNext finds the next occurance of Find in V, -1 if it was not found.     }
{     Searches from item [PrevPos + 1], ie PrevPos = -1 to find first          }
{     occurance.                                                               }
{                                                                              }
Function PosNext (const Find : Byte; const V : ByteArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : Byte;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : Word; const V : WordArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : Word;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : LongWord; const V : LongWordArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : LongWord;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : ShortInt; const V : ShortIntArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : ShortInt;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : SmallInt; const V : SmallIntArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : SmallInt;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : LongInt; const V : LongIntArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : LongInt;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : Int64; const V : Int64Array; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : Int64;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : Single; const V : SingleArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : Single;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : Double; const V : DoubleArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : Double;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : Extended; const V : ExtendedArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : Extended;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : Boolean; const V : BooleanArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : Boolean;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : String; const V : StringArray; const PrevPos : Integer; const IsSortedAscending : Boolean) : Integer;
var I, L, H : Integer;
    D       : String;
  Begin
    if IsSortedAscending then // binary search
      begin
        if MaxI (PrevPos + 1, 0) = 0 then // find first
          begin
            L := 0;
            H := Length (V) - 1;
            Repeat
              I := (L + H) div 2;
              D := V [I];
              if Find = D then
                begin
                  While (I > 0) and (V [I - 1] = Find) do
                    Dec (I);
                  Result := I;
                  exit;
                end else
              if D > Find then
                H := I - 1 else
                L := I + 1;
            Until L > H;
            Result := -1;
          end else // find next
          if PrevPos >= Length (V) - 1 then
            Result := -1 else
            if V [PrevPos + 1] = Find then
              Result := PrevPos + 1 else
              Result := -1;
      end else
      begin // linear search
        For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
          if V [I] = Find then
            begin
              Result := I;
              exit;
            end;
        Result := -1;
      end;
  End;

Function PosNext (const Find : TObject; const V : ObjectArray; const PrevPos : Integer) : Integer;
var I : Integer;
  Begin
    For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
      if V [I] = Find then
        begin
          Result := I;
          exit;
         end;
    Result := -1;
  End;

Function PosNext (const ClassType : TClass; const V : ObjectArray; const PrevPos : Integer) : Integer;
var I : Integer;
  Begin
    For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
      if V [I] is ClassType then
        begin
          Result := I;
          exit;
         end;
    Result := -1;
  End;

Function PosNext (const ClassName : String; const V : ObjectArray; const PrevPos : Integer) : Integer;
var I : Integer;
    T : TObject;
  Begin
    For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
      begin
        T := V [I];
        if Assigned (T) and (T.ClassName = ClassName) then
          begin
            Result := I;
            exit;
           end;
      end;
    Result := -1;
  End;

Function PosNext (const Find : Pointer; const V : PointerArray; const PrevPos : Integer) : Integer;
var I : Integer;
  Begin
    For I := MaxI (PrevPos + 1, 0) to Length (V) - 1 do
      if V [I] = Find then
        begin
          Result := I;
          exit;
         end;
    Result := -1;
  End;



{                                                                              }
{ Count                                                                        }
{                                                                              }
Function Count (const Find : Byte; const V : ByteArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : Word; const V : WordArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : LongWord; const V : LongWordArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : ShortInt; const V : ShortIntArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : SmallInt; const V : SmallIntArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : LongInt; const V : LongIntArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : Int64; const V : Int64Array; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : Single; const V : SingleArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : Double; const V : DoubleArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : Extended; const V : ExtendedArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : String; const V : StringArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;

Function Count (const Find : Boolean; const V : BooleanArray; const IsSortedAscending : Boolean = False) : Integer;
var I, J : Integer;
  Begin
    if IsSortedAscending then
      begin
        I := PosNext (Find, V, -1, True);
        if I = -1 then
          Result := 0 else
          begin
            Result := 1;
            J := Length (V);
            While (I + Result < J) and (V [I + Result] = Find) do
              Inc (Result);
          end;
      end else
      begin
        J := -1;
        Result := 0;
        Repeat
          I := PosNext (Find, V, J, False);
          if I >= 0 then
            begin
              Inc (Result);
              J := I;
            end;
        Until I < 0;
      end;
  End;



{                                                                              }
{ RemoveAll                                                                    }
{                                                                              }
Procedure RemoveAll (const Find : Byte; var V : ByteArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : Word; var V : WordArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : LongWord; var V : LongWordArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : ShortInt; var V : ShortIntArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : SmallInt; var V : SmallIntArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : LongInt; var V : LongIntArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : Int64; var V : Int64Array; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : Single; var V : SingleArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : Double; var V : DoubleArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : Extended; var V : ExtendedArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;

Procedure RemoveAll (const Find : String; var V : StringArray; const IsSortedAscending : Boolean = False);
var I, J : Integer;
  Begin
    I := PosNext (Find, V, -1, IsSortedAscending);
    While I >= 0 do
      begin
        J := 1;
        While (I + J < Length (V)) and (V [I + J] = Find) do
          Inc (J);
        Remove (V, I, J);
        I := PosNext (Find, V, I, IsSortedAscending);
      end;
  End;



{                                                                              }
{ Intersection                                                                 }
{   If both arrays are sorted ascending then time is o(n) instead of o(n^2).   }
{                                                                              }
Function Intersection (const V1, V2 : SingleArray; const IsSortedAscending : Boolean) : SingleArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : DoubleArray; const IsSortedAscending : Boolean) : DoubleArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : ExtendedArray; const IsSortedAscending : Boolean) : ExtendedArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : ByteArray; const IsSortedAscending : Boolean) : ByteArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : WordArray; const IsSortedAscending : Boolean) : WordArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : LongWordArray; const IsSortedAscending : Boolean) : LongWordArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : ShortIntArray; const IsSortedAscending : Boolean) : ShortIntArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : SmallIntArray; const IsSortedAscending : Boolean) : SmallIntArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : LongIntArray; const IsSortedAscending : Boolean) : LongIntArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : Int64Array; const IsSortedAscending : Boolean) : Int64Array;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Intersection (const V1, V2 : StringArray; const IsSortedAscending : Boolean) : StringArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] = V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) >= 0) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;



{                                                                              }
{ Difference                                                                   }
{   Returns elements in V1 but not in V2.                                      }
{   If both arrays are sorted ascending then time is o(n) instead of o(n^2).   }
{                                                                              }
Function Difference (const V1, V2 : SingleArray; const IsSortedAscending : Boolean) : SingleArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : DoubleArray; const IsSortedAscending : Boolean) : DoubleArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : ExtendedArray; const IsSortedAscending : Boolean) : ExtendedArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : ByteArray; const IsSortedAscending : Boolean) : ByteArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : WordArray; const IsSortedAscending : Boolean) : WordArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : LongWordArray; const IsSortedAscending : Boolean) : LongWordArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : ShortIntArray; const IsSortedAscending : Boolean) : ShortIntArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : SmallIntArray; const IsSortedAscending : Boolean) : SmallIntArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : LongIntArray; const IsSortedAscending : Boolean) : LongIntArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : Int64Array; const IsSortedAscending : Boolean) : Int64Array;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;

Function Difference (const V1, V2 : StringArray; const IsSortedAscending : Boolean) : StringArray;
var I, J, L, LV : Integer;
  Begin
    SetLength (Result, 0);
    if IsSortedAscending then
      begin
        I := 0;
        J := 0;
        L := Length (V1);
        LV := Length (V2);
        While (I < L) and (J < LV) do
          begin
            While (I < L) and (V1 [I] < V2 [J]) do
              Inc (I);
            if I < L then
              begin
                if V1 [I] <> V2 [J] then
                  Append (Result, V1 [I]);
                While (J < LV) and (V2 [J] <= V1 [I]) do
                  Inc (J);
              end;
          end;
      end else
      For I := 0 to Length (V1) - 1 do
        if (PosNext (V1 [I], V2) = -1) and (PosNext (V1 [I], Result) = -1) then
          Append (Result, V1 [I]);
  End;



{                                                                              }
{ Reverse                                                                      }
{                                                                              }
Procedure Reverse (var V : ByteArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : WordArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : LongWordArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : ShortIntArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : SmallIntArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : LongIntArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : Int64Array);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : StringArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : PointerArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : ObjectArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : SingleArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : DoubleArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;

Procedure Reverse (var V : ExtendedArray);
var I, L : Integer;
  Begin
    L := Length (V);
    For I := 1 to L div 2 do
      Swap (V [I - 1], V [L - I]);
  End;



{                                                                              }
{ Returns an open array (V) as a dynamic array.                                }
{                                                                              }
Function AsBooleanArray (const V : Array of Boolean) : BooleanArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsByteArray (const V : Array of Byte) : ByteArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsWordArray (const V : Array of Word) : WordArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsLongWordArray (const V : Array of LongWord) : LongWordArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsCardinalArray (const V : Array of Cardinal) : CardinalArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsShortIntArray (const V : Array of ShortInt) : ShortIntArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsSmallIntArray (const V : Array of SmallInt) : SmallIntArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsLongIntArray (const V : Array of LongInt) : LongIntArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsIntegerArray (const V : Array of Integer) : IntegerArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsInt64Array (const V : Array of Int64) : Int64Array;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsSingleArray (const V : Array of Single) : SingleArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsDoubleArray (const V : Array of Double) : DoubleArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsExtendedArray (const V : Array of Extended) : ExtendedArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsStringArray (const V : Array of String) : StringArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsPointerArray (const V : Array of Pointer) : PointerArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsCharSetArray (const V : Array of CharSet) : CharSetArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;

Function AsObjectArray (const V : Array of TObject) : ObjectArray;
var I : Integer;
  Begin
    SetLength (Result, High (V) + 1);
    For I := 0 to High (V) do
      Result [I] := V [I];
  End;



Function RangeByte (const First : Byte; const Count : Integer; const Increment : Byte) : ByteArray;
var I : Integer;
    J : Byte;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeWord (const First : Word; const Count : Integer; const Increment : Word) : WordArray;
var I : Integer;
    J : Word;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeLongWord (const First : LongWord; const Count : Integer; const Increment : LongWord) : LongWordArray;
var I : Integer;
    J : LongWord;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeCardinal (const First : Cardinal; const Count : Integer; const Increment : Cardinal) : CardinalArray;
var I : Integer;
    J : Cardinal;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeShortInt (const First : ShortInt; const Count : Integer; const Increment : ShortInt) : ShortIntArray;
var I : Integer;
    J : ShortInt;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeSmallInt (const First : SmallInt; const Count : Integer; const Increment : SmallInt) : SmallIntArray;
var I : Integer;
    J : SmallInt;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeLongInt (const First : LongInt; const Count : Integer; const Increment : LongInt) : LongIntArray;
var I : Integer;
    J : LongInt;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeInteger (const First : Integer; const Count : Integer; const Increment : Integer) : IntegerArray;
var I : Integer;
    J : Integer;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeInt64 (const First : Int64; const Count : Integer; const Increment : Int64) : Int64Array;
var I : Integer;
    J : Int64;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeSingle (const First : Single; const Count : Integer; const Increment : Single) : SingleArray;
var I : Integer;
    J : Single;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeDouble (const First : Double; const Count : Integer; const Increment : Double) : DoubleArray;
var I : Integer;
    J : Double;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;

Function RangeExtended (const First : Extended; const Count : Integer; const Increment : Extended) : ExtendedArray;
var I : Integer;
    J : Extended;
  Begin
    SetLength (Result, Count);
    J := First;
    For I := 0 to Count - 1 do
      begin
        Result [I] := J;
        J := J + Increment;
      end;
  End;



{                                                                              }
{ Dup                                                                          }
{                                                                              }
Function DupByte (const V : Byte; const Count : Integer) : ByteArray;
  Begin
    SetLength (Result, Count);
    FillChar (Result [0], Count, V);
  End;

Function DupWord (const V : Word; const Count : Integer) : WordArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupLongWord (const V : LongWord; const Count : Integer) : LongWordArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupCardinal (const V : Cardinal; const Count : Integer) : CardinalArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupShortInt (const V : ShortInt; const Count : Integer) : ShortIntArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupSmallInt (const V : SmallInt; const Count : Integer) : SmallIntArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupLongInt (const V : LongInt; const Count : Integer) : LongIntArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupInteger (const V : Integer; const Count : Integer) : IntegerArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupInt64 (const V : Int64; const Count : Integer) : Int64Array;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupSingle (const V : Single; const Count : Integer) : SingleArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupDouble (const V : Double; const Count : Integer) : DoubleArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupExtended (const V : Extended; const Count : Integer) : ExtendedArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupString (const V : String; const Count : Integer) : StringArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupCharSet (const V : CharSet; const Count : Integer) : CharSetArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;

Function DupObject (const V : TObject; const Count : Integer) : ObjectArray;
var I : Integer;
  Begin
    SetLength (Result, Count);
    For I := 0 to Count - 1 do
      Result [I] := V;
  End;



{                                                                              }
{ SetLengthAndZero                                                             }
{                                                                              }
Procedure SetLengthAndZero (var V : ByteArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (Byte) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : WordArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (Word) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : LongWordArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (LongWord) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : ShortIntArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (ShortInt) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : SmallIntArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (SmallInt) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : LongIntArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (LongInt) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : Int64Array; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (Int64) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : SingleArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (Single) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : DoubleArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (Double) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : ExtendedArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (Extended) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : CharSetArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (CharSet) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : BooleanArray; const NewLength : Integer);
var L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (Boolean) * (NewLength - L), #0);
  End;

Procedure SetLengthAndZero (var V : ObjectArray; const NewLength : Integer; const FreeObjects : Boolean);
var I, L : Integer;
  Begin
    L := Length (V);
    if L = NewLength then
      exit;
    if (L > NewLength) and FreeObjects then
      For I := NewLength to L - 1 do
        FreeAndNil (V [I]);
    SetLength (V, NewLength);
    if L > NewLength then
      exit;
    FillChar (V [L], Sizeof (Pointer) * (NewLength - L), #0);
  End;



{                                                                              }
{ IsEqual                                                                      }
{                                                                              }
Function IsEqual (const V1, V2 : ByteArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (Byte) * L);
  End;

Function IsEqual (const V1, V2 : WordArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (Word) * L);
  End;

Function IsEqual (const V1, V2 : LongWordArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (LongWord) * L);
  End;

Function IsEqual (const V1, V2 : ShortIntArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (ShortInt) * L);
  End;

Function IsEqual (const V1, V2 : SmallIntArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (SmallInt) * L);
  End;

Function IsEqual (const V1, V2 : LongIntArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (LongInt) * L);
  End;

Function IsEqual (const V1, V2 : Int64Array) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (Int64) * L);
  End;

Function IsEqual (const V1, V2 : SingleArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (Single) * L);
  End;

Function IsEqual (const V1, V2 : DoubleArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (Double) * L);
  End;

Function IsEqual (const V1, V2 : ExtendedArray) : Boolean;
var L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    Result := CompareMem (Pointer (V1)^, Pointer (V2)^, Sizeof (Extended) * L);
  End;

Function IsEqual (const V1, V2 : StringArray) : Boolean;
var I, L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    For I := 0 to L - 1 do
      if V1 [I] <> V2 [I] then
        begin
          Result := False;
          exit;
        end;
    Result := True;
  End;

Function IsEqual (const V1, V2 : CharSetArray) : Boolean;
var I, L : Integer;
  Begin
    L := Length (V1);
    if L <> Length (V2) then
      begin
        Result := False;
        exit;
      end;
    For I := 0 to L - 1 do
      if V1 [I] <> V2 [I] then
        begin
          Result := False;
          exit;
        end;
    Result := True;
  End;



{                                                                              }
{ Dynamic array to Dynamic array                                               }
{                                                                              }
Function ByteArrayToLongIntArray (const V : ByteArray) : LongIntArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function WordArrayToLongIntArray (const V : WordArray) : LongIntArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function ShortIntArrayToLongIntArray (const V : ShortIntArray) : LongIntArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function SmallIntArrayToLongIntArray (const V : SmallIntArray) : LongIntArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function LongIntArrayToInt64Array (const V : LongIntArray) : Int64Array;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function LongIntArrayToSingleArray (const V : LongIntArray) : SingleArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function LongIntArrayToDoubleArray (const V : LongIntArray) : DoubleArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function LongIntArrayToExtendedArray (const V : LongIntArray) : ExtendedArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function SingleArrayToExtendedArray (const V : SingleArray) : ExtendedArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function SingleArrayToDoubleArray (const V : SingleArray) : DoubleArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function SingleArrayToLongIntArray (const V : SingleArray) : LongIntArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := Trunc (V [I]);
  End;

Function SingleArrayToInt64Array (const V : SingleArray) : Int64Array;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := Trunc (V [I]);
  End;

Function DoubleArrayToSingleArray (const V : DoubleArray) : SingleArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function DoubleArrayToExtendedArray (const V : DoubleArray) : ExtendedArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function DoubleArrayToLongIntArray (const V : DoubleArray) : LongIntArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := Trunc (V [I]);
  End;

Function DoubleArrayToInt64Array (const V : DoubleArray) : Int64Array;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := Trunc (V [I]);
  End;

Function ExtendedArrayToSingleArray (const V : ExtendedArray) : SingleArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function ExtendedArrayToDoubleArray (const V : ExtendedArray) : DoubleArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [I];
  End;

Function ExtendedArrayToLongIntArray (const V : ExtendedArray) : LongIntArray;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := Trunc (V [I]);
  End;

Function ExtendedArrayToInt64Array (const V : ExtendedArray) : Int64Array;
var I, L : Integer;
  Begin
    L := Length (V);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := Trunc (V [I]);
  End;



{                                                                              }
{ Array from indexes                                                           }
{                                                                              }
Function ByteArrayFromIndexes (const V : ByteArray; const Indexes : IntegerArray) : ByteArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function WordArrayFromIndexes (const V : WordArray; const Indexes : IntegerArray) : WordArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function LongWordArrayFromIndexes (const V : LongWordArray; const Indexes : IntegerArray) : LongWordArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function CardinalArrayFromIndexes (const V : CardinalArray; const Indexes : IntegerArray) : CardinalArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function ShortIntArrayFromIndexes (const V : ShortIntArray; const Indexes : IntegerArray) : ShortIntArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function SmallIntArrayFromIndexes (const V : SmallIntArray; const Indexes : IntegerArray) : SmallIntArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function LongIntArrayFromIndexes (const V : LongIntArray; const Indexes : IntegerArray) : LongIntArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function IntegerArrayFromIndexes (const V : IntegerArray; const Indexes : IntegerArray) : IntegerArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function Int64ArrayFromIndexes (const V : Int64Array; const Indexes : IntegerArray) : Int64Array;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function SingleArrayFromIndexes (const V : SingleArray; const Indexes : IntegerArray) : SingleArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function DoubleArrayFromIndexes (const V : DoubleArray; const Indexes : IntegerArray) : DoubleArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function ExtendedArrayFromIndexes (const V : ExtendedArray; const Indexes : IntegerArray) : ExtendedArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;

Function StringArrayFromIndexes (const V : StringArray; const Indexes : IntegerArray) : StringArray;
var I, L : Integer;
  Begin
    L := Length (Indexes);
    SetLength (Result, L);
    For I := 0 to L - 1 do
      Result [I] := V [Indexes [I]];
  End;



{                                                                              }
{ Dynamic array Sort                                                           }
{                                                                              }
Procedure Sort (var V : ByteArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : WordArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : LongWordArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : ShortIntArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : SmallIntArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : LongIntArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : Int64Array);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : SingleArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : DoubleArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : ExtendedArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var V : StringArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While V [I] < V [M] do
            Inc (I);
          While V [J] > V [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (V [I], V [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    I := Length (V);
    if I > 0 then
      QuickSort (0, I - 1);
  End;



Procedure Sort (var Key : IntegerArray; var Data : IntegerArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : IntegerArray; var Data : Int64Array);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : IntegerArray; var Data : StringArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : IntegerArray; var Data : ExtendedArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : IntegerArray; var Data : PointerArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : StringArray; var Data : IntegerArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : StringArray; var Data : Int64Array);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : StringArray; var Data : StringArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : StringArray; var Data : ExtendedArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : StringArray; var Data : PointerArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : ExtendedArray; var Data : IntegerArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : ExtendedArray; var Data : Int64Array);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : ExtendedArray; var Data : StringArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : ExtendedArray; var Data : ExtendedArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;

Procedure Sort (var Key : ExtendedArray; var Data : PointerArray);

  Procedure QuickSort (L, R : Integer);
  var I, J, M : Integer;
    Begin
      Repeat
        I := L;
        J := R;
        M := (L + R) shr 1;
        Repeat
          While Key [I] < Key [M] do
            Inc (I);
          While Key [J] > Key [M] do
            Dec (J);
          if I <= J then
            begin
              Swap (Key [I], Key [J]);
              Swap (Data [I], Data [J]);
              if M = I then
                M := J else
                if M = J then
                  M := I;
              Inc (I);
              Dec (J);
            end;
        Until I > J;
        if L < J then
          QuickSort (L, J);
        L := I;
      Until I >= R;
    End;

var I : Integer;
  Begin
    Assert (Length (Key) = Length (Data), 'Sort pair must be of equal length.');
    I := Length (Key);
    if I > 0 then
      QuickSort (0, I - 1);
  End;




{                                                                              }
{ Test cases                                                                   }
{                                                                              }
Procedure Test_Misc;
var A, B : String;
  Begin
    { iif                                                                 }
    Assert (iif (True, 1, 2) = 1, 'iif');
    Assert (iif (False, 1, 2) = 2, 'iif');
    Assert (iif (True, '1', '2') = '1', 'iif');
    Assert (iif (False, '1', '2') = '2', 'iif');
    Assert (iif (True, 1.1, 2.2) = 1.1, 'iif');
    Assert (iif (False, 1.1, 2.2) = 2.2, 'iif');

    { CharSet                                                              }
    Assert (CharCount ([]) = 0, 'CharCount');
    Assert (CharCount (['a'..'z']) = 26, 'CharCount');
    Assert (CharCount ([#0, #255]) = 2, 'CharCount');

    { MoveMem                                                              }
    A := '12345';
    B := '     ';
    MoveMem (A [1], B [1], 0);
    Assert (B = '     ', 'MoveMem');
    MoveMem (A [1], B [1], 1);
    Assert (B = '1    ', 'MoveMem');
    MoveMem (A [1], B [1], 2);
    Assert (B = '12   ', 'MoveMem');
    MoveMem (A [1], B [1], 3);
    Assert (B = '123  ', 'MoveMem');
    MoveMem (A [1], B [1], 4);
    Assert (B = '1234 ', 'MoveMem');
    MoveMem (A [1], B [1], 5);
    Assert (B = '12345', 'MoveMem');
  End;

Procedure Test_BitFunctions;
  Begin
    { Bits                                                                 }
    Assert (SetBit ($100F, 5) = $102F, 'SetBit');
    Assert (ClearBit ($102F, 5) = $100F, 'ClearBit');
    Assert (ToggleBit ($102F, 5) = $100F, 'ToggleBit');
    Assert (ToggleBit ($100F, 5) = $102F, 'ToggleBit');
    Assert (IsBitSet ($102F, 5), 'IsBitSet');
    Assert (not IsBitSet ($100F, 5), 'IsBitSet');

    Assert (SetBitScanForward (0) = -1, 'SetBitScanForward');
    Assert (SetBitScanForward ($1020) = 5, 'SetBitScanForward');
    Assert (SetBitScanReverse ($1020) = 12, 'SetBitScanForward');
    Assert (SetBitScanForward ($1020, 6) = 12, 'SetBitScanForward');
    Assert (SetBitScanReverse ($1020, 11) = 5, 'SetBitScanForward');
    Assert (ClearBitScanForward ($FFFFFFFF) = -1, 'ClearBitScanForward');
    Assert (ClearBitScanForward ($1020) = 0, 'ClearBitScanForward');
    Assert (ClearBitScanReverse ($1020) = 31, 'ClearBitScanForward');
    Assert (ClearBitScanForward ($1020, 5) = 6, 'ClearBitScanForward');
    Assert (ClearBitScanReverse ($1020, 12) = 11, 'ClearBitScanForward');

    Assert (ReverseBits ($12345678) = $1E6A2C48, 'ReverseBits');
    Assert (SwapEndian ($12345678) = $78563412, 'SwapEndian');

    Assert (BitCount ($12341234) = 10, 'BitCount');

    Assert (LowBitMask (10) = $3FF, 'LowBitMask');
    Assert (HighBitMask (28) = $F0000000, 'HighBitMask');
    Assert (RangeBitMask (2, 6) = $7C, 'RangeBitMask');

    Assert (SetBitRange ($101, 2, 6) = $17D, 'SetBitRange');
    Assert (ClearBitRange ($17D, 2, 6) = $101, 'ClearBitRange');
    Assert (ToggleBitRange ($17D, 2, 6) = $101, 'ToggleBitRange');
    Assert (IsBitRangeSet ($17D, 2, 6), 'IsBitRangeSet');
    Assert (not IsBitRangeSet ($101, 2, 6), 'IsBitRangeSet');
    Assert (not IsBitRangeClear ($17D, 2, 6), 'IsBitRangeClear');
    Assert (IsBitRangeClear ($101, 2, 6), 'IsBitRangeClear');
  End;

Procedure Test_IntegerArray;
var S, T : IntegerArray;
    F    : Integer;
  Begin
    { IntegerArray                                                         }
    S := nil;
    For F := 1 to 100 do
      begin
        Append (S, F);
        Assert (Length (S) = F,                 'Append');
        Assert (S [F - 1] = F,                  'Append');
      end;

    T := Copy (S);
    AppendIntegerArray (S, T);
    For F := 1 to 100 do
      Assert (S [F + 99] = F,                   'Append');
    Assert (PosNext (60, S) = 59,               'PosNext');
    Assert (PosNext (60, T) = 59,               'PosNext');
    Assert (PosNext (60, S, 59) = 159,          'PosNext');
    Assert (PosNext (60, T, 59) = -1,           'PosNext');
    Assert (PosNext (60, T, -1, True) = 59,     'PosNext');
    Assert (PosNext (60, T, 59, True) = -1,     'PosNext');

    For F := 1 to 100 do
      begin
        Remove (S, PosNext (F, S), 1);
        Assert (Length (S) = 200 - F,           'Remove');
      end;
    For F := 99 downto 0 do
      begin
        Remove (S, PosNext (F xor 3 + 1, S), 1);
        Assert (Length (S) = F,                 'Remove');
      end;

    S := AsIntegerArray ([3, 1, 2, 5, 4]);
    Sort (S);
    Assert (S [0] = 1, 'Sort');
    Assert (S [1] = 2, 'Sort');
    Assert (S [2] = 3, 'Sort');
    Assert (S [3] = 4, 'Sort');
    Assert (S [4] = 5, 'Sort');
  End;

Procedure SelfTest;
  Begin
    Test_Misc;
    Test_BitFunctions;
    Test_IntegerArray;
  End;



end.

